;*****************************************************;
;* This is "pin.lsp" program 			     *;
;* Complete compiled in 02/06/99                     *;
;* Last change in 02/09/99     			     *;
;* ZX Mold Ltd  XY Liao				     *;
;*****************************************************;
;************************************* Main function start **************************************;
(defun pin(/ err_msg1 err_msg2)
;---------------------------------------------------
;shut off command echo and set undo mark
;---------------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "mark")
;---------------------------------------------------
;Save current system variable
;---------------------------------------------------
  (setq os_old (getvar "osmode")
	la_old (getvar "clayer")
	lt_old (getvar "celtype")
	co_old (getvar "cecolor")
	pw_old (getvar "plinewid")
	or_old (getvar "orthomode")
	st_old (getvar "textstyle")
	bp_old (getvar "blipmode")
  )
;---------------------------------------------------
;Initializing
;---------------------------------------------------
  (ini_useri2)
  (setvar "plinewid" 0)
  (setvar "blipmode" 0)
  (setvar "celtype" "bylayer")
  (setvar "cecolor" "bylayer")
  (if (not (tblsearch "layer" "epin"))
    (command "layer" "_new" "epin" "_color" "green" "epin" "l" "continuous" "epin" "")
    (command "_.layer" "thaw" "epin" "on" "epin" "unlock" "epin" "")
  )
  (setvar "clayer" "epin")
  (setq pin_conlb 1)
  (regapp "pin")
  (load "epin_lib")
  (setq pin_conlb  1
	last_d_m  0
	last_d_b  0
	last_l_m  0
	last_l_b  0
	mbf       1
	if_h_v    "0"
  )
  (if (not pin_count)
    (setq pin_count 1)
  )
;---------------------------------------------------
;Dialog start
;---------------------------------------------------
  (setq pin_dcl_id (load_dialog "pin.dcl"))
  (while (= 1 pin_conlb)
    (if (not (new_dialog "pindlg" pin_dcl_id))
      (*error* "Can't open \"pin.dcl\"!")
    )
    (ini_dcl_pin)
    (action_tile "PINM"     "(setq mbf 0) (ini_dcl_pin)")
    (action_tile "PINB"     "(setq mbf 1) (ini_dcl_pin)")
    (action_tile "PINTYP"   "(typ_act)")
    (action_tile "PINLEN"   "(len_act)")
    (action_tile "PINITEM"  "(setq rep_r $reason)  (valid_rep)")
    (action_tile "PINSPEC"  "(setq spec_r $reason) (valid_spec)")
    (action_tile "PINANG"   "(setq ang_r $reason)  (valid_ang)")
    (action_tile "HIDDENV"  "(ch_hidden) (start_pin_image)")
    (action_tile "cancel"   "(done_dialog 0)")
    (action_tile "accept"   "(done_dialog 1)")
    (action_tile "pin_z"    "(done_dialog 2)")
    (action_tile "pin_c"    "(done_dialog 3)")
    (action_tile "BACK"     "(done_dialog 4)")
    (action_tile "LOOK"     "(done_dialog 5)")
    (setq pin_next (start_dialog))
    (cond
      ((= 0 pin_next)
        (command "undo" "b")
        (setq pin_conlb 0)
      )
      ((= 1 pin_next)
        (setq pin_conlb 0)
      )
      ((= 2 pin_next)
        (pin_new_zst)
      )
      ((= 3 pin_next)
        (pin_new_cst)
      )
      ((= 4 pin_next)
        (setq pin_conlb 0)
      )
      ((= 5 pin_next)
        (command "zoom" "")
      )
    )
  )
  (ac_lxy_set)
  (prin1)
)

;**************************** Define dialog control functions group *****************************;
;-----------------------------------------
;Set hidden flag
;-----------------------------------------
(defun ch_hidden()                      
  (setq if_h_v (get_tile "HIDDENV"))
)

;----------------------------------------
;Initialize dialog
;----------------------------------------
(defun ini_dcl_pin()
  (cond 
    ((= 1 mbf)
      (setq mb "B")
      (set_tile "PINB" "1")
      (ini_list "PINTYP" (lib_ep 4))
      (ini_list "PINLEN" (lib_ep 12))
      (set_tile "PINTYP" (itoa last_d_b))
      (set_tile "PINLEN" (itoa last_l_b))
      (setq pin_type (nth last_d_b (lib_ep 4)))
      (setq pin_len  (nth last_l_b (lib_ep 12)))
      (setq d  (nth last_d_b (lib_ep 5)))
      (setq hd (nth last_d_b (lib_ep 6)))
      (setq b  (nth last_d_b (lib_ep 7)))
    )
    ((= 0 mbf)
      (setq mb "M")
      (set_tile "PINM" "1")
      (ini_list "PINTYP" (lib_ep 1))
      (ini_list "PINLEN" (lib_ep 10))
      (set_tile "PINTYP" (itoa last_d_m))
      (set_tile "PINLEN" (itoa last_l_m))
      (setq pin_type (nth last_d_m (lib_ep 1)))
      (setq pin_len  (nth last_l_m (lib_ep 10)))
      (setq d  (atof (nth last_d_m (lib_ep 1))))
      (setq hd (nth last_d_m (lib_ep 2)))
      (setq b  (nth last_d_m (lib_ep 3)))
    )
  )
  (setq rep (strcat "P" (itoa pin_count)))
  (set_tile "PINSPEC" (strcat pin_type "X" pin_len))
  (set_tile "PINITEM" rep)
  (set_tile "HIDDENV" if_h_v)
  (start_pin_image)
  (if err_msg1
    (set_tile "MSG" err_msg1)
    (if err_msg2
      (set_tile "MSG" err_msg2)
    )
  )
  (if (not pin_ang)
    (setq ang_auto T)
    (setq ang_auto nil)
  ) 
)
;-------------------------------------------
;Initialize image button
;-------------------------------------------
(defun start_pin_image(/ pic_fn)
  (cond 
    ((= "0" if_h_v)
      (foreach pic_fn '("pin_z" "pin_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
      )
      (foreach pic_fn '("pin_z" "pin_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn ")"))
	(end_image)
      )
    )
    ((= "1" if_h_v)
      (foreach pic_fn '("pin_z" "pin_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
      )
      (foreach pic_fn '("pin_z" "pin_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn "_h)"))
	(end_image)
      )
    )
  )
)
;------------------------------------------------
;pin diameter change function
;------------------------------------------------
(defun typ_act()
  (cond
    ((= "B" mb)
      (setq last_d_b (atoi (get_tile "PINTYP")))
      (setq pin_type (nth last_d_b (lib_ep 4)))
      (setq d  (nth last_d_b (lib_ep 5)))
      (setq hd (nth last_d_b (lib_ep 6)))
      (setq b  (nth last_d_b (lib_ep 7)))
    )
    ((= "M" mb)
      (setq last_d_m (atoi (get_tile "PINTYP")))
      (setq pin_type (nth last_d_m (lib_ep 1)))
      (setq d  (atof (nth last_d_m (lib_ep 1))))
      (setq hd (nth last_d_m (lib_ep 2)))
      (setq b  (nth last_d_m (lib_ep 3)))
    )
  )
  (set_tile "PINSPEC" (strcat pin_type "X" pin_len))
)
;------------------------------------------------
;pin length change function
;------------------------------------------------
(defun len_act()
  (cond
    ((= "B" mb)
      (setq last_l_b (atoi (get_tile "PINLEN")))
      (setq pin_len (nth last_l_b (lib_ep 12)))
    )
    ((= "M" mb)
      (setq last_l_m (atoi (get_tile "PINLEN")))
      (setq pin_len (nth last_l_m (lib_ep 10)))
    )
  )
  (set_tile "PINSPEC" (strcat pin_type "X" pin_len))
)
;------------------------------------------------
;Item number valid verify
;------------------------------------------------
(defun valid_rep()
  (setq rep (lxy_trim (get_tile "PINITEM")))
  (if (= 2 rep_r)
    (if (< (strlen rep) 2)
      (setq err_msg1 "Invalid item number!")
      (if (/= "P" (strcase (substr rep 1 1)))
        (setq err_msg1 "Invalid item number!")
        (if (= 0.0 (atof (substr rep 2)))
          (setq err_msg1 "Invalid item number!")
          (progn
            (setq pin_count (fix (atof (substr rep 2))))
            (setq rep (strcat "P" (itoa pin_count)))
            (set_tile "PINITEM" rep)
	    (setq err_msg1 nil)
          )
        )
      )
    )
  )
  (if err_msg1
    (progn 
      (mode_tile "PINITEM" 2)
      (set_tile "MSG" err_msg1)
    )
    (if (not err_msg2)
      (set_tile "MSG" "")
    )
  )
)
;------------------------------------------------
;specification box reset
;------------------------------------------------
(defun valid_spec()
  (if (= 2 spec_r)
    (set_tile "PINSPEC" (strcat epin_type "X" pin_len))
  )
)
;------------------------------------------------
;Pin angle valid verify
;------------------------------------------------
(defun valid_ang()
  (setq pin_ang (lxy_trim (get_tile "PINANG")))
  (if (= 2 ang_r)
    (if (/= "" pin_ang)
      (setq pin_ang (atof pin_ang)
	    ang_auto nil)
    )
  )
)
;*********************************** End of functions group *************************************;


;****************************** Call create pin function function *******************************;
(defun pin_new_cst()
  (load "pin_cst")
  (initget 32)
  (setvar "osmode" os_old)
  (setq err_msg2 nil)
  (if (setq pt1 (getpoint "\nPlease enter base point:"))
    (if (setq ob_ent (nentsel))
      (progn
        (setvar "osmode" 0)
        (setq pin_app "NEW")
        (pin_cst)
        (setvar "osmode" os_old)
      )
      (setq err_msg2 "Invalid entity!")
    )
    (setq err_msg2 "Invalid point!")
  )
  (if (not err_msg2)
    (progn
      (if (/= len pin_len)
        (cond
          ((= "B" mb)
            (setq last_l_b (xh_get len (lib_ep 12)))
          )
          ((= "M" mb)
            (setq last_l_m (xh_get len (lib_ep 10)))
          )
        )
      )
      (setq pin_sel_zst (ssget "x" '((0 . "INSERT") (-3 ("PIN")))))
      (if pin_sel_zst
        (setq count_all (sslength pin_sel_zst))
        (setq count_all nil)
      )
      (setq kkk 0)
      (while (< kkk count_all)
        (setq pin_ent_zst (ssname pin_sel_zst kkk))
        (setq pin_data (cdr (cadr (cadr (assoc -3 (entget pin_ent_zst '("pin")))))))
        (setq pin_data (strtolst pin_data))
        (setq rep_zst  (nth 0 pin_data)
	      zc_zst   (nth 1 pin_data)
              type_zst (nth 2 pin_data)
	      len_zst  (nth 3 pin_data)
        )
        (if (and (= "Z" zc_zst) (= rep rep_zst))
          (if (or (/= epin_type type_zst) (/= len len_zst))
            (progn
	      (setq cenpt (cdr (assoc 10 (entget pin_ent_zst))))
              ;(setq cenpt (wtou cenpt))
		(setq cenpt cenpt)
	      (entdel pin_ent_zst)
	      (setq pin_len len)
              (load "pin_zst")
	      (pin_zst)
            )
          )
        )
        (setq kkk (+ 1 kkk))
      )
      (setq pin_count (+ 1 pin_count))
    )
  )
)
;*************************************** end of function ****************************************;

;****************************** Call create pin function function *******************************;
(defun pin_new_zst()
  (load "pin_zst")
  (setvar "osmode" os_old)
  (while (setq cenpt (getpoint "\nPlease enter center point:"))
    (setvar "osmode" 0)
    (setq typ "N")
    (pin_zst)
    (setq err_msg2 nil)
    (setvar "osmode" os_old)
  )
  (setq pin_count (+ 1 pin_count)) ;set pin counter
)
;*************************************** end of function ****************************************;