;****************************************;
;*this is scr_cap.lsp program		*;
;*completely complied in 12/13/98	*;
;*last changed in 02/03/99		*;
;*ZX Mold Ltd   XY.Liao			*;
;****************************************;
;********************************************************************************************************;
;*This program is use to control cap screw libarary dialog and call drawing cap screw function
;*This pogram call two function:
;*one is       "cap_cst"
;*another is   "cap_zst"
;********************************************************************************************************;
(defun scr_cap(/ ex_lb		m_b_lb		scr_m_n		scr_m_len	scr_b_n		if_h_v	
		d		hd		b		s		screw_len	screw_lenf	
		screw_type	cap_dcl		app_typ)
;---------------------------------------
;set undo mark
;---------------------------------------
  (command "undo" "m")
;---------------------------------------
;initializing
;---------------------------------------
  (setq ex_lb 1)
  (setq m_b_lb    0
	scr_m_n   4
	scr_m_len 0
	scr_b_n   0
	scr_b_len 0
	if_h_v    "0"
  )
  (if (not screw_i)
	(setq screw_i 1)
  )
;---------------------------------------
;start dialog
;---------------------------------------
  (while (= 1 ex_lb) 
    (if (not (new_dialog "shcsdlg" screw_dcl))
	(exit)
    )
;---------------------------------------
;initializing dialog
;---------------------------------------
    (ini_dcl_v)
;---------------------------------------
;set dialog action
;---------------------------------------
    (action_tile "CAPM" "(setq m_b_lb 1) (ini_dcl_v)")
    (action_tile "CAPB" "(setq m_b_lb 0) (ini_dcl_v)")
    (action_tile "CAPTYP" "(typ_act)")
    (action_tile "CAPLEN" "(len_act)")
    (action_tile "HIDDENV" "(hid_ch)")
    (action_tile "cancel" "(done_dialog 0)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "cap_z" "(get_all_v) (done_dialog 2)")
    (action_tile "cap_c" "(get_all_v) (done_dialog 3)")
    (action_tile "BACK" "(done_dialog 4)")
    (action_tile "LOOK" "(done_dialog 5)")
;---------------------------------------
;determine what to next
;---------------------------------------
    (setq what_next (start_dialog))
    (cond
;---------------------------------------
;cancel action and exit
;---------------------------------------
	((= 0 what_next)
	   (command "undo" "b")
	   (setq ex_lb 0)
	   (setq if_next 0)
	)
;---------------------------------------
;exit
;---------------------------------------
	((= 1 what_next)
	   (setq ex_lb 0)
	   (setq if_next 0)
	)
;---------------------------------------
;call "scr_cap_zst" to create top view
;---------------------------------------
	((= 2 what_next)
	   (scr_cap_zst)
	   (setq ex_lb 1)
	)
;---------------------------------------
;call "scr_cap_cst" to create section view
;---------------------------------------
	((= 3 what_next)
	   (scr_cap_cst)
	   (setq ex_lb 1)
	)
;---------------------------------------
;return to main dialog
;---------------------------------------
	((= 4 what_next)
	   (setq ex_lb 0)
	   (setq if_next 1)
	)
;---------------------------------------
;hidden dialog 
;---------------------------------------
	((= 5 what_next)
	   (look)
	   (setq ex_lb 1)
	)
    )
  )
)
;*************************************** End of function ****************************************;


;******************************** dialog control function group *********************************;
;---------------------------------------
;start image function
;---------------------------------------
(defun start_vs(/ pic_fn)
  (foreach pic_fn '("cap_z" "cap_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
  )
  (foreach pic_fn '("cap_z" "cap_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn ")"))
	(end_image)
  )
)
(defun start_vs_h(/ pic_fn)
  (foreach pic_fn '("cap_z" "cap_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
  )
  (foreach pic_fn '("cap_z" "cap_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn "_h)"))
	(end_image)
  )
)
;---------------------------------------
;initializing dialog function
;---------------------------------------
(defun ini_dcl_v()
  (cond 
     ((= 0 m_b_lb)
      (set_tile "CAPB" "1")
      (ini_list "CAPTYP" (scr_lib "SHCSB" "spec"))
      (ini_list "CAPLEN" (nth scr_b_n (scr_lib "SHCSB" "cl")))
      (set_tile "CAPTYP" (itoa scr_b_n))
      (set_tile "CAPLEN" (itoa scr_b_len))
      (setq screw_type (nth scr_b_n (scr_lib "SHCSB" "spec")))
      (setq screw_len (nth scr_b_len (nth scr_b_n (scr_lib "SHCSB" "cl"))))
      (setq screw_lenf (nth scr_b_len (nth scr_b_n (scr_lib "SHCSB" "cll"))))
      (setq d (nth scr_b_n (scr_lib "SHCSB" "d_ct")))
      (setq hd (nth scr_b_n (scr_lib "SHCSB" "d_ch")))
      (setq s (nth scr_b_n (scr_lib "SHCSB" "cs")))
      (setq b (nth scr_b_n (scr_lib "SHCSB" "cb")))
     )
     ((= 1 m_b_lb)
      (set_tile "CAPM" "1")
      (ini_list "CAPTYP" (scr_lib "SHCSM" "spec"))
      (ini_list "CAPLEN" (nth scr_m_n (scr_lib "SHCSM" "cl")))
      (set_tile "CAPTYP" (itoa scr_m_n))
      (set_tile "CAPLEN" (itoa scr_m_len))
      (setq screw_type (nth scr_m_n (scr_lib "SHCSM" "spec")))
      (setq screw_len (nth scr_m_len (nth scr_m_n (scr_lib "SHCSM" "cl"))))
      (setq screw_lenf (atof screw_len))
      (setq d (nth scr_m_n (scr_lib "SHCSM" "d_ct")))
      (setq hd (nth scr_m_n (scr_lib "SHCSM" "d_ch")))
      (setq s (nth scr_m_n (scr_lib "SHCSM" "cs")))
      (setq b (nth scr_m_n (scr_lib "SHCSM" "cb")))
     )
  )
  (set_tile "CAPSPEC" (strcat screw_type "X" screw_len))
  (set_tile "CAPITEM" (strcat "V" (itoa screw_i)))
  (set_tile "HIDDENV" if_h_v)
  (if (= "1" if_h_v)
     (start_vs_h)
     (start_vs)
  )
)
;---------------------------------------
;spec select action
;---------------------------------------
(defun typ_act()
  (cond
     ((= 0 m_b_lb)
      (setq scr_b_n (atoi (get_tile "CAPTYP")))
      (ini_list "CAPLEN" (nth scr_b_n (scr_lib "SHCSB" "cl")))
      (setq screw_type (nth scr_b_n (scr_lib "SHCSB" "spec")))
      (if (not (xh_get screw_len (nth scr_b_n (scr_lib "SHCSB" "cl"))))
	(setq scr_b_len 0)
	(setq scr_b_len (xh_get screw_len (nth scr_b_n (scr_lib "SHCSB" "cl"))))
      )
      (set_tile "CAPLEN" (itoa scr_b_len))
      (setq screw_len (nth scr_b_len (nth scr_b_n (scr_lib "SHCSB" "cl"))))
      (setq screw_lenf (nth scr_b_len (nth scr_b_n (scr_lib "SHCSB" "cll"))))
      (setq d (nth scr_b_n (scr_lib "SHCSB" "d_ct")))
      (setq hd (nth scr_b_n (scr_lib "SHCSB" "d_ch")))
      (setq s (nth scr_b_n (scr_lib "SHCSB" "cs")))
      (setq b (nth scr_b_n (scr_lib "SHCSB" "cb")))
     )
     ((= 1 m_b_lb)
      (setq scr_m_n (atoi (get_tile "CAPTYP")))
      (ini_list "CAPLEN" (nth scr_m_n (scr_lib "SHCSM" "cl")))
      (setq screw_type (nth scr_m_n (scr_lib "SHCSM" "spec")))
      (if (not (xh_get screw_len (nth scr_m_n (scr_lib "SHCSM" "cl"))))
	(setq scr_m_len 0)
	(setq scr_m_len (xh_get screw_len (nth scr_m_n (scr_lib "SHCSM" "cl"))))
      )
      (set_tile "CAPLEN" (itoa scr_m_len))
      (setq screw_len (nth scr_m_len (nth scr_m_n (scr_lib "SHCSM" "cl"))))
      (setq screw_lenf (atof screw_len))
      (setq d (nth scr_m_n (scr_lib "SHCSM" "d_ct")))
      (setq hd (nth scr_m_n (scr_lib "SHCSM" "d_ch")))
      (setq s (nth scr_m_n (scr_lib "SHCSM" "cs")))
      (setq b (nth scr_m_n (scr_lib "SHCSM" "cb")))
     )
  )
  (set_tile "CAPSPEC" (strcat screw_type "X" screw_len))
)
;---------------------------------------
;length select action 
;---------------------------------------
(defun len_act()
  (cond
     ((= 0 m_b_lb)
      (setq scr_b_len (atoi (get_tile "CAPLEN")))
      (setq screw_len (nth scr_b_len (nth scr_b_n (scr_lib "SHCSB" "cl"))))
      (setq screw_lenf (nth scr_b_len (nth scr_b_n (scr_lib "SHCSB" "cll"))))
     )
     ((= 1 m_b_lb)
      (setq scr_m_len (atoi (get_tile "CAPLEN")))
      (setq screw_len (nth scr_m_len (nth scr_m_n (scr_lib "SHCSM" "cl"))))
      (setq screw_lenf (atof screw_len))
     )
  )
  (set_tile "CAPSPEC" (strcat screw_type "X" screw_len))
)
;---------------------------------------
;if draw screw in hidden select action
;---------------------------------------
(defun hid_ch()
  (setq if_h_v (get_tile "HIDDENV"))
  (if (= "1" if_h_v)
     (start_vs_h)
     (start_vs)
  )
)
;---------------------------------------
;get all parameter function
;---------------------------------------
(defun get_all_v()
  (setq rep (get_tile "CAPITEM"))
  (setq spec (get_tile "CAPSPEC"))
  (setq screw_i (atoi (substr rep 2)))
) 
;************************************ End of function group *************************************;

;************************************************************************************************;
(defun scr_cap_cst(/ pt1 pt2 ex_f mb)
;-------------------------------------
;calculate screw parameter
;-------------------------------------
  (if (= 0 m_b_lb)
     (progn
	(setq d (* d 25.4))
	(setq hd (* hd 25.4))
	(setq b (* b 25.4))
	(setq l (* screw_lenf 25.4))
	(setq mb "B")
     )
     (progn
     	(setq l screw_lenf)
     	(setq mb "M")
     )
  )
;------------------------------------
;initializing
;------------------------------------
  (initget 32)
  (setq ex_f 1)
  (load "cap_cst")
;---------------------------------------
;begin to call INS_CST to create screw
;---------------------------------------
  (while (= 1 ex_f)
     (setvar "osmode" os_old)
     (setq pt1 (getpoint "\nGet base point:"))
     (if pt1
        (setq pt2 (getpoint pt1 "\nGet second point:"))
     )
     (setvar "osmode" 0)
     (setq app_typ "NEW")
     (if (and pt1 pt2)
        (progn
          (setq pt (polar pt1 (angle pt1 pt2) 1.0))
          (cap_cst)
        )
	(setq ex_f 0)
     )
     (setvar "osmode" os_old)
  )
)
;*************************************** End of function ****************************************;

;********************************************************************************************************;
(defun scr_cap_zst(/ cenpt add_i)
;-----------------------------------------------------
;calculate screw parameter and set mb flag
;-----------------------------------------------------
  (if (= 0 m_b_lb)
     (progn
	(setq hd (* hd 25.4))
	(setq s (* s 25.4))
	(setq mb "B")
     )
     (setq mb "M")
  )
;-----------------------------------------------------
;initializing
;-----------------------------------------------------
  (load "cap_zst")
;-----------------------------------------------------
;Call INS_ZST to create screw top view
;-----------------------------------------------------
  (while (setq cenpt (getpoint "\nGet center:"))
      (setvar "osmode" 0)
      (cap_zst)
      (setq add_i T)
      (setvar "osmode" os_old)
  )
;-----------------------------------------------------
;counter
;-----------------------------------------------------
  (if add_i
      (setq screw_i (+ screw_i 1))
  )
)
;*************************************** End of function ****************************************;