;****************************************;
;*this is SPRING.lsp program		*;
;*completely complied in 02/25/99	*;
;*last changed in 02/25/99		*;
;*ZX Mold Ltd   XY.Liao			*;
;****************************************;
;********************************************************************************************************;
(defun spring(/ ex_lb		m_b_lb		sp_m_n		sp_m_len	sp_b_n		if_h_v	
		d		hd		b		s		spring_len	spring_lenf	
		spring_type	sp_dcl		app_typ)
;----------------------------------------------------
;defun lacal function
;----------------------------------------------------
  (defun look()
    (command "zoom" "")
  )
;----------------------------------------------------
;set undo mark
;----------------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;----------------------------------------------------
;save old system variable
;----------------------------------------------------
  (setq lt_old (getvar "celtype"))
  (setq co_old (getvar "cecolor"))
  (setq dim_old (getvar "dimstyle"))
  (setq la_old (getvar "clayer"))
  (setq os_old (getvar "osmode"))
  (setq st_old (getvar "textstyle"))
  (setq pw_old (getvar "plinewid"))
  (setq orgpt (getvar "ucsorg"))
;---------------------------------------------------
;set application system variable
;---------------------------------------------------
  (ini_useri2)
  (load "sp_lib")
  (if (not (tblsearch "layer" "spring"))
    (command "layer" "n" "spring" "c" "cyan" "spring" "l" "phantom2" "spring" "")
    (command "_.layer" "thaw" "spring" "on" "spring" "unlock" "spring" "")
  )
  (setvar "clayer" "spring")
  (setvar "plinewid" 0)
;---------------------------------------
;initializing
;---------------------------------------
  (if (not (tblsearch "appid" "spring"))
    (regapp "spring")
  )
  (setq ex_lb 1)
  (setq m_b_lb    0
	sp_m_n   4
	sp_m_len 0
	sp_b_n   0
	sp_b_len 0
	if_h_v    "0"
  )
  (if (not spring_i)
	(setq spring_i 1)
  )
;---------------------------------------
;start dialog
;---------------------------------------
  (setq sp_dcl (load_dialog "spring"))
  (while (= 1 ex_lb) 
    (if (not (new_dialog "spdlg" sp_dcl))
	(exit)
    )
;---------------------------------------
;initializing dialog
;---------------------------------------
    (ini_dcl_sp)
;---------------------------------------
;set dialog action
;---------------------------------------
    (action_tile "SPM" "(setq m_b_lb 1) (ini_dcl_sp)")
    (action_tile "SPB" "(setq m_b_lb 0) (ini_dcl_sp)")
    (action_tile "SPTYP" "(typ_act)")
    (action_tile "SPLEN" "(len_act)")
    (action_tile "HIDDENV" "(hid_ch)")
    (action_tile "cancel" "(done_dialog 0)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "sp_z" "(get_all_sp) (done_dialog 2)")
    (action_tile "sp_c" "(get_all_sp) (done_dialog 3)")
    (action_tile "BACK" "(done_dialog 4)")
    (action_tile "LOOK" "(done_dialog 5)")
;---------------------------------------
;determine what to next
;---------------------------------------
    (setq what_next (start_dialog))
    (cond
;---------------------------------------
;cancel action and exit
;---------------------------------------
	((= 0 what_next)
	   (command "undo" "b")
	   (setq ex_lb 0)
	   (setq if_next 0)
	)
;---------------------------------------
;exit
;---------------------------------------
	((= 1 what_next)
	   (setq ex_lb 0)
	   (setq if_next 0)
	)
;---------------------------------------
;call "sp_zst" to create top view
;---------------------------------------
	((= 2 what_next)
	   (sp_new_zst)
	   (setq ex_lb 1)
	)
;---------------------------------------
;call "sp_cst" to create section view
;---------------------------------------
	((= 3 what_next)
	   (sp_new_cst)
	   (setq ex_lb 1)
	)
;---------------------------------------
;return to main dialog
;---------------------------------------
	((= 4 what_next)
	   (setq ex_lb 0)
	   (setq if_next 1)
	)
;---------------------------------------
;hidden dialog 
;---------------------------------------
	((= 5 what_next)
	   (look)
	   (setq ex_lb 1)
	)
    )
  )
  (unload_dialog sp_dcl)
  (ac_lxy_set)
  (prin1)
)
;*************************************** End of function ****************************************;


;******************************** dialog control function group *********************************;
;---------------------------------------
;start image function
;---------------------------------------
(defun start_vs(/ pic_fn)
  (foreach pic_fn '("sp_z" "sp_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
  )
  (foreach pic_fn '("sp_z" "sp_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn ")"))
	(end_image)
  )
)
(defun start_vs_h(/ pic_fn)
  (foreach pic_fn '("sp_z" "sp_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
  )
  (foreach pic_fn '("sp_z" "sp_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn "_h)"))
	(end_image)
  )
)
;---------------------------------------
;initializing dialog function
;---------------------------------------
(defun ini_dcl_sp()
  (cond 
     ((= 0 m_b_lb)
      (set_tile "SPB" "1")
      (ini_list "SPTYP" (sp_lib "SPB" "spec"))
      (ini_list "SPLEN" (nth sp_b_n (sp_lib "SPB" "spl")))
      (set_tile "SPTYP" (itoa sp_b_n))
      (set_tile "SPLEN" (itoa sp_b_len))
      (setq spring_type (nth sp_b_n (sp_lib "SPB" "spec")))
      (setq spring_len (nth sp_b_len (nth sp_b_n (sp_lib "SPB" "spl"))))
      (setq od (nth sp_b_n (sp_lib "SPB" "od")))
      (setq id (nth sp_b_n (sp_lib "SPB" "id")))
      (setq a (nth sp_b_n (sp_lib "SPB" "r1")))
      (setq b (nth sp_b_n (sp_lib "SPB" "r2")))
     )
     ((= 1 m_b_lb)
      (set_tile "SPM" "1")
      (ini_list "SPTYP" (sp_lib "SPM" "spec"))
      (ini_list "SPLEN" (nth sp_m_n (sp_lib "SPM" "spl")))
      (set_tile "SPTYP" (itoa sp_m_n))
      (set_tile "SPLEN" (itoa sp_m_len))
      (setq spring_type (nth sp_m_n (sp_lib "SPM" "spec")))
      (setq spring_len (nth sp_m_len (nth sp_m_n (sp_lib "SPM" "spl"))))
      (setq od (nth sp_m_n (sp_lib "SPM" "od")))
      (setq id (nth sp_m_n (sp_lib "SPM" "id")))
      (setq a (nth sp_m_n (sp_lib "SPM" "r1")))
      (setq b (nth sp_m_n (sp_lib "SPM" "r2")))
     )
  )
  (set_tile "SPSPEC" (strcat spring_type "X" spring_len))
  (set_tile "SPITEM" (strcat "S" (itoa spring_i)))
  (set_tile "HIDDENV" if_h_v)
  (if (= "1" if_h_v)
     (start_vs_h)
     (start_vs)
  )
)
;---------------------------------------
;spec select action
;---------------------------------------
(defun typ_act()
  (cond
     ((= 0 m_b_lb)
      (setq sp_b_n (atoi (get_tile "SPTYP")))
      (ini_list "SPLEN" (nth sp_b_n (sp_lib "SPB" "spl")))
      (setq spring_type (nth sp_b_n (sp_lib "SPB" "spec")))
      (if (not (xh_get spring_len (nth sp_b_n (sp_lib "SPB" "spl"))))
	(setq sp_b_len 0)
	(setq sp_b_len (xh_get spring_len (nth sp_b_n (sp_lib "SPB" "spl"))))
      )
      (set_tile "SPLEN" (itoa sp_b_len))
      (setq spring_len (nth sp_b_len (nth sp_b_n (sp_lib "SPB" "spl"))))
      (setq od (nth sp_b_n (sp_lib "SPB" "od")))
      (setq id (nth sp_b_n (sp_lib "SPB" "id")))
      (setq a (nth sp_b_n (sp_lib "SPB" "r1")))
      (setq b (nth sp_b_n (sp_lib "SPB" "r2")))
     )
     ((= 1 m_b_lb)
      (setq sp_m_n (atoi (get_tile "SPTYP")))
      (ini_list "SPLEN" (nth sp_m_n (sp_lib "SPM" "spl")))
      (setq spring_type (nth sp_m_n (sp_lib "SPM" "spec")))
      (if (not (xh_get spring_len (nth sp_m_n (sp_lib "SPM" "spl"))))
	(setq sp_m_len 0)
	(setq sp_m_len (xh_get spring_len (nth sp_m_n (sp_lib "SPM" "spl"))))
      )
      (set_tile "SPLEN" (itoa sp_m_len))
      (setq spring_len (nth sp_m_len (nth sp_m_n (sp_lib "SPM" "spl"))))
      (setq od (nth sp_m_n (sp_lib "SPM" "od")))
      (setq id (nth sp_m_n (sp_lib "SPM" "id")))
      (setq a (nth sp_m_n (sp_lib "SPM" "r1")))
      (setq b (nth sp_m_n (sp_lib "SPM" "r2")))
     )
  )
  (set_tile "SPSPEC" (strcat spring_type "X" spring_len))
)
;---------------------------------------
;length select action 
;---------------------------------------
(defun len_act()
  (cond
     ((= 0 m_b_lb)
      (setq sp_b_len (atoi (get_tile "SPLEN")))
      (setq spring_len (nth sp_b_len (nth sp_b_n (sp_lib "SPB" "spl"))))
     )
     ((= 1 m_b_lb)
      (setq sp_m_len (atoi (get_tile "SPLEN")))
      (setq spring_len (nth sp_m_len (nth sp_m_n (sp_lib "SPM" "spl"))))
     )
  )
  (set_tile "SPSPEC" (strcat spring_type "X" spring_len))
)
;---------------------------------------
;if draw spring in hidden select action
;---------------------------------------
(defun hid_ch()
  (setq if_h_v (get_tile "HIDDENV"))
  (if (= "1" if_h_v)
     (start_vs_h)
     (start_vs)
  )
)
;---------------------------------------
;get all parameter function
;---------------------------------------
(defun get_all_sp()
  (setq rep (get_tile "SPITEM"))
  (setq spec (get_tile "SPSPEC"))
  (setq spring_i (atoi (substr rep 2)))
) 
;************************************ End of function group *************************************;

;************************************************************************************************;
(defun sp_new_cst(/ pt1 pt2 ex_f mb)
;-------------------------------------
;calculate spring parameter
;-------------------------------------
  (if (= 0 m_b_lb)
     (progn
	(setq od (* od 25.4))
	(setq id (* id 25.4))
	(setq mb "B")
     )
     (progn
     	(setq mb "M")
     )
  )
;------------------------------------
;initializing
;------------------------------------
  (initget 32)
  (setq ex_f 1)
  (load "sp_cst")
;---------------------------------------
;begin to call INS_CST to create spring
;---------------------------------------
  (while (= 1 ex_f)
     (setvar "osmode" os_old)
     (setq pt1 (getpoint "\nGet first point:"))
     (if pt1
        (setq pt2 (getpoint pt1 "\nGet second point:"))
     )
     (setvar "osmode" 0)
     (setq sp_app "NEW")
     (if (and pt1 pt2)
       (sp_cst)
       (setq ex_f 0)
     )
     (setvar "osmode" os_old)
  )
)
;*************************************** End of function ****************************************;

;********************************************************************************************************;
(defun sp_new_zst(/ cenpt add_i)
;-----------------------------------------------------
;calculate spring parameter and set mb flag
;-----------------------------------------------------
  (if (= 0 m_b_lb)
     (progn
       (setq od (* od 25.4))
       (setq mb "B")
     )
     (setq mb "M")
  )
;-----------------------------------------------------
;initializing
;-----------------------------------------------------
  (load "sp_zst")
;-----------------------------------------------------
;Call INS_ZST to create spring top view
;-----------------------------------------------------
  (while (setq cenpt (getpoint "\nGet center:"))
      (setvar "osmode" 0)
      (sp_zst)
      (setq add_i T)
      (setvar "osmode" os_old)
  )
;-----------------------------------------------------
;counter
;-----------------------------------------------------
  (if add_i
      (setq spring_i (+ spring_i 1))
  )
)
;*************************************** End of function ****************************************;