
(defun sp_edit()
;---------------------------------------------------
;shut off command echo and set undo mark
;---------------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;---------------------------------------------------
;Save current system variable
;---------------------------------------------------
  (setq os_old (getvar "osmode")
	la_old (getvar "clayer")
	lt_old (getvar "celtype")
	co_old (getvar "cecolor")
	pw_old (getvar "plinewid")
	or_old (getvar "orthomode")
	st_old (getvar "textstyle")
	bp_old (getvar "blipmode")
  )
;---------------------------------------------------
;Initializing
;---------------------------------------------------
  (ini_useri2)
  (setvar "plinewid" 0)
  (setvar "blipmode" 0)
  (setvar "celtype" "bylayer")
  (setvar "cecolor" "bylayer")
  (if (not (tblsearch "layer" "spring"))
    (command "_.layer" "_new" "spring" "_color" "cyan" "spring" "l" "phantom2" "spring" "")
    (command "_.layer" "thaw" "spring" "on" "spring" "unlock" "spring" "")
  )
  (setvar "clayer" "spring")
  (setq sp_conlb 1)
  (if (not (tblsearch "appid" "spring"))
    (regapp "spring")
  )
  (load "sp_lib")
;--------------------------------------------------
;Get spring
;--------------------------------------------------
  (setq INU T)
  (while INU
    (setq sp_ent (entsel))
    (if (not sp_ent)
      (setq sp_ent (entsel))
      (progn
        (setq sp_ent (car sp_ent))
        (if (assoc -3 (entget sp_ent '("spring")))
          (if (/= "spring" (car (cadr (assoc -3 (entget sp_ent '("spring"))))))
            (princ "\nIt is not a spring!\n")
	    (setq INU nil)
	  )
	)
      )
    )
  )
  (setq sp_data (cdr (cadr (cadr (assoc -3 (entget sp_ent '("spring")))))))
  (setq sp_data (strtolst sp_data))
  (progn
    (setq rep_old  (nth 0 sp_data)
	  mb       (nth 6 sp_data)
	  type_old (nth 2 sp_data)
	  len_old  (nth 3 sp_data)
	  zc       (nth 1 sp_data)
          if_h_v   (nth 4 sp_data)
          spec_old (strcat type_old "X" len_old)
    )
    (if (= "C" zc)
      (setq ang (atof (nth 7 sp_data)))
    )
    (setq chin "")
    (setq desc "SPRING")
  )
;-----------------------------------------------
;start dialog
;-----------------------------------------------
  (setq dcl_id (load_dialog "spring.dcl"))
  (setq edit_next 1)
  (while (= 1 edit_next) 
    (if (not (new_dialog "spedit" dcl_id))
      (exit)
    )
    (set_tile "rep" rep_old)
    (set_tile "chin" chin)
    (set_tile "desc" desc)
    (set_tile "cot" spec_old)
    (mode_tile "desc" 1)
    (mode_tile "chin" 1)
    (if err_msg
      (set_tile "MSG" err_msg)
    )
    (action_tile "accept" "(rep_get) (done_dialog 2)")
    (action_tile "E_DEL"  "(rep_get) (done_dialog 4)")
    (action_tile "rep"    "(setq rep_r  $reason) (valid_verify)")
    (action_tile "cot"    "(setq spec_r $reason) (valid_verify)")
    (action_tile "cancel" "(done_dialog 3)")
    (setq what_next (start_dialog))
    (cond
      ((= 2 what_next)
        (setq if_del_lb 0)
        (setq edit_next 0)
        (if (and (or rep_new spec_new)
	         (or (/= rep_old rep_new) (/= spec_old spec_new))
	         (not err_msg)
            )
          (if (= 1 if_all_lb)
            (progn
	      (princ "\nAnalyzing entity, Please wait a moment...")
              (setq all_set (ssget "X" '((0 . "INSERT") (-3 ("spring")))))
  	      (setq ent_count (sslength all_set))
  	      (setq i 0)
  	      (while (< i ent_count)
	        (setq ent_name (ssname all_set i))
	        (sp_modify ent_name)
	        (setq i (+ i 1))
	      )
            )
            (sp_modify sp_ent)
          )
          (setq edit_next 1)
        )
      )
      ((= 3 what_next)
        (setq edit_next 0)
      )
      ((= 4 what_next)
        (setq if_del_lb 1)
        (setq edit_next 0)
        (if (= 1 if_all_lb)
          (progn
	    (princ "\nAnalyzing entity, Please wait a moment...")
            (setq all_set (ssget "X" '((0 . "INSERT") (-3 ("spring")))))
  	    (setq ent_count (sslength all_set))
  	    (setq i 0)
  	    (while (< i ent_count)
	      (setq ent_name (ssname all_set i))
              (sp_del ent_name)
	      (setq i (+ i 1))
	    )
          )
          (sp_del sp_ent)
        )
      )
    )
  )
  (ac_lxy_set)
  (princ "done")
  (prin1)
)
;------------------------------------------------------------------------------------;	

;------------------------------------------------------------------------------------;	
(defun rep_get()
  (if (= "1" (get_tile "if_all"))
    (setq if_all_lb 1)
    (setq if_all_lb 0)
  )
) 


;------------------------------------------------------------------------------------;	
(defun sp_modify(ent_name / con_lb)
  (setq sp_data (cdr (cadr (cadr (assoc -3 (entget ent_name '("spring")))))))
  (setq sp_data (strtolst sp_data))
  (progn
     (setq rep      (nth 0 sp_data)
	   type_cur (nth 2 sp_data)
	   len      (nth 3 sp_data)
	   zc       (nth 1 sp_data)
           if_h_v   (nth 4 sp_data)
           spec     (strcat type_cur "X" len)
    )
    (if (= "C" zc)
      (setq ang    (atof (nth 7 sp_data))
	    l      (atof (nth 8 sp_data))
      )
    )
    (setq  pt1   (cdr (assoc 10 (entget ent_name))))
    (if (= -1.0 (cdr (assoc 41 (entget ent_name))))
      (progn
        (setq ang_mirr (cdr (assoc 50 (entget ent_name))))
        (setq ang_mirr (/ ang_mirr 2))
        (setq ang_mirr (+ ang_mirr (/ pi 2)))
        (if (<= pi ang_mirr)
          (setq ang_mirr (- ang_mirr pi))
        )
        (if (= "C" zc)
          (progn
	    (setq ang_mirr (- (- ang (* (fix (/ ang pi)) pi)) ang_mirr))
	    (setq ang (- ang (* 2 ang_mirr)))
          )
        )
      )
      (if (= "C" zc)
        (setq ang (+ ang (cdr (assoc 50 (entget ent_name)))))
      )
    )
    (if (= "C" zc)
      (progn
        (if (> ang (* pi 2))
          (setq ang (- ang (* pi 2)))
        )
        (if (< ang 0)
          (setq ang (+ ang (* 2 pi)))
        )
      )
    )
  )
  (if (= rep rep_old)
    (progn
      (if (/= spec spec_old)
        (progn
          (redraw ent_name 3)
          (command "zoom" "c" pt 50)
          (setq con_lb (yn  (strcat "ֲͬ" spec "! ?")))
	  (command "zoom" "p")
        )
        (setq con_lb 1)
      )
      (if (= 1 con_lb)
        (progn
          (entdel ent_name)
          (setq rep rep_new)
          (setq sp_app "OLD")
          (cond
	    ((= "C" zc)
              (load "sp_cst")
	      (sp_cst)
	    )
	    ((= "Z" zc)
              (setq cenpt pt1)
              (load "sp_zst")
              (sp_zst)
            )
          )
        ) 
      )
    )
  )
)

(defun sp_del(ent_name / con_lb)
  (setq sp_data (cdr (cadr (cadr (assoc -3 (entget ent_name '("spring")))))))
  (setq sp_data (strtolst sp_data))
  (progn
     (setq rep      (nth 0 sp_data)
	   type_cur (nth 2 sp_data)
	   len      (nth 3 sp_data)
	   zc       (nth 1 sp_data)
           if_h_v   (nth 4 sp_data)
           spec     (strcat type_cur "X" len)
    )
  )
  (if (= rep rep_old)
    (progn
      (if (/= spec spec_old)
        (progn
          (redraw ent_name 3)
          (command "zoom" "c" pt1 50)
          (setq con_lb (yn  (strcat "ֲͬ" spec "! ɾ?")))
          (command "zoom" "p")
        )
        (setq con_lb 1)
      )
      (if (= 1 con_lb)
        (entdel ent_name)
        (redraw ent_name 4)
      )
    )
  )
)



(defun valid_verify()
  (if (or (= 2 rep_r) (= 2 spec_r))
    (progn
;--------------------------------------------------
;Verify item number
;--------------------------------------------------
      (setq rep_new (lxy_trim (get_tile "rep")))
      (if (> 2 (strlen rep_new))
        (setq err_msg1 "Invalid item number!")
        (if (/= "S" (strcase (substr rep_new 1 1)))
          (setq err_msg1 "Invalid item number!")
          (if (= 0.0 (atof (substr rep_new 2)))
            (setq err_msg1 "Invalid item number!")
            (progn
              (setq rep_new (strcat "S" (itoa (fix (atof (substr rep_new 2))))))
              (set_tile "rep" rep_new)
	      (setq err_msg1 nil)
            )
          )
        )
      )
;---------------------------------------------------
;Verify spring specification
;---------------------------------------------------
      (setq spec_new (lxy_trim (get_tile "cot")))
      (if (not (lxy_word spec_new "X"))
	(setq err_msg "Invalid spring specification!")
        (progn
          (setq spring_type (substr spec_new 1 (- (lxy_word spec_new "X") 1))
	   	spring_len  (substr spec_new (+ (lxy_word spec_new "X") 1) (- (strlen spec_new) (lxy_word spec_new "X")))
    	  )
          (cond
            ((= "B" mb)
	      (setq n (xh_get spring_type (sp_lib "SPB" "spec")))
	      (if (not n)
	        (setq err_msg2 "Invalid spring specification!")
                (progn
	          (setq od (nth n (sp_lib "SPB" "od"))
	                id (nth n (sp_lib "SPB" "id"))
	                a  (nth n (sp_lib "SPB" "r1"))
	                b  (nth n (sp_lib "SPB" "r2"))
	                od (* od 25.4)
	                id (* id 25.4)
                  )
                )
              )
            )
            ((= "M" mb)
	      (setq n (xh_get spring_type (sp_lib "SPM" "spec")))
	      (if (not n)
	        (setq err_msg2 "Invalid spring specification!")
                (progn
	          (setq od (nth n (sp_lib "SPM" "od"))
	                id (nth n (sp_lib "SPM" "id"))
	                a  (nth n (sp_lib "SPM" "r1"))
	                b  (nth n (sp_lib "SPM" "r2"))
                  )
                )
              )
            )
          )
        )
      )
    )
  )
  (if err_msg1
    (progn 
      (mode_tile "rep" 2)
      (set_tile "MSG" err_msg1)
    )
    (if (not err_msg2)
      (set_tile "MSG" "")
      (progn 
        (mode_tile "spec" 2)
        (set_tile "MSG" err_msg2)
      )
    )
  )
)
