(defun ScrewGet(STYPE pt1 pt2 pt3 SSPEC REP StatFlag / 	TypLib		ScrLenLst1	ScrLenLst2
					ScrHD		ScrD		ScrB		ScrS
					ScrLen1		ScrLen2		ScrLenAbout	ScrLenMin
					ScrLenMax	mb		PLen		temp
					ItemTmp		dlta)
  (if (/= 'LIST (type scr_lib)) (load "ScrewLib"))
  (if (= 1 (logand 1 StatFlag)) (setq mb "M") (setq mb "B"))
  (cond
    ((= 'CAP STYPE)  (setq TypLib "SHCS"))
    ((= 'FLAT STYPE) (setq TypLib "SHFS"))
    ((= 'SET STYPE)  (setq TypLib "SHSS"))
  )
  (setq TypLib (strcat TypLib mb))
  (setq PLen (distance pt1 pt2))
  (setq ScrLenLst1 (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cl"))
	ScrD       (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "d_ct"))
  )
  (if (= "B" mb) 
    (setq ScrLenLst2 (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cll"))
	  ScrD (* ScrD 25.4)
    )
    (setq ScrLenLst2 (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cl")))
  )
  (setq ScrLenAbout (+ (* ScrD 1.3) PLen)
	ScrLenMin   (+ (* ScrD 1.2) PLen)
	ScrLenMax   (+ (* ScrD 2.0) PLen)
  )
  (cond 
    ((= 'CAP STYPE)
      (setq ScrLenAbout (- ScrLenAbout ScrD 1)
	    ScrLenMin   (- ScrLenMin   ScrD 1)
	    ScrLenMax   (- ScrLenMax   ScrD 1)
      )
      (if (= "B" mb)
        (setq ScrLenAbout (/ ScrLenAbout 25.4)
	      ScrLenMin   (/ ScrLenMin   25.4)
	      ScrLenMax   (/ ScrLenMax   25.4)
        )
      )
      (FindMatchLen)
      (setq ScrHD (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "d_ch"))
	    ScrB  (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cb"))
	    ScrS  (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cs"))
      )
      (if (= "B" mb) 
	(setq ScrHD   (* ScrHD 25.4)
	      ScrB    (* ScrB 25.4)
	      ScrS    (* ScrS 25.4)
	      ScrLen2 (* ScrLen2 25.4)
	)
      )
      (if (/= 'LIST (type ScrewCAP)) (load "ScrewCAP"))
      (ScrewCAP ScrHD ScrD ScrB ScrLen2 ScrS pt1 pt2 pt3 REP SSPEC ScrLen1 statFlag)
    )
    ((= 'FLAT STYPE)
      (setq ScrLenAbout (- ScrLenAbout 1)
	    ScrLenMin   (- ScrLenMin   1)
	    ScrLenMax   (- ScrLenMax   1)
      )
      (if (= "B" mb)
	(setq ScrLenAbout (/ ScrLenAbout 25.4)
	      ScrLenMin   (/ ScrLenMin   25.4)
	      ScrLenMax   (/ ScrLenMax   25.4)
	)
      )
      (FindMatchLen)
      (setq ScrHD (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "d_ch"))
	    ScrK  (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "ck"))
	    ScrS  (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cs"))
      )
      (if (= "B" mb) 
	(setq ScrHD (* ScrHD 25.4)
	      ScrK  (* ScrK 25.4)
	      ScrS  (* ScrS 25.4)
	)
      )
      (if (/= 'LIST (type ScrewFLT)) (load "ScrewFLT"))
      (ScrewFLT ScrHD ScrD ScrK ScrLen2 ScrS pt1 pt2 pt3 REP SSPEC ScrLen1 statFlag)
    )
    ((= 'SET STYPE)
      (setq ScrLen1 (GetScrLen ScrLenLst1)
            ScrLen2 (if (= "M" mb) 
		      (atoi (nth (xh_get Scrlen1 ScrLenLst1) ScrLenLst2))
		      (nth (xh_get ScrLen1 ScrLenLst1) ScrLenLst2)
		    )
      )
      (setq ScrZ  (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cz"))
	    ScrS  (nth (xh_get SSPEC (scr_lib TypLib "spec")) (scr_lib TypLib "cs"))
      )
      (if (= "B" mb) 
	(setq ScrZ  (* ScrZ 25.4)
	      ScrS  (* ScrS 25.4)
	)
      )
      (if (/= 'LIST (type ScrewSET)) (load "ScrewSET"))
      (ScrewSET ScrD ScrZ ScrLen2 ScrS pt1 pt2 REP SSPEC ScrLen1 statFlag)
    )
  )
)


(defun FindMatchLen()
  (foreach ItemN ScrLenLst2
    (progn
      (if (= "M" mb) 
	(setq ItemTmp (atoi ItemN))
	(setq ItemTmp ItemN)
      )
      (if (and (>= ItemTmp ScrLenMin) (<= ItemTmp ScrLenMax))
        (if (not temp)
          (setq temp ItemTmp
	        dlta (abs (- ItemTmp ScrLenAbout))
		ScrLen ItemN
	  )
          (if (> dlta (abs (- ItemTmp ScrLenAbout)))
	    (setq temp ItemTmp
	          dlta (abs (- ItemTmp ScrLenAbout))
		  ScrLen ItemN
	    )
	  )
        )
      )
    )
  )
  (if temp
    (setq ScrLen2 temp
	  ScrLen1 (nth (xh_get ScrLen ScrLenLst2) ScrLenLst1)
    )
    (setq ScrLen1 (GetScrLen ScrLenLst1)
          ScrLen2 (if (= "M" mb) 
		    (atoi (nth (xh_get Scrlen1 ScrLenLst1) ScrLenLst2))
		    (nth (xh_get ScrLen1 ScrLenLst1) ScrLenLst2)
		  )
    )
  )
)

   
(defun GetScrLen(LengthLst / temp)
  (setq ScrLenDclID (load_dialog "ScrLen"))
  (if (not (new_dialog "ScrLen" ScrLenDclID)) (exit))
  (ini_list "SCRL" LengthLst)
  (mode_tile "SCRLOK" 1)
  (action_tile "SCRL"  "(setq temp (nth (atoi (get_tile \"SCRL\")) LengthLst)) 
			(set_tile \"MSG\" temp) (mode_tile \"SCRLOK\" 0)")
  (action_tile "SCRLOK" "(done_dialog)")
  (start_dialog)
  (unload_dialog ScrLenDclID)
  temp
)

