#ifndef _ADEADS_H
#define _ADEADS_H
/****************************************************************************/
/*
     
   Copyright (C) 1995, 1996 by Autodesk, Inc.
     
   Permission to use, copy, modify, and distribute this software in 
   object code form for any purpose and without fee is hereby granted, 
   provided that the above copyright notice appears in all copies and 
   that both that copyright notice and the limited warranty and 
   restricted rights notice below appear in all supporting 
   documentation.
     
   AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
   AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
   DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
   UNINTERRUPTED OR ERROR FREE.
     
   Use, duplication, or disclosure by the U.S. Government is subject to 
   restrictions set forth in FAR 52.227-19 (Commercial Computer 
   Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
   (Rights in Technical Data and Computer Software), as applicable.
     
*/ 

/*
** DESCRIPTION:  ADE ADS API header file
*/

/****************************************************************************/
/* INCLUDES */
/****************************************************************************/

#include "adslib.h"

/****************************************************************************/
/* TYPDEFS */
/****************************************************************************/

typedef double ade_id;
typedef unsigned short ade_boolean;					

/****************************************************************************/
/* DEFINES */
/****************************************************************************/

#define ADEMEMERROR	-1001		/* Memory allocation failed */
#define ADEINVERROR	-1002		/* acedInvoke() failed		 */
#define ADEERROR	-1003		/* AutoLISP API function retuns RTNIL */
#define ADE_REALFAIL -1.0

#define ADE_NULLID 	0			

#define ADE_TRUE       1
#define ADE_FALSE      0

/****************************************************************************/
/* API Functions */
/****************************************************************************/ 

/* Ensure that C++ modules use the right linking conventions when calling
   functions contained in C. */
#ifdef __cplusplus
    extern /*MSG0*/"C" {
#endif

/* CAdeDwg and CAdeDwgSet API functions	*/
/****************************************/

struct resbuf * ade_dwgselectdlg (void *hWndParent, const char * pcCaption);

struct resbuf *ade_dslist (ade_id dwg_id, ade_boolean show_nested);

ade_id	ade_dwggetid (char *dwgName);

int	ade_dsisnested (ade_id dwgId);

ade_id	ade_dsattach (char *dwgName);

int	ade_dsdetach (ade_id dwgId);

struct resbuf *ade_dsproplist (char *property);

struct resbuf *ade_dwgproplist (ade_id dwgId, char *property);

int	ade_dwgzoomextents ();

int	ade_dwgactivate (ade_id dwgId);

int	ade_dwgdeactivate (ade_id dwgId);

int	ade_dwgisactive (ade_id dwgId);

int	ade_dwgquickview (ade_id dwgId);

ads_real ade_editunlockobjs (ads_name selSet);

int	ade_dwghaslocks (ade_id dwgId);

int	ade_dwgunlock (ade_id dwgId);

struct resbuf *ade_dwgsetof (ade_id dwgId);

int	ade_dwgistoplevel (ade_id dwgId);

struct resbuf *ade_dwggetsetting (ade_id dwgId, char *property);

int	ade_dwgsetsetting (ade_id dwgId, struct resbuf *propList);

/*
** Sets entity label point. Offset is computed in respect to absolute 
** center point and stored in XData
*/
int ade_entsetlocation (ads_name entName, ads_point point);

/*
** Returns a list of the attribute tags, 
** given a block name from the specified drawing
*/
struct resbuf *	ade_dwgattriblist (ade_id dwgId, char *blockName);

/*
** Returns a list of the key column names for the sepcified lpn
*/
struct resbuf *	ade_keycolumnlist (char *lpn);

/* CAdeQueryDefinition API functions	*/
/****************************************/

ade_id ade_qrydefine ( char *joinOp, char *bgGroups, char *notOp, 
	char *condType, struct resbuf *qryCond, char *endGroups);

int	ade_qryclear ();

ads_real ade_qryexecute ();

struct resbuf *ade_qrygetentlist (ade_id dwgId);

int ade_qryhandent (ade_id dwgId, char *handle, ads_name result);

struct resbuf *ade_qrygetdwgandhandle (ads_name ename);

int	ade_qrysettype (char *qryType, ade_boolean multiLine, char *templ, 
	char *fileName);

int	ade_qrysetaltprop (ade_boolean flag);

struct resbuf *ade_qrylist ();

int	ade_qrygroup (ade_id lineId1, ade_id lineId2);

int	ade_qryungroup (ade_id lineId1, ade_id lineId2);

struct resbuf *ade_qrygetcond (ade_id qryLineId);

int ade_qrysetcond (ade_id qryLineId, struct resbuf *qryLineDefn);

char *ade_sqlgetenvstring (char *lpName);

int	ade_qrygetreptransform() ;

int	ade_qrysetreptransform(ade_boolean flag);

/* CAdeQueryLibrary API functions	*/
/************************************/

struct resbuf *ade_qllistctgy ();

int	ade_qldelctgy (ade_id ctgId);

struct resbuf *ade_qlgetctgyinfo (ade_id ctgId, char *info);

int ade_qlsetctgyname (ade_id ctgId, char *name);

struct resbuf *ade_qlgetqryinfo (ade_id qryId, char *info);

ade_id ade_qlqrygetid (char *qryName);

int	ade_qlsetquery (ade_id qryId, char *info, struct resbuf *value);

ade_id	ade_qrysave(char *ctgname, struct resbuf *qryParams);

int	ade_qldelquery (ade_id qryId);

int	ade_qlloadqry (ade_id qryId);


/* Preferences */
/***************/

struct resbuf *ade_prefgetval (char *variableName);

int ade_prefsetval (char *variableName, struct resbuf *value);


/* User Security */
/*****************/

struct resbuf *ade_userlist ();

int ade_userget(ade_boolean forEntityLocks, char* userName);

int	ade_userset (const char* userName, const char* pswd);

int ade_usergetrights(const char* kpUserName, int* pUserRights);

int ade_usersetrights(const char* kpUserName, int nUserRights);


/* Error Reporting */
/*******************/

int	ade_errcode (int errNumber);

int	ade_errtype (int errNumber);

char *ade_errmsg (int errNumber);

int	ade_errqty ();

int	ade_errclear ();

struct resbuf *ade_errstatement (int errNumber);

int	ade_errpush (int errCode, char *errLevel, char *errMsg);

int	ade_errpushstatement (char *errStmt, int errPos);

int ade_errgetlevel();

int ade_errsetlevel(int errLevel);

int ade_errshowdlg();


//* Aliases		 */
/*****************/

int	ade_aliasadd (char *aliasName, char *pathName);

int	ade_aliasdelete (char *aliasName);

int	ade_aliasupdate (char *aliasName, char *pathName);

struct resbuf *ade_aliasgetlist ();

/* Actual path to alias path and backward */
char * ade_dwgaliaspath(const char *path);
char * ade_dwgactualpath(ade_id dwgId);

/* Miscellaneous */
/****************/

struct resbuf *ade_version ();

struct resbuf *ade_osfexpand (char *path, char *ext, char *pattern);


/* Property Alteration Functions */
/*********************************/

int ade_altpclear(void);

ade_id ade_altpdefine(char *property, struct resbuf *value);

struct resbuf *ade_altplist(void);

int ade_altpsetprop(ade_id propId, char *property,	struct resbuf *value);

struct resbuf *ade_altpgetprop(ade_id propId);

int ade_altpdelprop(ade_id propId);

/* Range Table Functions */
/*************************/

struct resbuf *ade_rtlist(void);

ade_id ade_rtdefrange(char *name, char *description, struct resbuf *rangeDef);

int ade_rtdeltable(char *name);

struct resbuf *ade_rtgetprop(ade_id rangeId, char *property);

ade_id ade_rtgetid(char *tableName);

struct resbuf *ade_expreval(ads_name ename, char *expr, char *type);

/* Object Data Functions */
/*************************/

int ade_odrecordqty(ads_name ename, char *tableName);

int ade_oddelrecord(ads_name ename, char *tableName, int recnum);

int ade_odaddrecord(ads_name ename, char *tableName);

int ade_oddefinetab(struct resbuf *tableDef);

int ade_odmodifytab(struct resbuf *tableDef);

int ade_oddeletetab(char *tableName);

int ade_odaddfield(char *tableName, struct resbuf *fieldList);

int ade_odmodifyfield(char *tableName, struct resbuf *fieldList);

int ade_oddeletefield(char *tableName, struct resbuf *fieldList);

struct resbuf *ade_odtablelist(void);

struct resbuf *ade_odtabledefn(char *tableName);

struct resbuf *ade_odgettables(ads_name ename);

int ade_odsetfield(ads_name ename, char *tableName, char *fieldName, 
	int recnum, struct resbuf *value);

struct resbuf *ade_odgetfield(ads_name ename, char *tableName, char *fieldName,
	int recnum);

ade_id ade_odnewrecord(char *tableName);

int ade_odfreerec(ade_id recId);

int ade_odattachrecord(ads_name ename, ade_id recId);

int ade_odpresetfield(ade_id recId, char *fieldName, struct resbuf *value);

struct resbuf *ade_odgetrecfield(ade_id recId, char *fieldName);

ade_id ade_odgetrecord(ads_name ename, char *tableName, int recnum);

int ade_dwgindexdef(char *idxName, int fGenerate, struct resbuf *odParams);

int ade_dwgindex(ade_id dwgId);
   
/* Projection Functions */
/************************/

char *ade_projgetwscode(void);

int ade_projsetwscode(char *csCode);

int ade_projsetsrc(char *csCode);

int ade_projsetdest(char *csCode);

int ade_projptforward(ads_point pnt, ads_point result);

int ade_projptbackward(ads_point pnt, ads_point result);

struct resbuf *ade_projgetinfo(char *csCode, char *infoCode);

/*
**  Returns a list of the projection categories names
*/
struct resbuf *ade_projlistctgy ();

/*
**  Returns a list of the coord. systems for the given category
*/
struct resbuf *ade_projlistcrdsysts (char *ctgName);

/* Get the category what the coord system belongs to
*/
char * ade_projgetctgyname (char *csCode);


/* Editing Functions */
/*********************/

ads_real ade_editlockobjs(ads_name selSet);

struct resbuf *ade_editislocked(ads_name ename);

int ade_editlocked(ads_name result);

int ade_editnew(ads_name result);

int ade_editlockederased(ads_name result);

int ade_editdefcen(ads_name ename, ads_point pnt);

/* Save Functions */
/******************/

int ade_saveobjs(struct resbuf *priority);

int ade_savetodwg(ads_name selSet, ade_id dwgId);

#ifdef __cplusplus
    }
#endif

#endif // __ADEADS_H
/* EOF */
