#ifndef _ADETOPO_H
#define _ADETOPO_H
/******************************************************************************/
/*
     
   Copyright (C) 1995, 1996 by Autodesk, Inc.
     
   Permission to use, copy, modify, and distribute this software in 
   object code form for any purpose and without fee is hereby granted, 
   provided that the above copyright notice appears in all copies and 
   that both that copyright notice and the limited warranty and 
   restricted rights notice below appear in all supporting 
   documentation.
     
   AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  
   AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
   DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
   UNINTERRUPTED OR ERROR FREE.
     
   Use, duplication, or disclosure by the U.S. Government is subject to 
   restrictions set forth in FAR 52.227-19 (Commercial Computer 
   Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
   (Rights in Technical Data and Computer Software), as applicable.
   
   
   CREATED BY:   Roman Zimin April, 1996
   
   DESCRIPTION:  ADE Topology ADS API header file
*/

/****************************************************************************/
/* INCLUDES */
/****************************************************************************/
#include "adeads.h"
/****************************************************************************/
/* API Functions */
/****************************************************************************/ 

/* Ensure that C++ modules use the right linking conventions when calling
   functions contained in C. */
#ifdef __cplusplus
    extern /*MSG0*/"C" {
#endif

/*  Topology variables */
ade_id         tpm_varalloc        ();
int            tpm_varget          (ade_id var_id,
                                    char *var_name,
                                    struct resbuf *res);
int            tpm_varset          (ade_id var_id,
                                    char *var_name,
                                    struct resbuf *val);
struct resbuf *tpm_varlist         (ade_id var_id);
int            tpm_varfree         (ade_id var_id);

/* Cleanup */
ade_id         tpm_cleanalloc      ();
int            tpm_cleaninit       (ade_id clean_id,
                                    ade_id var_id,
                                    ads_name ss);
int            tpm_cleanstart      (ade_id clean_id);
int            tpm_cleangroupnext  (ade_id clean_id);
int            tpm_cleancomplete   (ade_id clean_id);
int            tpm_cleangrouptype  (ade_id clean_id);
int            tpm_cleangroupsubtype (ade_id clean_id);
int            tpm_cleangroupqty   (ade_id clean_id,
                                    long *qty);
int            tpm_cleangroupdraw  (ade_id clean_id);
int            tpm_cleangroupmark  (ade_id clean_id);
int            tpm_cleangroupfix   (ade_id clean_id);
int            tpm_cleanerrorcur   (ade_id clean_id,
                                    long index);
int            tpm_cleanerrordraw  (ade_id clean_id);
int            tpm_cleanerrormark  (ade_id clean_id);
int            tpm_cleanerrorget   (ade_id clean_id,
                                    ads_point coords);
int            tpm_cleanerrorset   (ade_id clean_id,
                                    ads_point coords);
int            tpm_cleanerrorfix   (ade_id clean_id);
int            tpm_cleanend        (ade_id clean_id);
int            tpm_cleancancel     (ade_id clean_id);
int            tpm_cleanfree       (ade_id clean_id);

/* new Map 6 entries */
int			   tpm_cleanincludess      (ade_id var_id,
									    ads_name ssInclude);
int			   tpm_cleananchorss       (ade_id var_id,
									    ads_name ssAnchor);

int			   tpm_cleaninitanchorset  (ade_id clean_id,
									    ade_id var_id,
									    ads_name ssAnchor);

int			   tpm_cleanprofileload    (ade_id var_id,
										char *filename);
int			   tpm_cleanprofilesave    (ade_id var_id,
										char *filename);
int			   tpm_cleanactionlistins  (ade_id clean_model_var_id,
									    long index,
									    int action,
									    ade_id action_var_id);
int			   tpm_cleanactionlistdel  (ade_id var_id,
									    long index);
int			   tpm_cleanactionlistqty  (ade_id var_id,
									    long *qty);
int			   tpm_cleanactionlistgetat(ade_id clean_model_var_id,
									    long index,
									    ade_id action_var_id);

/*  Topology iterator */
ade_id         tpm_iterstart       (int source,
                                    int loaded);
int            tpm_iternext        (ade_id iter_id);
int            tpm_itername        (ade_id iter_id,
                                    char *buffer,
                                    int buflen);
int            tpm_iterversion     (ade_id iter_id,
                                    char *buffer,
                                    int buflen);
int            tpm_iterdesc        (ade_id iter_id,
                                    char *buffer,
                                    int buflen);
int            tpm_itertype        (ade_id iter_id);
int            tpm_iterstop        (ade_id iter_id);

/* Topology access */
int            tpm_acqty           (int source,
                                    int loaded);
int            tpm_acexist         (char *name,
                                    int source,
                                    int loaded);
int            tpm_acload          (char *name,
                                    int source);
int            tpm_acunload        (char *name);
ade_id         tpm_acopen          (char *name,
                                    int write_access);
int            tpm_acupgradeopen   (ade_id tpm_id);
int            tpm_acclose         (ade_id tpm_id);

/* Topology maintain functions */
int            tpm_mntbuild        (ade_id var_id,
                                    char *name,
                                    char *desc,
                                    int type,
                                    ads_name node_ss,
                                    ads_name link_ss,
                                    ads_name cntr_ss);
int            tpm_mntrebuild      (char *name);
int            tpm_mnterase        (char *name);
int            tpm_mntrename       (char *name,
                                    char *newName,
                                    char *newDesc);

/* Topology information */
int            tpm_infoname        (ade_id tpm_id,
                                    char *buffer,
                                    int buflen);
int            tpm_infoversion     (ade_id tpm_id,
                                    char *buffer,
                                    int buflen);
int            tpm_infodesc        (ade_id tpm_id,
                                    char *buffer,
                                    int buflen);
int            tpm_infotype        (ade_id tpm_id);
int            tpm_infocomplete    (ade_id tpm_id);
int            tpm_infocorrect     (ade_id tpm_id);
int            tpm_infobuildvar    (ade_id tpm_id,
                                    ade_id var_id);
int            tpm_infocurrent     (ade_id tpm_id);
int            tpm_infostatus      (ade_id tpm_id);
int            tpm_infomodified    (ade_id tpm_id);
                                    
/* Topology elements */                                    
int            tpm_elemqty         (ade_id tpm_id,
                                    int type,
                                    long *qty);
ade_id         tpm_elemid          (ade_id tpm_id,
                                    int type,
                                    long index);
struct resbuf *tpm_elemget         (ade_id tpm_id,
                                    ade_id elem_id);
struct resbuf *tpm_elemadj         (ade_id tpm_id,
                                    ade_id elem_id,
                                    int adj_type);
ade_id         tpm_elemfind        (ade_id tpm_id,
                                    int type,
                                    struct resbuf *pattern);
int            tpm_elemss          (ade_id tpm_id,
                                    int type,
                                    ads_name ss);

/* Topology analyzing */
int            tpm_anabuffer       (ade_id source_id,
                                    char *offset,
                                    ade_id var_id,
                                    char *result,
                                    char *desc);
int            tpm_anaoverlay      (ade_id overlay_id,
                                    struct resbuf *over_data,
                                    ade_id source_id,
                                    struct resbuf *sour_data,
                                    int oper,
                                    ade_id var_id,
                                    char *irdTable,
                                    char *irdTableDesc,
                                    char *result,
                                    char *desc);
int            tpm_anadissolve     (ade_id source_id,
                                    char *field,
                                    ade_id var_id,
                                    char *result,
                                    char *desc,
                                    char *irdTable,
                                    char *irdColumn);
                                    
/* Topology editing */
int            tpm_editaddelem     (ade_id tpm_id,
                                    int type,
                                    struct resbuf *elem);
int            tpm_editdelelem     (ade_id tpm_id,
                                    ade_id elem_id,
                                    int del_ent);/* if != 0, delete entities */
int            tpm_editmodelem     (ade_id tpm_id,
                                    ade_id elem_id,
                                    struct resbuf *new_val);
int            tpm_editupdelem     (ade_id tpm_id,
                                    ade_id elem_id);

/* Network tracing */
ade_id         tpm_tracealloc      (ade_id tpm_id,
                                    char *node_res,
                                    char *link_dir,
                                    char *link_direct_res,
                                    char *link_reverse_res);
struct resbuf *tpm_traceelemget    (ade_id trace_id,
                                    ade_id elem_id);
int            tpm_traceelemedit   (ade_id trace_id,
                                    ade_id elem_id,
                                    struct resbuf *new_val);
int            tpm_tracesetminres  (ade_id trace_id,
                                    ads_real res);
int            tpm_tracesetmaxres  (ade_id trace_id,
                                    ads_real res);
int            tpm_traceshort      (ade_id trace_id,
                                    ade_id start,
                                    ade_id end);
int            tpm_traceshortval   (ade_id trace_id,
                                    ads_real *res);
ade_id         tpm_traceshortscan  (ade_id trace_id,
                                    int flag);
int            tpm_traceflood      (ade_id trace_id,
                                    ade_id start,
                                    ads_real maxres);
int            tpm_tracebestroute  (ade_id topol_id,
									ade_id trace_id,
                                    struct resbuf *nodes);
int            tpm_tracebestrouteval(ade_id trace_id,
                                     ads_real *res);
ade_id         tpm_tracebestroutescan(ade_id trace_id,
                                      int flag);
int            tpm_traceqty        (ade_id trace_id,
                                    int type,
                                    long *qty);
ade_id         tpm_traceelemid     (ade_id trace_id,
                                    int type,
                                    long index);
int            tpm_tracefree       (ade_id trace_id);

/* Topology query parameters */
int            tpm_qrysettoponame  (char *name);
int            tpm_qrygettoponame  (char *buffer,
                                    int buflen);
int            tpm_qrysetrestopo   (char *name,
                                    char *desc);
int            tpm_qrygetrestopo   (char *buffer,
                                    int buflen);
int            tpm_qrygetresdesc   (char *buffer,
                                    int buflen);

#ifdef __cplusplus
    }
#endif

#endif /*_ADETOPO_H*/
/* EOF */
