// AcMapOracleConnection.h: interface for the AcMapOracleConnection class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPORACLECONNECTION_H__37F26EC7_2DE9_11D5_96DA_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPORACLECONNECTION_H__37F26EC7_2DE9_11D5_96DA_0010B56FA9A3__INCLUDED_

#pragma once

#include "oracl.h"			//for Oracle objects
#include "OracleExports.h"	//for ORCL_API

class AcMapOConnection;				//forward
class AcMapOracleConnection;		//forward
class AcMapOracleConnectionReactor;	//forward
class AcMapOracleImportReactor;		//forward
class AcMapOracleExportReactor;		//forward


//factory method
ORCL_API AcMapOracleConnection *AcMapOracleGetConnection();

class ORCL_API AcMapOracleConnection  
{
friend class AcMapOracleExport;
friend class AcMapOracleImport;
friend class AcMapOracleQuery;
friend AcMapOracleConnection *AcMapOracleGetConnection();
public:
	~AcMapOracleConnection();
	bool IsConnected() const;
	bool Connect(
		const char *kpcSchema,
		const char *kpcService=NULL,
		const char *kpcUserName=NULL, 
		const char *kpcUserPassword=NULL);
	bool Disconnect();
	bool IsSchemaValid();
	bool AddConnectionReactor(AcMapOracleConnectionReactor *pReactor);
	bool RemoveConnectionReactor(AcMapOracleConnectionReactor *pReactor);
	bool AddImportReactor(AcMapOracleImportReactor *pReactor);
	bool RemoveImportReactor(AcMapOracleImportReactor *pReactor);
	bool AddExportReactor(AcMapOracleExportReactor *pReactor);
	bool RemoveExportReactor(AcMapOracleExportReactor *pReactor);
	
	const char *Service() const;
	const char *Schema() const;
	const char *UserName() const;
	const ODatabase &Database() const;
private:
	bool IsConnected(bool bAddErrToErrStack) const;
	//methods
	AcMapOracleConnection();
	// Unimplemented Stuff
	AcMapOracleConnection(const AcMapOracleConnection &);
	AcMapOracleConnection &operator=(const AcMapOracleConnection &);

	//data
	AcMapOConnection *m_pConnection;
};


#endif // !defined(AFX_ACMAPORACLECONNECTION_H__37F26EC7_2DE9_11D5_96DA_0010B56FA9A3__INCLUDED_)
