// AcMapOracleExport.h: interface for the AcMapOracleExport class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPORACLEEXPORT_H__484F3AE1_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPORACLEEXPORT_H__484F3AE1_3039_11D5_96DE_0010B56FA9A3__INCLUDED_

#pragma once

class AcMapOExport;
class AcMapOracleConnection;

#include "OracleExports.h"	//for ORCL_API

class ORCL_API AcMapOracleExport
{
public:
	AcMapOracleExport(AcMapOracleConnection &connection);
	virtual ~AcMapOracleExport();

	//bit flags to control the associated data export
	//note: kUpdateErased can be used only if kDisregardIDs is not set
	typedef enum
	{
	kObjectData			=0x1,	//to be set if the Object Data should be exported
	kLinkTemplates		=0x2,	//to be set if the Link Templates should be exported
	kBlockAttributes	=0x4,	//to be set if the Block Attributes should be exported
	kEraseExported		=0x8,	//to be set if the objects should be erased after export
	kDisregardIDs		=0x10,	//to be set if the export should add new records to the database
	kUpdateErased		=0x20	//to be set if the erased object should be erase from the database
	} EExportOptions;

	bool ExportObjects(
		const AcDbObjectIdArray &arrAcDbObj,
		int eOptions=kObjectData|kLinkTemplates|kBlockAttributes|kEraseExported);
	bool ExportObjectsAll(
		const char *kpcLayerFilter="*", 
		int eOptions=kObjectData|kLinkTemplates|kBlockAttributes|kEraseExported);
private:
	AcMapOExport *m_pExport;
};

#endif // !defined(AFX_ACMAPORACLEEXPORT_H__484F3AE1_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
