// AcMapOracleQuery.h: interface for the AcMapOracleQuery class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPORACLEQUERY_H__484F3AE4_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPORACLEQUERY_H__484F3AE4_3039_11D5_96DE_0010B56FA9A3__INCLUDED_

#pragma once

class AcMapOracleConnection;	//forward
class AcDbDatabase;				//forward
class AcMapOQuerySqlStatement;	//forward

#include "OracleExports.h"	//for ORCL_API

class ORCL_API AcMapOracleQuery  
{
friend class AcMapOracleImport;
public:
	AcMapOracleQuery(AcMapOracleConnection &connection);
	virtual ~AcMapOracleQuery();

	bool InitWithCurrent(AcDbDatabase *pDbDatabase=NULL);//NULL is the current database;
	bool Init(const char *kpcWhereClause);
	const char * ConvertToSqlString();
	bool Load(const char *kpcQueryName);
	bool Save(const char *kpcQueryName) const;
private:
	AcMapOracleConnection &m_connection;
	AcMapOQuerySqlStatement *m_pSqlQuery;
};

#endif // !defined(AFX_ACMAPORACLEQUERY_H__484F3AE4_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
