// AcMapOSEConnection.h: interface for the AcMapOSEConnection class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPORACLECONNECTION_H__37F26EC7_2DE9_11D5_96DA_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPORACLECONNECTION_H__37F26EC7_2DE9_11D5_96DA_0010B56FA9A3__INCLUDED_

#pragma once

#include "oracl.h"			//for Oracle objects
#include "OracleExports.h"	//for ORCL_API
#include <vector>
#include <string>
class AcMapOConnection;				//forward
class AcMapOSEConnection;		//forward
class AcMapOSEConnectionReactor;	//forward
class AcMapOSEImportReactor;		//forward
class AcMapOSEExportReactor;		//forward


//factory method
ORCL_API AcMapOSEConnection *AcMapOSEGetConnection();

class ORCL_API AcMapOSEConnection  
{
friend class AcMapOSEExport;
friend class AcMapOSEImport;
friend class AcMapOSEQuery;
friend AcMapOSEConnection *AcMapOSEGetConnection();
public:
	~AcMapOSEConnection();
	bool IsConnected() const;
	bool Connect(
		const char *kpcSchema,
		const char *kpcService=NULL,
		const char *kpcUserName=NULL, 
		const char *kpcUserPassword=NULL,
		bool bValidateSchema=false);
	bool Disconnect();
	bool RefreshSchema();
	bool IsSchemaValid();
	bool Features(std::vector<std::string> &vFeaturesNames) const;
	bool AddConnectionReactor(AcMapOSEConnectionReactor *pReactor);
	bool RemoveConnectionReactor(AcMapOSEConnectionReactor *pReactor);
	bool AddImportReactor(AcMapOSEImportReactor *pReactor);
	bool RemoveImportReactor(AcMapOSEImportReactor *pReactor);
	bool AddExportReactor(AcMapOSEExportReactor *pReactor);
	bool RemoveExportReactor(AcMapOSEExportReactor *pReactor);
	
	const char *Service() const;
	const char *Schema() const;
	const char *UserName() const;
	const ODatabase &Database() const;
private:
	bool IsConnected(bool bAddErrToErrStack) const;
	//methods
	AcMapOSEConnection();
	// Unimplemented stuff
	AcMapOSEConnection(const AcMapOSEConnection &);
	AcMapOSEConnection &operator=(const AcMapOSEConnection &);

	//data
	AcMapOConnection *m_pConnection;
	bool m_bSchemaValid;
};


#endif // !defined(AFX_ACMAPORACLECONNECTION_H__37F26EC7_2DE9_11D5_96DA_0010B56FA9A3__INCLUDED_)
