// AcMapOracleExport.h: interface for the AcMapOSEExport class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPORACLEEXPORT_H__484F3AE1_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPORACLEEXPORT_H__484F3AE1_3039_11D5_96DE_0010B56FA9A3__INCLUDED_

#pragma once

class AdMapOExport;
class AcMapOSEConnection;

#include "OracleExports.h"	//for ORCL_API
#include <vector>
class ORCL_API AcMapOSEExport
{
public:
	AcMapOSEExport(AcMapOSEConnection &connection);
	virtual ~AcMapOSEExport();

	//bit flags to control the associated data export
	//note: kUpdateErased can be used only if kDisregardIDs is not set
	typedef enum
	{
		kRollbackAtError=0x1,	//to be set if you want to rollback all transaction at any error during export
		kUpdateModified	=0x2,	//to be set if you want to update the changed locked objects
		kUpdateErased	=0x4,	//to be set if the erased object should be erase from the database
		kRemoveExported =0x8	//to be set if the objects should be erased from the drawing after export
	} EExportOptions;

	bool Init(
		const std::vector<std::string> &vFeaturesNames, 
		int nOptions=kRollbackAtError|kUpdateModified|kUpdateErased|kRemoveExported);
	bool ExportObjects(
		const AcDbObjectIdArray &arrAcDbObj);
	bool ExportObjectsAll(AcDbDatabase *pDatabase);
private:
	AdMapOExport *m_pExport;
};

#endif // !defined(AFX_ACMAPORACLEEXPORT_H__484F3AE1_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
