// AcMapOracleIdentification.h: interface for the AcMapOSEObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPORACLEIDENTIFICATION_H__484F3AE2_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPORACLEIDENTIFICATION_H__484F3AE2_3039_11D5_96DE_0010B56FA9A3__INCLUDED_

#pragma once

#include "dbid.h"			//for AcDbObjectId
#include "OracleExports.h"	//for ORCL_API
#include <string>			//for std::string

class AcMapOSEConnection;	//forward

class ORCL_API AcMapOSEObject  
{
public:
	AcMapOSEObject (AcMapOSEConnection &connection);
	bool Init(AcDbObjectId acadId);
	bool Init(const OValue &oracleId, AcDbDatabase *pDatabase=NULL);
	virtual ~ AcMapOSEObject ();

	const OValue &GetOracleID() const;
	AcDbObjectId GetAcadID() const;
	const char *FeatureName() const;
	bool IsInEditSet() const;
	bool AddToEditSet() const;
	bool RemoveFromEditSet() const;
	bool IsUpToDate() const;
	bool IsModified() const;
	bool IsErased() const;
	unsigned long Version() const;
	bool WhoHasIt(
		unsigned long &UserId,
		std::string &strNtUser,
		std::string &strDbUser,
		std::string &strMapUser,
		std::string &strComputer,
		std::string &strLoginTime) const;

private:
	AcMapOSEConnection &m_connection;
	AcDbObjectId m_acadId;
	OValue m_ovOracleId;
	AcDbDatabase *m_pDatabase;
};

#endif // !defined(AFX_ACMAPORACLEIDENTIFICATION_H__484F3AE2_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
