// AcMapOracleProject.h: interface for the AcMapOSEProject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPOSEPROJECT_H__484F3AE2_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPOSEPROJECT_H__484F3AE2_3039_11D5_96DE_0010B56FA9A3__INCLUDED_

#pragma once

#include "dbid.h"			//for AcDbObjectId
#include "OracleExports.h"	//for ORCL_API
#include <vector>			//for std::vector
#include <string>			//for std::string

class AcMapOSEConnection;	//forward
class AcMapOProject;		//forward
class AcDbDatabase;			//forward

class ORCL_API AcMapOSEProject
{
public:
	AcMapOSEProject(AcMapOSEConnection &connection);
	virtual ~AcMapOSEProject();
	bool Init(AcDbDatabase *pDwg);
	typedef enum
	{
		kInEditSet=0x1,
		kNotInEditSet=0x2
	} EProjectOptions;

	// FilterQueriedObjects function is used to filter out the objects by their
	//state (i.e. locked, unlocked, erased, modified, etc). 
	//Using the this function you may specify the empty vector of features
	//to include all features in the schema, which specific to the connection. Empty
	//input array means all objects in the drawing will be considered for filtering.
	bool FilterQueriedObjects (
		const std::vector<std::string> &vFeatures,
		const AcDbObjectIdArray &arrInput,
		AcDbObjectIdArray &arrErased,
		AcDbObjectIdArray &arrModified,
		AcDbObjectIdArray &arrUnchanged,
		AcDbObjectIdArray &arrFilteredOut,
		int options) const;
	bool FilterNewObjects(
		const std::vector<std::string> &vFeatures,
		const AcDbObjectIdArray &arrInput,
		AcDbObjectIdArray &arrNew,
		AcDbObjectIdArray &arrFilteredOut) const;

	//the following two methods allow you to lock or unlock many objects in one call, they supposed
	//to be faster than the number of the correspondent calls to the methods of the
	//AcMapOSEObject class
	bool AddToEditSet(
		const AcDbObjectIdArray &acadIds, 
		AcDbObjectIdArray &arrFilteredOut);
	bool RemoveFromEditSet(
		const AcDbObjectIdArray &acadIds, 
		AcDbObjectIdArray &arrFilteredOut);

private:
	AcMapOSEConnection &m_connection;
	AcMapOProject *m_pProject;
};

#endif // !defined(AFX_ACMAPOSEPROJECT_H__484F3AE2_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
