// AdMapOracleQuery.h: interface for the AcMapOSEQuery class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACMAPORACLEQUERY_H__484F3AE4_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
#define AFX_ACMAPORACLEQUERY_H__484F3AE4_3039_11D5_96DE_0010B56FA9A3__INCLUDED_

#pragma once

class AcMapOSEConnection;	//forward
class AcDbDatabase;				//forward
class AcMapOMultipleQuerySqlStatement;	//forward

#include "OracleExports.h"	//for ORCL_API
#include <string>
#include <vector>

class ORCL_API AcMapOSEQuery  
{
friend class AcMapOSEImport;
public:
	AcMapOSEQuery(AcMapOSEConnection &connection);
	virtual ~AcMapOSEQuery();

	bool InitWithCurrent(AcDbDatabase *pDbDatabase=NULL);//NULL is the current database;
	void Clear();
	bool AddWhereConditionInFeatures(
		const std::vector<std::string>& vectFeatureNames, 
		const char *kpcWhereCondition,
		bool bAnd);
	//this method allows receiving the information about tables' aliases for the specified feature
	bool GetAliases(
			const std::string& strFeatureName,
			std::vector<std::string>& vectTableNames,
			std::vector<std::string>& vectAliases);
	const char * ConvertToSqlString();
	bool Load(const char *kpcQueryName);
	bool Save(const char *kpcQueryName) const;
private:
	AcMapOSEConnection &m_connection;
	AcMapOMultipleQuerySqlStatement *m_pSqlQuery;
};

#endif // !defined(AFX_ACMAPORACLEQUERY_H__484F3AE4_3039_11D5_96DE_0010B56FA9A3__INCLUDED_)
