#ifndef MAP_CONSTANTS_H
#define MAP_CONSTANTS_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains MAP ARX API constants.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

// Internal MAP object Identifier representation within the ARX API 
typedef unsigned long AcMapId ;

const unsigned long ERR_DWG_ID          = 0xFFFFFFFF;
const int   MAX_ODTABLE_NAME_LENGTH     = 32;
const int   MAX_ODCOLUMN_NAME_LENGTH    = 32;
const int   MAX_ODCOLUMN_DESC_LENGTH    = 256;

struct AcMap {

	// Run-time class identification for API classes
	enum EClassId
	{
		// location boundary classes
		kLocationBoundary = 1,
		kAllBoundary,
		kPointBoundary,
		kCircleBoundary,
		kFenceBoundary,
		kBufferFenceBoundary,
		kPolygonBoundary,
		kWindowBoundary,
		kPolylineBoundary,
		kBufferPolylineBoundary,
		kClosedPolylineBoundary,

		// Query Condition classes
		kQueryUnit,
		kQueryCondition,
		kLocationCondition,
		kPropertyCondition,
		kSQLCondition,
		kDataCondition,
		kLocationConditionImp,
		kPropertyConditionImp,
		kSQLConditionImp,
		kDataConditionImp,
		kQueryBranch
	} ;

	enum EAdeDwgStatus 
	{
		kDwgInactive        = 0,
		kDwgActive			= 1,
		kDwgLocked			= 4
	} ;

    // Types of AutoCAD Map Query
    enum EQueryType {
        kQueryDraw,
        kQueryPreview,
        kQueryReport
    } ;
    
    // types for the logical operators
    enum EJoinOperator
    {
	    kOperatorAnd = 1,
	    kOperatorOr	
    } ;

    // types for location query
    enum ELocationType
    {
	    kLocationInside,
	    kLocationCrossing
    } ;

    // object type for the property query
    enum EPropertyType
    {
	    kArea,
	    kBlockName,
	    kColor,
	    kElevation,
	    kEntType,
	    kGroup,
	    kLayer,
	    kLength,
	    kLineType,
	    kTextStyle,
	    kTextValue,
	    kThickness,
		kFeature,
		kLineweight,
		kPlotstyle
    } ;

    // types of symbol tables
    enum ETableType 
	{
        kBlockTable,
        kLayerTable,
        kLinetypeTable,
        kStyleTable,
        kRegappTable,
        kGroupTable,
        kLinkTemplate,
        kODD,
        kMLinestyleTable,
		kFeatureTable,
		kLineweightTable,
		kPlotstyleTable
    } ;
    
    // types of condition operators
    enum EConditionOperator
    {
	    kCondEq = 1,
	    kCondGT,
	    kCondGTorEq,
	    kCondLT,
	    kCondLTorEq,
	    kCondNotEq
    } ;
    
    //data query types
    enum EDataQueryType
    {
	    kDataIRD,
	    kDataAttribute,
	    kDataLinkTemplate,
        kDataEED,
		kDataFeature
    } ;    

	// options to save query
	enum ESaveQueryOptions
	{
		kSaveDrawingSet = 1,
		kSaveLocationCoordinates = 2,
		kSavePropertyAlteration	= 4,
		kAutoExecute = 8
	} ;

    // types of property alteration
    enum EAlterationType
    {
        kAlterationBlockName,
        kAlterationColor,
        kAlterationLayer,
        kAlterationRotation,
        kAlterationElevation,
        kAlterationHeight,
        kAlterationLineType,
        kAlterationScale,
        kAlterationStyle,
        kAlterationText,
        kAlterationThickness,
        kAlterationWidth,
        kAlterationTextEntity,
        kAlterationHatch,
    } ;
    
    // enum for types of the preferences
    enum EProjectOptionType
    {
		kQryPrefDefn,
		kSvBkPrefDefn,
		kCoordXformPrefDefn
	} ;

    // enum for types of the objects in the save set
    enum SaveSetObjectType
    {
        kQueriedExisted = 1,		// queried existed object
        kQueriedErased  = 2,		// queried erased object
        kNewlyCreated   = 4			// newly created object
    } ;

	// drawing update status 
	// this status should be set for the drawing to control saving back
	enum EAdeDwgUpdateStatus 
	{
		kDwgNonupdated        = 0,	// nothing to save
		kDwgShouldBeReloaded  = 1,	// lock information updated - another AutoCAD Map should only reload the drawing
		kDwgShouldBeRequeried = 4	// queried objects have been modified - another AutoCAD Map insatnce should requery
	} ;
			 
	// Preferences types
	enum EPrefType
	{
		kWSpaceType = 0,    // workspace
		kWSessType,		    // work session
		kQryType,		    // query
		kSvBkType,		    // save back
		kExtDbType,		    // database
		kCoordXformType,	// coordinate transformation
		kSystemType,	    // system
		kCoordsysType		// coordinate system
	};

	// User privileges constants
	enum EUserRights
	{
		kRightsSuperUser  = 1,	// superuser
		kRightsAltDwgSet  = 2,	// alter drawing set
		kRightsEditDwg    = 4,	// edit drawings
		kRightsDrawQuery  = 8,	// run "draw" query
		kRightsAltClass   = 16	// alter feature class
	};

    //  Object data value types
    enum EDataType
    {
        kUnknownType = 0,
        kInteger,
        kReal,
        kCharacter,
        kPoint
    };

    // types of range condition operators
    enum ERangeOperator
    {
	    kRangeEq = 1,
	    kRangeGT,
	    kRangeGTorEq,
	    kRangeLT,
	    kRangeLTorEq,
	    kRangeNotEq,
		kRangeOtherwise
    } ;

	enum EOpenMode 
	{
		kAdeClosed,
		kOpenForWrite,		
		kOpenForRead	
	} ;

	//  error message types
	enum EErrType 
	{
		kAdeNoMessage = 0 ,
		kAdeWarning,
		kAdeError,
		kAseWarning,
		kAseError,
		kAcWarning,
		kAcError,
		kAsiWarning,
		kAsiError,
		kIRDWarning,
		kIRDError,
		kWCWarning,
		kWCError,
		kMapError,
		kMentorError,
		kApplicationError,
		kDiagMessage
	} ;

	enum EErrCode {
		// For common usage
   		kOk = 0,
   		kErr,
   		kErrBadInput,
   		kErrObjectNotFound,
   		kErrOutOfMemory,
   		kErrObjNotInitialized,
		kErrWrongType,
		kErrWrongProject,
		kErrEOB,
   		kErrADSError,
   		kErrAdsNameConvertionFails,
		kErrWrongArgument,
		kErrWriteBufFails ,
		kErrReadBufFails,
		kErrXDataCorrupted,
		kErrNoEnvironment,
		kErrUsrBreak,
		kErrUncomparable,
		kErrPermissionDenied,
		kErrWrongSyntax,
		kErrDuplicate,
		kErrInvalidPathOrFileName,
		kErrInvalidVersion,
		kErrFileIOFatalError,

		// External subsystems
		kErrAcDbError = 200,
		kErrIRDNotInitialized,
		kErrIRDError,
		kErrASENotInitialized,
		kErrASEError,
		kErrASIError,
		kErrAsiNotInitialized,
		kErrAsiConnectToEnvironmentFailed,

		//	For transactional manager
		kErrClosed			= 1000,
		kErrWasErased,
		kErrOpenForRead,
		kErrOpenForWrite,
		kErrWrongMode,
		kErrClone,
		kErrResponse,
		kErrObjIsAbsent,
		kErrAccess,
		kErrMultipleUsage,
		kErrUpgrade,
		kErrNotClosed,

		// For CAdeList
		kErrGetIteratorFails = 1100, 
		kErrListIsEmpty,

		// For CAdeListIterator
		kErrListEnd,
		kErrListObjectIsAbsent,

  		// for source drawing
		kErrQueriedEntity = 1200,
		kErrDwgNotActive,
		kErrReadDwgFileFails,
		kErrMultipleUsers,
   		kErrEntityLockingFails,                      
		kErrUnlockedEntity,
		kErrLockedEntity,
		kErrAlreadyInSaveSet,		 
		kErrAlreadyNotInSaveSet,
		kErrMultipleReaders,
		kErrOpenPrefDictionaryFails,
		kErrSavePrefDictionaryFails,
   		kErrRestoreDSetFails,
		kErrOpenDSetDictionaryFails,
		kErrSaveDSetDictionaryFails,
		kErrOpenQueryDictionaryFails,
		kErrSaveQueryDictionaryFails,
		kErrOpenRTableDictionaryFails,
		kErrSaveRTableDictionaryFails,
		kErrRestoreRTableDictionaryFails,
		kErrOpenDocViewDictionaryFails,
		kErrSaveDocViewDictionaryFails,
		kErrOpenKeyViewDictionaryFails,
		kErrSaveKeyViewDictionaryFails,
		kErrSaveProjectionFails,
		kErrCopyHardPointerFails,
		kErrDwgToBeReloaded,
		kErrDwgHasBeenModified,
		kErrOnLockedLayer,
		kErrDwgSaveFales,
		kErrDwgLocksLeft,
		kErrLinkWillBeLost,
		kErrDwgDiskFull,
		kErrDwgHasQueriedObject,
		kErrUnlockedFile ,

		// for the Current Session
		kErrGetCPointFails = 1300,
		kErrSetCPointFails,
		kErrTextInsPointMissed,
		kErrTextAllignPointMissed,
		kErrTextHeightMissed,
		kErrTextStringMissed,
		kErrIndexUpdateFails,
		kErrIgnorePreview,
		kErrIgnorePSpace,
		kErrEraseIRDObjectFails,
		kErrRenameIRDObjectFails,
		kErrAlterIRDObjectFails,
		kErrIrdDuplicateTableName,
		kErrIrdNotIdenticaFormat,
		kErrBHatchUnit,
		kErrReQuery,
		kErrCantAccessFont,
		kErrCantAccessImageFile,
		kErrUnableRedefineXrefBlock,

		// Drawing Set
		kErrRestoreDrawingSetFails = 1500,
		kErrDuplicatedDrawing,
		kErrNestedDrawing,
		kErrActivateDrawingFails,
		kErrDeactivateDrawingFails,
		kErrLongDrawingDescription,
		kErrEntityHasBeenLocked,   
		kErrPreviewNotSupported,
		kErrAliasIsInUse,
		kErrActivateDrawingCancelled,
		kErrAttachDrawingCancelled,

		// for Feature Alteration
		kErrInvalidFeatureType = 1800,
		kErrNoListId,
		kErrInvalidExpType,
		kErrNoExpression,
		kErrTextCreationFailed,
		kErrHatchCreationFailed,
		kErrInvalidColor,
		kErrInvalidLayer,
		kErrInvalidStyle,
		kErrInvalidJustification,
		kErrInvalidScale,
		kErrNoRangeId,

		// Mapping
		kErrMapCoincPoint = 1900,
		kErrMapWrongScale,
		kErrMapTransform,
		kErrMapWrongExtents,
		kErrMapWrongPoints,
		kErrMapWrongSelSet,
		kErrMapWrongEntityName,
		kErrMapOpenEntity,
		kErrMapUpgradeEntity,
		kErrMapMoveStretchPoints,
		kErrMapEntityPoint,
		kErrMapCmdecho,
		kErrMapCecolor,
		kErrMapHatch,
		kErrMapWrongIntersectForPoints,
		kErrMapWrongHandle,
		kErrMapNotPolyline,
		kErrMapIterator,
		kErrMapWriteXData,
		kErrMapBuffer,
		kErrMapStretchPoints,

		// Topology
		kErrTopInvalidName = 2000,
		kErrTopExist,
		kErrTopBuildNet,
		kErrTopBuildPolygon,
		kErrTopBuildNode,
		kErrTopBuildArc,
		kErrTopBuildCntr,
		kErrTopAPIReg,
		kErrTopFuncNotAvail,
		kErrTopWriteData,
		kErrTopNotExist,
		kErrTopOverlayType,
		kErrTopMakeLayer,
		kErrTopBlockNotExist,
		kErrTopNotOpenForWrite,
		kErrTopOpenIrdTable,
		kErrTopWrongIrdAttr,
		kErrTopLoaded,
		kErrTopIncompleteElem,
		kErrTopInvalidColor,
		kErrTopInvalidFlag,
		kErrTopInvalidTolerance,
		kErrTopInvalidCorridor,
		kErrTopInvalidOffset,
		kErrTopInvalidHeight,
		kErrTopInvalidMarkerType,
		kErrTopInvalidEntityType,
		kErrTopInvalidErrorType,
	    kErrTopIntersection,
		kErrTopOverlayItself,
		kErrTopSourceDwgAccess,
		kErrTopSourceDwgNotActive,
		kErrTopSourceDatabaseAccess,
		kErrTopSourceObjectId,
		kErrTopNotLoaded,
		kErrTopImplicitNode,
		kErrTopMisplacedNode,
		kErrTopUnreferencedNode,
		kErrTopUnexistentNode,
		kErrTopMismatchStartNode,
		kErrTopMismatchEndNode,
		kErrTopMisplacedCentroid,
		kErrTopMismatchLeftPoly,
		kErrTopMismatchRightPoly,
		kErrTopUnexistentCentroid,
		kErrTopMultiplyCentroid,
		kErrTopWrongPolyQty,
		kErrTopMismatchPolyArea,
		kErrTopMismatchPolyPerimeter,
		kErrTopOpenSourceDwgTopo,
		kErrTopOpenTempTopo,
		kErrTopIdNotExist,
		kErrTopEmpty,
		kErrTopWasModified,
		kErrTopMultiple,
		kErrTopCalculateOffset,
		kErrTopZeroOffset,
		kErrTopDifferentOffset,
		kErrTopInvalidSelSet,
		kErrTopCleanNotInit,
		kErrTopCleanNoGroup,
		kErrTopCleanInvalidIndex,
		kErrTopCleanNoError,
		kErrTopTraceLinkNotExist,
		kErrTopTraceNodeNotExist,
		kErrTopTraceNoPath,
		kErrTopTraceInvalidIndex,
		kErrTopInvalidExpression,
		kErrTopLockedTable,
		kErrTopCreateTable,
		kErrTopCreateTableColumn,
		kErrTopTraceNodesEqual,
		kErrTopTracePathNotExist,
		kErrTopTraceFloodNotExist,
		kErrTopRenameDisabled,
		kErrTopDeleteDisabled,
		kErrTopInvalidExtents,
   
		// Topology API
		kErrTopApiErrWrongInput = 2100,
		kErrTopApiWrongId,
   
        // Kanotech tracing
		kErrTopSprErr = 2150,

		//Query Definition
		kErrUnexpectedBuffChar = 2200,
		kErrInvalidIndex,
		kErrInvalidQueryLine,
		kErrInvalidName,
		kErrEntryAlreadyExists,
		kErrEntryInOtherCategory,
		kErrEntryAndFileAlreadyExist,
		kErrASIConnectFailed,
		kErrASIStmtPrepareFailed,
		kErrASICsrAllocFailed,
		kErrASICsrOpenFailed,
		kErrInvalidDOName,
		kErrLPInitFailed,
		kErrColNotFound,
		kErrQDefNotInTM,
		kErrQryDefnExists,
		kErrInvalidOperator,
		kErrInvalidPtrnOperator,
		kErrInvalidField,
		kErrInvalidNotBranch,
		kErrInvalidBranch,
		kErrUndefinedValue,
		kErrInvalidLocationType,
		kErrCantLoadExternQuery,

		//Query Manager
		kErrIntersectFailed = 2300,
		kErrNoTemplate,
		kErrASIStoreValueFailed,
		kErrASIGetValueFailed,

		//Utility
		kErrLicFatal = 2400,
		kErrFileNotFound,
		kErrPathNotFound,
		kErrBadFormat,
		kErrConvtErr,

		//DATA dialogs
		kErrIRDMismatch = 2450,
		kErrIRDInvalidName,
		kErrIRDTableExists,
		kErrInvalidTableName,
		kErrInvalidAttrName,
		kErrTopoName,
		kErrQueriedAndNotNew,
		kErrNotAdministrator,

		//GenLink
		kErrTagNotFound = 2500,
		kErrTagValueAbcent,
		kErrIllegalFormat,
		kErrColMoreThanOne,

		//	Environment
		kErrInitEnv = 2600,
		kErrCantFindAdeExePath,
		kErrINIWrite,
		kErrInvalidUserName,
		kErrLoadUserList,
		kErrSaveUserList,
		kErrInvalidPswd,

		// Rx
		kErrRxAseLoad = 2700,
		kErrRxAseInit,
		kErrRxIrdLoad,
		kErrRxIrdInit,

		// Projection
		kErrNoProjCatFound = 2800,
		kErrNoDatumFound,
		kErrNoElipFound,
		kErrNoCoordFound,
		kErrFaileOpenDatumFile,
		kErrFaileOpenElipFile,
		kErrNoneCoord,
   
		// Expression
		kErrNoExpressionFound = 2900,
		kErrGetPropFail,
		kErrExpEvalFail,
		kErrExpMissingQuote,
		kErrExpMissingCParen,
		kErrExpExceedThreeOper,
		kErrRngTabNameExist,
		kErrLpnInvalid,
		kErrLpnNotFound,
		kErrRangeInvalidElse,
		kErrXEDValueFail=-15,
		kErrRngTabEvalFail=-14,
		kErrNoRngTabFound=-13,
		kErrNoRngTabLibFound=-12,
		kErrLispValueFail=-11,
		kErrGetAttrFail=-10,
		kErrGetSQLFail=-9,
		kErrGetEEDFail=-8,
		kErrInvalidProperty=-7,
		kErrExpInvalidOperand=-6,
		kErrExpADS=-5,
		kErrExpNoMemforOperand=-4,
		kErrExpMathOverFlow=-3,
		kErrExpInvalidOper=-2,
		kErrExpSyntaxErr=-1,

		// Index
		kErrInvalidIndexVersion = 3000,
		kErrIndexOutOfDate,
		kErrTypeAllObjects,
		kErrTypeNoOneObject,

		//Validation
		kErrWrongSymbolName = 3100,
		kErrWrongSymbol,
		kErrWrongStrLength,
		kErrDirDoesNotExist,
		kErrDirReadOnly,
		kErrAccessDenied,
		kErrFileDoesNotExist,
		kErrFileAlreadyExists,
		kErrFileOpenFailed,
		kErrFileReadOnly,
		kErrInvalidString,
		kErrOutOfRange,
		kErrWrongColor,
		kErrIncorrectParameters,
		kErrFileOpenLimit,
		kErrShareViolation,
		kErrNetAccessDenied,
		kErrPathDoesNotExist,

		// File Locking
		kErrDwkFileDoesNotExist = 3200,
		kErrOpenDwkFileFailed,
		kErrFileLockedByAcad,
		kErrOldMapLockFile,
		kErrFileIsNotDwk,
		kErrSpecifiedUserDoesNotExist,
		kErrCreateDwkFileFailed,
		kErrFileIsLockedForRead,
		kErrFileIsLockedForWrite,
		kErrInvalidLockStateSpecified,
		kErrNotOwnerOfWLH,
		kErrUserIsNotWriter,
		kErrUserIsNotReader,
		kErrUserHasReadLock,
		kErrLockFileIsFull,
		kErrDwgFileDoesNotExist,
		kErrNotAnADELockFile,
		kErrFileMayHaveBeenModified,
		kErrFileHasLocks,
	
		// UNICODE support
		kErrUnicodeInsufficientBufferToConvert = 4000,
		kErrUnicodeInvalidFlagsToConvert,
		kErrUnicodeInvalidParameterToConvert,
		kErrUnicodeNoTranslation,
		kErrUnicodeCodePageNotAvailable,

		//Double-byte support
		kErrNoMBCSAllowed
	} ;

} ;

#endif /* MAP_CONSTANTS_H */





