//===========================================================================
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//  This file contains the main MAP ARX API definitions.
//

#ifndef MAP_IMPPROJECT_H
#define MAP_IMPPROJECT_H

#pragma once // Ensure this file is only parsed once per translation unit.

// INCLUDES
#include <Adesk.h>           // For Adesk::Boolean
#include "MapConstants.h"

// FORWARD DECLARATIONS
class CMapProject;
class AcMapODContainer;
class AcMapErrorStack;
class AcMapDrawingSet;
class AcMapSaveSet;
class AcMapQueryLibrary;
class AcMapRangeLibrary;
class AcMapExpression ;
class AcMapQuery ;
class AcMapStringArray ;
class AcMapProjectReactor;
class AcMapProjectOptionsReactor;
class AcDbDatabase;
class AcGeMatrix3d;
class AcDbObjectId;


//===========================================================================
// AcMapProjectApiImp
//
class AcMapImpProject
{
public:
	                 
    virtual					~AcMapImpProject() ;

    virtual Adesk::Boolean  GetODContainer	(AcMapODContainer *&) const = 0 ;

    // Gets the Drawing Set object.
    //
    virtual Adesk::Boolean  GetDrawingSet	(AcMapDrawingSet *&) const = 0 ;
                                                 
    // Gets the Save Set object.
    //
    virtual Adesk::Boolean  GetSaveSet		(AcMapSaveSet *&) const = 0 ;
    
    // Gets the Query Library object.
    //
    virtual Adesk::Boolean  GetQueryLibrary	(AcMapQueryLibrary *&) const = 0 ;
    
    // Gets the Range Library object.
    //
    virtual Adesk::Boolean  GetRangeLibrary	(AcMapRangeLibrary *&) const = 0 ;

	// Gets the drawing database.
	//
	virtual AcDbDatabase*	Database		() const = 0 ;
    
    // Accesses the MAP project options integer or boolean values.
	//
    virtual AcMap::EErrCode GetOptionValue  (const char *pcName, 
											 int &value) const = 0 ;
    virtual AcMap::EErrCode SetOptionValue  (const char *pcName, 
											 int newVal) const = 0 ;

    // Accesses the MAP options string values.
	//
    virtual AcMap::EErrCode GetOptionValue  (const char *pcName, 
											 char *&value) const = 0 ;
    virtual AcMap::EErrCode SetOptionValue  (const char *pcName, 
											 const char *value) const = 0 ;

    // Accesses the projection name.
    //
    virtual AcMap::EErrCode SetProjection   (const char * pcName) const = 0 ;
    virtual AcMap::EErrCode GetProjection   (char *&pcName) const = 0 ;
    
    // Defines the expression.
    //
    virtual AcMap::EErrCode DefineExpression(AcMapExpression *&pObj,
											 const char* pcExpStr) const = 0 ;

    // Adds the project reactor instance.
    //
    virtual void			AddProjectReactor
											(AcMapProjectReactor *pObj) = 0;
    
    // Removes the project reactor instance.
    //
    virtual void			RemoveProjectReactor
											(AcMapProjectReactor *pObj) = 0;

    // Adds the options reactor instance.
    //
    virtual void			AddOptionsReactor
											(AcMapProjectOptionsReactor *pObj) const = 0 ;
    
    // Removes the options reactor instance.
    //
    virtual void			RemoveOptionsReactor
											(AcMapProjectOptionsReactor *pObj) const = 0 ;

    // Creates query interface object. Depending on the current parameter 
    // the interface object is associated either with the current Map query 
    // or creates a new query inside Map and gets the interface to it.
    //
    virtual AcMap::EErrCode CreateQuery     (AcMapQuery *&pObj,
											 Adesk::Boolean current = Adesk::kFalse ) const = 0 ;

    // Gets the collection of record names in the specified symbol table of the 
    // current drawing. 
    //
    virtual AcMap::EErrCode GetTableList    (AcMapStringArray &tArray,
											 AcMap::ETableType kType) const = 0;

    // Gets the Id of the source drawing, where the specified AutoCAD object has
    // been queried.
    //
    virtual AcMap::EErrCode GetSourceDrawingId
											(AcMapId &Id,
											 const AcDbObjectId &ObjectId) const = 0 ;

    // Checks whether MAP command or MAP ADS-RX API is active.
    //
    virtual Adesk::Boolean  IsMapActive		() const = 0 ;

    // Accesses the complex transformation.
    //
    virtual AcMap::EErrCode SetComplexTransformation
											(const AcGeMatrix3d &tTransform) = 0 ;
    virtual AcMap::EErrCode GetComplexTransformation
											(AcGeMatrix3d &tTransform)const = 0 ;
protected:
							AcMapImpProject	() ;
} ;

#endif /*MAP_IMPPROJECT_H*/
/*EOF*/
