#ifndef MAP_ODCOLUMN_H
#define MAP_ODCOLUMN_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the description of the AcMapODColumnDefinition class.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include "MapConstants.h"
#include "MapValue.h"

class   AcMapODColumnDefinition
{
public:
							AcMapODColumnDefinition     
											();

							AcMapODColumnDefinition     
											(const char *pcName,
											 AcMap::EDataType type,
											 const char *desc = NULL);

							AcMapODColumnDefinition 
											(const AcMapODColumnDefinition 
											 &tSource);

							AcMapODColumnDefinition     
											(const char *pcName, 
											 const char *pcDsc, 
											 const AcMapValue& defVal);

    virtual					~AcMapODColumnDefinition
											();

    // Copy operator.
    //
    virtual AcMapODColumnDefinition& 
							operator =      (const AcMapODColumnDefinition &tVal);
    
    // Comparison operator.
    //
    virtual Adesk::Boolean          
							operator ==     (const AcMapODColumnDefinition &tVal) const;

    // Accesses the column name.
    //
    virtual const char*		Name            () const; 
    virtual AcMap::EErrCode SetName         (const char *pcName); 

    // Accesses the column description.
    //
    virtual const char*		Description     () const; 
    virtual AcMap::EErrCode SetDescription  (const char *pcDsc); 

    // Accesses the column type. 
    //
    virtual void			SetType         (AcMap::EDataType colType);
    virtual AcMap::EDataType        
							Type            () const;

    // Accesses the default value.
    //
    virtual const AcMapValue&       
							DefaultValue    () const;
    virtual AcMap::EDataType        
							SetDefaultValue (const AcMapValue &tVal); 
    virtual AcMap::EDataType        
							SetDefaultValue (int tVal); 
    virtual AcMap::EDataType        
							SetDefaultValue (double tVal); 
    virtual AcMap::EDataType        
							SetDefaultValue (const char *tVal); 
    virtual AcMap::EDataType        
							SetDefaultValue (const AcGePoint3d &tVal); 

    // Settings validation.
    //
    virtual Adesk::Boolean          
							IsValid         () const;

protected:
    void					init            ();  
    static AcMap::EErrCode  CheckDescription(const char *pcDsc);
    static AcMap::EErrCode  CheckName       (const char *pcName);
    void					SetDefaultValue (AcMap::EDataType type);

private:
    char					m_ColumnName[MAX_ODCOLUMN_NAME_LENGTH+1];
											// Column name
    char					m_ColumnDesc[MAX_ODCOLUMN_DESC_LENGTH+1];
											// Column description   
    AcMap::EDataType		m_Type;         // Column type
    AcMapValue				m_DefaultValue; // Column default value
};

#endif /*MAP_ODCOLUMN_H*/
/*EOF*/
