#ifndef MAP_ODDEFINITION_H
#define MAP_ODDEFINITION_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the description of the AcMapODTableDefinition class.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include "adesk.h"
#include "MapConstants.h"
#include "MapColl.h"

//  Forward declarations
class   AcMapODColumnDefinition;

class AcMapODTableDefinition : 
    protected AcMapObjPtrArray<AcMapODColumnDefinition>
{
public:
							AcMapODTableDefinition  
											();

							AcMapODTableDefinition  
											(const AcMapODTableDefinition &tSource);

    virtual					~AcMapODTableDefinition 
											();

    // Copy operator.
    //
    virtual AcMapODTableDefinition& 
							operator =      (const AcMapODTableDefinition &tVal) ; 
                                                                                 
                                
    // Comparison operator.
    //
    virtual Adesk::Boolean  operator ==     (const AcMapODTableDefinition &tVal) const ;

    // Counts the columns in the table definition.
    //
    virtual int				Count           () const ;

    //  Gets the index of the column definition by the name.
    //  
    virtual int				FindColumn      (const char *pcColumnName) const;

    // Gets column definition by the index.
    //
    virtual AcMap::EErrCode GetColumn       (AcMapODColumnDefinition& Column, 
											 int index) const;

    // Adds the copy of the OD column definition to the table definition at the 
    // specified position (by default to the end of the column list).
    //
    virtual AcMap::EErrCode  AddColumn      (const AcMapODColumnDefinition& Column,
											 int pos = -1);

    
    // Remove operations.
    //
    virtual AcMap::EErrCode RemoveColumn    (int pos);
    virtual void			RemoveAll       ();
};
#endif /*MAP_ODDEFINITION_H*/
/*EOF*/
