#ifndef ADEODIT_H
#define ADEODIT_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the description of the AcMapODRecordIterator class.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include "MapConstants.h"
#include "MapODTable.h"
#include <dbid.h>

// Forward declarations.
class AcMapObjectId; 
class AcMapProject;

class AcMapODRecordIterator
{
public:
    virtual					~AcMapODRecordIterator
											();

	// Gets the associated project.
	virtual AcMapProject*	Project			() const = 0;

    // Gets the number of records, beginning from iterator's current position.
    // After execution, sets the iterator to after the last record.
    //
    virtual int				CountRecords    () = 0;

    // Gets the number of AutoCAD objects, having OD records attached, beginning from 
    // the iterator's current position. After execution, sets the iterator  
    // to after the last record.
    //
    virtual int				CountObjects    (AcDbObjectIdArray&) = 0;

    // Associates the iterator with the AutoCAD object. The current iterator position is
    // set to the first record if it exists. If bSkipSubobject is Adesk:kTrue, the records 
    // that are attached to the subobjects, for example vertexes, are skipped while iterating.
    //
    virtual AcMap::EErrCode Init            (const AcDbObjectId& acadId, 
											 AcMap::EOpenMode openMode,
											 Adesk::Boolean bSkipSubObject = Adesk::kTrue) = 0;
    virtual AcMap::EErrCode Init            (const AcMapObjectId& adeId, 
											 AcMap::EOpenMode openMode,
											 Adesk::Boolean bSkipSubObject = Adesk::kTrue) = 0;
    virtual AcMap::EErrCode Init            (AcDbObject *pAcadObj, 
											 AcMap::EOpenMode openMode,
											 Adesk::Boolean bSkipSubObject = Adesk::kTrue) = 0;

    // Accesses the iterator open mode.
    //
    virtual AcMap::EOpenMode
							OpenMode        () const = 0;

    // Gets the identifier of the AutoCAD object.
    //
    virtual AcDbObjectId	OwnerObjectId   () const = 0;

    virtual AcDbObjectId	CurrentObjectId () const = 0;

    // Gets the associated drawing identifier.
    //
    virtual AcMapId			DrawingId       () const = 0;

    // Checks if the last iterator position has been reached.
    //
    virtual Adesk::Boolean  IsDone          () = 0;

    // Sets the current iterator position at the first record.
    //
    virtual AcMap::EErrCode Rewind          () = 0;

    // Sets the current iterator position to the next record.
    //
    virtual AcMap::EErrCode Next            () = 0;

    // Gets the record from the current iterator position. 
    //
    virtual AcMap::EErrCode GetRecord       (AcMapODTableRecord &tRecord) = 0;

    // Updates the current record.
    //
    virtual AcMap::EErrCode UpdateRecord    (AcMapODTableRecord &tRecord) = 0;

    // Removes the current record.
    //
    virtual AcMap::EErrCode RemoveRecord    () = 0;

protected:
							AcMapODRecordIterator
											();
};


// Inlines.
inline
AcMapODRecordIterator::AcMapODRecordIterator()
{}

inline
AcMapODRecordIterator::~AcMapODRecordIterator()
{}

#endif /*ADEODIT_H*/
/*EOF*/
