#ifndef MAP_ODRECORD_H
#define MAP_ODRECORD_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the description of the AcMapODTableRecord class.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include "MapObjectId.h"
#include "mapcoll.h"

//  Forward declaration
class   AcMapValue;
class   AcMapODRecordIteratorImp;
class   AcMapProject ;

class   AcMapODTableRecord :
    protected AcMapObjPtrArray<AcMapValue>
{
public:
							AcMapODTableRecord  
											();
							AcMapODTableRecord  
									        (const AcMapODTableRecord& tSource);
    virtual					~AcMapODTableRecord 
								            ();

	// Sets/Gets the project.
	void					SetProject		(AcMapProject *pProject) ;
	
	AcMapProject*			Project			() const ;

    //  Copy operator.
    //
    AcMapODTableRecord&		operator =      (const AcMapODTableRecord &tRecord);

    // Comparison operator.
    //
    virtual Adesk::Boolean  operator ==     (const AcMapODTableRecord &tRecord) const;

    // Counts the records.
    //
    int						Count           () const;

    // Accesses the AutoCAD or MAP object identifier of the associated object.
    //
    virtual const AcMapObjectId&  
							MapObjectId     () const;

    // Accesses the value.
    //
    virtual const AcMapValue& 
							Value           (int i) const;
    virtual AcMapValue&		Value           (int i); 

    // Accesses the table name.
    //
    virtual const char*		ODTableName     () const;

	// Reinitializes the record making it empty.
	//
    void					init            ();

private:
friend class AcMapODRecordIteratorImp;
friend class AcMapODTableImp;

    // Editing operations. 
    //
    virtual AcMap::EErrCode AddValue        (const AcMapValue&, int pos = -1);
    virtual AcMap::EErrCode RemoveValue     (int index);

    AcMap::EErrCode         SetODTableName  (const char *pTable);            
    void					SetOwnerObjId   (AcMapObjectId& adeId);            

    char					m_TableName[MAX_ODTABLE_NAME_LENGTH];
											// OD Table Name
    AcMapObjectId			m_AdeId;        // AutoCAD object Id
	AcMapProject*			m_pProject ;	// corresponding project
};    
#endif /*MAP_ODRECORD_H*/
/*EOF*/
