#ifndef MAP_ODTABLE_H
#define MAP_ODTABLE_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the definition of the AcMapODTable class.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include "MapConstants.h"
#include <dbid.h>

// Forward declarations.
class AcMapODRecordIterator;
class AcMapODTableRecord;
class AcMapODTableDefinition;
class AcDbObject;
class AcMapProject;

class AcMapODTable
{
protected:
							AcMapODTable    ();

public:
   virtual					~AcMapODTable   ();

   // Gets the associated project.
   virtual AcMapProject*	Project			() const = 0 ;

   // Accesses table definition parameters.
   //
   virtual const char*		Name            () const = 0;
   virtual const char*		Description     () const = 0;
   virtual const AcMapODTableDefinition &    
							Definition      () const = 0;
   virtual Adesk::Boolean          
							StoreAsXData    () const = 0; 

   // Allocates the OD table iterator object for the specified drawing.
   //
   virtual AcMap::EErrCode  GetTableODRecordIterator
											(AcMapODRecordIterator *&pIter,
											 unsigned long lDwgId = 0) const = 0;

   // Initilizes the OD table record object with the default values. 
   //
   virtual AcMap::EErrCode  InitRecord      (AcMapODTableRecord& pRecord) const = 0;

   // Attaches a new record to the table and associates it with its the object.
   //
   virtual AcMap::EErrCode  AddRecord       (AcMapODTableRecord& Record,
											 AcDbObjectId& acadId) = 0;
   virtual AcMap::EErrCode  AddRecord       (AcMapODTableRecord& Record,
											 AcDbObject* acadObj) = 0;

};

// Inlines.
//
inline
AcMapODTable::AcMapODTable()
{}

inline
AcMapODTable::~AcMapODTable()
{}
#endif /*MAP_ODTABLE_H*/
/*EOF*/
