#ifndef MAP_PROJ_H
#define MAP_PROJ_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the description of the AcMapProject class.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include <adesk.h>
#include <acdocman.h>
#include "MapConstants.h"

//
// Forward declaration
class AcDbDatabase;
class AcMapODContainer;
class AcMapErrorStack;
class AcMapDrawingSet;
class AcMapSaveSet;
class AcMapQueryLibrary;
class AcMapRangeLibrary;
class AcMapQuery;
class AcMapProjectReactor;
class AcMapProjectOptionsReactor;
class AcMapExpression ;
class AcMapStringArray;
class AcMapImpProject;
class AcDbObjectId; 
class AcGeMatrix3d;

class AcMapProject 
{
friend class CMapProject;

public:
    virtual					~AcMapProject   () ;

    virtual Adesk::Boolean  GetODContainer	(AcMapODContainer *&) const ;

    // Gets the Drawing Set object.
    //
    virtual Adesk::Boolean  GetDrawingSet	(AcMapDrawingSet *&) const ;
                                                 
    // Gets the Save Set object.
    //
    virtual Adesk::Boolean  GetSaveSet		(AcMapSaveSet *&) const ;
    
    // Gets the Query Library object.
    //
    virtual Adesk::Boolean  GetQueryLibrary	(AcMapQueryLibrary *&) const ;
    
    // Gets the Range Library object.
    //
    virtual Adesk::Boolean  GetRangeLibrary	(AcMapRangeLibrary *&) const ;

	// Gets the drawing database
	virtual AcDbDatabase*	Database		() const ;

    // Accesses the MAP Project Options integer or boolean values.
    // The list of option names:

    //    Project:                            
    //     "RestoreLastActiveDwgsOnStartup"         - Boolean 
    //     "ActivateDwgsOnAttach"                   - Boolean 
    //     "ReconnectDbOnWSOpen"                    - Boolean
    //     "NoOfSQLConditionsInHistory"             - int
    //     "AdjustSizesAndScalesForChangesInUnits"  - Boolean
    //     "AdjustRotationsForMapDistortions"       - Boolean
    //     "AdjustSizesAndScalesForMapDistortions"  - Boolean
    //     "AdjustElevations"                       - Boolean
    //     "AdjustZeroRotationObjects"              - Boolean

    
    //    Query:
    //     "CaseSensitiveMatch"                     - Boolean
    //     "SaveCurrQueryInSession"                 - Boolean
    //     "MkSelSetWithQryObj"                     - Boolean
    //     "DefaultJoinOperator"                    - int (1 - Or, 2 - And)
    //     "BlockLocnForQuery"                      - Boolean
    //     "TextLocnForQuery"                       - Boolean
    //     "ShowBlockAsInsPt"                       - Boolean
    //     "CreateAssociativeHatchObjects"          - Boolean
    //     "ReferenceBoundaryForAreaLocation"       - Boolean
    //     "ShowImageAsBoundary"                    - Boolean
            
    //    Save Back
    //     "RedefineBlockDefinitions"               - Boolean
    //     "RedefineLayerDefinitions"               - Boolean
    //     "RedefineTextStyleDefinitions"           - Boolean
    //     "RemoveUnusedGroups"                     - Boolean
    //     "EraseSavedBackObjects"                  - Boolean
    //     "RemoveLockAfterSave"                    - Boolean
    //     "CreateHistoryFileOfChanges"             - Boolean
    //     "CreateBackupFileOfSourceDwg"            - Boolean
    //     "MarkObjectsForEditingWithoutPrompting"  - Boolean 
    //     "DontAddObjectsToSaveSet"                - Boolean 
    virtual AcMap::EErrCode GetOptionValue  (const char *pcName, 
											 int &value) const ;
    virtual AcMap::EErrCode SetOptionValue  (const char *pcName, 
											 int newVal) const ;

    // Accesses the MAP Project options string values.
    // The list of option names:
    //
    //    Query:
    //      "ColorForAdd"
    //      "ColorForRemove"
    virtual AcMap::EErrCode GetOptionValue  (const char *pcName, 
											 char *&value) const ;
    virtual AcMap::EErrCode SetOptionValue  (const char *pcName, 
											 const char *value) const ;

    // Accesses the projection name.
    //
    virtual AcMap::EErrCode SetProjection   (const char * pcName) const ;
    virtual AcMap::EErrCode GetProjection   (char *&pcName) const ;
    
    // Defines the expression.
    //
    virtual AcMap::EErrCode DefineExpression(AcMapExpression *&pObj,
											 const char* pcExpStr) const ;

    // Adds the project reactor instance.
    //
    virtual void			AddProjectReactor
											(AcMapProjectReactor *pObj) ;
    
    // Removes the project reactor instance.
    //
    virtual void			RemoveProjectReactor
											(AcMapProjectReactor *pObj) ;

    // Adds the options reactor instance.
    //
    virtual void			AddOptionsReactor
											(AcMapProjectOptionsReactor *pObj) const ;
    
    // Removes the options reactor instance.
    //
    virtual void			RemoveOptionsReactor
											(AcMapProjectOptionsReactor *pObj) const ;

    // Creates query interface object. Depending on the current parameter 
    // either the interface object is associated with the current MAP query 
    // or the method creates a new query inside MAP and gets the interface to it.
    //
    virtual AcMap::EErrCode CreateQuery		(AcMapQuery *&pObj,
											 Adesk::Boolean current = Adesk::kFalse ) const ;

    // Gets the collection of record names in the specified symbol table of the 
    // current drawing. 
    //
    virtual AcMap::EErrCode GetTableList    (AcMapStringArray&tArray,
											 AcMap::ETableType kType) const ;

    // Gets the Id of the source drawing, where the specified AutoCAD object has
    // been queried.
    //
    virtual AcMap::EErrCode GetSourceDrawingId
											(AcMapId &Id,
											 const AcDbObjectId &ObjectId) const ;

    // Checks whether MAP command or MAP ADS-RX API is active.
    //
    virtual Adesk::Boolean  IsMapActive     () const ;

    // Accesses the complex transformation.
    //
    virtual AcMap::EErrCode SetComplexTransformation
											(const AcGeMatrix3d &tTransform) ;
    virtual AcMap::EErrCode GetComplexTransformation
											(AcGeMatrix3d &tTransform) const  ;
private:
							AcMapProject    () ; 
							AcMapProject    (AcMapImpProject *) ;    

	AcMapImpProject			*m_pImpProject ;
} ;

class AcMapProjectIterator 
{
friend class AcMapSessionImp ;

public:
	virtual					~AcMapProjectIterator 
											() ;
	Adesk::Boolean			Done			() const ;
    void					Step			() ;
	void					Rewind			() ;
    AcMapProject*			Project			() ;
	AcApDocument*			Document		() ;

private:
							AcMapProjectIterator 
											() ;

	AcApDocumentIterator	*m_pIterator ;
} ;

#endif /*MAP_PROJ_H*/
/*EOF*/
