#ifndef MAP_SESSION_H
#define MAP_SESSION_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the description of the root MAP ARX API object AcMapRxObj.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include <adesk.h>
#include <rxobject.h>
#include <acdocman.h>
#include "MapConstants.h"

// Name of MAP Rx export class
#define ARX_MAP_CLASS        /*MSG0*/"Map_Class"

// MAP Services
#define ARX_MAP_SERVICES     /*MSG0*/"MapServices"

// AutoCAD ARX API declarations
class AcApDocument ;

// Forward MAP API declarations.
class AcMapAliases ;
class AcMapErrorStack ;
class AcMapProject ;
class AcMapSessionOptionsReactor ;
class AcMapStringArray ;
class AcMapProjectIterator ;
class AcMapSessionReactor ;

class AcMapSession : public AcRxObject
{
public:
    ACRX_DECLARE_MEMBERS(AcMapSession);

	// Gets the aliases object.
    //
    virtual Adesk::Boolean	GetAliases		(AcMapAliases *&) = 0 ;

	// Gets the error stack object.
    //
    virtual Adesk::Boolean  GetErrorStack	(AcMapErrorStack *&) = 0 ;
    
	// Allocates the project iterator.
	//
	virtual AcMapProjectIterator *
							GetProjectIterator
											() const = 0 ;

    // Logs in the user.
    //
    virtual Adesk::Boolean  LogIn           (const char *pcUserName,
											 const char *pcPassword) const = 0 ;
	// Gets the list of the registered users. 
    //
    virtual AcMap::EErrCode	GetUserList		(AcMapStringArray &tAr) const = 0 ;

    // Gets the current user. If the current user has not logged in and the getAutoCADUser 
    // parameter is True, the name of the current AutoCAD user is returned.
    //
    virtual AcMap::EErrCode GetCurrentUser  (char *&pcName,
											 Adesk::Boolean getAutoCADUser = Adesk::kTrue) const = 0 ; 

    // Gets the set of rights for the specified user. Values of each bit of the integer value
    // are shown in AcMap::EUserRight. Only a superuser can access foreign rights.
    //
    virtual AcMap::EErrCode	GetUserRights   (int& rights,
											 const char *pcName) const = 0 ;

    // Sets the rights for the specified user. Values of each bit of the integer value
    // are shown in AcMap::EUserRight
    // This method is available only for a superuser.
    //
    virtual AcMap::EErrCode	SetUserRights   (int rights,
											 const char *pcName) const = 0 ;

    // Prevents MAP from unloading.
    //
    virtual void			Lock            () const = 0 ;
    
    // Reverses a lock. Allows MAP to unload after a previous Lock.
    //
    virtual void			Unlock          () const = 0 ;

    // Gets the current version of MAP ARX API.
    //
    virtual const char*		ArxApiVersion   () const = 0;

    // Accesses the Work Space Rectangle.
    //
    virtual AcMap::EErrCode GetWSpaceRectangle
											(RECT &tRect) const = 0 ;
    virtual AcMap::EErrCode SetWSpaceRectangle
											(const RECT &tRect) const = 0 ;

	// Executes MAP command.
    //
    virtual Adesk::Boolean	InvokeCommand   (const char *) const = 0 ;
    
    // Executes MAP API function.
    //
    virtual Adesk::Boolean  InvokeFunction  (int funcCode,
											 struct resbuf *args,
											 struct resbuf **retVal) const = 0 ;
   
	// Gets the project object by its AutoCAD document.
	//
	virtual Adesk::Boolean	GetProject		(AcMapProject *&pProject,
											 AcApDocument *pdoc=curDoc()) const = 0 ;


	// Gets the project object by its documents Window title.
	//
	virtual Adesk::Boolean	GetProject		(AcMapProject *&pProject,
											 const char *pcDocTitle) const = 0 ;


	// Gets the AutoCAD document object associated with the specified project object. 
	//
	virtual Adesk::Boolean	GetDocument		(AcApDocument *&pDocument,
											 const AcMapProject *pProject) const = 0 ;

	// Adds the session reactor instance.
    //
    virtual void			AddSessionReactor
											(AcMapSessionReactor *pObj) const = 0 ;
    
    // Removes the session reactor instance.
    //
    virtual void			RemoveSessionReactor
											(AcMapSessionReactor *pObj) const = 0 ;


	// Adds the options reactor instance.
    //
    virtual void			AddOptionsReactor
											(AcMapSessionOptionsReactor *pObj) const = 0 ;
    
    // Removes the options reactor instance.
    //
    virtual void			RemoveOptionsReactor
											(AcMapSessionOptionsReactor *pObj) const = 0 ;

    // Accesses the MAP system options integer or boolean values.
    // The list of option names:

    //    Work Space:
    //     "Drawings"                               - Boolean
    //     "QueryLibrary"                           - Boolean
    //     "Feature Classes"                        - Boolean
    //     "Databases"                              - Boolean
    //     "Tables"                                 - Boolean
    //     "Link Templates"                         - Boolean
    //     "Queries"                                - Boolean
    //     "Topologies"                             - Boolean
    //     "ShowWSpaceOnStartup"                    - Boolean
    //     "ShowOPMOnStartup"                    	- Boolean
    //     "WSpaceDockingView"                      - Boolean   
              
    //   External Database
    //     "DisplayTabsInSingleView"                - Boolean
    //     "OpenDataViewReadOnly"                   - Boolean
    //     "SaveDataViewFmtChanges"                 - Boolean
	//     "KeepDataViewOnTop"                      - Boolean

    //   Multi-User
	//	   "ForceUserLogin"							- Boolean
    //     "EnableObjectLocking"                    - Boolean

	//   System
    //     "NumberOfOpenDwgs"                       - Boolean
    //     "LogFileActive"                          - Boolean 
	//     "LogMessageLevel"                        - int (0, 1, 2)
    virtual AcMap::EErrCode GetOptionValue  (const char *pcName, 
											 int &value) const = 0 ;
    virtual AcMap::EErrCode SetOptionValue  (const char *pcName, 
											 int newVal) const = 0 ;

    // Accesses the MAP system options string values.
    // The list of option names:
    //
    //    Work Session:
    //      "LogFileName"
	//      "QueryFileDirectory"

    //    Database Types
    //      "DbfDatabases"
    //      "XlsDatabases"
    //      "DbDatabases"

	//    System
    //      "CheckoutDirectory"
	//
	virtual AcMap::EErrCode GetOptionValue  (const char *pcName, 
											 char *&value) const = 0 ;
    virtual AcMap::EErrCode SetOptionValue  (const char *pcName, 
											 const char *value) const = 0;

    // Accesses the MAP System options double values.
    // The list of option names:
    //
    //   System
    //      "DoublePrec"                            - 0.< X < - 1.
    //
    virtual AcMap::EErrCode GetOptionValue  (const char *pcName, 
											 double &value) const = 0 ;
    virtual AcMap::EErrCode SetOptionValue  (const char *pcName, 
											 double newVal) const = 0 ;

    // Checks if option node is enabled.
    // The list of option names:
    //     "Drawings"     
    //     "QueryLibrary" 
    //     "Databases"
    //     "Tables"
    //     "Link Templates"
    //     "Queries"
    //     "Topologies"
    // For all other names Adesk::kTrue is returned.
    //
    virtual Adesk::Boolean  IsOptionNodeEnabled
											(const char *pcName) const = 0 ;

	// Sets active page for the "MAP Options" dialog. This setting is used while the 
    // "Set Options" dialog is initialized. 
    //
    virtual void			SetActiveOptionPage	
											(AcMap::EPrefType type) const = 0 ; 

    
};

/****************************************************************************/
/* Get the pointer to MAP export class */
/****************************************************************************/

extern AcMapSession*		AcMapGetSession ();

/****************************************************************************/
#endif // MAP_SESSION_H
