#ifndef MAP_TEMPLATE_H
#define MAP_TEMPLARE_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
// This file contains the descriptions of MAP ARX API classes to manipulate 
// a report template definition.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include "adesk.h"
#include "MapConstants.h"

// Forward declarations
class AcMapProject ;
class AcMapTemplateLine;
class AcMapExpression ;

class AcMapReportTemplate
{
protected: 
							AcMapReportTemplate
											() ;
public:
    virtual					~AcMapReportTemplate
											() ;

	// Gets the associated project.
	//
	virtual AcMapProject*	Project			() const = 0 ;

    // Reinitializes template definition.
    //
    virtual AcMap::EErrCode Clear           () = 0 ;

    // Counts template lines.
    //
    virtual int				CountLines		() const = 0 ;

    // Adds new template line. 
    //
    virtual AcMap::EErrCode AddLine         (const char *pcExpression) = 0 ;

    // Adds new template line. 
    //
    virtual AcMap::EErrCode AddLine         (const AcMapExpression &tExpr) = 0 ;

    // Gets the i-th template line. If pObj is NULL, a new AcMapTemplateLine object is 
    // allocated. An application is responsible for releasing this object.
    //
    virtual AcMap::EErrCode GetLine         (AcMapTemplateLine *&pObj,
											 int i) const = 0 ;

    // Gets the template line specified by Id. If pObj is NULL, a new AcMapTemplateLine object is 
    // allocated. An application is responsible for releasing this object.
    //
    virtual AcMap::EErrCode GetLine         (AcMapTemplateLine *&pObj,
											 AcMapId Id) const = 0 ;

    // Removes the i-th template line from the report definition.
    //
    virtual AcMap::EErrCode RemoveLine      (int i) = 0 ;
    
    // Removes the template line specified by Id  from the report template.
    //
    virtual AcMap::EErrCode RemoveLine      (AcMapId Id) = 0 ;

    // Accesses the full pathname of the report file.
    //
    virtual AcMap::EErrCode GetFileName     (const char *&pcFileName) const = 0 ;
    virtual AcMap::EErrCode GetFileName     (char *&pcFileName) const = 0 ;
    virtual AcMap::EErrCode SetFileName     (const char *pcFileName) = 0 ;

    // Accesses the option value to add the nested objects to the report.
    //
    virtual AcMap::EErrCode IsReportNestedEnabled
											(Adesk::Boolean &bIsEnabled) const = 0 ;
    virtual AcMap::EErrCode EnableReportNested
											(Adesk::Boolean bIsEnabled) = 0 ;

    // Accesses the option value to apply the transformation. 
    //
    virtual AcMap::EErrCode IsTransformationEnabled
											(Adesk::Boolean &bIsEnabled) const = 0 ;
    virtual AcMap::EErrCode EnableTransformation
											(Adesk::Boolean bIsEnabled) = 0 ;
} ;

class AcMapTemplateLine
{
protected: 
							AcMapTemplateLine
											() ;
public:
    virtual					~AcMapTemplateLine
											() ;

    // Gets Id of the object.
    //
    virtual AcMapId			ObjectId        () const = 0 ;      

	// Gets the associated project.
	//
	virtual AcMapProject*	Project			() const = 0 ;    

	// Accesses the expression string.
    //
    virtual AcMap::EErrCode GetExpression   (const char *&pcExpression) const = 0 ;
    virtual AcMap::EErrCode GetExpression   (char *&pcExpression) const = 0 ;
    virtual AcMap::EErrCode SetExpression   (const char *pcExpression) = 0 ;

    // Accesses the expression as the AcMapExpression object.
    //
    virtual AcMap::EErrCode GetExpression   (AcMapExpression *&pObj) const = 0 ;
    virtual AcMap::EErrCode SetExpression   (const AcMapExpression &tExpr) = 0 ;
} ;
#endif /*MAP_TEMPLATE_H*/
/*EOF*/
