#ifndef MAP_VALUE_H
#define MAP_VALUE_H
//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
//  This file contains the description of the AcMapValue class.
//
#if _MSC_VER > 1000
#pragma once // Ensure this file is only parsed once per translation unit.
#endif

#include <adesk.h>
#include <gepnt3d.h>
#include "MapConstants.h"

class   AcMapValue
{
public:
							AcMapValue      (int val);
							AcMapValue      (double val);
							AcMapValue      (const char *val);
							AcMapValue      (const AcGePoint3d &val);
							AcMapValue      (const AcMapValue &tVal);
							AcMapValue      (AcMap::EDataType kType);
							AcMapValue      ();

    virtual					~AcMapValue     ();

    // Clears all member data. After this method executes, the type of the 
    // value is undefined.
    //
    virtual void			init            ();

    // Assignments. Type of the object is not changed. Specified parameter is
    // converted to the existing object type. If the type of the object is kODUnknown 
    // it is changed in accordance with parameter type.
    //
    virtual AcMapValue&		operator =      (const AcMapValue &tVal);
    virtual AcMapValue&		operator =      (int val);
    virtual AcMapValue&		operator =      (Adesk::Int16 val);
    virtual AcMapValue&		operator =      (Adesk::Int32 val);
    virtual AcMapValue&		operator =      (double val);
    virtual AcMapValue&		operator =      (const char *val);
    virtual AcMapValue&		operator =      (const AcGePoint3d &val);

    // Comparison. Types of the comparison objects can be different. 
    // Result is Adesk::kTrue if *this == (type_of_this)tVal && 
    // tVal == (type_of_tVal)(*this).
    //
    virtual Adesk::Boolean  
							operator ==     (const AcMapValue &tVal) const;
    virtual Adesk::Boolean  
							operator !=     (const AcMapValue &tVal) const;

    // Access the ordinates, in case value can be converted to the point.
    //
    double					operator []     (int) const;
    double&					operator []     (int);

    // Conversion methods that define the conversion from OD type to base type.
    //
							operator int    () const;
							operator Adesk::Int16               
											() const;
							operator Adesk::Int32               
											() const;
							operator double                     
										   () const;
							operator const char*                
											() const;
							operator const AcGePoint3d&         
											() const;

    // This method can be used to check whether the object has been initialized. 
    // Uninitialized object is type AcMap::kODUnknown.
    //
    virtual AcMap::EDataType            
							Type            () const;

protected:
    AcMap::EErrCode         copyStr         (const char* str) const;
    AcMap::EErrCode         doubleToStr     (double rValue) const; 
    AcMap::EErrCode         intToStr        (int iValue) const; 
    AcMap::EErrCode         pointToStr      (AcGePoint3d pntValue) const; 
    AcMap::EErrCode         strToInt        (const char *sVal, int& iVal) const; 
    AcMap::EErrCode         strToPoint3d    (const char *sVal, AcGePoint3d& pVal) const; 
    AcMap::EErrCode			strToReal       (const char *sVal, double& rVal) const; 

private:
    double					m_Double;       // Double value
    int						m_Int;          // Integer value
    AcGePoint3d				m_Point;        // Point value
    char *					mp_Str;         // String value
    AcMap::EDataType		m_Type;         // Data type
};
#endif /*MAP_VALUE_H*/
/*EOF*/
