CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9C414D29-7041-46CF-9A7D-C6373614B233}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{89846452-DA87-4D2C-944F-170E6616C305}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{489136FD-C6E1-4631-8583-485B6ACB57DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CFFC1672-93B3-44BB-AC64-4309F13A4C74}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3BE6260A-9819-45EF-B4A9-B7DA6EEEC6A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C69D5AA8-917B-4467-81C1-7DE4C86A7596}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1E7B22B2-7653-4F2B-A913-E40D99AE1EAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{97E0C54E-EB42-4F4B-9213-892DDDFF90D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D247D3CA-41F7-46FC-A5B1-E502474E867F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2EE7B51F-FAAB-4A2D-98C8-D153BE6FDB90}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9B88787E-A245-498C-BE74-03A5AD5F1B4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FD20C912-497A-45A8-8FD7-BFF849BFBAA4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8BDF71A3-A455-4484-8A72-58E9B652778F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DC3BACD3-D2A1-4639-90D7-0E1D673D584E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8A0997A2-25D3-4366-BF25-E1023750BF82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{53404690-459B-4DC0-AAC1-7C89E7FCF24F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{890E857A-8F7D-4131-9FF1-9CA21192007C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{65E0F6C2-2D75-4A76-BE59-352FED538A1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C80B98CF-F295-4D75-864D-FED8479EF32D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B4306D6D-2DFE-46F6-BE05-11F67B36A6AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{93A0F249-C8F8-4F81-A051-0937F6174081}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2AEE283B-979B-4230-853C-8CBADE1B8C5E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1DE926CC-5B16-4BC9-B260-7BC24F0F2B15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{89F85C08-8AF1-4EDE-8049-A7562A69F6DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{71BE6974-3F9E-41F1-9073-57AB62C6A897}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{749EB018-E680-481D-A798-6DCC4712B809}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{460FA82E-AC8A-4246-82E1-7B90E7283275}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7D224BAC-2351-4673-BBBD-4524B8F3FD3D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{92D4DAE6-7FCE-4647-85AD-B40BBBDB2F9D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1F02C8B8-E1E9-4348-A7E6-D42D19234550}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C98B7CD2-5D46-4130-9950-4E4A2C92F662}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{EC682A9F-9A5E-4EBD-A19A-9E9C7F0206E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F216F49F-5377-4E53-B85D-6E3AD8CDE42C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E747E8AC-9273-4347-ADC0-30DAAC073AE9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A81F8C6F-7446-4108-9CA5-C3D4E6773D5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{14771CFB-50D4-4BA8-A7E8-F138F2C227F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B41B1166-C82F-4DDD-8EB6-03175296A204}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F408183C-7F88-4A35-82D7-80945F834B12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BF3254DF-032D-446C-8F70-EEA85B4812EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DF19AC32-4BB3-48FA-95C0-265DC5FB1A98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3FECBFED-E5CC-453B-99B6-7A99C10D6E8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{69E21969-90E5-41B1-9FB6-A428AA82CD25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B35F0A7E-73C6-48D8-97C9-9406BA84BF59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{72F6D500-5169-4D4B-8E71-27FFCE8D5EFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FA148573-E0E5-400F-8978-D95410035F18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DF19AC32-4BB3-48FA-95C0-265DC5FB1A99}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E6299DEC-FE6B-4BAE-89C6-97F287E33A93}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0744D46C-B2FB-4718-9387-7B571D3133D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{721F201C-73C7-4F95-8079-A9D0EEE9FED2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{66730C5A-82DB-474B-A685-0484C6A59B7F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0279E1B9-0871-41BA-910B-1A8962A72687}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FC30A6FE-8968-4FEA-9461-27C1BD51075D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5D7BB2B4-3778-4286-A820-CB80AFB3256A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E34FB6A3-9908-4AE5-807A-B947343C7367}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8A420EDB-862E-4C82-BA13-9D9370D7CF57}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{03527BAB-4B06-4F5D-A4B3-457D005F72C4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{EECE1C32-F1AC-4A85-8D36-DE1ED77FEA00}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2E1BF0FB-821A-4CF1-9A43-333A064C3413}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{26FAE072-6D20-49A4-96B3-1C66FA0569AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0DE4E246-69F3-4D36-A02F-4A2C0BD873F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C93F448E-F065-41CD-8FEB-4459EA52D351}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E7D960A6-B4B0-4BFC-BA0C-4905467BE4D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{36815267-1C28-4768-8A07-F28744B5A4D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9C292231-2CE4-4893-971F-FFDA45AE875A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1518F589-A9CD-4CC3-99D8-99801F5BCFF5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{93072A3E-CF91-4E25-9316-EBA7808CD5DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E41AA91D-E1E2-4498-B7E9-D669395022EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{904ED171-CF4B-4637-92E9-7BAE496197BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F4E4E47B-1E29-4197-A2AD-CF33E06956DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{73F9DBD8-20BD-49CC-82B9-8A6175579DC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D789E20D-6185-4C02-95F3-A649B744FACE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E827AE2B-A83C-49D4-B672-A24D1A6FD89E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5DE9C0BB-2DC4-4CC7-9544-C3102AAA27F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{77CD28EF-DFDE-4142-BFA4-9D7E4377A3C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CDCDAC16-D2C4-43AB-B209-4240C6C96514}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{ACE171FB-CBBD-4168-8C53-8B5C84C1DDAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{649E466B-8929-4AE7-A855-73B7B85A9E1A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{27C19B89-402D-439D-8D5B-995E1E7A854D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DAEFC71B-8B2E-465E-8FE2-E01254D9B2D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9618C71D-31E7-4864-A7C1-0ABA3F236E22}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DA499B6C-D17D-48F9-A5A6-6F76A3BD20F7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{34095D68-70DC-4672-B3F0-969DFA815004}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C9B1347F-26E6-4B84-A840-531FCD1B8F7E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DFC907AD-D1C3-4669-9569-483F7075DE02}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D344E569-ABBA-4E34-AFEF-23C01F1B3A4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6EE62A33-9F89-4473-9A08-127BD835B063}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{95BA7BED-609C-4780-A6D5-269750484069}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F8DCD5F7-98E6-4B03-BA00-DB7811B679CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{15DDF6DC-B41B-493F-9C5E-F23FAC81C1AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F3A5352C-724A-4E7E-977A-FEBD225D4C0B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{33BD0B7F-CF0D-45DD-8B34-DA37D2A919AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{03245650-3A0C-44A8-86B8-A074E9F939A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C9D00500-9E38-4943-993D-CB8C72DF7485}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{51CC95B3-494E-4B61-B44B-3F14C3A19D63}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2AEEBC84-FA86-4F01-BD3D-8701639000B7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FF7B84CC-D263-4FBC-8D25-8E47B7165D30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AADBFB12-EED5-4119-B228-5C2B9C5C8E9C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7D3BF844-0003-428B-9BD6-11B693DFD980}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3907D683-0B9A-4122-9924-CF396A33ABF2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2133A596-0E02-43D5-9ADE-3B181A18963D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E3D11C0D-E72D-4339-BC49-D86D7066C089}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CACFCF56-F06E-4EB6-93C5-D2B769953BE2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9F9A50DA-3238-4C0B-AFFE-8D04D044F4DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9464BB02-4315-4304-9144-6D577A016CAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{280F70E8-C6EB-4601-9F8E-7BF85F1F8986}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{83A6706F-609A-45DE-88FC-56BB6970477A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2DD4DE71-993F-46DE-B349-E9B601BD8FA7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BA2DE4D5-B69A-4BAF-82B2-4B9B48C21D3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D217283F-A38F-43B9-B3AC-FA9D80E18162}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{170F972D-D1FA-4B45-BDDB-E20E205C9766}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{12421F1B-5660-48A2-B159-FAE72EEA7A2F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7E706189-6318-4BCA-9B59-016628754338}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AD8B8B45-6DC7-42D6-BB03-1ED9D5094FDF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FB109740-53CE-4B3E-9CC9-213EA40EC49C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A6735685-8625-4E5D-9CE4-D97A4EF75206}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{32F530CC-143E-46E6-BD21-03919692801B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C48510D7-1897-4F06-8DD7-B393068C5C20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AB46913E-C8BA-450F-A75D-C40A2C410E06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{54D528A7-EB2D-4D97-A9F4-601D5984481F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{13FB7CF1-9B0A-49C1-8D43-C4A39F6F09A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2F7EB898-233D-425C-9EE7-CAC1563E68FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BE19301B-7560-403A-98AD-B9DFF750845F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{69564C6A-9BA4-4875-A72C-9CB424C75AD8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{23E7324C-B2F6-4CE1-96B9-1174F284D877}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{44430D8D-0C09-4044-B70D-FA44B59A9B8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A26014A3-15B6-4EA3-B07D-90C7A6F106B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FBC57B80-45F9-4088-A412-7006ECE0D3DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2FB54857-3613-476A-98DF-CB09D2761FD6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A5F7B507-8A66-4E9D-87A6-CE3467874C1F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2485050D-F89B-47A4-AEFF-641BEB2728E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{83095356-BFAD-4E7E-AA8C-B588579398DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FA9FA20E-38EA-4E20-A35F-E5AF186C1EBA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{26F85853-547F-442E-B4ED-C0A608690EE0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2DF742CC-9814-4951-932F-F17A7F79E9A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{45DB4849-960B-4724-9172-B11E8CCE37AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7EB3CFBB-9DAF-4DF3-9907-22896D398FA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{088691E4-0205-41CB-B073-4907FDF16D8E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{951A4768-F5BD-467F-A07A-CEB047F785F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F4B35FF3-8E2E-461F-9CB2-FE0DF6472D63}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8845E448-0B7A-4377-9A05-F368639162EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{ADC8C68E-9896-47BF-A64B-4AD8A9EBD1B0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BF122924-7AB5-45D5-9015-B3CBFD7C3198}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3B47AC1B-2D20-4816-80A3-534A231CB94E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{46DB818F-BB06-4AF4-9C95-8ADB83200B5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D08E1F07-088B-49B8-854F-9913BBAF019E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AC229F13-7253-4FA4-A66C-E27A4F58CF9B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DDC1B9FF-EF0C-42F0-985B-4270120B8399}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FFC40F58-91B1-44AC-BCF6-636A4412C687}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7CC9CE76-E7CE-449B-8C23-C585BE49AC7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7A4DC10D-AB63-4413-8993-8F8CBE25CB04}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E5802D51-5194-4E5A-8F63-FB48B0242EBB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AD6F8A8A-939E-486E-8B4A-3CA34916551C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6950871D-3CDC-442A-8F05-75A9E10A0C0C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{55ECA879-EC04-4239-890F-976D8002DDFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{84B235CD-EBA8-48BF-AAA7-40550A066094}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D3EFC865-8A3D-48BC-BE78-BC3937DB284D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8017641E-1F55-4A55-82CC-0BC0FF87088D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B21C0DAD-35ED-476F-BA13-15E713FD98C9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{54F3293C-8A29-4087-A59A-DBFB8B767296}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E2914B7B-BD05-4090-831F-8A48A83BB54E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6D77A76E-2911-4A77-AA24-C8899726C6A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A0296017-7BD4-4389-B297-5D3AED169A39}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{15419FFA-2645-4048-8538-8D0FE4029A1E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D1828F5B-77CE-4886-A50A-78509A0467A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{12C453FE-615B-4B1A-BF17-2EA2578A9523}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8A1B3EC7-18B7-41FB-9F26-165A4B7DC750}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{62B16045-5CF0-469C-8D67-F3C11830E1EB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C0F8E29C-DE14-431E-AA3E-A5A595272066}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A59697F4-5817-42F6-8162-116EB66D4820}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4692AE51-697B-4EA5-974A-3E9DCD5D57D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1E63FEE4-FE54-4351-9370-4C7A225AC701}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{07374B1A-602E-4B1D-9ABF-FB663D4D0474}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A2C8BA21-C0AA-4751-9501-1C0D410FCF59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5D4353F0-1A87-4612-B1C9-C7ADB058854D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E7E0C938-44E5-49FE-8E4D-33534F106C89}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{66AFE394-5E13-4582-818B-70F77705216C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AF18827C-812E-4B23-8856-A4AAA50F3297}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3F734DD3-49C9-4527-BB43-98659CEB4E3A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A74ACE04-CF05-4883-8325-2DF2DC2BB8BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6DBBD6B3-798E-4339-82F7-F9E8ACA13F90}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5C94AAC2-A601-4B0E-9653-2A78CE6E1883}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9E5FC3CC-9323-4A13-B498-079C41E6A323}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9B6AE474-FFD8-43BE-A13D-12A2C0449478}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F9152C57-BBC0-4C29-AFEB-9842D04C3F2B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{65C93539-0390-4FAE-AE12-7FE37F7D9457}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CF5E21B4-001A-433D-9AB4-374CBD81E491}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9FA28E58-CFC0-4FF7-9906-0A15EAD87AD5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6453552F-6AB2-4E9D-B6B1-1CC5E82CB166}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E4F1A547-99EF-41C9-9CB4-B1F4D0C29242}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F7318C8E-2ED2-4273-B8D5-89BB3FDA0CC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{83E9F2B8-2423-4644-AB19-BC3C22C567D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5DA2A157-5FBD-4543-9D9B-5BCF14DBE146}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B90E09F2-9916-4ED0-85CF-84A74936DDDB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{215FD723-DAEB-4770-BEF5-B9084CAAB868}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3B4F995F-D1A7-4B5E-9569-5769D22FEB0B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9256DA5A-7CE9-4C3B-A047-DE8689C26311}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4B393208-47CC-4854-9164-8F0B2BA74253}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{669138D0-0EF9-4C65-9C96-ADB6550A4CDF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5A999A6F-AA23-43C5-AEAD-59C579A6D906}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{68C273FA-0A33-4C68-897B-5417B9B93DB9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BBFD09D4-2E29-4CB6-BC7D-FE5313EFB2A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C70B3E9B-3D3A-446C-967B-912CEECBD1EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{23380B5A-19F2-4C1F-82A8-FB8D20D7A5C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BB6D6377-D742-4A7B-9F3C-ED95368FF052}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6C699984-8786-4197-99C6-A58D3D095C07}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{71561B90-A752-4023-A224-5173D509D8C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B10BDDC9-70CB-4039-9E7E-6AE0CBD64423}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{14CBC83F-5F83-43E2-9B15-C173B51A8452}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F035F73C-F251-4C66-8591-676FE9AE0523}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FF162AF2-4F42-41F2-9A76-A84E302D2054}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{79F30B3A-3944-440E-ACE7-DD7C32E92276}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DB0E850C-5777-424E-885A-88F43F86DB95}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{250288C2-6B5E-4271-A5DE-317C43DAFCBA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4C5BE6FF-157D-43D5-9610-838CC1091C4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0DEBAAC6-D8EF-4BEE-9D1B-341CB03F06E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5EF306C0-FFB4-441F-AFAE-D7AEEE72EB31}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4909A11C-9C2C-4B8D-8563-4CF454A4B66E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D58CDCBC-BA74-481B-B4C1-8194F108FD78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E414C09C-56FD-47F9-BF24-C7BAF40D3BEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6272B484-DEF2-48F9-9EF1-2CDFCF3AAA09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BA2DF7C1-6A3B-4537-AFB6-43251BC86B0E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E4C441AC-F827-431F-8DBA-95943C1A2406}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{23918D5B-8DBE-4294-9E03-EB6F7AEE73F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BCB4C942-C152-4F08-A9D2-A93541095B10}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E6498A6B-1BFC-4AA9-ACA1-9091E0359F98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{562FA9CA-9AAC-468B-8E7C-D1E78BA0AB8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{65930293-F610-4F03-92F7-DC6104B858B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7FD361A4-8852-4DC1-B822-84171B18F85B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{00B3673B-3D31-47B6-8B85-9961124C7E44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A8AA1857-6DFE-41C0-8FDD-11931D6F473A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C49B5A5F-AA71-46B2-BA9A-D811E437D451}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{46020C9E-FDEE-434D-9FEA-CD50CC994A10}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{32BB0074-18D3-4430-BF60-60D5F2D4C781}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4F4E0E36-2F5C-4DA3-BCDB-75408B8A2AD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CA0583A4-2358-42F6-92E5-CDDC94D2CCA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{82A3EE11-3CDE-494C-B89D-909FF107717E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B8CD5CC6-B1AF-4395-8CBD-D4DAD9879FDB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4E3BF0D4-2E5B-41E9-8977-ABB4DD386981}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C3265680-8CC6-4424-AA44-09A71317EB29}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C7C7F1DD-78DD-48F8-A9F0-737917486049}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0D716B65-1EA7-4304-94D7-438ECD223593}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{36059131-A7F9-4FD3-A341-79E2ABBA5571}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{97481D6A-8E64-4AED-81A8-5DFFD2E738D1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A4932423-E31A-4B0F-B6B2-D7B603913590}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FA1BE77E-E9B0-40EC-BADB-3688842C5BB3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4BB41C57-BE2D-4672-B9C7-2DD3B9A371C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{23F99AE5-A04F-4D79-9859-BAAD14405D25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8CE0FC26-A2D9-484E-B850-FB02BCE42C23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{83761288-2E1D-4086-9EBD-A7B82F9887F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A6186F83-FF35-4C3F-B148-3DB8B977D084}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{85C828BC-416F-4A32-971D-C3143625BA81}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{307E2FD1-CB78-4111-9ED8-3E226D4D675B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F4856C5D-E03F-4625-B7D0-555F41C61345}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CC97FD39-ADCD-4F85-B19E-01FC4281A153}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D151ECBF-C69A-4CD1-9DAF-0DB350586934}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{29FA2E9C-4450-4F03-B596-978531DFED5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0C52CA33-825D-435A-9774-A090BB60C772}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{09D6AF6F-9C99-4D65-A973-7019A03281A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{945C85FA-2B6C-4C6B-917A-D7A70414280D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DA253E48-6F22-44E7-919B-F067199F69F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1BD06FBB-5849-488E-B105-D8170FA592BF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DB38E89F-E9D3-422B-B53A-7E0B16B87D3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7EA345BE-2110-4505-B62E-CDE239E79C3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{37D2B362-D518-4CED-B346-FB5F9C2F634F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E8A6A853-C9C2-4D6D-836D-675C4BEDFE32}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3CB789D6-46F4-41F1-8968-E93D82B39914}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{63E5A7CA-2211-4384-BCAE-976C43E51D8B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F7009567-3B2B-4AC7-A2B7-EFF3D35AC822}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DF672AF1-43AF-4BB3-B74D-C39EFD63B94E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1303641B-520E-4F1C-BF57-9D9CFFE2EF1D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FE100384-BD38-42F1-B3AF-5D311D850CB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6CEDA87F-5A17-41E2-9E5E-041E6A2C6C75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C3A81087-FCBB-4FFF-BB79-D66B7AA66A6F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1116BF36-2196-49A0-B797-40C61371BF27}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F3519938-092D-4D0E-8BFD-141A3F207C83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3AB90EF5-D702-4B20-B127-D8F6815980E7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DAE2A17C-1CC6-4B37-A885-4E38D5CAC346}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F866FC4C-233F-4849-AA4C-C7866FBD0594}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AA69C413-D41E-449C-B004-E2E6D4ABB285}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B02E71BD-AB34-4B82-A3C0-5DDD700CE0E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4576921D-45DC-44AE-A0B2-39B6B9659BA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{816A59ED-CFF0-4DC7-AB25-82BE2E7C390F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F2C16E74-86A5-40F0-9132-5643A2986C54}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F232A6C4-E352-4453-91FC-4EF540BB05AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C221E9D7-8E49-44E8-B3AE-A01311988803}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E173971A-30B9-4CC3-B0BF-90011F0807DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{90AF38C9-230F-4F9F-8289-FFC116BDF2CA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A9F00618-09A0-4E0D-9137-E24751BFCDCB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F475B63B-2603-4FAB-90C7-9EA865826875}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D71E1444-5407-4A11-B20D-D4186A82553A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{34A6D8CE-1B6C-470A-8FA3-6DCD35094FB8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{70DA34BA-EFC7-4C94-A2B1-F608780AC7DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E097336E-C249-4609-AF8D-656C9B04107A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C3F225B2-110A-48AD-9156-1477139080A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CEF7DEC2-9460-4AD7-B6CA-333E41D58143}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{AA6F1604-FB28-4A3A-A3FE-52118DE87C6C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9A2FAF27-19B0-40EE-A0BC-D0F0A79CEE4E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9BD0DDD1-D3E0-4E17-A452-8D1EA68E7796}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{3F654C68-FB36-475B-90FC-BF65AF2AD690}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{60A8620B-CE58-4A29-B251-01A42503ED3D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{424B6F19-56D6-4697-A4B6-88D4BC5DC1FD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{91E0D1A2-38D8-495F-9307-3BFAD7955D21}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{07B08C5F-D3E4-49C9-991B-633DA031435E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{99CC289B-D8CA-4587-B04A-EC3EDBC644E7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{52BCF879-5FE4-4E87-84F9-523CAD83BF41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{685F1F8D-6535-4D6A-9AB0-2FD49E193FF5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E2878081-FF79-49F5-8A06-8DD5303902E7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DEFF8501-1460-44B3-8E55-C39A8E981879}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6A4A2271-8CC4-45AD-8F32-C23802EED662}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{75E09DB4-E394-4A2F-8FD0-1D62DF4E4B19}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{4700EC21-2EEB-4208-A041-20F9A9D2DCEB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{35F1A503-E43C-44B2-BB6B-67E0BA27B299}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{FC3609D7-9ABE-444D-90AE-915C8DA2B029}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A02395C9-FDAF-41C3-8074-02001670B3CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{92194EFB-AAEA-4B5D-8231-22E76C5BBA18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{47B852A6-2AAE-408B-91BF-70CDA6DECEDE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2207EDA3-BC85-4B99-AF39-839AD01425D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{204C7A8E-C997-41B6-A6BF-30C7CE49C051}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E2F4A710-22C5-4AA6-B5B7-7DADF186A18A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6758CED9-5670-4605-ADFF-25F919E00A43}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{B3F38650-B1D0-4722-BE02-DA1D25449AFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{56AC6DB0-33DD-49E3-BBC7-84FEA5AB69C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A47B677E-CF0E-4044-A546-73214ED2B3EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C4CA9773-9499-4455-93A2-CFCF2EAC08C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9FE8DD90-CCD0-4306-A23B-0C8690C84B6D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E530015F-CB4E-413A-88C7-5CF34F0DA5B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6C53DD54-B741-4838-A738-42FC7D53CEFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{35D65EB9-AA65-4AC9-A3D7-CD36C88A8F35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{D08AF5FC-3BB9-4A11-9078-B7AF9EF5428B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9693E998-53A9-4E69-8558-8F9A203DFFEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8CF02788-72D5-48D3-B804-4B374A3993DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0A9A0CF2-21C3-4E33-8DE3-40171100E450}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{91BC0600-D105-4657-9C83-49BB74FFD470}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{60B0F26C-B35D-4428-8AE4-6BEE821ABC7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E4A41905-4E11-4D3E-BB80-7230B5C47E27}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CA426114-62DB-49EC-90D2-C4843881666D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{87178CBC-C655-495C-A068-7FD32FCDA8B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{282F6F20-8CD3-4D1A-962D-87DF5E4C8103}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F1BC481F-D755-411E-A00B-5AA2813056FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C8432417-7D21-4035-8020-184FA657BE56}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{DF0B0E5A-25E8-421C-9056-6391F13FE12D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CBE1AE52-1D56-42CC-AD1B-BEDFFEE46345}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{6B8F6B7F-19B5-4890-8527-4D8A027332DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0AD91B07-85BB-446F-BC27-BD73829F3321}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BC114E98-D9FF-4713-9079-EE1F90F08A0A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{F391C343-6AC4-436E-B6F7-A60DF5E7C387}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{E8971F43-B67F-422A-A3A9-7EBFA62C091F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0F94BA7B-C3FE-4D1C-9228-5D093CE32F3A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{2DBD7689-0F02-4FBE-99BF-129222F8859B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{BE7C58F4-584C-4D3C-B286-42D07A282A68}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{5C2DD93D-75B0-4093-B56F-9CD564948675}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{634DA82A-3302-411D-A3E8-994D19C7A2F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A7C920A4-8FBE-4642-BE70-942FDA455F7E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{97A7C5FA-41C0-44C4-87C8-0D699EB1B1FC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{9817974D-4F8F-4A07-98F7-DCCCD660CF6F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{0313D9C7-6B76-4DD0-AFCB-6405B109B42A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{43CA9AF1-784F-4E9B-99FC-6D6EB4928CC4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A4DBF84D-E78B-4A59-A3F2-AD8C26FDF653}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{62B7E3A1-2AD4-4B98-9C18-6498579988EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{64A11136-13C9-443D-ABCC-8C7653970850}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{473D427B-9318-4AA9-83CC-D28EEF2AE5E2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{8BC0CDD5-F278-486F-95B4-AC51C41F5B52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{10C342D6-035B-48F6-8A95-115F0A7096B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{A9991337-CDCB-4E68-A795-22B771B6B20D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{C0AA64D7-2E37-470C-8ADF-4B0618F93D70}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{1EF0117D-014F-4A07-ACD4-D834584A4F25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{97A7C5FA-41C0-44C4-87C8-0D699EB1B1FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{7323FACD-81D6-4308-AB63-D5E75E9F03A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "patch", "Shared Technology", "Photoshop Camera Raw 7", "")
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{541D0C68-5928-4E2A-8002-8F1614F1BF73}"><File><InstallPath>[INSTALLDIR]\Plug-Ins\CS6\File Formats\Camera Raw.8bi</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0" , "ValidationSig", "ESCF1LfugT9DfrO8I1M8/ysUIqZPuX47elrybS2/cws1vzAbdmuee3oWZ4HMzvgKCnSAB6hh58H9s7XB4OoLkW4ircBdV5VhGebHbNq/AldYOb8NxtWK2IMIgaFXl2ba4a7xVg5OgHrCHS0Ymt8RMZMpmfI8ek2U5R4GiKAIRPi+s50dJxT2lHH7eqsObCb3se5q3E9jmGzB3JeockNq4GUn+8zZ4wUBuKDnaaGuBzonOusbpqBoV6i0VJ2otw9Den04r1y20g6GGbVDE26w6IzCs4GUBfE7FzFkYoYWRAvY1D6OY6aukF7QoCVxknunaJuSOLsmi/9cbxkX98KsVpDzXh6r81gDTH4I8XKZ3ytixv/d4M7j2bwuxudOonnSQenSXMoZEAqQ7vkHVmYhQzj0snjc0r0eTP+nfQ7wSalpNeFRgumavAIf0xvdf5Z5Yrp9Uki/7mHogr65oQDSbCeDOsjRm2VwYPH9S8oDzNAr0ErUVfFCCqycqEfeIoKv")
INSERT INTO Payloads VALUES	("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "Shared Technology", "Photoshop Camera Raw 7_8.3_AdobeCameraRaw7.0All", "8.3", "patch")
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.98.0"><BuildInfo>
    <Property name="Created">2013-12-03 02:01:20.316000</Property>
    <Property name="TargetName">AdobeCameraRaw7.0All-031213020120</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{541D0C68-5928-4E2A-8002-8F1614F1BF73}</Property>
    <Property name="ProductName">Photoshop Camera Raw 7</Property>
    <Property name="ProductVersion">8.3</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7_8.3_AdobeCameraRaw7.0All</ProductName>
      <ProductVersion>8.3</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{9C414D29-7041-46CF-9A7D-C6373614B233}</AdobeCode>
    <AdobeCode>{89846452-DA87-4D2C-944F-170E6616C305}</AdobeCode>
    <AdobeCode>{489136FD-C6E1-4631-8583-485B6ACB57DD}</AdobeCode>
    <AdobeCode>{CFFC1672-93B3-44BB-AC64-4309F13A4C74}</AdobeCode>
    <AdobeCode>{3BE6260A-9819-45EF-B4A9-B7DA6EEEC6A3}</AdobeCode>
    <AdobeCode>{C69D5AA8-917B-4467-81C1-7DE4C86A7596}</AdobeCode>
    <AdobeCode>{1E7B22B2-7653-4F2B-A913-E40D99AE1EAB}</AdobeCode>
    <AdobeCode>{97E0C54E-EB42-4F4B-9213-892DDDFF90D8}</AdobeCode>
    <AdobeCode>{D247D3CA-41F7-46FC-A5B1-E502474E867F}</AdobeCode>
    <AdobeCode>{2EE7B51F-FAAB-4A2D-98C8-D153BE6FDB90}</AdobeCode>
    <AdobeCode>{9B88787E-A245-498C-BE74-03A5AD5F1B4B}</AdobeCode>
    <AdobeCode>{FD20C912-497A-45A8-8FD7-BFF849BFBAA4}</AdobeCode>
    <AdobeCode>{8BDF71A3-A455-4484-8A72-58E9B652778F}</AdobeCode>
    <AdobeCode>{DC3BACD3-D2A1-4639-90D7-0E1D673D584E}</AdobeCode>
    <AdobeCode>{8A0997A2-25D3-4366-BF25-E1023750BF82}</AdobeCode>
    <AdobeCode>{53404690-459B-4DC0-AAC1-7C89E7FCF24F}</AdobeCode>
    <AdobeCode>{890E857A-8F7D-4131-9FF1-9CA21192007C}</AdobeCode>
    <AdobeCode>{65E0F6C2-2D75-4A76-BE59-352FED538A1B}</AdobeCode>
    <AdobeCode>{C80B98CF-F295-4D75-864D-FED8479EF32D}</AdobeCode>
    <AdobeCode>{B4306D6D-2DFE-46F6-BE05-11F67B36A6AB}</AdobeCode>
    <AdobeCode>{93A0F249-C8F8-4F81-A051-0937F6174081}</AdobeCode>
    <AdobeCode>{2AEE283B-979B-4230-853C-8CBADE1B8C5E}</AdobeCode>
    <AdobeCode>{1DE926CC-5B16-4BC9-B260-7BC24F0F2B15}</AdobeCode>
    <AdobeCode>{89F85C08-8AF1-4EDE-8049-A7562A69F6DE}</AdobeCode>
    <AdobeCode>{71BE6974-3F9E-41F1-9073-57AB62C6A897}</AdobeCode>
    <AdobeCode>{749EB018-E680-481D-A798-6DCC4712B809}</AdobeCode>
    <AdobeCode>{460FA82E-AC8A-4246-82E1-7B90E7283275}</AdobeCode>
    <AdobeCode>{7D224BAC-2351-4673-BBBD-4524B8F3FD3D}</AdobeCode>
    <AdobeCode>{92D4DAE6-7FCE-4647-85AD-B40BBBDB2F9D}</AdobeCode>
    <AdobeCode>{1F02C8B8-E1E9-4348-A7E6-D42D19234550}</AdobeCode>
    <AdobeCode>{C98B7CD2-5D46-4130-9950-4E4A2C92F662}</AdobeCode>
    <AdobeCode>{EC682A9F-9A5E-4EBD-A19A-9E9C7F0206E6}</AdobeCode>
    <AdobeCode>{F216F49F-5377-4E53-B85D-6E3AD8CDE42C}</AdobeCode>
    <AdobeCode>{E747E8AC-9273-4347-ADC0-30DAAC073AE9}</AdobeCode>
    <AdobeCode>{A81F8C6F-7446-4108-9CA5-C3D4E6773D5F}</AdobeCode>
    <AdobeCode>{14771CFB-50D4-4BA8-A7E8-F138F2C227F8}</AdobeCode>
    <AdobeCode>{B41B1166-C82F-4DDD-8EB6-03175296A204}</AdobeCode>
    <AdobeCode>{F408183C-7F88-4A35-82D7-80945F834B12}</AdobeCode>
    <AdobeCode>{BF3254DF-032D-446C-8F70-EEA85B4812EE}</AdobeCode>
    <AdobeCode>{DF19AC32-4BB3-48FA-95C0-265DC5FB1A98}</AdobeCode>
    <AdobeCode>{3FECBFED-E5CC-453B-99B6-7A99C10D6E8F}</AdobeCode>
    <AdobeCode>{69E21969-90E5-41B1-9FB6-A428AA82CD25}</AdobeCode>
    <AdobeCode>{B35F0A7E-73C6-48D8-97C9-9406BA84BF59}</AdobeCode>
    <AdobeCode>{72F6D500-5169-4D4B-8E71-27FFCE8D5EFE}</AdobeCode>
    <AdobeCode>{FA148573-E0E5-400F-8978-D95410035F18}</AdobeCode>
    <AdobeCode>{DF19AC32-4BB3-48FA-95C0-265DC5FB1A99}</AdobeCode>
    <AdobeCode>{E6299DEC-FE6B-4BAE-89C6-97F287E33A93}</AdobeCode>
    <AdobeCode>{0744D46C-B2FB-4718-9387-7B571D3133D3}</AdobeCode>
    <AdobeCode>{721F201C-73C7-4F95-8079-A9D0EEE9FED2}</AdobeCode>
    <AdobeCode>{66730C5A-82DB-474B-A685-0484C6A59B7F}</AdobeCode>
    <AdobeCode>{0279E1B9-0871-41BA-910B-1A8962A72687}</AdobeCode>
    <AdobeCode>{FC30A6FE-8968-4FEA-9461-27C1BD51075D}</AdobeCode>
    <AdobeCode>{5D7BB2B4-3778-4286-A820-CB80AFB3256A}</AdobeCode>
    <AdobeCode>{E34FB6A3-9908-4AE5-807A-B947343C7367}</AdobeCode>
    <AdobeCode>{8A420EDB-862E-4C82-BA13-9D9370D7CF57}</AdobeCode>
    <AdobeCode>{03527BAB-4B06-4F5D-A4B3-457D005F72C4}</AdobeCode>
    <AdobeCode>{EECE1C32-F1AC-4A85-8D36-DE1ED77FEA00}</AdobeCode>
    <AdobeCode>{2E1BF0FB-821A-4CF1-9A43-333A064C3413}</AdobeCode>
    <AdobeCode>{26FAE072-6D20-49A4-96B3-1C66FA0569AD}</AdobeCode>
    <AdobeCode>{0DE4E246-69F3-4D36-A02F-4A2C0BD873F4}</AdobeCode>
    <AdobeCode>{C93F448E-F065-41CD-8FEB-4459EA52D351}</AdobeCode>
    <AdobeCode>{E7D960A6-B4B0-4BFC-BA0C-4905467BE4D9}</AdobeCode>
    <AdobeCode>{36815267-1C28-4768-8A07-F28744B5A4D5}</AdobeCode>
    <AdobeCode>{9C292231-2CE4-4893-971F-FFDA45AE875A}</AdobeCode>
    <AdobeCode>{1518F589-A9CD-4CC3-99D8-99801F5BCFF5}</AdobeCode>
    <AdobeCode>{93072A3E-CF91-4E25-9316-EBA7808CD5DC}</AdobeCode>
    <AdobeCode>{E41AA91D-E1E2-4498-B7E9-D669395022EF}</AdobeCode>
    <AdobeCode>{904ED171-CF4B-4637-92E9-7BAE496197BD}</AdobeCode>
    <AdobeCode>{F4E4E47B-1E29-4197-A2AD-CF33E06956DC}</AdobeCode>
    <AdobeCode>{73F9DBD8-20BD-49CC-82B9-8A6175579DC1}</AdobeCode>
    <AdobeCode>{D789E20D-6185-4C02-95F3-A649B744FACE}</AdobeCode>
    <AdobeCode>{E827AE2B-A83C-49D4-B672-A24D1A6FD89E}</AdobeCode>
    <AdobeCode>{5DE9C0BB-2DC4-4CC7-9544-C3102AAA27F9}</AdobeCode>
    <AdobeCode>{77CD28EF-DFDE-4142-BFA4-9D7E4377A3C0}</AdobeCode>
    <AdobeCode>{CDCDAC16-D2C4-43AB-B209-4240C6C96514}</AdobeCode>
    <AdobeCode>{ACE171FB-CBBD-4168-8C53-8B5C84C1DDAD}</AdobeCode>
    <AdobeCode>{649E466B-8929-4AE7-A855-73B7B85A9E1A}</AdobeCode>
    <AdobeCode>{27C19B89-402D-439D-8D5B-995E1E7A854D}</AdobeCode>
    <AdobeCode>{DAEFC71B-8B2E-465E-8FE2-E01254D9B2D2}</AdobeCode>
    <AdobeCode>{9618C71D-31E7-4864-A7C1-0ABA3F236E22}</AdobeCode>
    <AdobeCode>{DA499B6C-D17D-48F9-A5A6-6F76A3BD20F7}</AdobeCode>
    <AdobeCode>{34095D68-70DC-4672-B3F0-969DFA815004}</AdobeCode>
    <AdobeCode>{C9B1347F-26E6-4B84-A840-531FCD1B8F7E}</AdobeCode>
    <AdobeCode>{DFC907AD-D1C3-4669-9569-483F7075DE02}</AdobeCode>
    <AdobeCode>{D344E569-ABBA-4E34-AFEF-23C01F1B3A4B}</AdobeCode>
    <AdobeCode>{6EE62A33-9F89-4473-9A08-127BD835B063}</AdobeCode>
    <AdobeCode>{95BA7BED-609C-4780-A6D5-269750484069}</AdobeCode>
    <AdobeCode>{F8DCD5F7-98E6-4B03-BA00-DB7811B679CC}</AdobeCode>
    <AdobeCode>{15DDF6DC-B41B-493F-9C5E-F23FAC81C1AB}</AdobeCode>
    <AdobeCode>{F3A5352C-724A-4E7E-977A-FEBD225D4C0B}</AdobeCode>
    <AdobeCode>{33BD0B7F-CF0D-45DD-8B34-DA37D2A919AD}</AdobeCode>
    <AdobeCode>{03245650-3A0C-44A8-86B8-A074E9F939A9}</AdobeCode>
    <AdobeCode>{C9D00500-9E38-4943-993D-CB8C72DF7485}</AdobeCode>
    <AdobeCode>{51CC95B3-494E-4B61-B44B-3F14C3A19D63}</AdobeCode>
    <AdobeCode>{2AEEBC84-FA86-4F01-BD3D-8701639000B7}</AdobeCode>
    <AdobeCode>{FF7B84CC-D263-4FBC-8D25-8E47B7165D30}</AdobeCode>
    <AdobeCode>{AADBFB12-EED5-4119-B228-5C2B9C5C8E9C}</AdobeCode>
    <AdobeCode>{7D3BF844-0003-428B-9BD6-11B693DFD980}</AdobeCode>
    <AdobeCode>{3907D683-0B9A-4122-9924-CF396A33ABF2}</AdobeCode>
    <AdobeCode>{2133A596-0E02-43D5-9ADE-3B181A18963D}</AdobeCode>
    <AdobeCode>{E3D11C0D-E72D-4339-BC49-D86D7066C089}</AdobeCode>
    <AdobeCode>{CACFCF56-F06E-4EB6-93C5-D2B769953BE2}</AdobeCode>
    <AdobeCode>{9F9A50DA-3238-4C0B-AFFE-8D04D044F4DE}</AdobeCode>
    <AdobeCode>{9464BB02-4315-4304-9144-6D577A016CAE}</AdobeCode>
    <AdobeCode>{280F70E8-C6EB-4601-9F8E-7BF85F1F8986}</AdobeCode>
    <AdobeCode>{83A6706F-609A-45DE-88FC-56BB6970477A}</AdobeCode>
    <AdobeCode>{2DD4DE71-993F-46DE-B349-E9B601BD8FA7}</AdobeCode>
    <AdobeCode>{BA2DE4D5-B69A-4BAF-82B2-4B9B48C21D3E}</AdobeCode>
    <AdobeCode>{D217283F-A38F-43B9-B3AC-FA9D80E18162}</AdobeCode>
    <AdobeCode>{170F972D-D1FA-4B45-BDDB-E20E205C9766}</AdobeCode>
    <AdobeCode>{12421F1B-5660-48A2-B159-FAE72EEA7A2F}</AdobeCode>
    <AdobeCode>{7E706189-6318-4BCA-9B59-016628754338}</AdobeCode>
    <AdobeCode>{AD8B8B45-6DC7-42D6-BB03-1ED9D5094FDF}</AdobeCode>
    <AdobeCode>{FB109740-53CE-4B3E-9CC9-213EA40EC49C}</AdobeCode>
    <AdobeCode>{A6735685-8625-4E5D-9CE4-D97A4EF75206}</AdobeCode>
    <AdobeCode>{32F530CC-143E-46E6-BD21-03919692801B}</AdobeCode>
    <AdobeCode>{C48510D7-1897-4F06-8DD7-B393068C5C20}</AdobeCode>
    <AdobeCode>{AB46913E-C8BA-450F-A75D-C40A2C410E06}</AdobeCode>
    <AdobeCode>{54D528A7-EB2D-4D97-A9F4-601D5984481F}</AdobeCode>
    <AdobeCode>{13FB7CF1-9B0A-49C1-8D43-C4A39F6F09A5}</AdobeCode>
    <AdobeCode>{2F7EB898-233D-425C-9EE7-CAC1563E68FE}</AdobeCode>
    <AdobeCode>{BE19301B-7560-403A-98AD-B9DFF750845F}</AdobeCode>
    <AdobeCode>{69564C6A-9BA4-4875-A72C-9CB424C75AD8}</AdobeCode>
    <AdobeCode>{23E7324C-B2F6-4CE1-96B9-1174F284D877}</AdobeCode>
    <AdobeCode>{44430D8D-0C09-4044-B70D-FA44B59A9B8F}</AdobeCode>
    <AdobeCode>{A26014A3-15B6-4EA3-B07D-90C7A6F106B2}</AdobeCode>
    <AdobeCode>{FBC57B80-45F9-4088-A412-7006ECE0D3DA}</AdobeCode>
    <AdobeCode>{2FB54857-3613-476A-98DF-CB09D2761FD6}</AdobeCode>
    <AdobeCode>{A5F7B507-8A66-4E9D-87A6-CE3467874C1F}</AdobeCode>
    <AdobeCode>{2485050D-F89B-47A4-AEFF-641BEB2728E1}</AdobeCode>
    <AdobeCode>{83095356-BFAD-4E7E-AA8C-B588579398DE}</AdobeCode>
    <AdobeCode>{FA9FA20E-38EA-4E20-A35F-E5AF186C1EBA}</AdobeCode>
    <AdobeCode>{26F85853-547F-442E-B4ED-C0A608690EE0}</AdobeCode>
    <AdobeCode>{2DF742CC-9814-4951-932F-F17A7F79E9A1}</AdobeCode>
    <AdobeCode>{45DB4849-960B-4724-9172-B11E8CCE37AC}</AdobeCode>
    <AdobeCode>{7EB3CFBB-9DAF-4DF3-9907-22896D398FA9}</AdobeCode>
    <AdobeCode>{088691E4-0205-41CB-B073-4907FDF16D8E}</AdobeCode>
    <AdobeCode>{951A4768-F5BD-467F-A07A-CEB047F785F6}</AdobeCode>
    <AdobeCode>{F4B35FF3-8E2E-461F-9CB2-FE0DF6472D63}</AdobeCode>
    <AdobeCode>{8845E448-0B7A-4377-9A05-F368639162EE}</AdobeCode>
    <AdobeCode>{ADC8C68E-9896-47BF-A64B-4AD8A9EBD1B0}</AdobeCode>
    <AdobeCode>{BF122924-7AB5-45D5-9015-B3CBFD7C3198}</AdobeCode>
    <AdobeCode>{3B47AC1B-2D20-4816-80A3-534A231CB94E}</AdobeCode>
    <AdobeCode>{46DB818F-BB06-4AF4-9C95-8ADB83200B5F}</AdobeCode>
    <AdobeCode>{D08E1F07-088B-49B8-854F-9913BBAF019E}</AdobeCode>
    <AdobeCode>{AC229F13-7253-4FA4-A66C-E27A4F58CF9B}</AdobeCode>
    <AdobeCode>{DDC1B9FF-EF0C-42F0-985B-4270120B8399}</AdobeCode>
    <AdobeCode>{FFC40F58-91B1-44AC-BCF6-636A4412C687}</AdobeCode>
    <AdobeCode>{7CC9CE76-E7CE-449B-8C23-C585BE49AC7C}</AdobeCode>
    <AdobeCode>{7A4DC10D-AB63-4413-8993-8F8CBE25CB04}</AdobeCode>
    <AdobeCode>{E5802D51-5194-4E5A-8F63-FB48B0242EBB}</AdobeCode>
    <AdobeCode>{AD6F8A8A-939E-486E-8B4A-3CA34916551C}</AdobeCode>
    <AdobeCode>{6950871D-3CDC-442A-8F05-75A9E10A0C0C}</AdobeCode>
    <AdobeCode>{55ECA879-EC04-4239-890F-976D8002DDFE}</AdobeCode>
    <AdobeCode>{84B235CD-EBA8-48BF-AAA7-40550A066094}</AdobeCode>
    <AdobeCode>{D3EFC865-8A3D-48BC-BE78-BC3937DB284D}</AdobeCode>
    <AdobeCode>{8017641E-1F55-4A55-82CC-0BC0FF87088D}</AdobeCode>
    <AdobeCode>{B21C0DAD-35ED-476F-BA13-15E713FD98C9}</AdobeCode>
    <AdobeCode>{54F3293C-8A29-4087-A59A-DBFB8B767296}</AdobeCode>
    <AdobeCode>{E2914B7B-BD05-4090-831F-8A48A83BB54E}</AdobeCode>
    <AdobeCode>{6D77A76E-2911-4A77-AA24-C8899726C6A1}</AdobeCode>
    <AdobeCode>{A0296017-7BD4-4389-B297-5D3AED169A39}</AdobeCode>
    <AdobeCode>{15419FFA-2645-4048-8538-8D0FE4029A1E}</AdobeCode>
    <AdobeCode>{D1828F5B-77CE-4886-A50A-78509A0467A3}</AdobeCode>
    <AdobeCode>{12C453FE-615B-4B1A-BF17-2EA2578A9523}</AdobeCode>
    <AdobeCode>{8A1B3EC7-18B7-41FB-9F26-165A4B7DC750}</AdobeCode>
    <AdobeCode>{62B16045-5CF0-469C-8D67-F3C11830E1EB}</AdobeCode>
    <AdobeCode>{C0F8E29C-DE14-431E-AA3E-A5A595272066}</AdobeCode>
    <AdobeCode>{A59697F4-5817-42F6-8162-116EB66D4820}</AdobeCode>
    <AdobeCode>{4692AE51-697B-4EA5-974A-3E9DCD5D57D2}</AdobeCode>
    <AdobeCode>{1E63FEE4-FE54-4351-9370-4C7A225AC701}</AdobeCode>
    <AdobeCode>{07374B1A-602E-4B1D-9ABF-FB663D4D0474}</AdobeCode>
    <AdobeCode>{A2C8BA21-C0AA-4751-9501-1C0D410FCF59}</AdobeCode>
    <AdobeCode>{5D4353F0-1A87-4612-B1C9-C7ADB058854D}</AdobeCode>
    <AdobeCode>{E7E0C938-44E5-49FE-8E4D-33534F106C89}</AdobeCode>
    <AdobeCode>{66AFE394-5E13-4582-818B-70F77705216C}</AdobeCode>
    <AdobeCode>{AF18827C-812E-4B23-8856-A4AAA50F3297}</AdobeCode>
    <AdobeCode>{3F734DD3-49C9-4527-BB43-98659CEB4E3A}</AdobeCode>
    <AdobeCode>{A74ACE04-CF05-4883-8325-2DF2DC2BB8BC}</AdobeCode>
    <AdobeCode>{6DBBD6B3-798E-4339-82F7-F9E8ACA13F90}</AdobeCode>
    <AdobeCode>{5C94AAC2-A601-4B0E-9653-2A78CE6E1883}</AdobeCode>
    <AdobeCode>{9E5FC3CC-9323-4A13-B498-079C41E6A323}</AdobeCode>
    <AdobeCode>{9B6AE474-FFD8-43BE-A13D-12A2C0449478}</AdobeCode>
    <AdobeCode>{F9152C57-BBC0-4C29-AFEB-9842D04C3F2B}</AdobeCode>
    <AdobeCode>{65C93539-0390-4FAE-AE12-7FE37F7D9457}</AdobeCode>
    <AdobeCode>{CF5E21B4-001A-433D-9AB4-374CBD81E491}</AdobeCode>
    <AdobeCode>{9FA28E58-CFC0-4FF7-9906-0A15EAD87AD5}</AdobeCode>
    <AdobeCode>{6453552F-6AB2-4E9D-B6B1-1CC5E82CB166}</AdobeCode>
    <AdobeCode>{E4F1A547-99EF-41C9-9CB4-B1F4D0C29242}</AdobeCode>
    <AdobeCode>{F7318C8E-2ED2-4273-B8D5-89BB3FDA0CC6}</AdobeCode>
    <AdobeCode>{83E9F2B8-2423-4644-AB19-BC3C22C567D3}</AdobeCode>
    <AdobeCode>{5DA2A157-5FBD-4543-9D9B-5BCF14DBE146}</AdobeCode>
    <AdobeCode>{B90E09F2-9916-4ED0-85CF-84A74936DDDB}</AdobeCode>
    <AdobeCode>{215FD723-DAEB-4770-BEF5-B9084CAAB868}</AdobeCode>
    <AdobeCode>{3B4F995F-D1A7-4B5E-9569-5769D22FEB0B}</AdobeCode>
    <AdobeCode>{9256DA5A-7CE9-4C3B-A047-DE8689C26311}</AdobeCode>
    <AdobeCode>{4B393208-47CC-4854-9164-8F0B2BA74253}</AdobeCode>
    <AdobeCode>{669138D0-0EF9-4C65-9C96-ADB6550A4CDF}</AdobeCode>
    <AdobeCode>{5A999A6F-AA23-43C5-AEAD-59C579A6D906}</AdobeCode>
    <AdobeCode>{68C273FA-0A33-4C68-897B-5417B9B93DB9}</AdobeCode>
    <AdobeCode>{BBFD09D4-2E29-4CB6-BC7D-FE5313EFB2A0}</AdobeCode>
    <AdobeCode>{C70B3E9B-3D3A-446C-967B-912CEECBD1EA}</AdobeCode>
    <AdobeCode>{23380B5A-19F2-4C1F-82A8-FB8D20D7A5C0}</AdobeCode>
    <AdobeCode>{BB6D6377-D742-4A7B-9F3C-ED95368FF052}</AdobeCode>
    <AdobeCode>{6C699984-8786-4197-99C6-A58D3D095C07}</AdobeCode>
    <AdobeCode>{71561B90-A752-4023-A224-5173D509D8C3}</AdobeCode>
    <AdobeCode>{B10BDDC9-70CB-4039-9E7E-6AE0CBD64423}</AdobeCode>
    <AdobeCode>{14CBC83F-5F83-43E2-9B15-C173B51A8452}</AdobeCode>
    <AdobeCode>{F035F73C-F251-4C66-8591-676FE9AE0523}</AdobeCode>
    <AdobeCode>{FF162AF2-4F42-41F2-9A76-A84E302D2054}</AdobeCode>
    <AdobeCode>{79F30B3A-3944-440E-ACE7-DD7C32E92276}</AdobeCode>
    <AdobeCode>{DB0E850C-5777-424E-885A-88F43F86DB95}</AdobeCode>
    <AdobeCode>{250288C2-6B5E-4271-A5DE-317C43DAFCBA}</AdobeCode>
    <AdobeCode>{4C5BE6FF-157D-43D5-9610-838CC1091C4B}</AdobeCode>
    <AdobeCode>{0DEBAAC6-D8EF-4BEE-9D1B-341CB03F06E0}</AdobeCode>
    <AdobeCode>{5EF306C0-FFB4-441F-AFAE-D7AEEE72EB31}</AdobeCode>
    <AdobeCode>{4909A11C-9C2C-4B8D-8563-4CF454A4B66E}</AdobeCode>
    <AdobeCode>{D58CDCBC-BA74-481B-B4C1-8194F108FD78}</AdobeCode>
    <AdobeCode>{E414C09C-56FD-47F9-BF24-C7BAF40D3BEC}</AdobeCode>
    <AdobeCode>{6272B484-DEF2-48F9-9EF1-2CDFCF3AAA09}</AdobeCode>
    <AdobeCode>{BA2DF7C1-6A3B-4537-AFB6-43251BC86B0E}</AdobeCode>
    <AdobeCode>{E4C441AC-F827-431F-8DBA-95943C1A2406}</AdobeCode>
    <AdobeCode>{23918D5B-8DBE-4294-9E03-EB6F7AEE73F6}</AdobeCode>
    <AdobeCode>{BCB4C942-C152-4F08-A9D2-A93541095B10}</AdobeCode>
    <AdobeCode>{E6498A6B-1BFC-4AA9-ACA1-9091E0359F98}</AdobeCode>
    <AdobeCode>{562FA9CA-9AAC-468B-8E7C-D1E78BA0AB8F}</AdobeCode>
    <AdobeCode>{65930293-F610-4F03-92F7-DC6104B858B5}</AdobeCode>
    <AdobeCode>{7FD361A4-8852-4DC1-B822-84171B18F85B}</AdobeCode>
    <AdobeCode>{00B3673B-3D31-47B6-8B85-9961124C7E44}</AdobeCode>
    <AdobeCode>{A8AA1857-6DFE-41C0-8FDD-11931D6F473A}</AdobeCode>
    <AdobeCode>{C49B5A5F-AA71-46B2-BA9A-D811E437D451}</AdobeCode>
    <AdobeCode>{46020C9E-FDEE-434D-9FEA-CD50CC994A10}</AdobeCode>
    <AdobeCode>{32BB0074-18D3-4430-BF60-60D5F2D4C781}</AdobeCode>
    <AdobeCode>{4F4E0E36-2F5C-4DA3-BCDB-75408B8A2AD4}</AdobeCode>
    <AdobeCode>{CA0583A4-2358-42F6-92E5-CDDC94D2CCA9}</AdobeCode>
    <AdobeCode>{82A3EE11-3CDE-494C-B89D-909FF107717E}</AdobeCode>
    <AdobeCode>{B8CD5CC6-B1AF-4395-8CBD-D4DAD9879FDB}</AdobeCode>
    <AdobeCode>{4E3BF0D4-2E5B-41E9-8977-ABB4DD386981}</AdobeCode>
    <AdobeCode>{C3265680-8CC6-4424-AA44-09A71317EB29}</AdobeCode>
    <AdobeCode>{C7C7F1DD-78DD-48F8-A9F0-737917486049}</AdobeCode>
    <AdobeCode>{0D716B65-1EA7-4304-94D7-438ECD223593}</AdobeCode>
    <AdobeCode>{36059131-A7F9-4FD3-A341-79E2ABBA5571}</AdobeCode>
    <AdobeCode>{97481D6A-8E64-4AED-81A8-5DFFD2E738D1}</AdobeCode>
    <AdobeCode>{A4932423-E31A-4B0F-B6B2-D7B603913590}</AdobeCode>
    <AdobeCode>{FA1BE77E-E9B0-40EC-BADB-3688842C5BB3}</AdobeCode>
    <AdobeCode>{4BB41C57-BE2D-4672-B9C7-2DD3B9A371C6}</AdobeCode>
    <AdobeCode>{23F99AE5-A04F-4D79-9859-BAAD14405D25}</AdobeCode>
    <AdobeCode>{8CE0FC26-A2D9-484E-B850-FB02BCE42C23}</AdobeCode>
    <AdobeCode>{83761288-2E1D-4086-9EBD-A7B82F9887F5}</AdobeCode>
    <AdobeCode>{A6186F83-FF35-4C3F-B148-3DB8B977D084}</AdobeCode>
    <AdobeCode>{85C828BC-416F-4A32-971D-C3143625BA81}</AdobeCode>
    <AdobeCode>{307E2FD1-CB78-4111-9ED8-3E226D4D675B}</AdobeCode>
    <AdobeCode>{F4856C5D-E03F-4625-B7D0-555F41C61345}</AdobeCode>
    <AdobeCode>{CC97FD39-ADCD-4F85-B19E-01FC4281A153}</AdobeCode>
    <AdobeCode>{D151ECBF-C69A-4CD1-9DAF-0DB350586934}</AdobeCode>
    <AdobeCode>{29FA2E9C-4450-4F03-B596-978531DFED5C}</AdobeCode>
    <AdobeCode>{0C52CA33-825D-435A-9774-A090BB60C772}</AdobeCode>
    <AdobeCode>{09D6AF6F-9C99-4D65-A973-7019A03281A0}</AdobeCode>
    <AdobeCode>{945C85FA-2B6C-4C6B-917A-D7A70414280D}</AdobeCode>
    <AdobeCode>{DA253E48-6F22-44E7-919B-F067199F69F1}</AdobeCode>
    <AdobeCode>{1BD06FBB-5849-488E-B105-D8170FA592BF}</AdobeCode>
    <AdobeCode>{DB38E89F-E9D3-422B-B53A-7E0B16B87D3F}</AdobeCode>
    <AdobeCode>{7EA345BE-2110-4505-B62E-CDE239E79C3F}</AdobeCode>
    <AdobeCode>{37D2B362-D518-4CED-B346-FB5F9C2F634F}</AdobeCode>
    <AdobeCode>{E8A6A853-C9C2-4D6D-836D-675C4BEDFE32}</AdobeCode>
    <AdobeCode>{3CB789D6-46F4-41F1-8968-E93D82B39914}</AdobeCode>
    <AdobeCode>{63E5A7CA-2211-4384-BCAE-976C43E51D8B}</AdobeCode>
    <AdobeCode>{F7009567-3B2B-4AC7-A2B7-EFF3D35AC822}</AdobeCode>
    <AdobeCode>{DF672AF1-43AF-4BB3-B74D-C39EFD63B94E}</AdobeCode>
    <AdobeCode>{1303641B-520E-4F1C-BF57-9D9CFFE2EF1D}</AdobeCode>
    <AdobeCode>{FE100384-BD38-42F1-B3AF-5D311D850CB1}</AdobeCode>
    <AdobeCode>{6CEDA87F-5A17-41E2-9E5E-041E6A2C6C75}</AdobeCode>
    <AdobeCode>{C3A81087-FCBB-4FFF-BB79-D66B7AA66A6F}</AdobeCode>
    <AdobeCode>{1116BF36-2196-49A0-B797-40C61371BF27}</AdobeCode>
    <AdobeCode>{F3519938-092D-4D0E-8BFD-141A3F207C83}</AdobeCode>
    <AdobeCode>{3AB90EF5-D702-4B20-B127-D8F6815980E7}</AdobeCode>
    <AdobeCode>{DAE2A17C-1CC6-4B37-A885-4E38D5CAC346}</AdobeCode>
    <AdobeCode>{F866FC4C-233F-4849-AA4C-C7866FBD0594}</AdobeCode>
    <AdobeCode>{AA69C413-D41E-449C-B004-E2E6D4ABB285}</AdobeCode>
    <AdobeCode>{B02E71BD-AB34-4B82-A3C0-5DDD700CE0E0}</AdobeCode>
    <AdobeCode>{4576921D-45DC-44AE-A0B2-39B6B9659BA2}</AdobeCode>
    <AdobeCode>{816A59ED-CFF0-4DC7-AB25-82BE2E7C390F}</AdobeCode>
    <AdobeCode>{F2C16E74-86A5-40F0-9132-5643A2986C54}</AdobeCode>
    <AdobeCode>{F232A6C4-E352-4453-91FC-4EF540BB05AE}</AdobeCode>
    <AdobeCode>{C221E9D7-8E49-44E8-B3AE-A01311988803}</AdobeCode>
    <AdobeCode>{E173971A-30B9-4CC3-B0BF-90011F0807DD}</AdobeCode>
    <AdobeCode>{90AF38C9-230F-4F9F-8289-FFC116BDF2CA}</AdobeCode>
    <AdobeCode>{A9F00618-09A0-4E0D-9137-E24751BFCDCB}</AdobeCode>
    <AdobeCode>{F475B63B-2603-4FAB-90C7-9EA865826875}</AdobeCode>
    <AdobeCode>{D71E1444-5407-4A11-B20D-D4186A82553A}</AdobeCode>
    <AdobeCode>{34A6D8CE-1B6C-470A-8FA3-6DCD35094FB8}</AdobeCode>
    <AdobeCode>{70DA34BA-EFC7-4C94-A2B1-F608780AC7DC}</AdobeCode>
    <AdobeCode>{E097336E-C249-4609-AF8D-656C9B04107A}</AdobeCode>
    <AdobeCode>{C3F225B2-110A-48AD-9156-1477139080A0}</AdobeCode>
    <AdobeCode>{CEF7DEC2-9460-4AD7-B6CA-333E41D58143}</AdobeCode>
    <AdobeCode>{AA6F1604-FB28-4A3A-A3FE-52118DE87C6C}</AdobeCode>
    <AdobeCode>{9A2FAF27-19B0-40EE-A0BC-D0F0A79CEE4E}</AdobeCode>
    <AdobeCode>{9BD0DDD1-D3E0-4E17-A452-8D1EA68E7796}</AdobeCode>
    <AdobeCode>{3F654C68-FB36-475B-90FC-BF65AF2AD690}</AdobeCode>
    <AdobeCode>{60A8620B-CE58-4A29-B251-01A42503ED3D}</AdobeCode>
    <AdobeCode>{424B6F19-56D6-4697-A4B6-88D4BC5DC1FD}</AdobeCode>
    <AdobeCode>{91E0D1A2-38D8-495F-9307-3BFAD7955D21}</AdobeCode>
    <AdobeCode>{07B08C5F-D3E4-49C9-991B-633DA031435E}</AdobeCode>
    <AdobeCode>{99CC289B-D8CA-4587-B04A-EC3EDBC644E7}</AdobeCode>
    <AdobeCode>{52BCF879-5FE4-4E87-84F9-523CAD83BF41}</AdobeCode>
    <AdobeCode>{685F1F8D-6535-4D6A-9AB0-2FD49E193FF5}</AdobeCode>
    <AdobeCode>{E2878081-FF79-49F5-8A06-8DD5303902E7}</AdobeCode>
    <AdobeCode>{DEFF8501-1460-44B3-8E55-C39A8E981879}</AdobeCode>
    <AdobeCode>{6A4A2271-8CC4-45AD-8F32-C23802EED662}</AdobeCode>
    <AdobeCode>{75E09DB4-E394-4A2F-8FD0-1D62DF4E4B19}</AdobeCode>
    <AdobeCode>{4700EC21-2EEB-4208-A041-20F9A9D2DCEB}</AdobeCode>
    <AdobeCode>{35F1A503-E43C-44B2-BB6B-67E0BA27B299}</AdobeCode>
    <AdobeCode>{FC3609D7-9ABE-444D-90AE-915C8DA2B029}</AdobeCode>
    <AdobeCode>{A02395C9-FDAF-41C3-8074-02001670B3CB}</AdobeCode>
    <AdobeCode>{92194EFB-AAEA-4B5D-8231-22E76C5BBA18}</AdobeCode>
    <AdobeCode>{47B852A6-2AAE-408B-91BF-70CDA6DECEDE}</AdobeCode>
    <AdobeCode>{2207EDA3-BC85-4B99-AF39-839AD01425D0}</AdobeCode>
    <AdobeCode>{204C7A8E-C997-41B6-A6BF-30C7CE49C051}</AdobeCode>
    <AdobeCode>{E2F4A710-22C5-4AA6-B5B7-7DADF186A18A}</AdobeCode>
    <AdobeCode>{6758CED9-5670-4605-ADFF-25F919E00A43}</AdobeCode>
    <AdobeCode>{B3F38650-B1D0-4722-BE02-DA1D25449AFB}</AdobeCode>
    <AdobeCode>{56AC6DB0-33DD-49E3-BBC7-84FEA5AB69C3}</AdobeCode>
    <AdobeCode>{A47B677E-CF0E-4044-A546-73214ED2B3EA}</AdobeCode>
    <AdobeCode>{C4CA9773-9499-4455-93A2-CFCF2EAC08C7}</AdobeCode>
    <AdobeCode>{9FE8DD90-CCD0-4306-A23B-0C8690C84B6D}</AdobeCode>
    <AdobeCode>{E530015F-CB4E-413A-88C7-5CF34F0DA5B5}</AdobeCode>
    <AdobeCode>{6C53DD54-B741-4838-A738-42FC7D53CEFE}</AdobeCode>
    <AdobeCode>{35D65EB9-AA65-4AC9-A3D7-CD36C88A8F35}</AdobeCode>
    <AdobeCode>{D08AF5FC-3BB9-4A11-9078-B7AF9EF5428B}</AdobeCode>
    <AdobeCode>{9693E998-53A9-4E69-8558-8F9A203DFFEC}</AdobeCode>
    <AdobeCode>{8CF02788-72D5-48D3-B804-4B374A3993DD}</AdobeCode>
    <AdobeCode>{0A9A0CF2-21C3-4E33-8DE3-40171100E450}</AdobeCode>
    <AdobeCode>{91BC0600-D105-4657-9C83-49BB74FFD470}</AdobeCode>
    <AdobeCode>{60B0F26C-B35D-4428-8AE4-6BEE821ABC7C}</AdobeCode>
    <AdobeCode>{E4A41905-4E11-4D3E-BB80-7230B5C47E27}</AdobeCode>
    <AdobeCode>{CA426114-62DB-49EC-90D2-C4843881666D}</AdobeCode>
    <AdobeCode>{87178CBC-C655-495C-A068-7FD32FCDA8B6}</AdobeCode>
    <AdobeCode>{282F6F20-8CD3-4D1A-962D-87DF5E4C8103}</AdobeCode>
    <AdobeCode>{F1BC481F-D755-411E-A00B-5AA2813056FA}</AdobeCode>
    <AdobeCode>{C8432417-7D21-4035-8020-184FA657BE56}</AdobeCode>
    <AdobeCode>{DF0B0E5A-25E8-421C-9056-6391F13FE12D}</AdobeCode>
    <AdobeCode>{CBE1AE52-1D56-42CC-AD1B-BEDFFEE46345}</AdobeCode>
    <AdobeCode>{6B8F6B7F-19B5-4890-8527-4D8A027332DC}</AdobeCode>
    <AdobeCode>{0AD91B07-85BB-446F-BC27-BD73829F3321}</AdobeCode>
    <AdobeCode>{BC114E98-D9FF-4713-9079-EE1F90F08A0A}</AdobeCode>
    <AdobeCode>{F391C343-6AC4-436E-B6F7-A60DF5E7C387}</AdobeCode>
    <AdobeCode>{E8971F43-B67F-422A-A3A9-7EBFA62C091F}</AdobeCode>
    <AdobeCode>{0F94BA7B-C3FE-4D1C-9228-5D093CE32F3A}</AdobeCode>
    <AdobeCode>{2DBD7689-0F02-4FBE-99BF-129222F8859B}</AdobeCode>
    <AdobeCode>{BE7C58F4-584C-4D3C-B286-42D07A282A68}</AdobeCode>
    <AdobeCode>{5C2DD93D-75B0-4093-B56F-9CD564948675}</AdobeCode>
    <AdobeCode>{634DA82A-3302-411D-A3E8-994D19C7A2F5}</AdobeCode>
    <AdobeCode>{A7C920A4-8FBE-4642-BE70-942FDA455F7E}</AdobeCode>
    <AdobeCode>{97A7C5FA-41C0-44C4-87C8-0D699EB1B1FC}</AdobeCode>
    <AdobeCode>{9817974D-4F8F-4A07-98F7-DCCCD660CF6F}</AdobeCode>
    <AdobeCode>{0313D9C7-6B76-4DD0-AFCB-6405B109B42A}</AdobeCode>
    <AdobeCode>{43CA9AF1-784F-4E9B-99FC-6D6EB4928CC4}</AdobeCode>
    <AdobeCode>{A4DBF84D-E78B-4A59-A3F2-AD8C26FDF653}</AdobeCode>
    <AdobeCode>{62B7E3A1-2AD4-4B98-9C18-6498579988EF}</AdobeCode>
    <AdobeCode>{64A11136-13C9-443D-ABCC-8C7653970850}</AdobeCode>
    <AdobeCode>{473D427B-9318-4AA9-83CC-D28EEF2AE5E2}</AdobeCode>
    <AdobeCode>{8BC0CDD5-F278-486F-95B4-AC51C41F5B52}</AdobeCode>
    <AdobeCode>{10C342D6-035B-48F6-8A95-115F0A7096B6}</AdobeCode>
    <AdobeCode>{A9991337-CDCB-4E68-A795-22B771B6B20D}</AdobeCode>
    <AdobeCode>{C0AA64D7-2E37-470C-8ADF-4B0618F93D70}</AdobeCode>
    <AdobeCode>{1EF0117D-014F-4A07-ACD4-D834584A4F25}</AdobeCode>
    <AdobeCode>{97A7C5FA-41C0-44C4-87C8-0D699EB1B1FB}</AdobeCode>
    <AdobeCode>{7323FACD-81D6-4308-AB63-D5E75E9F03A0}</AdobeCode>
  </Upgrades><Channel enable="1" id="PhotoshopCameraRaw7-7.0">
        <DisplayName>Photoshop Camera Raw 7</DisplayName>
      </Channel><Update id="8.3.52">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw 8.3(CS6)&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour 8.3(CS6) de Photoshop Camera Raw&lt;/fr_FR&gt;
		&lt;de_DE&gt;Photoshop Camera Raw 8.3(CS6)-Update&lt;/de_DE&gt;
		&lt;it_IT&gt;Aggiornamento di Photoshop Camera Raw 8.3(CS6)&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop Camera Raw 8.3(CS6) アップデート&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización Photoshop Camera Raw 8.3(CS6)&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatering till Photoshop Camera Raw 8.3(CS6)&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop Camera Raw 8.3(CS6) 更新&lt;/zh_CN&gt;
		&lt;zh_TW&gt;Photoshop Camera Raw 8.3(CS6) 更新&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Photoshop Camera Raw 8.3(CS6)-update&lt;/nl_NL&gt;
		&lt;ko_KR&gt;Photoshop Camera Raw 8.3(CS6) 업데이트&lt;/ko_KR&gt;
		&lt;nb_NO&gt;Oppdatering for Photoshop Camera Raw 8.3(CS6)&lt;/nb_NO&gt;
		&lt;da_DK&gt;Photoshop Camera Raw 8.3(CS6)-opdatering&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop Camera Raw 8.3(CS6) -päivitys&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Photoshop Camera Raw 8.3(CS6) – aktualizacja&lt;/pl_PL&gt;
		&lt;cs_CZ&gt;Aktualizace Photoshop Camera Raw 8.3(CS6)&lt;/cs_CZ&gt;
		&lt;ro_RO&gt;Actualizare Photoshop Camera Raw 8.3(CS6)&lt;/ro_RO&gt;
		&lt;hu_HU&gt;Photoshop Camera Raw 8.3(CS6) frissítés&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление Photoshop Camera Raw 8.3(CS6)&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do Photoshop Camera Raw 8.3(CS6)&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення Photoshop Camera Raw 8.3(CS6)&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop Camera Raw 8.3(CS6) Güncellemesi&lt;/tr_TR&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Update to the Camera Raw plug-in that ships with Photoshop CS6.  Adds raw support for new camera models.&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour du module externe Camera Raw fourni avec Photoshop CS6.  Ajoute la prise en charge des fichiers Raw pour les nouveaux modèles d'appareils photo.&lt;/fr_FR&gt;
		&lt;de_DE&gt;Update für das Camera Raw-Zusatzmodul, das im Lieferumfang von Photoshop CS6 enthalten ist.  Zusätzliche Unterstützung für Raw-Dateien aus neuen Kameramodellen.&lt;/de_DE&gt;
		&lt;it_IT&gt;Eseguite l'aggiornamento del plug-in di Camera Raw in dotazione con Photoshop CS6.  Consente il supporto per i file raw per nuovi modelli di fotocamere.&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop CS6 に同梱されている Camera Raw プラグインに更新します。  新しいカメラモデル対応の Raw サポートが追加されます。&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización para el plugin Camera Raw suministrado con Photoshop CS6.  Permite la compatibilidad con los archivos RAW de los nuevos modelos de cámara.&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatera plugin-programmet Camera Raw som levereras med Photoshop CS6.  Lägger till stöd för raw-format för nya kameramodeller.&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop CS6 随附的 Camera Raw 插件的更新。针对新相机型号增加 raw 文件格式支持.&lt;/zh_CN&gt;
		&lt;zh_TW&gt;更新 Photoshop CS6 隨附的 Camera Raw 增效模組。  新增對新相機機型的原生支援.&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Update voor de Camera Raw-plug-in die bij Photoshop CS6 wordt geleverd.  Voegt RAW-ondersteuning toe voor nieuwe cameramodellen.&lt;/nl_NL&gt;
		&lt;cs_CZ&gt;Aktualizace zásuvného modulu Camera Raw, dodávaného s aplikací Photoshop CS6.  Přidává podporu formátu raw u nových modelů fotoaparátů.&lt;/cs_CZ&gt;
		&lt;nb_NO&gt;Oppdatering for tilleggsmodulen Camera Raw som leveres med Photoshop CS6.  Legger til ekte støtte for nye kameramodeller.&lt;/nb_NO&gt;
		&lt;da_DK&gt;Opdatering til Camera Raw-ekstramodulet, der leveres sammen med Photoshop CS6.  Føjer Raw-understøttelse til nye kameramodeller.&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop CS6:n mukana toimitettavan Camera Raw -laajennuksen päivitys.  Lisää raw-tuen uusille kameramalleille.&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Aktualizacja wtyczki Camera Raw, która jest dołączona do programu Photoshop CS6.  Dodaje obsługę RAW dla nowych modeli aparatów.&lt;/pl_PL&gt;
		&lt;ko_KR&gt;Photoshop CS6와 함께 제공된 Camera Raw 플러그인을 업데이트합니다.  새 카메라 모델의 raw 파일 지원 추가.&lt;/ko_KR&gt;
		&lt;ro_RO&gt;Actualizaţi la plugin-ul Camera Raw livrat cu Photoshop CS6.  Acesta adaugă compatibilitate cu formate brute de la noi modele de camere foto.&lt;/ro_RO&gt;
		&lt;hu_HU&gt;A Photoshop CS6 verzióhoz tartozó Camera Raw bővítmény frissítése.  Biztosítja a raw-formátum támogatását újabb fényképezőgép-típusok esetében is.&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление внешнего модуля Camera Raw, который входит в комплект поставки Photoshop CS6.  Добавлена поддержка формата raw для новых моделей камер.&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do plug-in do Camera Raw fornecido com o Photoshop CS6.  Inclusão de suporte adicional para novos modelos de câmeras.&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення для модуля Camera Raw, що постачається з пакетом Photoshop CS6.  Додано підтримку формату raw для нових моделей фотокамер.&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop CS6 ile birlikte verilen Camera Raw eklentisine güncelleyin.  Yeni fotoğraf makinesi modelleri için raw desteği sağlar.&lt;/tr_TR&gt;
    &lt;/Description&gt;</Update><Extends type="patch">
    <ParentProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7</ProductName>
      <AdobeCode>{CFC3110A-491C-4DBF-A97D-66C567600A2F}</AdobeCode>
    </ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="49000688" sysDriveSize="62567421"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>49001210</TotalSize>
      <MaxPathComponent>/Plug-Ins/CS6/File Formats\Camera Raw.8bi</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[SharedApplicationData]</Root>
      <TotalSize>62567421</TotalSize>
      <MaxPathComponent>/Adobe/CameraRaw/LensProfiles/1.0/Sigma/Nikon\NIKON CORPORATION (SIGMA 17-70mm F2.8-4 DC MACRO OS HSM C013) - RAW.lcp</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="62567421"/>
      <Asset flag="1" name="Assets1_1" size="49000688"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
    <Win32>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Bb][Rr][Ii][Dd][Gg][Ee].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Aa][Uu][Tt][Oo][Aa][Nn][Aa][Ll][Yy][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ll][Ii][Gg][Hh][Tt][Rr][Oo][Oo][Mm].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Oo][Rr][Gg][Aa][Nn][Ii][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Nn][Gg] [Cc][Oo][Nn][Vv][Ee][Rr][Tt][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Ee][Dd][Ii][Tt][Oo][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss].[Ee][Xx][Ee]$</Process>
    </Win32>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">8.3</Value>
      <Value lang="be_BY">8.3</Value>
      <Value lang="bg_BG">8.3</Value>
      <Value lang="ca_ES">8.3</Value>
      <Value lang="cs_CZ">8.3</Value>
      <Value lang="da_DK">8.3</Value>
      <Value lang="de_DE">8.3</Value>
      <Value lang="el_GR">8.3</Value>
      <Value lang="en_GB">8.3</Value>
      <Value lang="en_MX">8.3</Value>
      <Value lang="en_US">8.3</Value>
      <Value lang="en_XC">8.3</Value>
      <Value lang="en_XM">8.3</Value>
      <Value lang="es_ES">8.3</Value>
      <Value lang="es_MX">8.3</Value>
      <Value lang="es_QM">8.3</Value>
      <Value lang="et_EE">8.3</Value>
      <Value lang="fi_FI">8.3</Value>
      <Value lang="fr_CA">8.3</Value>
      <Value lang="fr_FR">8.3</Value>
      <Value lang="fr_MX">8.3</Value>
      <Value lang="fr_XM">8.3</Value>
      <Value lang="he_IL">8.3</Value>
      <Value lang="hi_IN">8.3</Value>
      <Value lang="hr_HR">8.3</Value>
      <Value lang="hu_HU">8.3</Value>
      <Value lang="is_IS">8.3</Value>
      <Value lang="it_IT">8.3</Value>
      <Value lang="ja_JP">8.3</Value>
      <Value lang="ko_KR">8.3</Value>
      <Value lang="lt_LT">8.3</Value>
      <Value lang="lv_LV">8.3</Value>
      <Value lang="mk_MK">8.3</Value>
      <Value lang="nb_NO">8.3</Value>
      <Value lang="nl_NL">8.3</Value>
      <Value lang="nn_NO">8.3</Value>
      <Value lang="no_NO">8.3</Value>
      <Value lang="pl_PL">8.3</Value>
      <Value lang="pt_BR">8.3</Value>
      <Value lang="ro_RO">8.3</Value>
      <Value lang="ru_RU">8.3</Value>
      <Value lang="sh_YU">8.3</Value>
      <Value lang="sk_SK">8.3</Value>
      <Value lang="sl_SI">8.3</Value>
      <Value lang="sq_AL">8.3</Value>
      <Value lang="sv_SE">8.3</Value>
      <Value lang="th_TH">8.3</Value>
      <Value lang="tr_TR">8.3</Value>
      <Value lang="uk_UA">8.3</Value>
      <Value lang="vi_VN">8.3</Value>
      <Value lang="zh_CN">8.3</Value>
      <Value lang="zh_TW">8.3</Value>
      <Value lang="en_AE">8.3</Value>
      <Value lang="en_IL">8.3</Value>
      <Value lang="fr_MA">8.3</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Photoshop Camera Raw 7</Value>
      <Value lang="be_BY">Photoshop Camera Raw 7</Value>
      <Value lang="bg_BG">Photoshop Camera Raw 7</Value>
      <Value lang="ca_ES">Photoshop Camera Raw 7</Value>
      <Value lang="cs_CZ">Photoshop Camera Raw 7</Value>
      <Value lang="da_DK">Photoshop Camera Raw 7</Value>
      <Value lang="de_DE">Photoshop Camera Raw 7</Value>
      <Value lang="el_GR">Photoshop Camera Raw 7</Value>
      <Value lang="en_GB">Photoshop Camera Raw 7</Value>
      <Value lang="en_MX">Photoshop Camera Raw 7</Value>
      <Value lang="en_US">Photoshop Camera Raw 7</Value>
      <Value lang="en_XC">Photoshop Camera Raw 7</Value>
      <Value lang="en_XM">Photoshop Camera Raw 7</Value>
      <Value lang="es_ES">Photoshop Camera Raw 7</Value>
      <Value lang="es_MX">Photoshop Camera Raw 7</Value>
      <Value lang="es_QM">Photoshop Camera Raw 7</Value>
      <Value lang="et_EE">Photoshop Camera Raw 7</Value>
      <Value lang="fi_FI">Photoshop Camera Raw 7</Value>
      <Value lang="fr_CA">Photoshop Camera Raw 7</Value>
      <Value lang="fr_FR">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MX">Photoshop Camera Raw 7</Value>
      <Value lang="fr_XM">Photoshop Camera Raw 7</Value>
      <Value lang="he_IL">Photoshop Camera Raw 7</Value>
      <Value lang="hi_IN">Photoshop Camera Raw 7</Value>
      <Value lang="hr_HR">Photoshop Camera Raw 7</Value>
      <Value lang="hu_HU">Photoshop Camera Raw 7</Value>
      <Value lang="is_IS">Photoshop Camera Raw 7</Value>
      <Value lang="it_IT">Photoshop Camera Raw 7</Value>
      <Value lang="ja_JP">Photoshop Camera Raw 7</Value>
      <Value lang="ko_KR">Photoshop Camera Raw 7</Value>
      <Value lang="lt_LT">Photoshop Camera Raw 7</Value>
      <Value lang="lv_LV">Photoshop Camera Raw 7</Value>
      <Value lang="mk_MK">Photoshop Camera Raw 7</Value>
      <Value lang="nb_NO">Photoshop Camera Raw 7</Value>
      <Value lang="nl_NL">Photoshop Camera Raw 7</Value>
      <Value lang="nn_NO">Photoshop Camera Raw 7</Value>
      <Value lang="no_NO">Photoshop Camera Raw 7</Value>
      <Value lang="pl_PL">Photoshop Camera Raw 7</Value>
      <Value lang="pt_BR">Photoshop Camera Raw 7</Value>
      <Value lang="ro_RO">Photoshop Camera Raw 7</Value>
      <Value lang="ru_RU">Photoshop Camera Raw 7</Value>
      <Value lang="sh_YU">Photoshop Camera Raw 7</Value>
      <Value lang="sk_SK">Photoshop Camera Raw 7</Value>
      <Value lang="sl_SI">Photoshop Camera Raw 7</Value>
      <Value lang="sq_AL">Photoshop Camera Raw 7</Value>
      <Value lang="sv_SE">Photoshop Camera Raw 7</Value>
      <Value lang="th_TH">Photoshop Camera Raw 7</Value>
      <Value lang="tr_TR">Photoshop Camera Raw 7</Value>
      <Value lang="uk_UA">Photoshop Camera Raw 7</Value>
      <Value lang="vi_VN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_CN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_TW">Photoshop Camera Raw 7</Value>
      <Value lang="en_AE">Photoshop Camera Raw 7</Value>
      <Value lang="en_IL">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MA">Photoshop Camera Raw 7</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0", "ChannelID", "PhotoshopCameraRaw7-7.0")
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0", "ChannelInfo", '<Channel enable="1" id="PhotoshopCameraRaw7-7.0">
        <DisplayName>Photoshop Camera Raw 7</DisplayName>
      </Channel>')
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0", "UpdateID", "8.3.52")
INSERT INTO PayloadData VALUES("{541D0C68-5928-4E2A-8002-8F1614F1BF73}", "0", "UpdateInfo", '<Update id="8.3.52">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw 8.3(CS6)&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour 8.3(CS6) de Photoshop Camera Raw&lt;/fr_FR&gt;
		&lt;de_DE&gt;Photoshop Camera Raw 8.3(CS6)-Update&lt;/de_DE&gt;
		&lt;it_IT&gt;Aggiornamento di Photoshop Camera Raw 8.3(CS6)&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop Camera Raw 8.3(CS6) アップデート&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización Photoshop Camera Raw 8.3(CS6)&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatering till Photoshop Camera Raw 8.3(CS6)&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop Camera Raw 8.3(CS6) 更新&lt;/zh_CN&gt;
		&lt;zh_TW&gt;Photoshop Camera Raw 8.3(CS6) 更新&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Photoshop Camera Raw 8.3(CS6)-update&lt;/nl_NL&gt;
		&lt;ko_KR&gt;Photoshop Camera Raw 8.3(CS6) 업데이트&lt;/ko_KR&gt;
		&lt;nb_NO&gt;Oppdatering for Photoshop Camera Raw 8.3(CS6)&lt;/nb_NO&gt;
		&lt;da_DK&gt;Photoshop Camera Raw 8.3(CS6)-opdatering&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop Camera Raw 8.3(CS6) -päivitys&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Photoshop Camera Raw 8.3(CS6) – aktualizacja&lt;/pl_PL&gt;
		&lt;cs_CZ&gt;Aktualizace Photoshop Camera Raw 8.3(CS6)&lt;/cs_CZ&gt;
		&lt;ro_RO&gt;Actualizare Photoshop Camera Raw 8.3(CS6)&lt;/ro_RO&gt;
		&lt;hu_HU&gt;Photoshop Camera Raw 8.3(CS6) frissítés&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление Photoshop Camera Raw 8.3(CS6)&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do Photoshop Camera Raw 8.3(CS6)&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення Photoshop Camera Raw 8.3(CS6)&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop Camera Raw 8.3(CS6) Güncellemesi&lt;/tr_TR&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Update to the Camera Raw plug-in that ships with Photoshop CS6.  Adds raw support for new camera models.&lt;/en_US&gt;
		&lt;fr_FR&gt;Mise à jour du module externe Camera Raw fourni avec Photoshop CS6.  Ajoute la prise en charge des fichiers Raw pour les nouveaux modèles d'appareils photo.&lt;/fr_FR&gt;
		&lt;de_DE&gt;Update für das Camera Raw-Zusatzmodul, das im Lieferumfang von Photoshop CS6 enthalten ist.  Zusätzliche Unterstützung für Raw-Dateien aus neuen Kameramodellen.&lt;/de_DE&gt;
		&lt;it_IT&gt;Eseguite l'aggiornamento del plug-in di Camera Raw in dotazione con Photoshop CS6.  Consente il supporto per i file raw per nuovi modelli di fotocamere.&lt;/it_IT&gt;
		&lt;ja_JP&gt;Photoshop CS6 に同梱されている Camera Raw プラグインに更新します。  新しいカメラモデル対応の Raw サポートが追加されます。&lt;/ja_JP&gt;
		&lt;es_ES&gt;Actualización para el plugin Camera Raw suministrado con Photoshop CS6.  Permite la compatibilidad con los archivos RAW de los nuevos modelos de cámara.&lt;/es_ES&gt;
		&lt;sv_SE&gt;Uppdatera plugin-programmet Camera Raw som levereras med Photoshop CS6.  Lägger till stöd för raw-format för nya kameramodeller.&lt;/sv_SE&gt;
		&lt;zh_CN&gt;Photoshop CS6 随附的 Camera Raw 插件的更新。针对新相机型号增加 raw 文件格式支持.&lt;/zh_CN&gt;
		&lt;zh_TW&gt;更新 Photoshop CS6 隨附的 Camera Raw 增效模組。  新增對新相機機型的原生支援.&lt;/zh_TW&gt;
		&lt;nl_NL&gt;Update voor de Camera Raw-plug-in die bij Photoshop CS6 wordt geleverd.  Voegt RAW-ondersteuning toe voor nieuwe cameramodellen.&lt;/nl_NL&gt;
		&lt;cs_CZ&gt;Aktualizace zásuvného modulu Camera Raw, dodávaného s aplikací Photoshop CS6.  Přidává podporu formátu raw u nových modelů fotoaparátů.&lt;/cs_CZ&gt;
		&lt;nb_NO&gt;Oppdatering for tilleggsmodulen Camera Raw som leveres med Photoshop CS6.  Legger til ekte støtte for nye kameramodeller.&lt;/nb_NO&gt;
		&lt;da_DK&gt;Opdatering til Camera Raw-ekstramodulet, der leveres sammen med Photoshop CS6.  Føjer Raw-understøttelse til nye kameramodeller.&lt;/da_DK&gt;
		&lt;fi_FI&gt;Photoshop CS6:n mukana toimitettavan Camera Raw -laajennuksen päivitys.  Lisää raw-tuen uusille kameramalleille.&lt;/fi_FI&gt;
		&lt;pl_PL&gt;Aktualizacja wtyczki Camera Raw, która jest dołączona do programu Photoshop CS6.  Dodaje obsługę RAW dla nowych modeli aparatów.&lt;/pl_PL&gt;
		&lt;ko_KR&gt;Photoshop CS6와 함께 제공된 Camera Raw 플러그인을 업데이트합니다.  새 카메라 모델의 raw 파일 지원 추가.&lt;/ko_KR&gt;
		&lt;ro_RO&gt;Actualizaţi la plugin-ul Camera Raw livrat cu Photoshop CS6.  Acesta adaugă compatibilitate cu formate brute de la noi modele de camere foto.&lt;/ro_RO&gt;
		&lt;hu_HU&gt;A Photoshop CS6 verzióhoz tartozó Camera Raw bővítmény frissítése.  Biztosítja a raw-formátum támogatását újabb fényképezőgép-típusok esetében is.&lt;/hu_HU&gt;
		&lt;ru_RU&gt;Обновление внешнего модуля Camera Raw, который входит в комплект поставки Photoshop CS6.  Добавлена поддержка формата raw для новых моделей камер.&lt;/ru_RU&gt;
		&lt;pt_BR&gt;Atualização do plug-in do Camera Raw fornecido com o Photoshop CS6.  Inclusão de suporte adicional para novos modelos de câmeras.&lt;/pt_BR&gt;
		&lt;uk_UA&gt;Оновлення для модуля Camera Raw, що постачається з пакетом Photoshop CS6.  Додано підтримку формату raw для нових моделей фотокамер.&lt;/uk_UA&gt;
		&lt;tr_TR&gt;Photoshop CS6 ile birlikte verilen Camera Raw eklentisine güncelleyin.  Yeni fotoğraf makinesi modelleri için raw desteği sağlar.&lt;/tr_TR&gt;
    &lt;/Description&gt;</Update>')
