CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7C73E4B2-13F9-457C-AE41-2CD6AF0FF37B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3644144A-2A49-48DE-AC68-8F9E71A2A424}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C2D52DC7-2B15-403F-9286-7F3DF7FCA5BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{021C870F-24ED-406D-A544-4B4845D51EB2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{462197D0-44E9-4EF2-8570-392B9711C3AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CF9C12B3-4840-477A-ADD4-69849D02B948}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{38ADDE59-0982-4F26-831A-AD2BBB1E430F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F9B3BCB8-4889-47A5-9DC7-AED8DF968BCA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3256983C-F66C-4164-B150-5DEA5621F240}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{55081A97-35A4-4425-A17E-016148885289}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{840C4B93-66C7-426D-8138-4D47293EB70E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{98D5B8A6-F955-49AD-A4C1-01E867121D2C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BC0B51E6-ADD6-4B24-8739-C0E5671DA64F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B8D9A663-E72E-4068-A71A-CCCE15636D54}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{01D36D30-2EBF-462A-9C67-F90293CBA20F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{FE672002-7320-4D76-9C7B-13A8C69ACEA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{6C5FFD43-E0DF-4E70-825A-737A3074ECB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{6B23B5D1-DB94-4F63-A56C-A4798C4D4098}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{18996042-772A-4699-AF72-A696AFE95477}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DEC5AEE3-BCFF-436F-B772-169AE188B702}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{02635819-AB5D-4EAB-BF67-7713A11BA649}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A200E5BB-C1A6-4AD3-85E5-1CE3E751C6EC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{559E9B06-932F-4274-BFB2-D9580591D718}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CB6BEC69-811C-4FD7-94ED-8D3CEEA00E14}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0511A6B0-7758-47BF-A0A4-06D9869265FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CF4F0A76-7337-4466-A293-1224EC9DB68F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{94513337-51B4-4799-9E91-FFF6672742A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{FE8271A9-276C-4316-B04A-2FDF7DEDDB36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{39BA5361-5ACE-4940-A47E-80197C92CD13}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{08BB5CD0-D241-46A6-9792-B4FB15C92564}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{02F5C0DB-31B8-4871-BE4E-5D212DAA3C6E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{21798322-8EE0-4699-9D0B-0DCCFE3E5893}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F06C2431-D2A6-42D0-AC50-8BB34C8DED2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{24E31A3B-D553-4022-BBD4-2D06B99AE88F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7A1DB20C-5662-4879-ADB6-D596FC342893}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{36B57DEB-92EB-4961-B35C-386681E268BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{93391243-07DE-4EC6-B060-00A363AE6502}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{5BDD0AEC-DD34-44DB-BDA5-7B5222FEB1B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{FF65BFB9-B353-468C-B10C-3C46224B6F93}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7AD421E0-3249-4950-A4AC-B7A9075817C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8CC5D43C-97D8-4963-BE8C-51317FD341A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F86DC2FF-9F9F-4F91-B28A-8C0177E6878C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{57B6401E-C8C9-44AD-9EB6-56185E8EC9CA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A9333AFB-695C-47A5-ABBC-842333E1850B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{EF1E32F3-7831-4E89-9CAD-BB36EDA46299}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F448F63A-AAD1-4BE8-A93E-5B419076D7FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{4086E0DC-1499-4340-A5C2-AAC0E188DAE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{4967F891-7E4A-458D-976D-9729608E3663}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{6FA7CBBA-B4DB-4EA1-81E5-F77782295BB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{18152D73-2348-445B-AA75-CE332455BC20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3A9D77AD-658D-4E49-A746-2B19B054D654}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0BE207E4-E22D-4984-A1D4-575A45692E91}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BA437598-DA4A-4E7D-9B4C-9E683330C1DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B5CA186F-25B5-4247-9728-3EDA871DE801}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{812B3223-7507-4A6F-A388-ABFB021A20FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7DEAE842-CA5E-4EFF-A762-1414EBEF0300}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F20E94B2-1907-46C9-AAA1-3FB227199ACB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{26B5A327-3EC2-4A1A-B4EB-31F367736861}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DC280538-55CF-4821-A4E7-32623275EF77}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DF6C8B2B-AE4C-42A8-84CC-14D1364CF06A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{5C1A6EB6-C256-4D86-969C-DB77734E0317}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D1982939-76ED-4324-AD01-933178F25861}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{88F252FC-008A-4ACA-81A4-A5A2CCF78636}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{522B84C7-9231-4881-8931-BE65DE51FC19}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{1D105D22-FAA2-4E9A-9DDE-64BBF4653A33}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DFAC9C7C-6B12-4C8F-9A26-C7E988D308E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3C6CC1A4-9894-4243-A22F-02E0F81EFC85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{78E1E2E9-4BB0-409E-A696-ABA0ED5D8F53}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{44099F03-9BD7-40DD-A6B3-580F7FFC49BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{873EF784-9E12-4CEF-A81F-57CCDAAB23B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7BB7DEF8-AE49-45C8-AB3D-326AA8DA5FE3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B68FB95B-79FA-46AF-ABDC-BEA515168E2B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8B3AFB7E-EF48-4708-9E99-3D21F0208AA6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{79DA2DCA-EEB0-4CDE-985F-8A82D7726C50}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BBD281CF-DFE8-464F-B481-5E80AF010356}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{1B19DD8C-6DD4-471D-AB4F-164FDD5F8A40}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A2B8F684-F783-47EB-8832-4227361FBCE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8A96672E-45D5-490B-9490-72B82581141B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{1C9AA695-815D-46FF-B989-0D58CB1A7271}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F8D9AF60-EBF2-4BDE-9F50-A0213EF76FB6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{77C6D82C-3CC0-48F0-B9A1-E673FA3EBA23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{745919EC-282D-4A21-B3D1-00DAD224CFBB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{14621349-3D13-4625-9B81-34CACD4E2817}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7C345358-C0C3-4F7B-A849-885F587A8022}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BD9C1AAF-84F0-4916-BBC3-0C689E83B0A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7C752836-6A1A-4492-B18F-8ED26029933E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8B2DBB60-0DD2-428B-B991-1BBE28464EBF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8A547035-DFD1-473E-A793-499872C7C739}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{606FF9CA-4996-41FF-B5C0-2681DD5621CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{799A8884-7966-4B66-A0E9-C71058C4F8A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{1941F945-A732-400E-B9B1-3B3927B977EC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{93C2629B-E5AA-474F-9748-7CEF5E5FE1AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8E6D694E-8469-42FF-8985-DBCFF7FD2AC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{EEB57F7B-64A8-4B4B-AD07-F5E1E70C2C4D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8ABE45D6-86CF-44AF-ABFA-04F4A627DF9D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{2953AC3A-3209-4209-AE02-AAC28C730AD1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B814A85C-3F4A-4909-8096-61B2001A60EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0E0AE597-F611-445E-82E1-1079CEDB2DB3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{87CAD807-2C8B-4360-934F-548921744061}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{90CE9674-FF30-465C-9500-A46DA453123C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{FF4F0895-A44A-4A87-B1C6-9213F18C9A85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{13B9AD6D-CEF3-418C-ACB1-4A16D8185B36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A061265A-DD76-43D2-8C29-98F347A0EC0B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A0144DEE-1757-408D-A1A5-CFCC4EAA9D4D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{2565EEED-D2AA-4127-A6FC-721D2DE32C94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3073C982-F0F9-4A2A-AABA-4C68A92FE836}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C3665F4E-FF33-4999-9AFF-CBCABE51DA40}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{6BF2BF6A-766C-484D-A029-0354E82002F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{5C94CFBE-A637-44D3-95C2-B0D98DA03764}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{E03BF468-116F-455A-A42C-22D9FC731DD8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{6BF52936-B02B-45BD-AEE6-55AC3E834824}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{09D5C0D7-1337-42F4-A7DC-F8667A819BF5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0CB6D87D-C8EF-457E-BD25-FA39451E76A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{45F3360F-1988-4F1C-ADFF-E952ECD3F8E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{129892F4-690A-4C92-86EE-DAEF652B0B06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CA874C30-46AD-437C-8537-D982382BE438}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F956ED9F-3FF3-447C-B894-766E991F41D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{563566F5-506F-4F1E-9739-5A39175A75D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{38C7C796-EAE3-427A-8424-CC2FB3B73479}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CDBA16B3-E641-4893-B7B0-09972F85C517}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{EACADA73-EADC-49AB-B023-D3E45DEE82C4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{57C9681B-7641-46BF-9097-6EA818DE8557}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{81967FDF-60C4-484D-8BD2-837AFE144030}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{AD5C3967-8E8D-4F5D-876E-DD9461991C5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BC195504-BCAE-4A82-AFD1-29B8F469CAFF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3B32AAEB-4B93-4403-B2D8-E7FD69751AD3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BE237186-2509-4955-8686-DC1AB2B53C57}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{49545DB3-5DA9-4FEB-9C42-5A123BE7F721}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C3958F18-80CE-44BB-ADF3-AF6CA9FE2EF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{EB63B2DC-BC76-4862-9AEA-0110C4846641}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{EC5DF353-79B2-45CC-BE09-49A13E8B5073}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{12ED8871-B7FD-4762-A23B-0B8083F44DB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0E5488F5-C3EA-47A8-9216-72D7A84A9D35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{AD64ADE4-4057-4FFB-9292-D05C3BE8638C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{4C6C228D-7747-4AC2-BEFE-4860C43A47C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{6C4CDCDD-0585-4ADC-A32C-EC71F135D261}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{5127D28B-D9F9-4366-839F-BB77FFD9E25D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{722489FD-4CFB-434B-A2C9-4B593088A55E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{2ACCAA6D-4151-4103-907F-B188327C8450}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{980D7EB3-59E6-47A9-9B01-01E8650A413F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{43D51211-BA8F-40A2-90B4-00F2DF9BD908}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{658D4079-8D05-4623-9C42-36B6D148C953}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7D3F7673-0BC2-49B8-BAF3-7A66B77AFD72}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{6F8464F4-4EAF-4F0D-8F38-266E54387E73}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CE9A9CAF-8720-4DBB-B114-C2FEFD9FAEE2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A5A1D53E-C006-47C3-802B-861879463F74}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0689EF91-D8B0-4671-9102-16987B00BCDC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{E5C24874-F205-4C6D-A20F-D9DC900CCE78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C6AA9036-1776-4A91-A2BE-E464F5B0A70C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B3DE5581-B3EC-41FC-B770-0DB6B6A8AF8A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DE5D3A00-4414-4D90-81DA-24847662756E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{46D2E7B7-85BE-4718-B6DD-9F6171E46177}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{AA7D59AF-02E5-4917-8ACE-FD80B12BD775}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D5D69CC5-2D67-4090-AC98-023D29EB99C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{301B5DB1-097A-4309-9EB3-78727969ED4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{9AA08D96-8D48-4CED-8336-4FB9051806B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{30F1C516-CEAC-48E4-BB06-51BDA5E6C9F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{325392A6-64A9-4A02-8F4A-09DF545CAA47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3C5C87B7-6926-4093-9FC0-2D3E2357FE92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{677C7F25-ECA2-4AFD-971D-405D14400D00}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C75D294B-9CB6-4840-9DCE-99796BCFB063}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CA3AC1A0-5BE8-496F-8758-AB35F6F9E8F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DEA297A8-2482-48A6-9B3D-0C83DBA4CB83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3B06DF13-04DC-48BA-B8B7-4778F911E22E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{65CB3346-D0BF-444C-AC22-043A4F385D28}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A364774C-B4A3-44D8-9A4B-928069778ACF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{60965C95-D7F3-4BDD-AA9B-2C26487F8341}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B72F0C5F-3648-4FAE-8E05-3447DC29F8ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{9B48FDD0-3666-40D4-848E-4ED95A029035}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D92EF854-EF22-40CC-A46F-473A8671A685}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{EC430F54-2A25-4331-B013-D5E89B050E0A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{9E492485-420E-4CCB-AFD6-7F1DEE3C30D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{13C92FDA-CE94-4B05-9E5C-DF1F3DAB6B02}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DC303783-9A27-4B85-B3D2-C4828A807969}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{87AA94BD-5E18-4782-A363-A77D1341C3A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C72D2D38-922E-494D-A539-406AE8809AAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B0971D06-9D6C-4D77-B443-CE2E8BBD861F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D766CD23-635A-4A5F-8A6A-079382610635}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{78DB4B24-AE99-4904-A6DD-68101226A4DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D53CA9C7-8C1B-469A-972C-4D9FC37E6F70}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A99DF779-FEE9-4B8E-9EB4-A2D79F9E2618}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{12CD36A7-E38F-458C-AD22-3751EB953007}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{37A9D076-3B55-4BED-AC2F-ED699C280338}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CD805F7B-F9F2-4B74-AFDE-6F5C74AA28B0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{18608BF4-1574-41E8-8E8F-88C92D381214}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8B562CB2-9864-47F4-B7A8-E84811048D82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8A58D575-8F79-41F4-A096-697E44A0C42C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{91498854-38F2-4872-9717-E544B0D37FBA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DBDCA09C-E840-4959-83F6-D9E5BFD0CEFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{5F6B34E9-15A7-42EE-8B2C-38105E4300DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{92A49ED1-3EF7-4DC0-A47E-093954C6B99A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BC289ABF-E5D5-448C-83A8-AA1D8FBB78CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{1341E925-2AE4-4416-9921-A181FF02D71B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{99917A9B-27F5-40BE-AF06-57F771579DA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{E2D19262-7614-47D9-83E9-F0866724F198}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DA5342B7-BFBC-4DEB-8CA0-77C5CD9814F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{57555FF0-2AE7-4818-B647-CBBBC39318CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{784F7589-CD4E-448A-877B-A0FC2CE90A07}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0E02ACF9-A8FB-404B-9F38-F0FFD88A7840}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{13FD414A-96CD-4DD1-A54B-9145A00955ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F40E1FF7-4817-4018-9051-0625C3FF9C98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D4F5B610-BD67-4391-8A1E-6B26A315426A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D6F7BFCE-6CA3-4181-A967-9C7449396274}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C487F5CF-6F1A-48B4-9DDA-4FDCF3F22353}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{97AECE99-1692-4A11-BD4E-3DDAC85E385A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7B09BC6E-7F8C-4C3E-90EC-EF20C2868777}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{AD8D7F38-DA99-4618-882E-1473C3042EA6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F8AB1550-057A-4A86-98AE-052D94D65EA1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{EE9A957C-5F46-4A3C-B672-5B34F61A6B31}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{2E5C3A55-9260-4C3E-8AA0-3270B1A0FBC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{035C7769-6AE3-4B97-9C9E-793B5BA8F053}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F110647C-013B-42E7-9F4B-C5C26ECCBC6D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{38DCF34E-96B0-4908-A844-BBD953E04B4F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BD294DE9-69D6-4CB8-A825-DDB8E348CAA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0932484D-4D5C-4F30-9C58-3082C389FAE1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D9A62BEC-56D3-44C4-B681-4D51B50F6669}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DD59E450-75DA-4178-8A69-4AC97A527CF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{1DC86842-7DE4-47FC-8C30-9724E0D1A1F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{4D03F8A9-1ED0-4CAC-9AE9-C88FA6DA2D85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3C3114BC-BAA0-488A-A890-DB765A0DF9BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7F7AD0FE-D847-492B-B389-78A6BC829AD1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{E7676F57-3FC1-4AE3-87B0-8ED59C9CD980}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CD1C5490-2E27-49E2-8A61-6A14CFE2B5AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{2725542C-47EF-48EA-83FD-C618648227E7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B4A1AD6A-A167-4176-957F-FA6ADBC450C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{302F8901-0B79-41FE-ABE0-F1830A43820C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F8E7018A-0F7D-4487-8C8A-8D68ED5335C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BDB45208-5C65-44B1-ABE7-7FE36423AE11}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{418C8AF7-9235-45E4-88AB-3D8B9A94D8B9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{73FF8F87-ACC4-4C2B-A1FA-185E90446422}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{946510FC-DB2D-44C9-B87C-63A5841CF23D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C1452C75-1E6C-4E38-A88F-34CFD4212E8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{66064256-1771-4F04-9DF8-C3300ABAE679}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{17657869-C99B-4AF9-AE9B-8CB1388F0863}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B0EDD120-337F-4199-B11E-72BCDDA9EC12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{240E95CC-E0EF-40B1-A9D8-165E8B2AC390}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A4E88F8D-B1F7-44A9-ACC9-5790B4F71549}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{92C6447C-99AF-4AC2-BF22-A3E79F3FAE69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{18D7F9F7-F6BF-4462-92CC-953F25CCE771}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{48E73747-2897-420B-8D3C-9E9EFD4D75A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{8539F7A5-B2F9-4DA5-9E7F-E170B3B7AD38}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{01F83F38-1792-453F-9FD7-3B88BF265B4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{86AEDE71-23D2-4BE0-BF0A-417FBA32C970}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F0471B68-984D-4042-B2DF-F5246040CEE7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C8DA8DA8-83A8-4825-8152-0A2C09474B6E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0378AD89-49A7-43E1-81C2-4F7FF6CB6EDA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{02D656E5-CA66-4B27-B92F-115C0297D035}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{10755E16-658F-4E47-8314-A0D638F445EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DF2FC6BF-8882-46C5-9C1E-C115F6EBA675}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A726D728-6E2C-46A3-87F3-D9B57270ECEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{166177AE-1A14-40ED-9F35-89365BF4058E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{925D0676-7188-4907-90B8-EA5269F49FC8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{CC1CBB75-B72A-4914-933E-F14498106E47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{952F3761-06B8-4AA3-8D5A-ACEC1CBE59F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B699C3E2-FF0F-415D-ADA4-1A0A2C941780}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{80349813-E504-40BF-820C-0BE7B7E8D50A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F560AD54-7142-4CBC-9533-0C4026744EDB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{850008EB-0AD3-4C8C-91AF-2F4607C57D03}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{9BC7ACF3-FEF8-4E24-8533-1396E844BD3A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{DBA108FC-FFA3-4E6B-A4C7-E6092A1F5FD3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{9FC962B9-C981-4096-BC1D-8E2054B1CA5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C3845B5B-C4A1-4A4E-8A04-438B021DD313}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{FCA4F8A5-69C7-438F-8928-343B11B187C5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{72D2C2CD-310B-46F5-AEE1-0D06340BCBC4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{C49101FC-8B92-4038-AABF-093B19E1905A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B18D4956-7D7F-4CB9-9B7F-AB353A5D179A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{7661A13E-F404-4AE3-B22B-F590ABEF394E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{87EEC421-7AF7-46A8-A130-697DC8A8C403}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{85EFADEE-F8A6-4BF5-81A9-DD56BB927044}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{5542C286-969C-4FEE-93BC-754D9CD2F800}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{BB6088B5-F41B-41D7-9090-4A9CFEA686DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{9C2E2088-5851-44C0-B95D-7BB0CBC16F53}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{4397B32D-7E50-47B3-8B86-1D27827F607A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{27331495-C0AD-4273-BA51-9274758D0370}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B5160508-0E8D-4793-AD2B-C2E4BB3163D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{3D3AE628-A172-431B-BA9B-A063FAF30424}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{F0319758-F59D-4212-BE14-593D2D8EC456}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D582F004-ED4D-4A60-BDCC-DD5C249613F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{27787CD7-2877-4229-A172-DEEFB4073B66}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{B4FFC19A-4D1F-4E4E-82DC-48242D940518}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D2B91D7C-C4B5-49D1-AC5E-1F15D6966747}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{AE1C9B93-6633-4254-A674-78B41EE9FA69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{0200464D-18E2-4992-A958-0BD96EEC96C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{D1CBC066-5EDE-4802-BB80-0F698049CDE2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{A8E96181-4C74-4484-BCF2-7D449FE01451}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "{55F0AFED-606D-476A-A07A-134291002FBA}", "patch", "Shared Technology", "Photoshop Camera Raw 7 (64 bit)", "")
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{C90013CD-40A9-443A-9A10-85F09F382EC9}"><File><InstallPath>[INSTALLDIR]\Plug-Ins\CS6\File Formats\Camera Raw.8bi</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0" , "ValidationSig", "uHmQsOSgneeFpYjcgaVeihfhQD2VGfSq275mNe3TeDKJdI8JYUAT2ZIbUMpn7W5DSmuAGjK5o+ulE8l9ynzlXLqLrRXBjVrLFiqgrqIZhkoYOLfH0p0U67Txndd6T35OvZAphelb6W26FRjFV795+9q2wKZZ8WS9kInUr47MK1/Xsfvzfbvs0vu5u3GdbHCWCRgxw8InlhHPZqdCzF4Vl/gJdR8ULb3LNthSDQt+dCqOhb6mQygSUVWWOSEwIxpnzYd40jAz8sKo/Z1U2xW+KJDvh2a6WamR+4qFqLW3uSQysZeRrfGsG2jph2b6RDJxoV5gsSxrcSGNLnHIdpEJDyn4w8NtwBkHBMMUJJBAOqsRUTp0NxVafEYl/xBZj8D4zFQSufIdgYQXpNXkE/MUWFFHqJn9xL1gTWZKZK0WXjt3mBlLX6Xp9XTX2ePPJ4C+W9SmTTHOZhN64mM93O26e1qkkbgrK+CIzPnWajlj42MySmVbBL1+tLw6xNCydMdF")
INSERT INTO Payloads VALUES	("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "Shared Technology", "Photoshop Camera Raw 7 (64 bit)_8.3_AdobeCameraRaw7.0All-x64", "8.3", "patch")
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.98.0"><BuildInfo>
    <Property name="Created">2013-11-05 16:13:27.338000</Property>
    <Property name="TargetName">AdobeCameraRaw7.0All-x64-051113161327</Property>
    <Property name="ProcessorFamily">x64</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{C90013CD-40A9-443A-9A10-85F09F382EC9}</Property>
    <Property name="ProductName">Photoshop Camera Raw 7 (64 bit)</Property>
    <Property name="ProductVersion">8.3</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7 (64 bit)_8.3_AdobeCameraRaw7.0All-x64</ProductName>
      <ProductVersion>8.3</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{7C73E4B2-13F9-457C-AE41-2CD6AF0FF37B}</AdobeCode>
    <AdobeCode>{3644144A-2A49-48DE-AC68-8F9E71A2A424}</AdobeCode>
    <AdobeCode>{C2D52DC7-2B15-403F-9286-7F3DF7FCA5BD}</AdobeCode>
    <AdobeCode>{021C870F-24ED-406D-A544-4B4845D51EB2}</AdobeCode>
    <AdobeCode>{462197D0-44E9-4EF2-8570-392B9711C3AC}</AdobeCode>
    <AdobeCode>{CF9C12B3-4840-477A-ADD4-69849D02B948}</AdobeCode>
    <AdobeCode>{38ADDE59-0982-4F26-831A-AD2BBB1E430F}</AdobeCode>
    <AdobeCode>{F9B3BCB8-4889-47A5-9DC7-AED8DF968BCA}</AdobeCode>
    <AdobeCode>{3256983C-F66C-4164-B150-5DEA5621F240}</AdobeCode>
    <AdobeCode>{55081A97-35A4-4425-A17E-016148885289}</AdobeCode>
    <AdobeCode>{840C4B93-66C7-426D-8138-4D47293EB70E}</AdobeCode>
    <AdobeCode>{98D5B8A6-F955-49AD-A4C1-01E867121D2C}</AdobeCode>
    <AdobeCode>{BC0B51E6-ADD6-4B24-8739-C0E5671DA64F}</AdobeCode>
    <AdobeCode>{B8D9A663-E72E-4068-A71A-CCCE15636D54}</AdobeCode>
    <AdobeCode>{01D36D30-2EBF-462A-9C67-F90293CBA20F}</AdobeCode>
    <AdobeCode>{FE672002-7320-4D76-9C7B-13A8C69ACEA9}</AdobeCode>
    <AdobeCode>{6C5FFD43-E0DF-4E70-825A-737A3074ECB1}</AdobeCode>
    <AdobeCode>{6B23B5D1-DB94-4F63-A56C-A4798C4D4098}</AdobeCode>
    <AdobeCode>{18996042-772A-4699-AF72-A696AFE95477}</AdobeCode>
    <AdobeCode>{DEC5AEE3-BCFF-436F-B772-169AE188B702}</AdobeCode>
    <AdobeCode>{02635819-AB5D-4EAB-BF67-7713A11BA649}</AdobeCode>
    <AdobeCode>{A200E5BB-C1A6-4AD3-85E5-1CE3E751C6EC}</AdobeCode>
    <AdobeCode>{559E9B06-932F-4274-BFB2-D9580591D718}</AdobeCode>
    <AdobeCode>{CB6BEC69-811C-4FD7-94ED-8D3CEEA00E14}</AdobeCode>
    <AdobeCode>{0511A6B0-7758-47BF-A0A4-06D9869265FF}</AdobeCode>
    <AdobeCode>{CF4F0A76-7337-4466-A293-1224EC9DB68F}</AdobeCode>
    <AdobeCode>{94513337-51B4-4799-9E91-FFF6672742A8}</AdobeCode>
    <AdobeCode>{FE8271A9-276C-4316-B04A-2FDF7DEDDB36}</AdobeCode>
    <AdobeCode>{39BA5361-5ACE-4940-A47E-80197C92CD13}</AdobeCode>
    <AdobeCode>{08BB5CD0-D241-46A6-9792-B4FB15C92564}</AdobeCode>
    <AdobeCode>{02F5C0DB-31B8-4871-BE4E-5D212DAA3C6E}</AdobeCode>
    <AdobeCode>{21798322-8EE0-4699-9D0B-0DCCFE3E5893}</AdobeCode>
    <AdobeCode>{F06C2431-D2A6-42D0-AC50-8BB34C8DED2D}</AdobeCode>
    <AdobeCode>{24E31A3B-D553-4022-BBD4-2D06B99AE88F}</AdobeCode>
    <AdobeCode>{7A1DB20C-5662-4879-ADB6-D596FC342893}</AdobeCode>
    <AdobeCode>{36B57DEB-92EB-4961-B35C-386681E268BE}</AdobeCode>
    <AdobeCode>{93391243-07DE-4EC6-B060-00A363AE6502}</AdobeCode>
    <AdobeCode>{5BDD0AEC-DD34-44DB-BDA5-7B5222FEB1B5}</AdobeCode>
    <AdobeCode>{FF65BFB9-B353-468C-B10C-3C46224B6F93}</AdobeCode>
    <AdobeCode>{7AD421E0-3249-4950-A4AC-B7A9075817C1}</AdobeCode>
    <AdobeCode>{8CC5D43C-97D8-4963-BE8C-51317FD341A5}</AdobeCode>
    <AdobeCode>{F86DC2FF-9F9F-4F91-B28A-8C0177E6878C}</AdobeCode>
    <AdobeCode>{57B6401E-C8C9-44AD-9EB6-56185E8EC9CA}</AdobeCode>
    <AdobeCode>{A9333AFB-695C-47A5-ABBC-842333E1850B}</AdobeCode>
    <AdobeCode>{EF1E32F3-7831-4E89-9CAD-BB36EDA46299}</AdobeCode>
    <AdobeCode>{F448F63A-AAD1-4BE8-A93E-5B419076D7FB}</AdobeCode>
    <AdobeCode>{4086E0DC-1499-4340-A5C2-AAC0E188DAE6}</AdobeCode>
    <AdobeCode>{4967F891-7E4A-458D-976D-9729608E3663}</AdobeCode>
    <AdobeCode>{6FA7CBBA-B4DB-4EA1-81E5-F77782295BB5}</AdobeCode>
    <AdobeCode>{18152D73-2348-445B-AA75-CE332455BC20}</AdobeCode>
    <AdobeCode>{3A9D77AD-658D-4E49-A746-2B19B054D654}</AdobeCode>
    <AdobeCode>{0BE207E4-E22D-4984-A1D4-575A45692E91}</AdobeCode>
    <AdobeCode>{BA437598-DA4A-4E7D-9B4C-9E683330C1DD}</AdobeCode>
    <AdobeCode>{B5CA186F-25B5-4247-9728-3EDA871DE801}</AdobeCode>
    <AdobeCode>{812B3223-7507-4A6F-A388-ABFB021A20FF}</AdobeCode>
    <AdobeCode>{7DEAE842-CA5E-4EFF-A762-1414EBEF0300}</AdobeCode>
    <AdobeCode>{F20E94B2-1907-46C9-AAA1-3FB227199ACB}</AdobeCode>
    <AdobeCode>{26B5A327-3EC2-4A1A-B4EB-31F367736861}</AdobeCode>
    <AdobeCode>{DC280538-55CF-4821-A4E7-32623275EF77}</AdobeCode>
    <AdobeCode>{DF6C8B2B-AE4C-42A8-84CC-14D1364CF06A}</AdobeCode>
    <AdobeCode>{5C1A6EB6-C256-4D86-969C-DB77734E0317}</AdobeCode>
    <AdobeCode>{D1982939-76ED-4324-AD01-933178F25861}</AdobeCode>
    <AdobeCode>{88F252FC-008A-4ACA-81A4-A5A2CCF78636}</AdobeCode>
    <AdobeCode>{522B84C7-9231-4881-8931-BE65DE51FC19}</AdobeCode>
    <AdobeCode>{1D105D22-FAA2-4E9A-9DDE-64BBF4653A33}</AdobeCode>
    <AdobeCode>{DFAC9C7C-6B12-4C8F-9A26-C7E988D308E0}</AdobeCode>
    <AdobeCode>{3C6CC1A4-9894-4243-A22F-02E0F81EFC85}</AdobeCode>
    <AdobeCode>{78E1E2E9-4BB0-409E-A696-ABA0ED5D8F53}</AdobeCode>
    <AdobeCode>{44099F03-9BD7-40DD-A6B3-580F7FFC49BC}</AdobeCode>
    <AdobeCode>{873EF784-9E12-4CEF-A81F-57CCDAAB23B5}</AdobeCode>
    <AdobeCode>{7BB7DEF8-AE49-45C8-AB3D-326AA8DA5FE3}</AdobeCode>
    <AdobeCode>{B68FB95B-79FA-46AF-ABDC-BEA515168E2B}</AdobeCode>
    <AdobeCode>{8B3AFB7E-EF48-4708-9E99-3D21F0208AA6}</AdobeCode>
    <AdobeCode>{79DA2DCA-EEB0-4CDE-985F-8A82D7726C50}</AdobeCode>
    <AdobeCode>{BBD281CF-DFE8-464F-B481-5E80AF010356}</AdobeCode>
    <AdobeCode>{1B19DD8C-6DD4-471D-AB4F-164FDD5F8A40}</AdobeCode>
    <AdobeCode>{A2B8F684-F783-47EB-8832-4227361FBCE4}</AdobeCode>
    <AdobeCode>{8A96672E-45D5-490B-9490-72B82581141B}</AdobeCode>
    <AdobeCode>{1C9AA695-815D-46FF-B989-0D58CB1A7271}</AdobeCode>
    <AdobeCode>{F8D9AF60-EBF2-4BDE-9F50-A0213EF76FB6}</AdobeCode>
    <AdobeCode>{77C6D82C-3CC0-48F0-B9A1-E673FA3EBA23}</AdobeCode>
    <AdobeCode>{745919EC-282D-4A21-B3D1-00DAD224CFBB}</AdobeCode>
    <AdobeCode>{14621349-3D13-4625-9B81-34CACD4E2817}</AdobeCode>
    <AdobeCode>{7C345358-C0C3-4F7B-A849-885F587A8022}</AdobeCode>
    <AdobeCode>{BD9C1AAF-84F0-4916-BBC3-0C689E83B0A0}</AdobeCode>
    <AdobeCode>{7C752836-6A1A-4492-B18F-8ED26029933E}</AdobeCode>
    <AdobeCode>{8B2DBB60-0DD2-428B-B991-1BBE28464EBF}</AdobeCode>
    <AdobeCode>{8A547035-DFD1-473E-A793-499872C7C739}</AdobeCode>
    <AdobeCode>{606FF9CA-4996-41FF-B5C0-2681DD5621CB}</AdobeCode>
    <AdobeCode>{799A8884-7966-4B66-A0E9-C71058C4F8A7}</AdobeCode>
    <AdobeCode>{1941F945-A732-400E-B9B1-3B3927B977EC}</AdobeCode>
    <AdobeCode>{93C2629B-E5AA-474F-9748-7CEF5E5FE1AF}</AdobeCode>
    <AdobeCode>{8E6D694E-8469-42FF-8985-DBCFF7FD2AC0}</AdobeCode>
    <AdobeCode>{EEB57F7B-64A8-4B4B-AD07-F5E1E70C2C4D}</AdobeCode>
    <AdobeCode>{8ABE45D6-86CF-44AF-ABFA-04F4A627DF9D}</AdobeCode>
    <AdobeCode>{2953AC3A-3209-4209-AE02-AAC28C730AD1}</AdobeCode>
    <AdobeCode>{B814A85C-3F4A-4909-8096-61B2001A60EE}</AdobeCode>
    <AdobeCode>{0E0AE597-F611-445E-82E1-1079CEDB2DB3}</AdobeCode>
    <AdobeCode>{87CAD807-2C8B-4360-934F-548921744061}</AdobeCode>
    <AdobeCode>{90CE9674-FF30-465C-9500-A46DA453123C}</AdobeCode>
    <AdobeCode>{FF4F0895-A44A-4A87-B1C6-9213F18C9A85}</AdobeCode>
    <AdobeCode>{13B9AD6D-CEF3-418C-ACB1-4A16D8185B36}</AdobeCode>
    <AdobeCode>{A061265A-DD76-43D2-8C29-98F347A0EC0B}</AdobeCode>
    <AdobeCode>{A0144DEE-1757-408D-A1A5-CFCC4EAA9D4D}</AdobeCode>
    <AdobeCode>{2565EEED-D2AA-4127-A6FC-721D2DE32C94}</AdobeCode>
    <AdobeCode>{3073C982-F0F9-4A2A-AABA-4C68A92FE836}</AdobeCode>
    <AdobeCode>{C3665F4E-FF33-4999-9AFF-CBCABE51DA40}</AdobeCode>
    <AdobeCode>{6BF2BF6A-766C-484D-A029-0354E82002F8}</AdobeCode>
    <AdobeCode>{5C94CFBE-A637-44D3-95C2-B0D98DA03764}</AdobeCode>
    <AdobeCode>{E03BF468-116F-455A-A42C-22D9FC731DD8}</AdobeCode>
    <AdobeCode>{6BF52936-B02B-45BD-AEE6-55AC3E834824}</AdobeCode>
    <AdobeCode>{09D5C0D7-1337-42F4-A7DC-F8667A819BF5}</AdobeCode>
    <AdobeCode>{0CB6D87D-C8EF-457E-BD25-FA39451E76A3}</AdobeCode>
    <AdobeCode>{45F3360F-1988-4F1C-ADFF-E952ECD3F8E6}</AdobeCode>
    <AdobeCode>{129892F4-690A-4C92-86EE-DAEF652B0B06}</AdobeCode>
    <AdobeCode>{CA874C30-46AD-437C-8537-D982382BE438}</AdobeCode>
    <AdobeCode>{F956ED9F-3FF3-447C-B894-766E991F41D8}</AdobeCode>
    <AdobeCode>{563566F5-506F-4F1E-9739-5A39175A75D7}</AdobeCode>
    <AdobeCode>{38C7C796-EAE3-427A-8424-CC2FB3B73479}</AdobeCode>
    <AdobeCode>{CDBA16B3-E641-4893-B7B0-09972F85C517}</AdobeCode>
    <AdobeCode>{EACADA73-EADC-49AB-B023-D3E45DEE82C4}</AdobeCode>
    <AdobeCode>{57C9681B-7641-46BF-9097-6EA818DE8557}</AdobeCode>
    <AdobeCode>{81967FDF-60C4-484D-8BD2-837AFE144030}</AdobeCode>
    <AdobeCode>{AD5C3967-8E8D-4F5D-876E-DD9461991C5F}</AdobeCode>
    <AdobeCode>{BC195504-BCAE-4A82-AFD1-29B8F469CAFF}</AdobeCode>
    <AdobeCode>{3B32AAEB-4B93-4403-B2D8-E7FD69751AD3}</AdobeCode>
    <AdobeCode>{BE237186-2509-4955-8686-DC1AB2B53C57}</AdobeCode>
    <AdobeCode>{49545DB3-5DA9-4FEB-9C42-5A123BE7F721}</AdobeCode>
    <AdobeCode>{C3958F18-80CE-44BB-ADF3-AF6CA9FE2EF3}</AdobeCode>
    <AdobeCode>{EB63B2DC-BC76-4862-9AEA-0110C4846641}</AdobeCode>
    <AdobeCode>{EC5DF353-79B2-45CC-BE09-49A13E8B5073}</AdobeCode>
    <AdobeCode>{12ED8871-B7FD-4762-A23B-0B8083F44DB1}</AdobeCode>
    <AdobeCode>{0E5488F5-C3EA-47A8-9216-72D7A84A9D35}</AdobeCode>
    <AdobeCode>{AD64ADE4-4057-4FFB-9292-D05C3BE8638C}</AdobeCode>
    <AdobeCode>{4C6C228D-7747-4AC2-BEFE-4860C43A47C8}</AdobeCode>
    <AdobeCode>{6C4CDCDD-0585-4ADC-A32C-EC71F135D261}</AdobeCode>
    <AdobeCode>{5127D28B-D9F9-4366-839F-BB77FFD9E25D}</AdobeCode>
    <AdobeCode>{722489FD-4CFB-434B-A2C9-4B593088A55E}</AdobeCode>
    <AdobeCode>{2ACCAA6D-4151-4103-907F-B188327C8450}</AdobeCode>
    <AdobeCode>{980D7EB3-59E6-47A9-9B01-01E8650A413F}</AdobeCode>
    <AdobeCode>{43D51211-BA8F-40A2-90B4-00F2DF9BD908}</AdobeCode>
    <AdobeCode>{658D4079-8D05-4623-9C42-36B6D148C953}</AdobeCode>
    <AdobeCode>{7D3F7673-0BC2-49B8-BAF3-7A66B77AFD72}</AdobeCode>
    <AdobeCode>{6F8464F4-4EAF-4F0D-8F38-266E54387E73}</AdobeCode>
    <AdobeCode>{CE9A9CAF-8720-4DBB-B114-C2FEFD9FAEE2}</AdobeCode>
    <AdobeCode>{A5A1D53E-C006-47C3-802B-861879463F74}</AdobeCode>
    <AdobeCode>{0689EF91-D8B0-4671-9102-16987B00BCDC}</AdobeCode>
    <AdobeCode>{E5C24874-F205-4C6D-A20F-D9DC900CCE78}</AdobeCode>
    <AdobeCode>{C6AA9036-1776-4A91-A2BE-E464F5B0A70C}</AdobeCode>
    <AdobeCode>{B3DE5581-B3EC-41FC-B770-0DB6B6A8AF8A}</AdobeCode>
    <AdobeCode>{DE5D3A00-4414-4D90-81DA-24847662756E}</AdobeCode>
    <AdobeCode>{46D2E7B7-85BE-4718-B6DD-9F6171E46177}</AdobeCode>
    <AdobeCode>{AA7D59AF-02E5-4917-8ACE-FD80B12BD775}</AdobeCode>
    <AdobeCode>{D5D69CC5-2D67-4090-AC98-023D29EB99C7}</AdobeCode>
    <AdobeCode>{301B5DB1-097A-4309-9EB3-78727969ED4B}</AdobeCode>
    <AdobeCode>{9AA08D96-8D48-4CED-8336-4FB9051806B5}</AdobeCode>
    <AdobeCode>{30F1C516-CEAC-48E4-BB06-51BDA5E6C9F4}</AdobeCode>
    <AdobeCode>{325392A6-64A9-4A02-8F4A-09DF545CAA47}</AdobeCode>
    <AdobeCode>{3C5C87B7-6926-4093-9FC0-2D3E2357FE92}</AdobeCode>
    <AdobeCode>{677C7F25-ECA2-4AFD-971D-405D14400D00}</AdobeCode>
    <AdobeCode>{C75D294B-9CB6-4840-9DCE-99796BCFB063}</AdobeCode>
    <AdobeCode>{CA3AC1A0-5BE8-496F-8758-AB35F6F9E8F5}</AdobeCode>
    <AdobeCode>{DEA297A8-2482-48A6-9B3D-0C83DBA4CB83}</AdobeCode>
    <AdobeCode>{3B06DF13-04DC-48BA-B8B7-4778F911E22E}</AdobeCode>
    <AdobeCode>{65CB3346-D0BF-444C-AC22-043A4F385D28}</AdobeCode>
    <AdobeCode>{A364774C-B4A3-44D8-9A4B-928069778ACF}</AdobeCode>
    <AdobeCode>{60965C95-D7F3-4BDD-AA9B-2C26487F8341}</AdobeCode>
    <AdobeCode>{B72F0C5F-3648-4FAE-8E05-3447DC29F8ED}</AdobeCode>
    <AdobeCode>{9B48FDD0-3666-40D4-848E-4ED95A029035}</AdobeCode>
    <AdobeCode>{D92EF854-EF22-40CC-A46F-473A8671A685}</AdobeCode>
    <AdobeCode>{EC430F54-2A25-4331-B013-D5E89B050E0A}</AdobeCode>
    <AdobeCode>{9E492485-420E-4CCB-AFD6-7F1DEE3C30D6}</AdobeCode>
    <AdobeCode>{13C92FDA-CE94-4B05-9E5C-DF1F3DAB6B02}</AdobeCode>
    <AdobeCode>{DC303783-9A27-4B85-B3D2-C4828A807969}</AdobeCode>
    <AdobeCode>{87AA94BD-5E18-4782-A363-A77D1341C3A7}</AdobeCode>
    <AdobeCode>{C72D2D38-922E-494D-A539-406AE8809AAB}</AdobeCode>
    <AdobeCode>{B0971D06-9D6C-4D77-B443-CE2E8BBD861F}</AdobeCode>
    <AdobeCode>{D766CD23-635A-4A5F-8A6A-079382610635}</AdobeCode>
    <AdobeCode>{78DB4B24-AE99-4904-A6DD-68101226A4DD}</AdobeCode>
    <AdobeCode>{D53CA9C7-8C1B-469A-972C-4D9FC37E6F70}</AdobeCode>
    <AdobeCode>{A99DF779-FEE9-4B8E-9EB4-A2D79F9E2618}</AdobeCode>
    <AdobeCode>{12CD36A7-E38F-458C-AD22-3751EB953007}</AdobeCode>
    <AdobeCode>{37A9D076-3B55-4BED-AC2F-ED699C280338}</AdobeCode>
    <AdobeCode>{CD805F7B-F9F2-4B74-AFDE-6F5C74AA28B0}</AdobeCode>
    <AdobeCode>{18608BF4-1574-41E8-8E8F-88C92D381214}</AdobeCode>
    <AdobeCode>{8B562CB2-9864-47F4-B7A8-E84811048D82}</AdobeCode>
    <AdobeCode>{8A58D575-8F79-41F4-A096-697E44A0C42C}</AdobeCode>
    <AdobeCode>{91498854-38F2-4872-9717-E544B0D37FBA}</AdobeCode>
    <AdobeCode>{DBDCA09C-E840-4959-83F6-D9E5BFD0CEFD}</AdobeCode>
    <AdobeCode>{5F6B34E9-15A7-42EE-8B2C-38105E4300DB}</AdobeCode>
    <AdobeCode>{92A49ED1-3EF7-4DC0-A47E-093954C6B99A}</AdobeCode>
    <AdobeCode>{BC289ABF-E5D5-448C-83A8-AA1D8FBB78CC}</AdobeCode>
    <AdobeCode>{1341E925-2AE4-4416-9921-A181FF02D71B}</AdobeCode>
    <AdobeCode>{99917A9B-27F5-40BE-AF06-57F771579DA2}</AdobeCode>
    <AdobeCode>{E2D19262-7614-47D9-83E9-F0866724F198}</AdobeCode>
    <AdobeCode>{DA5342B7-BFBC-4DEB-8CA0-77C5CD9814F0}</AdobeCode>
    <AdobeCode>{57555FF0-2AE7-4818-B647-CBBBC39318CF}</AdobeCode>
    <AdobeCode>{784F7589-CD4E-448A-877B-A0FC2CE90A07}</AdobeCode>
    <AdobeCode>{0E02ACF9-A8FB-404B-9F38-F0FFD88A7840}</AdobeCode>
    <AdobeCode>{13FD414A-96CD-4DD1-A54B-9145A00955ED}</AdobeCode>
    <AdobeCode>{F40E1FF7-4817-4018-9051-0625C3FF9C98}</AdobeCode>
    <AdobeCode>{D4F5B610-BD67-4391-8A1E-6B26A315426A}</AdobeCode>
    <AdobeCode>{D6F7BFCE-6CA3-4181-A967-9C7449396274}</AdobeCode>
    <AdobeCode>{C487F5CF-6F1A-48B4-9DDA-4FDCF3F22353}</AdobeCode>
    <AdobeCode>{97AECE99-1692-4A11-BD4E-3DDAC85E385A}</AdobeCode>
    <AdobeCode>{7B09BC6E-7F8C-4C3E-90EC-EF20C2868777}</AdobeCode>
    <AdobeCode>{AD8D7F38-DA99-4618-882E-1473C3042EA6}</AdobeCode>
    <AdobeCode>{F8AB1550-057A-4A86-98AE-052D94D65EA1}</AdobeCode>
    <AdobeCode>{EE9A957C-5F46-4A3C-B672-5B34F61A6B31}</AdobeCode>
    <AdobeCode>{2E5C3A55-9260-4C3E-8AA0-3270B1A0FBC6}</AdobeCode>
    <AdobeCode>{035C7769-6AE3-4B97-9C9E-793B5BA8F053}</AdobeCode>
    <AdobeCode>{F110647C-013B-42E7-9F4B-C5C26ECCBC6D}</AdobeCode>
    <AdobeCode>{38DCF34E-96B0-4908-A844-BBD953E04B4F}</AdobeCode>
    <AdobeCode>{BD294DE9-69D6-4CB8-A825-DDB8E348CAA9}</AdobeCode>
    <AdobeCode>{0932484D-4D5C-4F30-9C58-3082C389FAE1}</AdobeCode>
    <AdobeCode>{D9A62BEC-56D3-44C4-B681-4D51B50F6669}</AdobeCode>
    <AdobeCode>{DD59E450-75DA-4178-8A69-4AC97A527CF3}</AdobeCode>
    <AdobeCode>{1DC86842-7DE4-47FC-8C30-9724E0D1A1F2}</AdobeCode>
    <AdobeCode>{4D03F8A9-1ED0-4CAC-9AE9-C88FA6DA2D85}</AdobeCode>
    <AdobeCode>{3C3114BC-BAA0-488A-A890-DB765A0DF9BD}</AdobeCode>
    <AdobeCode>{7F7AD0FE-D847-492B-B389-78A6BC829AD1}</AdobeCode>
    <AdobeCode>{E7676F57-3FC1-4AE3-87B0-8ED59C9CD980}</AdobeCode>
    <AdobeCode>{CD1C5490-2E27-49E2-8A61-6A14CFE2B5AD}</AdobeCode>
    <AdobeCode>{2725542C-47EF-48EA-83FD-C618648227E7}</AdobeCode>
    <AdobeCode>{B4A1AD6A-A167-4176-957F-FA6ADBC450C8}</AdobeCode>
    <AdobeCode>{302F8901-0B79-41FE-ABE0-F1830A43820C}</AdobeCode>
    <AdobeCode>{F8E7018A-0F7D-4487-8C8A-8D68ED5335C1}</AdobeCode>
    <AdobeCode>{BDB45208-5C65-44B1-ABE7-7FE36423AE11}</AdobeCode>
    <AdobeCode>{418C8AF7-9235-45E4-88AB-3D8B9A94D8B9}</AdobeCode>
    <AdobeCode>{73FF8F87-ACC4-4C2B-A1FA-185E90446422}</AdobeCode>
    <AdobeCode>{946510FC-DB2D-44C9-B87C-63A5841CF23D}</AdobeCode>
    <AdobeCode>{C1452C75-1E6C-4E38-A88F-34CFD4212E8F}</AdobeCode>
    <AdobeCode>{66064256-1771-4F04-9DF8-C3300ABAE679}</AdobeCode>
    <AdobeCode>{17657869-C99B-4AF9-AE9B-8CB1388F0863}</AdobeCode>
    <AdobeCode>{B0EDD120-337F-4199-B11E-72BCDDA9EC12}</AdobeCode>
    <AdobeCode>{240E95CC-E0EF-40B1-A9D8-165E8B2AC390}</AdobeCode>
    <AdobeCode>{A4E88F8D-B1F7-44A9-ACC9-5790B4F71549}</AdobeCode>
    <AdobeCode>{92C6447C-99AF-4AC2-BF22-A3E79F3FAE69}</AdobeCode>
    <AdobeCode>{18D7F9F7-F6BF-4462-92CC-953F25CCE771}</AdobeCode>
    <AdobeCode>{48E73747-2897-420B-8D3C-9E9EFD4D75A0}</AdobeCode>
    <AdobeCode>{8539F7A5-B2F9-4DA5-9E7F-E170B3B7AD38}</AdobeCode>
    <AdobeCode>{01F83F38-1792-453F-9FD7-3B88BF265B4B}</AdobeCode>
    <AdobeCode>{86AEDE71-23D2-4BE0-BF0A-417FBA32C970}</AdobeCode>
    <AdobeCode>{F0471B68-984D-4042-B2DF-F5246040CEE7}</AdobeCode>
    <AdobeCode>{C8DA8DA8-83A8-4825-8152-0A2C09474B6E}</AdobeCode>
    <AdobeCode>{0378AD89-49A7-43E1-81C2-4F7FF6CB6EDA}</AdobeCode>
    <AdobeCode>{02D656E5-CA66-4B27-B92F-115C0297D035}</AdobeCode>
    <AdobeCode>{10755E16-658F-4E47-8314-A0D638F445EE}</AdobeCode>
    <AdobeCode>{DF2FC6BF-8882-46C5-9C1E-C115F6EBA675}</AdobeCode>
    <AdobeCode>{A726D728-6E2C-46A3-87F3-D9B57270ECEC}</AdobeCode>
    <AdobeCode>{166177AE-1A14-40ED-9F35-89365BF4058E}</AdobeCode>
    <AdobeCode>{925D0676-7188-4907-90B8-EA5269F49FC8}</AdobeCode>
    <AdobeCode>{CC1CBB75-B72A-4914-933E-F14498106E47}</AdobeCode>
    <AdobeCode>{952F3761-06B8-4AA3-8D5A-ACEC1CBE59F3}</AdobeCode>
    <AdobeCode>{B699C3E2-FF0F-415D-ADA4-1A0A2C941780}</AdobeCode>
    <AdobeCode>{80349813-E504-40BF-820C-0BE7B7E8D50A}</AdobeCode>
    <AdobeCode>{F560AD54-7142-4CBC-9533-0C4026744EDB}</AdobeCode>
    <AdobeCode>{850008EB-0AD3-4C8C-91AF-2F4607C57D03}</AdobeCode>
    <AdobeCode>{9BC7ACF3-FEF8-4E24-8533-1396E844BD3A}</AdobeCode>
    <AdobeCode>{DBA108FC-FFA3-4E6B-A4C7-E6092A1F5FD3}</AdobeCode>
    <AdobeCode>{9FC962B9-C981-4096-BC1D-8E2054B1CA5F}</AdobeCode>
    <AdobeCode>{C3845B5B-C4A1-4A4E-8A04-438B021DD313}</AdobeCode>
    <AdobeCode>{FCA4F8A5-69C7-438F-8928-343B11B187C5}</AdobeCode>
    <AdobeCode>{72D2C2CD-310B-46F5-AEE1-0D06340BCBC4}</AdobeCode>
    <AdobeCode>{C49101FC-8B92-4038-AABF-093B19E1905A}</AdobeCode>
    <AdobeCode>{B18D4956-7D7F-4CB9-9B7F-AB353A5D179A}</AdobeCode>
    <AdobeCode>{7661A13E-F404-4AE3-B22B-F590ABEF394E}</AdobeCode>
    <AdobeCode>{87EEC421-7AF7-46A8-A130-697DC8A8C403}</AdobeCode>
    <AdobeCode>{85EFADEE-F8A6-4BF5-81A9-DD56BB927044}</AdobeCode>
    <AdobeCode>{5542C286-969C-4FEE-93BC-754D9CD2F800}</AdobeCode>
    <AdobeCode>{BB6088B5-F41B-41D7-9090-4A9CFEA686DC}</AdobeCode>
    <AdobeCode>{9C2E2088-5851-44C0-B95D-7BB0CBC16F53}</AdobeCode>
    <AdobeCode>{4397B32D-7E50-47B3-8B86-1D27827F607A}</AdobeCode>
    <AdobeCode>{27331495-C0AD-4273-BA51-9274758D0370}</AdobeCode>
    <AdobeCode>{B5160508-0E8D-4793-AD2B-C2E4BB3163D3}</AdobeCode>
    <AdobeCode>{3D3AE628-A172-431B-BA9B-A063FAF30424}</AdobeCode>
    <AdobeCode>{F0319758-F59D-4212-BE14-593D2D8EC456}</AdobeCode>
    <AdobeCode>{D582F004-ED4D-4A60-BDCC-DD5C249613F4}</AdobeCode>
    <AdobeCode>{27787CD7-2877-4229-A172-DEEFB4073B66}</AdobeCode>
    <AdobeCode>{B4FFC19A-4D1F-4E4E-82DC-48242D940518}</AdobeCode>
    <AdobeCode>{D2B91D7C-C4B5-49D1-AC5E-1F15D6966747}</AdobeCode>
    <AdobeCode>{AE1C9B93-6633-4254-A674-78B41EE9FA69}</AdobeCode>
    <AdobeCode>{0200464D-18E2-4992-A958-0BD96EEC96C3}</AdobeCode>
    <AdobeCode>{D1CBC066-5EDE-4802-BB80-0F698049CDE2}</AdobeCode>
    <AdobeCode>{A8E96181-4C74-4484-BCF2-7D449FE01451}</AdobeCode>
  </Upgrades><Channel enable="1" id="PhotoshopCameraRaw764bit-7.0">
        <DisplayName>Photoshop Camera Raw 7 (64 bit)</DisplayName>
      </Channel><Update id="8.3.37">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw x64 Updates&lt;/en_US&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw x64 Updates&lt;/en_US&gt;
    &lt;/Description&gt;</Update><Extends type="patch">
    <ParentProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Photoshop Camera Raw 7 (64 bit)</ProductName>
      <AdobeCode>{55F0AFED-606D-476A-A07A-134291002FBA}</AdobeCode>
    </ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="52620528" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>52620528</TotalSize>
      <MaxPathComponent>/Plug-Ins/CS6/File Formats\Camera Raw.8bi</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="52620528"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
    <Win32>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Bb][Rr][Ii][Dd][Gg][Ee].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Nn][Gg] [Cc][Oo][Nn][Vv][Ee][Rr][Tt][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ll][Ii][Gg][Hh][Tt][Rr][Oo][Oo][Mm].[Ee][Xx][Ee]$</Process>
    </Win32>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">8.3</Value>
      <Value lang="be_BY">8.3</Value>
      <Value lang="bg_BG">8.3</Value>
      <Value lang="ca_ES">8.3</Value>
      <Value lang="cs_CZ">8.3</Value>
      <Value lang="da_DK">8.3</Value>
      <Value lang="de_DE">8.3</Value>
      <Value lang="el_GR">8.3</Value>
      <Value lang="en_GB">8.3</Value>
      <Value lang="en_MX">8.3</Value>
      <Value lang="en_US">8.3</Value>
      <Value lang="en_XC">8.3</Value>
      <Value lang="en_XM">8.3</Value>
      <Value lang="es_ES">8.3</Value>
      <Value lang="es_MX">8.3</Value>
      <Value lang="es_QM">8.3</Value>
      <Value lang="et_EE">8.3</Value>
      <Value lang="fi_FI">8.3</Value>
      <Value lang="fr_CA">8.3</Value>
      <Value lang="fr_FR">8.3</Value>
      <Value lang="fr_MX">8.3</Value>
      <Value lang="fr_XM">8.3</Value>
      <Value lang="he_IL">8.3</Value>
      <Value lang="hi_IN">8.3</Value>
      <Value lang="hr_HR">8.3</Value>
      <Value lang="hu_HU">8.3</Value>
      <Value lang="is_IS">8.3</Value>
      <Value lang="it_IT">8.3</Value>
      <Value lang="ja_JP">8.3</Value>
      <Value lang="ko_KR">8.3</Value>
      <Value lang="lt_LT">8.3</Value>
      <Value lang="lv_LV">8.3</Value>
      <Value lang="mk_MK">8.3</Value>
      <Value lang="nb_NO">8.3</Value>
      <Value lang="nl_NL">8.3</Value>
      <Value lang="nn_NO">8.3</Value>
      <Value lang="no_NO">8.3</Value>
      <Value lang="pl_PL">8.3</Value>
      <Value lang="pt_BR">8.3</Value>
      <Value lang="ro_RO">8.3</Value>
      <Value lang="ru_RU">8.3</Value>
      <Value lang="sh_YU">8.3</Value>
      <Value lang="sk_SK">8.3</Value>
      <Value lang="sl_SI">8.3</Value>
      <Value lang="sq_AL">8.3</Value>
      <Value lang="sv_SE">8.3</Value>
      <Value lang="th_TH">8.3</Value>
      <Value lang="tr_TR">8.3</Value>
      <Value lang="uk_UA">8.3</Value>
      <Value lang="vi_VN">8.3</Value>
      <Value lang="zh_CN">8.3</Value>
      <Value lang="zh_TW">8.3</Value>
      <Value lang="en_AE">8.3</Value>
      <Value lang="en_IL">8.3</Value>
      <Value lang="fr_MA">8.3</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="be_BY">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="bg_BG">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ca_ES">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="cs_CZ">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="da_DK">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="de_DE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="el_GR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_GB">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_MX">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_US">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_XC">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_XM">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="es_ES">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="es_MX">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="es_QM">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="et_EE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fi_FI">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_CA">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_FR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_MX">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_XM">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="he_IL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="hi_IN">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="hr_HR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="hu_HU">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="is_IS">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="it_IT">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ja_JP">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ko_KR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="lt_LT">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="lv_LV">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="mk_MK">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="nb_NO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="nl_NL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="nn_NO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="no_NO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="pl_PL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="pt_BR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ro_RO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ru_RU">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sh_YU">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sk_SK">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sl_SI">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sq_AL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sv_SE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="th_TH">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="tr_TR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="uk_UA">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="vi_VN">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="zh_CN">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="zh_TW">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_AE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_IL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_MA">Photoshop Camera Raw 7 (64 bit)</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0", "ChannelID", "PhotoshopCameraRaw764bit-7.0")
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0", "ChannelInfo", '<Channel enable="1" id="PhotoshopCameraRaw764bit-7.0">
        <DisplayName>Photoshop Camera Raw 7 (64 bit)</DisplayName>
      </Channel>')
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0", "UpdateID", "8.3.37")
INSERT INTO PayloadData VALUES("{C90013CD-40A9-443A-9A10-85F09F382EC9}", "0", "UpdateInfo", '<Update id="8.3.37">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw x64 Updates&lt;/en_US&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;Photoshop Camera Raw x64 Updates&lt;/en_US&gt;
    &lt;/Description&gt;</Update>')
