CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B77A17EB-E9F2-49A1-8287-4FDE55E2EB78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{94317D93-1901-4CDF-9E1B-792B721013D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D9EE6982-6366-430D-8986-894D9DF58792}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4AC31786-8C1E-40F7-A21A-E5A023EFB798}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{888E98D1-1C58-494F-8A52-3B6E5C71D4C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{61C115E8-928A-4C72-AE35-4998D3F8BEE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F7EBC8E8-C6FD-4DB4-8227-1C401404BD15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{15DF9952-C9C9-4451-8090-7B151581E3E9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{795815B0-4374-4735-8CE9-C948D3A94EB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{121CCCD0-AFCA-47E8-AF20-DA092638FC46}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{56517DAD-E822-42FC-BB4F-5D13B3E61707}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9A07CE70-3352-446D-93B1-455B07EB9451}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C6666EFB-ED9D-482A-AFDD-364E5CFD07B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5F9A832B-D52F-4817-9052-4D0853FE2E3B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{666FDACA-5555-4E59-B3CD-042D5FE94843}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F6CDBC5D-6CD7-4ADC-B7F2-5A4138EA0D26}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CEE09D95-5FC1-4CA8-948E-0E79BDFC5DBA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2D03036B-9C81-47AF-8FB0-7F863A97B4EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9089A0B4-0D08-43DA-BBDC-0BA61F99D57C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{22933482-8FF0-4FF1-84A2-5274E757C2E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E66C6800-9684-4D86-BED3-5CA1B61CB8CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F656B055-55E8-4D18-AB05-6F9CBAE34875}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{85498C02-79D1-4A85-B64C-CD68B41699B3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F2881A5B-18BC-455A-B711-975402424BC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{BA587A76-F562-42C7-84BA-5D73E696FD29}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{633ECEB5-B3A3-44AE-9B47-A7EF5F09AAA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F19A198D-313F-435B-A2EC-E9B4328059D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9A33ED01-26E3-41FC-A5C6-68C4C53DFD9A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CA078D73-34DA-406A-860C-861028AAD075}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E2286898-049D-43EF-AA30-0A93E3744AC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1161C108-EB7C-473D-A7AD-1F6C9B53FCB7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CC1702FA-1501-41FB-8F28-77CA593A5EDE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{438E3CE2-94E5-4BF3-9C1B-DEE03509207C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B9CB63C4-46FD-4394-95E4-0602E3B4D7F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2E1E7629-54C8-496F-867D-79D2CD453CF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7CE07019-FDA0-4DAE-B572-D0FD87A6CDE5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{726A8BE1-471A-4C8F-A3E7-7C050B2286B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D14F3CF5-27BB-40D7-899C-77E90DDBCE8D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F960C17E-3AB3-44DF-9305-089ACF7FE643}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1D521D65-962D-4E85-A77D-255F635569A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{43CA98F7-61CA-41F8-8ABD-CC8D89E61317}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{12F3F37B-05A1-47EC-B68B-9E2C9144D649}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{098500A4-9BB6-4C1F-91DA-806E28B165B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E8F27EA1-E863-4531-879B-647FA5799122}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1CD5C1DF-60F0-4D32-BAFB-B29F182ADB3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6A54A7C5-F4B4-42E2-AECA-BF243416897F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{3BBF4D93-CFDC-4F57-9F1F-BD6BCF7C159B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D219BF1A-B6D5-4CB1-9079-8B42F8579572}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9FC6805B-9FD9-410A-A620-51D58644999D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{63215CCA-0E19-4D7D-9224-7370AAEA8883}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{592A592D-45CF-4BEE-90AA-E607CB7EDB36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{744FF7A8-88C0-446B-8932-30DBE3685B81}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{373E0076-73DD-41C2-AC75-3310F07B98CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{ED2E09FF-9B91-44BD-94B1-788E97DA8AA5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D80184F6-7509-4B32-9F1F-5FB777362A36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5256AFFE-A42B-4BE8-AF85-DF6F8E83E7ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{204E9832-7F65-4F95-AA61-22B4B1845C2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9CF5EF40-1118-4C1A-A94C-9C624492F268}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{755473AB-43CB-47F8-932A-23537492DC6B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8A90BCC6-FA37-431C-A763-38DFB7D1158E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D50263ED-6BEB-4712-AB41-631733745340}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{0D5B4DCA-A876-4B49-8AA9-355FB4181E92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A7014808-9F3A-4A1F-B672-E562D857D701}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{07DDBCC2-42B6-4959-A327-6C2ACBBFE44D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{00267828-B0B4-426C-912C-CC02D86DD1C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{374DFD96-DEF7-4C0A-8034-2854CE62E40D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8759C7AB-442C-4A44-9811-8C6856F29DD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CDAB5583-CCC8-4504-9755-27DBAC28F1CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E5A9AE44-2FF6-4195-B5F2-DB813832FF65}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5DD4B1AA-F437-41CE-97BB-15466C791317}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{81537B6E-541A-44D4-A4E5-370D3CAFD9A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7413479E-9FFB-412A-9D5A-7C18597926EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D3071618-C10D-49F8-BACD-5F58DA294468}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2172549C-534B-4753-A954-6CA7B28E7AC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5CF514F9-8DED-47F0-85F3-89288AFE61FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{888A30BA-8B5F-4060-A02A-E112001BC128}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{157F5A3C-CFA5-4149-BBD9-C85CE8AFE823}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{37B6FBF2-2002-4E73-BEE8-E03DD424B6FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{623FDAA5-71F4-4651-A3CE-1DB1EABDA72C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E9452461-8C5A-4710-8928-B8128FD29525}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2D126C40-17E8-4AE2-9FB2-937A4267429A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C5B47D44-9865-4339-98AE-83005EC109A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A7B68178-03BF-4763-9670-F8CAC076DAA5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{429D9987-2E21-470F-8A71-18819D335B13}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A2557E25-F902-4414-B4C7-527A2B95FBD2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{842D5C00-6926-4861-8EAF-945022B3BCE8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4D7161FB-14D1-4A32-8C60-158C35B59717}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6F0860C0-326A-4FD2-B1D5-0BF2B51B1C6E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{382BE745-10F7-47B1-8C03-627D05D7FAAF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{3606C91F-7186-4A5A-8839-BAE84BD167BF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D8B7DC49-E007-4703-A320-F0083316DE71}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{372D4D59-EBCD-42AD-943C-D7B1EBC78103}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B2579A74-F4AA-40B1-B47A-E73BA173EC8C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CB7D58F3-0133-410C-A70E-FB35F5A285A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{DF1424DA-8781-40BF-B50D-60631B091E44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D35C0674-485B-4BCD-A5FA-C23ACC8B0C7F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7A01B0EF-1D52-4C9E-ABF2-FBEE721B6221}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F63B253A-47BE-4812-8D08-2EAA4F1FC585}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8B5EC0D2-8C2F-40BF-869A-D890A90FBBC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C1D6C57A-8FB6-492F-8EE7-3B401BF6033A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{63C9F553-F320-4B01-88B3-71C8B813161A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{49DF7DC1-3634-4DE3-9F6E-43CA27831B6E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{56256CC3-7EF8-41E2-8AC6-0A5C5169797B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{EFF8A8AA-C13D-4ED5-B1BB-C24ABA859C4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8B23442F-C61B-441A-8D04-6C1F6740EEB3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{189D9B18-EF64-461F-984D-479910979A87}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B4DA2B42-C00A-4E8F-865C-E06E1FE79BE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{14E3D209-3A36-49D1-B878-912110CB44BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4F1D0643-87A2-4D62-B2A0-1DEBA02C6C7F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{91A31138-61C1-4D69-8E44-DA9CDA06BF92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{140AF1F7-AA59-40D4-9A5F-520FFF2B5557}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{FA254377-B6DC-4D1E-9224-EB46321E8B49}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{609C7D76-932D-4744-ACCD-B5987C87B38E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{77724CF9-79AD-4ADF-9A38-8AE4130433B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9876765E-4974-43D8-966B-F2B21D5F6FD1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{55F75AD6-BA91-499A-B3EA-6B046699AFCB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{18771D27-2175-4E90-884F-36E32CA30F62}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C50978FF-CD1E-463F-98A1-A11286C56BD7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{73BD5554-BF7D-4E60-8765-D6B75EE643AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{DE040AAF-037D-48D0-AA4B-415F75C16252}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CB5484D0-7E26-49FE-8349-D02E0FBA0A3C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4485A0CF-FB6D-4D9A-A8FC-F630028C7C71}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1F770727-7C5C-490A-A1FC-D4CAF8A2383B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{66C47252-46F0-4FD3-94F5-10F346E1E46C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{41A3690C-2A97-46BD-A70D-0DE3283F246A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F6CADD0A-EE32-491E-AE80-219C998D102E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{DDCAA4DD-EDB6-4E60-AB73-E163F7C514AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C30397C1-6C16-494F-AC41-44123328B9DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7987D521-8BE4-4AD8-AFEB-F034CD664D83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5F98A615-6121-45C5-AD17-B059686032A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F7CA7492-916B-4E41-8B1E-DF6058A59B75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CE76A725-39C2-416A-A586-9DCF4CEC2402}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{93732787-2EDA-41CE-A46D-3B9CF4183D5E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C46E0A84-B840-4484-AAF7-950AF73AC15E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{89AA3EF5-2C65-4438-879F-F79F294EF8AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{986799B3-2C76-42A8-8D0C-C77F8D2076CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{39733725-E3A7-4344-9F71-AA30C7CC1249}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D691A2E6-A3D2-4904-8A78-7C362E07F9A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F9858F2D-3831-48CF-BD31-FC04FBCB5B56}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4786CBC9-CBE3-4297-A3C2-F2AED5324E5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C67B1F3A-C915-4DD8-9664-824DF02648D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{81E1E621-EF23-4E56-9E21-395A414BBA70}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6933B26C-D139-41FA-A18E-220D835F4494}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{0BC30414-1218-49AC-A6DA-C35E9C2942C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{41220F1D-CB3A-4E89-8C42-FB444A7E0841}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C90500BE-927E-451E-A0FB-01AB97EDC950}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7E3B4C3D-96D2-461D-9152-38218C5E4C08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8BB45702-3179-4884-A121-50A277C6A486}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{648ECA61-E6A0-4344-806D-1609597E9A6F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8BF20651-99FD-4ADA-A9FC-4E24B81F562E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{AA199B26-06C6-461D-B579-A13686F0EB34}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8D6E2887-C2AA-4D99-AD6D-703F51226889}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{61B43996-A27F-49C2-8FC8-7BADF2474608}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{974E3D65-F097-443E-8D1B-1017C045C818}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{91D08A37-35DC-477D-B1CC-3410E02AA605}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{66D54E39-0969-4399-AB14-5AAAEAA7E516}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{06324700-372E-4AE8-98C3-CAE82D6612B3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{55CCEC57-0042-4E6B-BEDB-EB812C113CF0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{45854BA0-92DB-4A51-ACEE-1C97B05D4395}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C6AD3545-9C17-4B4D-821C-9E4C4B467B86}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{44F87F40-5C66-4A3F-A6BA-D0ADF482B292}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F00AFC47-74DC-4253-9B83-FEB387A8E8D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4D5DE2E6-40B6-4B5D-9B76-170510644E33}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B039D002-CEFA-488B-8494-05B537677E78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{97E14254-D1B7-4E72-99B0-D5600D7B1D7B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6DCE9360-CF5A-4371-B4FA-338F9AD0B435}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1B298277-D778-4A1E-8AC6-75F3908BEB77}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4BA6A968-1577-44B4-9233-F5F6706B3B1E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{82D63D9A-F986-4500-9C32-4321AED56534}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7B728334-57A5-4BCD-B5C7-F024F0224526}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{473A6E9D-C1A8-4663-8EDB-28FFE8C2952B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2ABD2493-AD4F-4C63-9397-E69581599C75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C3E298A3-8209-4F7C-B873-F0D66967B129}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2118B9CF-BE2D-4297-91B7-051B404A3AA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E960A73D-991B-4D6F-95DE-C6BFC73E7C89}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{38CE8E2B-ABDF-487F-A606-31D5E75AF8C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{DB4ACF15-A387-4C66-8361-888145692B5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B8B901D0-3F71-4236-97F3-4D152CFF8841}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{20DEE7EE-6ABC-484E-9767-6D318D17F8AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A1195FCD-AA56-4C4A-B880-042F752A6A92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{ACFCA756-7ABD-448D-ADCD-D4F54284017C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2C6C5AB6-1F05-4538-A8C0-8E58068467A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7C4045BF-DA9A-490C-8E08-823823F3D301}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6DBC337F-A503-4B5E-8C2F-59781239B283}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{10392BA5-7147-487E-BE69-4DC8E6F8496E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7AE7FA1E-A099-4A79-AE82-BB772EC76BBD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A2CF5675-54A9-4783-B213-9763A76C447B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{EFDB5880-3E63-45B0-9D9E-754D4B140F0F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1DA7859F-3163-4032-9AB9-AD3857E0ED17}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4A9A4FD8-C8F3-48C3-9185-D2D060DBD1F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6BB86B3E-A1CB-4C3B-A1A4-5BC1052FFCAA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{70A2EC90-0EC5-4884-9A9C-F30E11CE9D83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5B210450-FCF4-48E9-90AD-809B57BA5BAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CCBD2F9B-EBE0-4CD2-829D-4A896F72C4B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{181B6BB9-7492-42E7-96DA-67C60B57C65D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{78DC252D-B56C-41C8-85BE-A6506A227FA0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2E1202BB-6D05-4247-96D1-B26A89B455A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{37A86D9D-BE97-408D-BBFA-BC75343ABE19}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7260C48F-B993-437B-A5F8-8172C0C11DA8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{71B0CBB0-8B71-4D9D-B56D-8177D2579836}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{48C54851-6BA4-4E36-AC3F-72C93AD0D266}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F420C498-3360-4AB4-A35F-3E2A502739D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{50CF81EE-A67D-4343-BF0B-2DAA0FF01B44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{AE1AFB74-1787-4E14-BBD0-EAF6A0EDCBE5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{22DB3F23-6A18-47E8-B5F6-D955987F4047}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{78FC6B9F-8326-4334-989B-514BCEA9CE72}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{68842ABA-EDB4-42DC-A325-B17326578DFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D6D0A118-EC2D-4A3F-9BC0-8C1F8CF2AAFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{0720966A-31B1-408B-9F80-0D0DE3A25FC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5A9B7D04-932D-48F4-AE71-0AF9E7080174}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{ECD41B52-F4BB-4E1C-9527-8AE0789745A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C53996CE-24A1-4D58-AEA6-F306C0C22921}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A385DFE2-4AEE-4CDC-9EBD-28B64A9C016A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E5A8116F-E653-4486-8E77-2E8966ECB5CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{21F0EF5F-9B1B-4FC2-95B2-EF11B05C1FDD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9469833D-15F5-4898-B1DF-2DCAFFB9633A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{302BEF67-F75B-4390-9044-A633F5F68CA8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4CEDA4E4-848E-4616-9345-6A5664FB31F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7336C140-2276-41A8-B4DB-C8A67F095E59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5BAA3325-9940-4C37-9956-D750E1BFE8E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C91D9285-099C-489D-8D30-3FB3B036E56D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2551CD4D-300F-459A-A293-D747D94C0BAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D6A9A497-5EE3-4611-88ED-4F27BA2260D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{0686CD0D-6FC6-4FCE-9214-3EE3F7E90A95}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9E5B77E9-ACE1-4C25-A4C1-52AD98D10AF0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F3E31E83-729B-45BE-AA1D-57C794787559}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B13A93E8-8C40-4587-8A26-649B019CA04C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B7F460E3-E85C-4E0C-89F1-A118171B3C72}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F4E8B093-D670-43F1-82E7-08020ACB5452}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5DFFB5CB-400A-44E4-8ABC-75FE34F4C40E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{FF20736F-3D8A-4B1B-9396-18EA1D4B7F7D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6465E605-31F5-4A43-AD3F-9CE45A066726}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{00D64CAF-5F22-47CA-BD5C-46B82401AAE0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9E389018-DD3D-4C93-A592-722938020937}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{499C3231-B2F0-4981-9E0B-8C0C8E7DBAE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F0F978BB-D11B-4071-A0CF-E0B0E627B715}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{91377C46-844B-4BC0-AC85-6AC70930E27A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8A4BAF1A-3C16-45C2-997D-5198902A9B7B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9C6B8D69-DB88-48C9-AAF0-20BE54DCD038}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A17AF0B8-E85E-43EF-B7DB-77C2CBDF3B24}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{00778BC3-D219-4C3C-9A8C-71875F2AAD34}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{76A6633B-BC56-4509-973E-CDDC0D578C6B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6B50F21F-3BC4-469B-8661-8A4D6CA255FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{62828891-75FD-48CF-B1B2-F4C497EFE866}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D861BCD3-F473-48E2-B913-A002075E8270}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7194D954-0729-4A66-B40D-004996D8594F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B86DF039-33FE-4A55-B4C1-84303DDC93BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7925EF6B-E9CC-474E-B830-D1173283C3E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{908852C2-176B-4BDB-AEF2-50B01C4E2246}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9191FD67-ABD9-4793-9AD4-EFDEE205E3EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{29083AB0-25AE-4FE1-BCAB-12E67A21C460}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{EB096204-2579-404B-BC58-E69A53C17254}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F720004E-8980-4010-82F2-440BE6228817}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{EA4D74E4-A472-4012-853D-3BE600B08FCC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{57D0E4F7-ABFA-4FE4-A2E9-99DF92E41DD2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{58A4FC46-5087-46D9-A972-3C0BD6DA7394}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E49FEE87-C5CB-4BE3-B72E-30360F0F200C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{50567AD4-FC2E-4C56-B567-8E354D1BA7C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2F5D7EA1-F574-4A44-A1E6-C64622A40672}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{EA134E4A-0F01-4943-A694-634EC350F42C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{AA1FCC28-D7B5-4B2E-BCE3-64C393EB5335}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{576EF85B-6D47-4A6C-BD2F-290566868D0B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1F7BF9C6-78D7-4EF4-95EF-52B871C5A070}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D33FF3FB-3592-4D48-8158-338F15708B27}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{604CD92D-4084-49F7-8A6D-2ABB844CDDAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{4674A72C-3486-46C6-8AFB-210755AF0CDF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2745E404-64AF-46B8-8434-597F9D6EB573}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{13B0B055-541B-456E-B4A1-F12DD705C2D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9D403881-E9D2-4CE5-8CA4-8BCB49765023}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{890B91B5-7F1B-4DAB-93B8-93E23350CBAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{FDABFFC2-39EB-403E-98D4-9F675D36A815}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{45E8CBBC-38DE-43C3-B53B-2DAC18BC3DCF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6A24CCF6-EFD9-4904-AC5C-5E96C42A8C82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{B944A667-E1BF-443A-92B5-EA1389B4B30E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{D12D7E1F-8CF0-4EB4-8F1A-0B9E7F7F41A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{581CB783-419F-45AA-B8FC-98626ABFEA5B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A23C10F7-9D57-4566-8BE4-7EC5A92885AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{59D660C9-9303-43C3-A3F4-068FA95DA3C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{029B59F7-E7A7-4396-B249-3BB99456EFF2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C4F53121-161B-4D33-9A84-027E6DCDF182}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5FCB9EE5-9D16-44AA-AECF-46D9859D6FAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5F229A8F-2712-484E-9DF2-33122D36FA7E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{7BA4FC44-A3B7-4DB2-A485-E0F6EBEEB43D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{2DEC353E-219F-4900-9D7B-7847C675980E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{971ED46A-EC8D-4E2F-AFEC-BD6522BB43E9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{144A46CB-D3F4-4CE8-A51F-46A5280648D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{440331D6-71CE-43F5-83D9-FFB434371D76}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{8E488E89-AB2E-4C3F-9C75-4CABF4AB4925}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{9568B2C3-2286-43B9-A304-C66C91632680}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5FF240EA-27F4-4976-AB55-79216A416144}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{F80B89B1-C4B6-42F2-818D-3F6B0C80C3EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{BB453EC8-982F-48F8-84F4-D8C864805F18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CEBD7ACF-0228-496A-9150-A1283E65920C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1B380C6A-E78F-46DF-80B4-5760B7EF50B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E6DEF8EF-5AA6-4084-B2B5-D61F7ABB7BFA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{BC060AAC-74FF-4439-B996-02A65C4170D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{FC87EBE8-0A88-4F01-88A2-CD97D908D70F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{24166DFF-9154-4248-80B0-F144BA0D2031}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{5D7DA15E-8AAD-4BB4-90D5-03EA4129C0D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{106AC1FF-7262-4291-8406-DE72C56402A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{CB1433E7-E794-4987-BCD6-F37225C7449D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{70C0D4C4-645A-4B35-8B30-D87B6EAB8A3B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{E98D2C25-B372-49AE-BF9E-D3D1FFE016C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{FA826697-B224-4B68-8ABA-296ADD12DCC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{3D87F9A9-693B-4346-8459-7E3E03B916A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{1AD13E62-781E-44A2-96DA-8F153585A708}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{6CD26A90-01B0-4786-8196-AFDF73850F92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{C4CD98A8-0AD8-4585-9E85-423B82CE9CD7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{A536D67E-250C-49FD-A175-789F5B2918D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{33941BCB-499D-4D07-A43B-39F09DD858AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "patch", "Shared Technology", "Camera Profiles Installer", "")
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}"/>')
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0" , "ValidationSig", "IN8ltCl0J3cJsug+eN6+la/65V7e8SGcJ5mC/8Kf/yZL01qjf61Jcrlk6pEW/dEv2yJtbEC1eNO17WMbEx42UarYp5vhFN3hLFA/p4CDvZOfXwXtzParFK6ugDMi5SxInuHn9t1t5lqbZz14h6tbZQUdY8fXyeM5jxpeZKy5cXcbAMNnYKtbINsLa0yda3AnqsI3Sn+PmloBSaIh/Tp60BWlw6PVN16kMSjvQOFDg994lnaavnqCpdlCu+Z+/eAlJO6Jg10XRjWegLivEGghRJ84+K2DdL2GyK0Z8fGk1dSLuuut5bh6F3n+yJwbWTfSZPkZ5Y6xH1IbI6WifjylGxnUx+CXLs3R8YTMhWWYhHsFXnuuHqKetS391gIWREec1vj1NC9zQDrbwgO1i+9rCpwkXjKhSjrkBOG/JjVh/vTC1ORK1vd6ToJv+G7oSe1jEThcq8JYVp/XfMExo/qScPlPdB9+tuVVknRC43sqN8pdLca5YSq3mrZpkIztgtnm")
INSERT INTO Payloads VALUES	("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "Shared Technology", "Camera Profiles Installer_8.3_AdobeCameraRawProfile7.0All", "8.3", "patch")
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.98.0"><BuildInfo>
    <Property name="Created">2013-11-05 16:01:56.998000</Property>
    <Property name="TargetName">AdobeCameraRawProfile7.0All-051113160156</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}</Property>
    <Property name="ProductName">Camera Profiles Installer</Property>
    <Property name="ProductVersion">8.3</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[SharedApplicationData]/Adobe/CameraRaw</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Camera Profiles Installer_8.3_AdobeCameraRawProfile7.0All</ProductName>
      <ProductVersion>8.3</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{B77A17EB-E9F2-49A1-8287-4FDE55E2EB78}</AdobeCode>
    <AdobeCode>{94317D93-1901-4CDF-9E1B-792B721013D6}</AdobeCode>
    <AdobeCode>{D9EE6982-6366-430D-8986-894D9DF58792}</AdobeCode>
    <AdobeCode>{4AC31786-8C1E-40F7-A21A-E5A023EFB798}</AdobeCode>
    <AdobeCode>{888E98D1-1C58-494F-8A52-3B6E5C71D4C8}</AdobeCode>
    <AdobeCode>{61C115E8-928A-4C72-AE35-4998D3F8BEE4}</AdobeCode>
    <AdobeCode>{F7EBC8E8-C6FD-4DB4-8227-1C401404BD15}</AdobeCode>
    <AdobeCode>{15DF9952-C9C9-4451-8090-7B151581E3E9}</AdobeCode>
    <AdobeCode>{795815B0-4374-4735-8CE9-C948D3A94EB1}</AdobeCode>
    <AdobeCode>{121CCCD0-AFCA-47E8-AF20-DA092638FC46}</AdobeCode>
    <AdobeCode>{56517DAD-E822-42FC-BB4F-5D13B3E61707}</AdobeCode>
    <AdobeCode>{9A07CE70-3352-446D-93B1-455B07EB9451}</AdobeCode>
    <AdobeCode>{C6666EFB-ED9D-482A-AFDD-364E5CFD07B1}</AdobeCode>
    <AdobeCode>{5F9A832B-D52F-4817-9052-4D0853FE2E3B}</AdobeCode>
    <AdobeCode>{666FDACA-5555-4E59-B3CD-042D5FE94843}</AdobeCode>
    <AdobeCode>{F6CDBC5D-6CD7-4ADC-B7F2-5A4138EA0D26}</AdobeCode>
    <AdobeCode>{CEE09D95-5FC1-4CA8-948E-0E79BDFC5DBA}</AdobeCode>
    <AdobeCode>{2D03036B-9C81-47AF-8FB0-7F863A97B4EA}</AdobeCode>
    <AdobeCode>{9089A0B4-0D08-43DA-BBDC-0BA61F99D57C}</AdobeCode>
    <AdobeCode>{22933482-8FF0-4FF1-84A2-5274E757C2E0}</AdobeCode>
    <AdobeCode>{E66C6800-9684-4D86-BED3-5CA1B61CB8CD}</AdobeCode>
    <AdobeCode>{F656B055-55E8-4D18-AB05-6F9CBAE34875}</AdobeCode>
    <AdobeCode>{85498C02-79D1-4A85-B64C-CD68B41699B3}</AdobeCode>
    <AdobeCode>{F2881A5B-18BC-455A-B711-975402424BC1}</AdobeCode>
    <AdobeCode>{BA587A76-F562-42C7-84BA-5D73E696FD29}</AdobeCode>
    <AdobeCode>{633ECEB5-B3A3-44AE-9B47-A7EF5F09AAA2}</AdobeCode>
    <AdobeCode>{F19A198D-313F-435B-A2EC-E9B4328059D7}</AdobeCode>
    <AdobeCode>{9A33ED01-26E3-41FC-A5C6-68C4C53DFD9A}</AdobeCode>
    <AdobeCode>{CA078D73-34DA-406A-860C-861028AAD075}</AdobeCode>
    <AdobeCode>{E2286898-049D-43EF-AA30-0A93E3744AC3}</AdobeCode>
    <AdobeCode>{1161C108-EB7C-473D-A7AD-1F6C9B53FCB7}</AdobeCode>
    <AdobeCode>{CC1702FA-1501-41FB-8F28-77CA593A5EDE}</AdobeCode>
    <AdobeCode>{438E3CE2-94E5-4BF3-9C1B-DEE03509207C}</AdobeCode>
    <AdobeCode>{B9CB63C4-46FD-4394-95E4-0602E3B4D7F6}</AdobeCode>
    <AdobeCode>{2E1E7629-54C8-496F-867D-79D2CD453CF7}</AdobeCode>
    <AdobeCode>{7CE07019-FDA0-4DAE-B572-D0FD87A6CDE5}</AdobeCode>
    <AdobeCode>{726A8BE1-471A-4C8F-A3E7-7C050B2286B2}</AdobeCode>
    <AdobeCode>{D14F3CF5-27BB-40D7-899C-77E90DDBCE8D}</AdobeCode>
    <AdobeCode>{F960C17E-3AB3-44DF-9305-089ACF7FE643}</AdobeCode>
    <AdobeCode>{1D521D65-962D-4E85-A77D-255F635569A7}</AdobeCode>
    <AdobeCode>{43CA98F7-61CA-41F8-8ABD-CC8D89E61317}</AdobeCode>
    <AdobeCode>{12F3F37B-05A1-47EC-B68B-9E2C9144D649}</AdobeCode>
    <AdobeCode>{098500A4-9BB6-4C1F-91DA-806E28B165B4}</AdobeCode>
    <AdobeCode>{E8F27EA1-E863-4531-879B-647FA5799122}</AdobeCode>
    <AdobeCode>{1CD5C1DF-60F0-4D32-BAFB-B29F182ADB3E}</AdobeCode>
    <AdobeCode>{6A54A7C5-F4B4-42E2-AECA-BF243416897F}</AdobeCode>
    <AdobeCode>{3BBF4D93-CFDC-4F57-9F1F-BD6BCF7C159B}</AdobeCode>
    <AdobeCode>{D219BF1A-B6D5-4CB1-9079-8B42F8579572}</AdobeCode>
    <AdobeCode>{9FC6805B-9FD9-410A-A620-51D58644999D}</AdobeCode>
    <AdobeCode>{63215CCA-0E19-4D7D-9224-7370AAEA8883}</AdobeCode>
    <AdobeCode>{592A592D-45CF-4BEE-90AA-E607CB7EDB36}</AdobeCode>
    <AdobeCode>{744FF7A8-88C0-446B-8932-30DBE3685B81}</AdobeCode>
    <AdobeCode>{373E0076-73DD-41C2-AC75-3310F07B98CB}</AdobeCode>
    <AdobeCode>{ED2E09FF-9B91-44BD-94B1-788E97DA8AA5}</AdobeCode>
    <AdobeCode>{D80184F6-7509-4B32-9F1F-5FB777362A36}</AdobeCode>
    <AdobeCode>{5256AFFE-A42B-4BE8-AF85-DF6F8E83E7ED}</AdobeCode>
    <AdobeCode>{204E9832-7F65-4F95-AA61-22B4B1845C2A}</AdobeCode>
    <AdobeCode>{9CF5EF40-1118-4C1A-A94C-9C624492F268}</AdobeCode>
    <AdobeCode>{755473AB-43CB-47F8-932A-23537492DC6B}</AdobeCode>
    <AdobeCode>{8A90BCC6-FA37-431C-A763-38DFB7D1158E}</AdobeCode>
    <AdobeCode>{D50263ED-6BEB-4712-AB41-631733745340}</AdobeCode>
    <AdobeCode>{0D5B4DCA-A876-4B49-8AA9-355FB4181E92}</AdobeCode>
    <AdobeCode>{A7014808-9F3A-4A1F-B672-E562D857D701}</AdobeCode>
    <AdobeCode>{07DDBCC2-42B6-4959-A327-6C2ACBBFE44D}</AdobeCode>
    <AdobeCode>{00267828-B0B4-426C-912C-CC02D86DD1C6}</AdobeCode>
    <AdobeCode>{374DFD96-DEF7-4C0A-8034-2854CE62E40D}</AdobeCode>
    <AdobeCode>{8759C7AB-442C-4A44-9811-8C6856F29DD4}</AdobeCode>
    <AdobeCode>{CDAB5583-CCC8-4504-9755-27DBAC28F1CF}</AdobeCode>
    <AdobeCode>{E5A9AE44-2FF6-4195-B5F2-DB813832FF65}</AdobeCode>
    <AdobeCode>{5DD4B1AA-F437-41CE-97BB-15466C791317}</AdobeCode>
    <AdobeCode>{81537B6E-541A-44D4-A4E5-370D3CAFD9A1}</AdobeCode>
    <AdobeCode>{7413479E-9FFB-412A-9D5A-7C18597926EF}</AdobeCode>
    <AdobeCode>{D3071618-C10D-49F8-BACD-5F58DA294468}</AdobeCode>
    <AdobeCode>{2172549C-534B-4753-A954-6CA7B28E7AC0}</AdobeCode>
    <AdobeCode>{5CF514F9-8DED-47F0-85F3-89288AFE61FB}</AdobeCode>
    <AdobeCode>{888A30BA-8B5F-4060-A02A-E112001BC128}</AdobeCode>
    <AdobeCode>{157F5A3C-CFA5-4149-BBD9-C85CE8AFE823}</AdobeCode>
    <AdobeCode>{37B6FBF2-2002-4E73-BEE8-E03DD424B6FB}</AdobeCode>
    <AdobeCode>{623FDAA5-71F4-4651-A3CE-1DB1EABDA72C}</AdobeCode>
    <AdobeCode>{E9452461-8C5A-4710-8928-B8128FD29525}</AdobeCode>
    <AdobeCode>{2D126C40-17E8-4AE2-9FB2-937A4267429A}</AdobeCode>
    <AdobeCode>{C5B47D44-9865-4339-98AE-83005EC109A4}</AdobeCode>
    <AdobeCode>{A7B68178-03BF-4763-9670-F8CAC076DAA5}</AdobeCode>
    <AdobeCode>{429D9987-2E21-470F-8A71-18819D335B13}</AdobeCode>
    <AdobeCode>{A2557E25-F902-4414-B4C7-527A2B95FBD2}</AdobeCode>
    <AdobeCode>{842D5C00-6926-4861-8EAF-945022B3BCE8}</AdobeCode>
    <AdobeCode>{4D7161FB-14D1-4A32-8C60-158C35B59717}</AdobeCode>
    <AdobeCode>{6F0860C0-326A-4FD2-B1D5-0BF2B51B1C6E}</AdobeCode>
    <AdobeCode>{382BE745-10F7-47B1-8C03-627D05D7FAAF}</AdobeCode>
    <AdobeCode>{3606C91F-7186-4A5A-8839-BAE84BD167BF}</AdobeCode>
    <AdobeCode>{D8B7DC49-E007-4703-A320-F0083316DE71}</AdobeCode>
    <AdobeCode>{372D4D59-EBCD-42AD-943C-D7B1EBC78103}</AdobeCode>
    <AdobeCode>{B2579A74-F4AA-40B1-B47A-E73BA173EC8C}</AdobeCode>
    <AdobeCode>{CB7D58F3-0133-410C-A70E-FB35F5A285A6}</AdobeCode>
    <AdobeCode>{DF1424DA-8781-40BF-B50D-60631B091E44}</AdobeCode>
    <AdobeCode>{D35C0674-485B-4BCD-A5FA-C23ACC8B0C7F}</AdobeCode>
    <AdobeCode>{7A01B0EF-1D52-4C9E-ABF2-FBEE721B6221}</AdobeCode>
    <AdobeCode>{F63B253A-47BE-4812-8D08-2EAA4F1FC585}</AdobeCode>
    <AdobeCode>{8B5EC0D2-8C2F-40BF-869A-D890A90FBBC6}</AdobeCode>
    <AdobeCode>{C1D6C57A-8FB6-492F-8EE7-3B401BF6033A}</AdobeCode>
    <AdobeCode>{63C9F553-F320-4B01-88B3-71C8B813161A}</AdobeCode>
    <AdobeCode>{49DF7DC1-3634-4DE3-9F6E-43CA27831B6E}</AdobeCode>
    <AdobeCode>{56256CC3-7EF8-41E2-8AC6-0A5C5169797B}</AdobeCode>
    <AdobeCode>{EFF8A8AA-C13D-4ED5-B1BB-C24ABA859C4B}</AdobeCode>
    <AdobeCode>{8B23442F-C61B-441A-8D04-6C1F6740EEB3}</AdobeCode>
    <AdobeCode>{189D9B18-EF64-461F-984D-479910979A87}</AdobeCode>
    <AdobeCode>{B4DA2B42-C00A-4E8F-865C-E06E1FE79BE4}</AdobeCode>
    <AdobeCode>{14E3D209-3A36-49D1-B878-912110CB44BD}</AdobeCode>
    <AdobeCode>{4F1D0643-87A2-4D62-B2A0-1DEBA02C6C7F}</AdobeCode>
    <AdobeCode>{91A31138-61C1-4D69-8E44-DA9CDA06BF92}</AdobeCode>
    <AdobeCode>{140AF1F7-AA59-40D4-9A5F-520FFF2B5557}</AdobeCode>
    <AdobeCode>{FA254377-B6DC-4D1E-9224-EB46321E8B49}</AdobeCode>
    <AdobeCode>{609C7D76-932D-4744-ACCD-B5987C87B38E}</AdobeCode>
    <AdobeCode>{77724CF9-79AD-4ADF-9A38-8AE4130433B2}</AdobeCode>
    <AdobeCode>{9876765E-4974-43D8-966B-F2B21D5F6FD1}</AdobeCode>
    <AdobeCode>{55F75AD6-BA91-499A-B3EA-6B046699AFCB}</AdobeCode>
    <AdobeCode>{18771D27-2175-4E90-884F-36E32CA30F62}</AdobeCode>
    <AdobeCode>{C50978FF-CD1E-463F-98A1-A11286C56BD7}</AdobeCode>
    <AdobeCode>{73BD5554-BF7D-4E60-8765-D6B75EE643AD}</AdobeCode>
    <AdobeCode>{DE040AAF-037D-48D0-AA4B-415F75C16252}</AdobeCode>
    <AdobeCode>{CB5484D0-7E26-49FE-8349-D02E0FBA0A3C}</AdobeCode>
    <AdobeCode>{4485A0CF-FB6D-4D9A-A8FC-F630028C7C71}</AdobeCode>
    <AdobeCode>{1F770727-7C5C-490A-A1FC-D4CAF8A2383B}</AdobeCode>
    <AdobeCode>{66C47252-46F0-4FD3-94F5-10F346E1E46C}</AdobeCode>
    <AdobeCode>{41A3690C-2A97-46BD-A70D-0DE3283F246A}</AdobeCode>
    <AdobeCode>{F6CADD0A-EE32-491E-AE80-219C998D102E}</AdobeCode>
    <AdobeCode>{DDCAA4DD-EDB6-4E60-AB73-E163F7C514AA}</AdobeCode>
    <AdobeCode>{C30397C1-6C16-494F-AC41-44123328B9DE}</AdobeCode>
    <AdobeCode>{7987D521-8BE4-4AD8-AFEB-F034CD664D83}</AdobeCode>
    <AdobeCode>{5F98A615-6121-45C5-AD17-B059686032A4}</AdobeCode>
    <AdobeCode>{F7CA7492-916B-4E41-8B1E-DF6058A59B75}</AdobeCode>
    <AdobeCode>{CE76A725-39C2-416A-A586-9DCF4CEC2402}</AdobeCode>
    <AdobeCode>{93732787-2EDA-41CE-A46D-3B9CF4183D5E}</AdobeCode>
    <AdobeCode>{C46E0A84-B840-4484-AAF7-950AF73AC15E}</AdobeCode>
    <AdobeCode>{89AA3EF5-2C65-4438-879F-F79F294EF8AA}</AdobeCode>
    <AdobeCode>{986799B3-2C76-42A8-8D0C-C77F8D2076CC}</AdobeCode>
    <AdobeCode>{39733725-E3A7-4344-9F71-AA30C7CC1249}</AdobeCode>
    <AdobeCode>{D691A2E6-A3D2-4904-8A78-7C362E07F9A0}</AdobeCode>
    <AdobeCode>{F9858F2D-3831-48CF-BD31-FC04FBCB5B56}</AdobeCode>
    <AdobeCode>{4786CBC9-CBE3-4297-A3C2-F2AED5324E5C}</AdobeCode>
    <AdobeCode>{C67B1F3A-C915-4DD8-9664-824DF02648D7}</AdobeCode>
    <AdobeCode>{81E1E621-EF23-4E56-9E21-395A414BBA70}</AdobeCode>
    <AdobeCode>{6933B26C-D139-41FA-A18E-220D835F4494}</AdobeCode>
    <AdobeCode>{0BC30414-1218-49AC-A6DA-C35E9C2942C3}</AdobeCode>
    <AdobeCode>{41220F1D-CB3A-4E89-8C42-FB444A7E0841}</AdobeCode>
    <AdobeCode>{C90500BE-927E-451E-A0FB-01AB97EDC950}</AdobeCode>
    <AdobeCode>{7E3B4C3D-96D2-461D-9152-38218C5E4C08}</AdobeCode>
    <AdobeCode>{8BB45702-3179-4884-A121-50A277C6A486}</AdobeCode>
    <AdobeCode>{648ECA61-E6A0-4344-806D-1609597E9A6F}</AdobeCode>
    <AdobeCode>{8BF20651-99FD-4ADA-A9FC-4E24B81F562E}</AdobeCode>
    <AdobeCode>{AA199B26-06C6-461D-B579-A13686F0EB34}</AdobeCode>
    <AdobeCode>{8D6E2887-C2AA-4D99-AD6D-703F51226889}</AdobeCode>
    <AdobeCode>{61B43996-A27F-49C2-8FC8-7BADF2474608}</AdobeCode>
    <AdobeCode>{974E3D65-F097-443E-8D1B-1017C045C818}</AdobeCode>
    <AdobeCode>{91D08A37-35DC-477D-B1CC-3410E02AA605}</AdobeCode>
    <AdobeCode>{66D54E39-0969-4399-AB14-5AAAEAA7E516}</AdobeCode>
    <AdobeCode>{06324700-372E-4AE8-98C3-CAE82D6612B3}</AdobeCode>
    <AdobeCode>{55CCEC57-0042-4E6B-BEDB-EB812C113CF0}</AdobeCode>
    <AdobeCode>{45854BA0-92DB-4A51-ACEE-1C97B05D4395}</AdobeCode>
    <AdobeCode>{C6AD3545-9C17-4B4D-821C-9E4C4B467B86}</AdobeCode>
    <AdobeCode>{44F87F40-5C66-4A3F-A6BA-D0ADF482B292}</AdobeCode>
    <AdobeCode>{F00AFC47-74DC-4253-9B83-FEB387A8E8D2}</AdobeCode>
    <AdobeCode>{4D5DE2E6-40B6-4B5D-9B76-170510644E33}</AdobeCode>
    <AdobeCode>{B039D002-CEFA-488B-8494-05B537677E78}</AdobeCode>
    <AdobeCode>{97E14254-D1B7-4E72-99B0-D5600D7B1D7B}</AdobeCode>
    <AdobeCode>{6DCE9360-CF5A-4371-B4FA-338F9AD0B435}</AdobeCode>
    <AdobeCode>{1B298277-D778-4A1E-8AC6-75F3908BEB77}</AdobeCode>
    <AdobeCode>{4BA6A968-1577-44B4-9233-F5F6706B3B1E}</AdobeCode>
    <AdobeCode>{82D63D9A-F986-4500-9C32-4321AED56534}</AdobeCode>
    <AdobeCode>{7B728334-57A5-4BCD-B5C7-F024F0224526}</AdobeCode>
    <AdobeCode>{473A6E9D-C1A8-4663-8EDB-28FFE8C2952B}</AdobeCode>
    <AdobeCode>{2ABD2493-AD4F-4C63-9397-E69581599C75}</AdobeCode>
    <AdobeCode>{C3E298A3-8209-4F7C-B873-F0D66967B129}</AdobeCode>
    <AdobeCode>{2118B9CF-BE2D-4297-91B7-051B404A3AA9}</AdobeCode>
    <AdobeCode>{E960A73D-991B-4D6F-95DE-C6BFC73E7C89}</AdobeCode>
    <AdobeCode>{38CE8E2B-ABDF-487F-A606-31D5E75AF8C0}</AdobeCode>
    <AdobeCode>{DB4ACF15-A387-4C66-8361-888145692B5A}</AdobeCode>
    <AdobeCode>{B8B901D0-3F71-4236-97F3-4D152CFF8841}</AdobeCode>
    <AdobeCode>{20DEE7EE-6ABC-484E-9767-6D318D17F8AF}</AdobeCode>
    <AdobeCode>{A1195FCD-AA56-4C4A-B880-042F752A6A92}</AdobeCode>
    <AdobeCode>{ACFCA756-7ABD-448D-ADCD-D4F54284017C}</AdobeCode>
    <AdobeCode>{2C6C5AB6-1F05-4538-A8C0-8E58068467A6}</AdobeCode>
    <AdobeCode>{7C4045BF-DA9A-490C-8E08-823823F3D301}</AdobeCode>
    <AdobeCode>{6DBC337F-A503-4B5E-8C2F-59781239B283}</AdobeCode>
    <AdobeCode>{10392BA5-7147-487E-BE69-4DC8E6F8496E}</AdobeCode>
    <AdobeCode>{7AE7FA1E-A099-4A79-AE82-BB772EC76BBD}</AdobeCode>
    <AdobeCode>{A2CF5675-54A9-4783-B213-9763A76C447B}</AdobeCode>
    <AdobeCode>{EFDB5880-3E63-45B0-9D9E-754D4B140F0F}</AdobeCode>
    <AdobeCode>{1DA7859F-3163-4032-9AB9-AD3857E0ED17}</AdobeCode>
    <AdobeCode>{4A9A4FD8-C8F3-48C3-9185-D2D060DBD1F3}</AdobeCode>
    <AdobeCode>{6BB86B3E-A1CB-4C3B-A1A4-5BC1052FFCAA}</AdobeCode>
    <AdobeCode>{70A2EC90-0EC5-4884-9A9C-F30E11CE9D83}</AdobeCode>
    <AdobeCode>{5B210450-FCF4-48E9-90AD-809B57BA5BAB}</AdobeCode>
    <AdobeCode>{CCBD2F9B-EBE0-4CD2-829D-4A896F72C4B1}</AdobeCode>
    <AdobeCode>{181B6BB9-7492-42E7-96DA-67C60B57C65D}</AdobeCode>
    <AdobeCode>{78DC252D-B56C-41C8-85BE-A6506A227FA0}</AdobeCode>
    <AdobeCode>{2E1202BB-6D05-4247-96D1-B26A89B455A3}</AdobeCode>
    <AdobeCode>{37A86D9D-BE97-408D-BBFA-BC75343ABE19}</AdobeCode>
    <AdobeCode>{7260C48F-B993-437B-A5F8-8172C0C11DA8}</AdobeCode>
    <AdobeCode>{71B0CBB0-8B71-4D9D-B56D-8177D2579836}</AdobeCode>
    <AdobeCode>{48C54851-6BA4-4E36-AC3F-72C93AD0D266}</AdobeCode>
    <AdobeCode>{F420C498-3360-4AB4-A35F-3E2A502739D7}</AdobeCode>
    <AdobeCode>{50CF81EE-A67D-4343-BF0B-2DAA0FF01B44}</AdobeCode>
    <AdobeCode>{AE1AFB74-1787-4E14-BBD0-EAF6A0EDCBE5}</AdobeCode>
    <AdobeCode>{22DB3F23-6A18-47E8-B5F6-D955987F4047}</AdobeCode>
    <AdobeCode>{78FC6B9F-8326-4334-989B-514BCEA9CE72}</AdobeCode>
    <AdobeCode>{68842ABA-EDB4-42DC-A325-B17326578DFD}</AdobeCode>
    <AdobeCode>{D6D0A118-EC2D-4A3F-9BC0-8C1F8CF2AAFE}</AdobeCode>
    <AdobeCode>{0720966A-31B1-408B-9F80-0D0DE3A25FC3}</AdobeCode>
    <AdobeCode>{5A9B7D04-932D-48F4-AE71-0AF9E7080174}</AdobeCode>
    <AdobeCode>{ECD41B52-F4BB-4E1C-9527-8AE0789745A2}</AdobeCode>
    <AdobeCode>{C53996CE-24A1-4D58-AEA6-F306C0C22921}</AdobeCode>
    <AdobeCode>{A385DFE2-4AEE-4CDC-9EBD-28B64A9C016A}</AdobeCode>
    <AdobeCode>{E5A8116F-E653-4486-8E77-2E8966ECB5CF}</AdobeCode>
    <AdobeCode>{21F0EF5F-9B1B-4FC2-95B2-EF11B05C1FDD}</AdobeCode>
    <AdobeCode>{9469833D-15F5-4898-B1DF-2DCAFFB9633A}</AdobeCode>
    <AdobeCode>{302BEF67-F75B-4390-9044-A633F5F68CA8}</AdobeCode>
    <AdobeCode>{4CEDA4E4-848E-4616-9345-6A5664FB31F2}</AdobeCode>
    <AdobeCode>{7336C140-2276-41A8-B4DB-C8A67F095E59}</AdobeCode>
    <AdobeCode>{5BAA3325-9940-4C37-9956-D750E1BFE8E1}</AdobeCode>
    <AdobeCode>{C91D9285-099C-489D-8D30-3FB3B036E56D}</AdobeCode>
    <AdobeCode>{2551CD4D-300F-459A-A293-D747D94C0BAE}</AdobeCode>
    <AdobeCode>{D6A9A497-5EE3-4611-88ED-4F27BA2260D7}</AdobeCode>
    <AdobeCode>{0686CD0D-6FC6-4FCE-9214-3EE3F7E90A95}</AdobeCode>
    <AdobeCode>{9E5B77E9-ACE1-4C25-A4C1-52AD98D10AF0}</AdobeCode>
    <AdobeCode>{F3E31E83-729B-45BE-AA1D-57C794787559}</AdobeCode>
    <AdobeCode>{B13A93E8-8C40-4587-8A26-649B019CA04C}</AdobeCode>
    <AdobeCode>{B7F460E3-E85C-4E0C-89F1-A118171B3C72}</AdobeCode>
    <AdobeCode>{F4E8B093-D670-43F1-82E7-08020ACB5452}</AdobeCode>
    <AdobeCode>{5DFFB5CB-400A-44E4-8ABC-75FE34F4C40E}</AdobeCode>
    <AdobeCode>{FF20736F-3D8A-4B1B-9396-18EA1D4B7F7D}</AdobeCode>
    <AdobeCode>{6465E605-31F5-4A43-AD3F-9CE45A066726}</AdobeCode>
    <AdobeCode>{00D64CAF-5F22-47CA-BD5C-46B82401AAE0}</AdobeCode>
    <AdobeCode>{9E389018-DD3D-4C93-A592-722938020937}</AdobeCode>
    <AdobeCode>{499C3231-B2F0-4981-9E0B-8C0C8E7DBAE6}</AdobeCode>
    <AdobeCode>{F0F978BB-D11B-4071-A0CF-E0B0E627B715}</AdobeCode>
    <AdobeCode>{91377C46-844B-4BC0-AC85-6AC70930E27A}</AdobeCode>
    <AdobeCode>{8A4BAF1A-3C16-45C2-997D-5198902A9B7B}</AdobeCode>
    <AdobeCode>{9C6B8D69-DB88-48C9-AAF0-20BE54DCD038}</AdobeCode>
    <AdobeCode>{A17AF0B8-E85E-43EF-B7DB-77C2CBDF3B24}</AdobeCode>
    <AdobeCode>{00778BC3-D219-4C3C-9A8C-71875F2AAD34}</AdobeCode>
    <AdobeCode>{76A6633B-BC56-4509-973E-CDDC0D578C6B}</AdobeCode>
    <AdobeCode>{6B50F21F-3BC4-469B-8661-8A4D6CA255FA}</AdobeCode>
    <AdobeCode>{62828891-75FD-48CF-B1B2-F4C497EFE866}</AdobeCode>
    <AdobeCode>{D861BCD3-F473-48E2-B913-A002075E8270}</AdobeCode>
    <AdobeCode>{7194D954-0729-4A66-B40D-004996D8594F}</AdobeCode>
    <AdobeCode>{B86DF039-33FE-4A55-B4C1-84303DDC93BB}</AdobeCode>
    <AdobeCode>{7925EF6B-E9CC-474E-B830-D1173283C3E5}</AdobeCode>
    <AdobeCode>{908852C2-176B-4BDB-AEF2-50B01C4E2246}</AdobeCode>
    <AdobeCode>{9191FD67-ABD9-4793-9AD4-EFDEE205E3EA}</AdobeCode>
    <AdobeCode>{29083AB0-25AE-4FE1-BCAB-12E67A21C460}</AdobeCode>
    <AdobeCode>{EB096204-2579-404B-BC58-E69A53C17254}</AdobeCode>
    <AdobeCode>{F720004E-8980-4010-82F2-440BE6228817}</AdobeCode>
    <AdobeCode>{EA4D74E4-A472-4012-853D-3BE600B08FCC}</AdobeCode>
    <AdobeCode>{57D0E4F7-ABFA-4FE4-A2E9-99DF92E41DD2}</AdobeCode>
    <AdobeCode>{58A4FC46-5087-46D9-A972-3C0BD6DA7394}</AdobeCode>
    <AdobeCode>{E49FEE87-C5CB-4BE3-B72E-30360F0F200C}</AdobeCode>
    <AdobeCode>{50567AD4-FC2E-4C56-B567-8E354D1BA7C0}</AdobeCode>
    <AdobeCode>{2F5D7EA1-F574-4A44-A1E6-C64622A40672}</AdobeCode>
    <AdobeCode>{EA134E4A-0F01-4943-A694-634EC350F42C}</AdobeCode>
    <AdobeCode>{AA1FCC28-D7B5-4B2E-BCE3-64C393EB5335}</AdobeCode>
    <AdobeCode>{576EF85B-6D47-4A6C-BD2F-290566868D0B}</AdobeCode>
    <AdobeCode>{1F7BF9C6-78D7-4EF4-95EF-52B871C5A070}</AdobeCode>
    <AdobeCode>{D33FF3FB-3592-4D48-8158-338F15708B27}</AdobeCode>
    <AdobeCode>{604CD92D-4084-49F7-8A6D-2ABB844CDDAE}</AdobeCode>
    <AdobeCode>{4674A72C-3486-46C6-8AFB-210755AF0CDF}</AdobeCode>
    <AdobeCode>{2745E404-64AF-46B8-8434-597F9D6EB573}</AdobeCode>
    <AdobeCode>{13B0B055-541B-456E-B4A1-F12DD705C2D4}</AdobeCode>
    <AdobeCode>{9D403881-E9D2-4CE5-8CA4-8BCB49765023}</AdobeCode>
    <AdobeCode>{890B91B5-7F1B-4DAB-93B8-93E23350CBAB}</AdobeCode>
    <AdobeCode>{FDABFFC2-39EB-403E-98D4-9F675D36A815}</AdobeCode>
    <AdobeCode>{45E8CBBC-38DE-43C3-B53B-2DAC18BC3DCF}</AdobeCode>
    <AdobeCode>{6A24CCF6-EFD9-4904-AC5C-5E96C42A8C82}</AdobeCode>
    <AdobeCode>{B944A667-E1BF-443A-92B5-EA1389B4B30E}</AdobeCode>
    <AdobeCode>{D12D7E1F-8CF0-4EB4-8F1A-0B9E7F7F41A0}</AdobeCode>
    <AdobeCode>{581CB783-419F-45AA-B8FC-98626ABFEA5B}</AdobeCode>
    <AdobeCode>{A23C10F7-9D57-4566-8BE4-7EC5A92885AA}</AdobeCode>
    <AdobeCode>{59D660C9-9303-43C3-A3F4-068FA95DA3C6}</AdobeCode>
    <AdobeCode>{029B59F7-E7A7-4396-B249-3BB99456EFF2}</AdobeCode>
    <AdobeCode>{C4F53121-161B-4D33-9A84-027E6DCDF182}</AdobeCode>
    <AdobeCode>{5FCB9EE5-9D16-44AA-AECF-46D9859D6FAB}</AdobeCode>
    <AdobeCode>{5F229A8F-2712-484E-9DF2-33122D36FA7E}</AdobeCode>
    <AdobeCode>{7BA4FC44-A3B7-4DB2-A485-E0F6EBEEB43D}</AdobeCode>
    <AdobeCode>{2DEC353E-219F-4900-9D7B-7847C675980E}</AdobeCode>
    <AdobeCode>{971ED46A-EC8D-4E2F-AFEC-BD6522BB43E9}</AdobeCode>
    <AdobeCode>{144A46CB-D3F4-4CE8-A51F-46A5280648D7}</AdobeCode>
    <AdobeCode>{440331D6-71CE-43F5-83D9-FFB434371D76}</AdobeCode>
    <AdobeCode>{8E488E89-AB2E-4C3F-9C75-4CABF4AB4925}</AdobeCode>
    <AdobeCode>{9568B2C3-2286-43B9-A304-C66C91632680}</AdobeCode>
    <AdobeCode>{5FF240EA-27F4-4976-AB55-79216A416144}</AdobeCode>
    <AdobeCode>{F80B89B1-C4B6-42F2-818D-3F6B0C80C3EA}</AdobeCode>
    <AdobeCode>{BB453EC8-982F-48F8-84F4-D8C864805F18}</AdobeCode>
    <AdobeCode>{CEBD7ACF-0228-496A-9150-A1283E65920C}</AdobeCode>
    <AdobeCode>{1B380C6A-E78F-46DF-80B4-5760B7EF50B1}</AdobeCode>
    <AdobeCode>{E6DEF8EF-5AA6-4084-B2B5-D61F7ABB7BFA}</AdobeCode>
    <AdobeCode>{BC060AAC-74FF-4439-B996-02A65C4170D6}</AdobeCode>
    <AdobeCode>{FC87EBE8-0A88-4F01-88A2-CD97D908D70F}</AdobeCode>
    <AdobeCode>{24166DFF-9154-4248-80B0-F144BA0D2031}</AdobeCode>
    <AdobeCode>{5D7DA15E-8AAD-4BB4-90D5-03EA4129C0D4}</AdobeCode>
    <AdobeCode>{106AC1FF-7262-4291-8406-DE72C56402A9}</AdobeCode>
    <AdobeCode>{CB1433E7-E794-4987-BCD6-F37225C7449D}</AdobeCode>
    <AdobeCode>{70C0D4C4-645A-4B35-8B30-D87B6EAB8A3B}</AdobeCode>
    <AdobeCode>{E98D2C25-B372-49AE-BF9E-D3D1FFE016C6}</AdobeCode>
    <AdobeCode>{FA826697-B224-4B68-8ABA-296ADD12DCC6}</AdobeCode>
    <AdobeCode>{3D87F9A9-693B-4346-8459-7E3E03B916A5}</AdobeCode>
    <AdobeCode>{1AD13E62-781E-44A2-96DA-8F153585A708}</AdobeCode>
    <AdobeCode>{6CD26A90-01B0-4786-8196-AFDF73850F92}</AdobeCode>
    <AdobeCode>{C4CD98A8-0AD8-4585-9E85-423B82CE9CD7}</AdobeCode>
    <AdobeCode>{A536D67E-250C-49FD-A175-789F5B2918D6}</AdobeCode>
    <AdobeCode>{33941BCB-499D-4D07-A43B-39F09DD858AF}</AdobeCode>
  </Upgrades><Channel enable="1" id="CameraProfilesInstaller-7.0">
        <DisplayName>Camera Profiles Installer</DisplayName>
      </Channel><Update id="8.3.37">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Camera Raw Profiles Updates&lt;/en_US&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;It's a Camera Raw Profiles patcher&lt;/en_US&gt;
    &lt;/Description&gt;</Update><Extends type="patch">
    <ParentProductInfo>
      <Family>Shared Technology</Family>
      <ProductName>Camera Profiles Installer</ProductName>
      <AdobeCode>{539AEF15-3A2B-4A31-A587-7E90F7D9C700}</AdobeCode>
    </ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="93161093" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>93689036</TotalSize>
      <MaxPathComponent>/LensProfiles/1.0/Tamron/Nikon\NIKON CORPORATION (TAMRON SP 90mm F_2.8 Di MACRO 1-1 VC USD F004N) - RAW.lcp</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="93161093"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
    <Win32/>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">8.3</Value>
      <Value lang="be_BY">8.3</Value>
      <Value lang="bg_BG">8.3</Value>
      <Value lang="ca_ES">8.3</Value>
      <Value lang="cs_CZ">8.3</Value>
      <Value lang="da_DK">8.3</Value>
      <Value lang="de_DE">8.3</Value>
      <Value lang="el_GR">8.3</Value>
      <Value lang="en_GB">8.3</Value>
      <Value lang="en_MX">8.3</Value>
      <Value lang="en_US">8.3</Value>
      <Value lang="en_XC">8.3</Value>
      <Value lang="en_XM">8.3</Value>
      <Value lang="es_ES">8.3</Value>
      <Value lang="es_MX">8.3</Value>
      <Value lang="es_QM">8.3</Value>
      <Value lang="et_EE">8.3</Value>
      <Value lang="fi_FI">8.3</Value>
      <Value lang="fr_CA">8.3</Value>
      <Value lang="fr_FR">8.3</Value>
      <Value lang="fr_MX">8.3</Value>
      <Value lang="fr_XM">8.3</Value>
      <Value lang="he_IL">8.3</Value>
      <Value lang="hi_IN">8.3</Value>
      <Value lang="hr_HR">8.3</Value>
      <Value lang="hu_HU">8.3</Value>
      <Value lang="is_IS">8.3</Value>
      <Value lang="it_IT">8.3</Value>
      <Value lang="ja_JP">8.3</Value>
      <Value lang="ko_KR">8.3</Value>
      <Value lang="lt_LT">8.3</Value>
      <Value lang="lv_LV">8.3</Value>
      <Value lang="mk_MK">8.3</Value>
      <Value lang="nb_NO">8.3</Value>
      <Value lang="nl_NL">8.3</Value>
      <Value lang="nn_NO">8.3</Value>
      <Value lang="no_NO">8.3</Value>
      <Value lang="pl_PL">8.3</Value>
      <Value lang="pt_BR">8.3</Value>
      <Value lang="ro_RO">8.3</Value>
      <Value lang="ru_RU">8.3</Value>
      <Value lang="sh_YU">8.3</Value>
      <Value lang="sk_SK">8.3</Value>
      <Value lang="sl_SI">8.3</Value>
      <Value lang="sq_AL">8.3</Value>
      <Value lang="sv_SE">8.3</Value>
      <Value lang="th_TH">8.3</Value>
      <Value lang="tr_TR">8.3</Value>
      <Value lang="uk_UA">8.3</Value>
      <Value lang="vi_VN">8.3</Value>
      <Value lang="zh_CN">8.3</Value>
      <Value lang="zh_TW">8.3</Value>
      <Value lang="en_AE">8.3</Value>
      <Value lang="en_IL">8.3</Value>
      <Value lang="fr_MA">8.3</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Camera Profiles Installer</Value>
      <Value lang="be_BY">Camera Profiles Installer</Value>
      <Value lang="bg_BG">Camera Profiles Installer</Value>
      <Value lang="ca_ES">Camera Profiles Installer</Value>
      <Value lang="cs_CZ">Camera Profiles Installer</Value>
      <Value lang="da_DK">Camera Profiles Installer</Value>
      <Value lang="de_DE">Camera Profiles Installer</Value>
      <Value lang="el_GR">Camera Profiles Installer</Value>
      <Value lang="en_GB">Camera Profiles Installer</Value>
      <Value lang="en_MX">Camera Profiles Installer</Value>
      <Value lang="en_US">Camera Profiles Installer</Value>
      <Value lang="en_XC">Camera Profiles Installer</Value>
      <Value lang="en_XM">Camera Profiles Installer</Value>
      <Value lang="es_ES">Camera Profiles Installer</Value>
      <Value lang="es_MX">Camera Profiles Installer</Value>
      <Value lang="es_QM">Camera Profiles Installer</Value>
      <Value lang="et_EE">Camera Profiles Installer</Value>
      <Value lang="fi_FI">Camera Profiles Installer</Value>
      <Value lang="fr_CA">Camera Profiles Installer</Value>
      <Value lang="fr_FR">Camera Profiles Installer</Value>
      <Value lang="fr_MX">Camera Profiles Installer</Value>
      <Value lang="fr_XM">Camera Profiles Installer</Value>
      <Value lang="he_IL">Camera Profiles Installer</Value>
      <Value lang="hi_IN">Camera Profiles Installer</Value>
      <Value lang="hr_HR">Camera Profiles Installer</Value>
      <Value lang="hu_HU">Camera Profiles Installer</Value>
      <Value lang="is_IS">Camera Profiles Installer</Value>
      <Value lang="it_IT">Camera Profiles Installer</Value>
      <Value lang="ja_JP">Camera Profiles Installer</Value>
      <Value lang="ko_KR">Camera Profiles Installer</Value>
      <Value lang="lt_LT">Camera Profiles Installer</Value>
      <Value lang="lv_LV">Camera Profiles Installer</Value>
      <Value lang="mk_MK">Camera Profiles Installer</Value>
      <Value lang="nb_NO">Camera Profiles Installer</Value>
      <Value lang="nl_NL">Camera Profiles Installer</Value>
      <Value lang="nn_NO">Camera Profiles Installer</Value>
      <Value lang="no_NO">Camera Profiles Installer</Value>
      <Value lang="pl_PL">Camera Profiles Installer</Value>
      <Value lang="pt_BR">Camera Profiles Installer</Value>
      <Value lang="ro_RO">Camera Profiles Installer</Value>
      <Value lang="ru_RU">Camera Profiles Installer</Value>
      <Value lang="sh_YU">Camera Profiles Installer</Value>
      <Value lang="sk_SK">Camera Profiles Installer</Value>
      <Value lang="sl_SI">Camera Profiles Installer</Value>
      <Value lang="sq_AL">Camera Profiles Installer</Value>
      <Value lang="sv_SE">Camera Profiles Installer</Value>
      <Value lang="th_TH">Camera Profiles Installer</Value>
      <Value lang="tr_TR">Camera Profiles Installer</Value>
      <Value lang="uk_UA">Camera Profiles Installer</Value>
      <Value lang="vi_VN">Camera Profiles Installer</Value>
      <Value lang="zh_CN">Camera Profiles Installer</Value>
      <Value lang="zh_TW">Camera Profiles Installer</Value>
      <Value lang="en_AE">Camera Profiles Installer</Value>
      <Value lang="en_IL">Camera Profiles Installer</Value>
      <Value lang="fr_MA">Camera Profiles Installer</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0", "ChannelID", "CameraProfilesInstaller-7.0")
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0", "ChannelInfo", '<Channel enable="1" id="CameraProfilesInstaller-7.0">
        <DisplayName>Camera Profiles Installer</DisplayName>
      </Channel>')
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0", "UpdateID", "8.3.37")
INSERT INTO PayloadData VALUES("{FCC010B9-2CF1-4BEE-A3A2-CA4D52EE67FA}", "0", "UpdateInfo", '<Update id="8.3.37">
        
        
      &lt;DisplayName default="en_US"&gt;
        &lt;en_US&gt;Camera Raw Profiles Updates&lt;/en_US&gt;
    &lt;/DisplayName&gt;&lt;Description default="en_US"&gt;
        &lt;en_US&gt;It's a Camera Raw Profiles patcher&lt;/en_US&gt;
    &lt;/Description&gt;</Update>')
