/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod;

import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.world.biome.BiomeChocolate;
import com.ochotonida.candymod.world.biome.BiomeCottonCandy;
import com.ochotonida.candymod.world.biome.BiomeGummy;
import com.ochotonida.candymod.world.biome.ModBiome;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBiomes {
    public static final List<ModBiomeEntry> biomeEntryList = new ArrayList<ModBiomeEntry>();
    public static final BiomeCottonCandy BIOME_COTTON_CANDY = new BiomeCottonCandy();
    public static final BiomeChocolate BIOME_CHOCOLATE = new BiomeChocolate();
    public static final BiomeGummy BIOME_GUMMY = new BiomeGummy();

    static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerBiome(event, BIOME_COTTON_CANDY, BiomeManager.BiomeType.COOL, ModConfig.weightCottonCanyPlains, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiome(event, BIOME_CHOCOLATE, BiomeManager.BiomeType.WARM, ModConfig.weightChocolateForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiome(event, BIOME_GUMMY, BiomeManager.BiomeType.WARM, ModConfig.weightGummySwamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.HILLS);
    }

    private static void registerBiome(RegistryEvent.Register<Biome> event, ModBiome biome, BiomeManager.BiomeType type, int weight, BiomeDictionary.Type ... biomeDictTypes) {
        event.getRegistry().register((IForgeRegistryEntry)biome);
        for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
        }
        biomeEntryList.add(new ModBiomeEntry(biome, type, weight));
    }

    public static class ModBiomeEntry {
        private final int weight;
        private final Biome biome;
        private final BiomeManager.BiomeType type;
        private final BiomeManager.BiomeEntry entry;

        private ModBiomeEntry(ModBiome biome, BiomeManager.BiomeType type, int weight) {
            this.type = type;
            this.biome = biome;
            this.weight = weight;
            this.entry = new BiomeManager.BiomeEntry((Biome)biome, weight);
        }

        public ModBiome getBiome() {
            return (ModBiome)this.biome;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }

        public BiomeManager.BiomeType getType() {
            return this.type;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

