/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig {
    public static final String CATEGORY_BIOMES = "biomes";
    public static final String CATEGORY_MOBS = "mobs";
    public static final String CATEGORY_DIMENSION = "dimension";
    public static Configuration config;
    public static int dimensionId;
    public static int weightCottonCanyPlains;
    public static int weightChocolateForest;
    public static int weightGummySwamp;
    public static int weightCottonCandySheep;
    public static int weightEasterChicken;
    public static int weightGummyMouse;
    public static int weightGummyBear;
    public static boolean isGummyTransluscent;
    public static boolean preventModdedMobSpawn;
    public static boolean preventModdedMobspawnNuclear;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ModConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "Dimension id to use for the candy world dimension";
        comment = "Cotton candy plains biome weight. 0 to prevent generation in overworld";
        weightCottonCanyPlains = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightCandyCottonPlains", comment, weightCottonCanyPlains);
        comment = "Chocolate forest biome weight. 0 to prevent generation in overworld";
        weightChocolateForest = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightChocolateForest", comment, weightChocolateForest);
        comment = "Gummy swamp biome weight. 0 to prevent generation in overworld";
        weightGummySwamp = ModConfig.loadInt(CATEGORY_BIOMES, "candymod.weightGummySwamp", comment, weightGummySwamp);
        comment = "Cotton candy sheep weight. 0 to prevent spawning";
        weightCottonCandySheep = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightCottonCandySheep", comment, weightCottonCandySheep);
        comment = "Easter chicken weight. 0 to prevent spawning";
        weightEasterChicken = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightEasterChicken", comment, weightEasterChicken);
        comment = "Gummy mice weight. 0 to prevent spawning";
        weightGummyMouse = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightGummyMouse", comment, weightGummyMouse);
        comment = "Gummy bear weight. 0 to prevent spawning";
        weightGummyBear = ModConfig.loadInt(CATEGORY_MOBS, "candymod.weightGummyBear", comment, weightGummyBear);
        comment = "setting this to true should prevent any non-Candy World mobs from spawning in candy world biomes";
        preventModdedMobSpawn = ModConfig.loadBool(CATEGORY_MOBS, "candymod.preventModdedMobspawn", comment, preventModdedMobSpawn);
        comment = comment + " (last-resort nuclear option, try other solutions first) \nThis will clear the spawn of the biomes list right before the server starts, if that doesn't work, I don't know what else will";
        preventModdedMobspawnNuclear = ModConfig.loadBool(CATEGORY_MOBS, "candymod.preventModdedMobspawnNuclear", comment, preventModdedMobspawnNuclear);
        comment = "Setting this to false will make the game render gummy blocks solid, improving performance";
        isGummyTransluscent = ModConfig.loadBool("client", "candymod.isGummyTransluscent", comment, isGummyTransluscent);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadInt(String category, String name, String comment, int def) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        int val = prop.getInt(def);
        if (val < 0) {
            val = 0;
            prop.set(0);
        }
        return val;
    }

    public static boolean loadBool(String category, String name, String comment, boolean def) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        return prop.getBoolean(def);
    }

    static {
        dimensionId = 23;
        weightCottonCanyPlains = 4;
        weightChocolateForest = 4;
        weightGummySwamp = 4;
        weightCottonCandySheep = 14;
        weightEasterChicken = 14;
        weightGummyMouse = 14;
        weightGummyBear = 11;
        isGummyTransluscent = true;
        preventModdedMobSpawn = false;
        preventModdedMobspawnNuclear = false;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("candymod")) {
                ModConfig.init();
            }
        }
    }
}

