/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.block;

import com.ochotonida.candymod.CandyMod;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockStackable
extends Block {
    protected BlockStackable(Material material, MapColor mapcolor) {
        super(material, mapcolor);
        this.func_149647_a(CandyMod.TAB_BLOCKS);
    }

    public void setName(String name) {
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        boolean topSolid = worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
        return topSolid || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockStackable;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().getClass().isInstance((Object)this)) {
            return this.func_176195_g(worldIn.func_180495_p(pos.func_177984_a()), worldIn, pos.func_177984_a()) + this.field_149782_v;
        }
        return this.field_149782_v;
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175707_a(pos.func_177982_a(-5, -5, -5), pos.func_177982_a(5, 5, 5))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-4, -4, -4), (BlockPos)pos.func_177982_a(4, 4, 4))) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
            }
        }
    }
}

