/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.block.candygrass;

import com.ochotonida.candymod.CandyMod;
import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModItems;
import com.ochotonida.candymod.common.BlockProperties;
import com.ochotonida.candymod.common.ModSoundTypes;
import com.ochotonida.candymod.common.enums.EnumChocolate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockCandyGrass
extends Block
implements IGrowable {
    public BlockCandyGrass() {
        super(Material.field_151577_b, MapColor.field_151671_v);
        this.func_149663_c("candy_grass_block");
        this.setRegistryName("candy_grass_block");
        this.func_149675_a(true);
        this.func_149711_c(0.6f);
        this.func_149672_a(ModSoundTypes.CANDY_GRASS);
        this.func_149647_a(CandyMod.TAB_BLOCKS);
        this.setHarvestLevel("shovel", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK)));
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumChocolate)((Object)state.func_177229_b(BlockProperties.CHOCOLATE_TYPE))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumChocolate.META_LOOKUP.length - 1; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        switch ((EnumChocolate)((Object)state.func_177229_b(BlockProperties.CHOCOLATE_TYPE))) {
            case MILK: {
                return ModSoundTypes.CANDY_GRASS;
            }
            case WHITE: {
                return ModSoundTypes.CANDY_DIRT;
            }
        }
        return this.func_185467_w();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumChocolate)((Object)state.func_177229_b(BlockProperties.CHOCOLATE_TYPE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.CHOCOLATE_TYPE});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumChocolate type = EnumChocolate.byMetadata(meta);
        return this.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)type));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModBlocks.CANDY_SOIL.func_180660_a(ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK)), rand, fortune);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int i;
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
        if (state == this.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK))) {
            for (i = 0; i < 1 + fortune; ++i) {
                if (rand.nextInt(8) != 0) continue;
                drops.add((Object)new ItemStack((Item)ModItems.COTTON_CANDY, 1, 0));
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.func_175697_a(pos, 3)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) < 4 && worldIn.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) {
                worldIn.func_175656_a(pos, ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, state.func_177229_b(BlockProperties.CHOCOLATE_TYPE)));
            } else if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 3; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177984_a());
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    if (iblockstate1 != ModBlocks.CANDY_SOIL.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, state.func_177229_b(BlockProperties.CHOCOLATE_TYPE)) || worldIn.func_175671_l(blockpos.func_177984_a()) < 4 || iblockstate.getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) continue;
                    worldIn.func_175656_a(blockpos, ModBlocks.CANDY_GRASS.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, state.func_177229_b(BlockProperties.CHOCOLATE_TYPE)));
                }
            }
        }
    }

    public boolean func_149700_E() {
        return true;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return ModBlocks.COTTON_CANDY_PLANT.func_176196_c(world, pos.func_177984_a()) && state == this.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK));
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return state == this.func_176223_P().func_177226_a(BlockProperties.CHOCOLATE_TYPE, (Comparable)((Object)EnumChocolate.MILK));
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos.func_177984_a(), ModBlocks.COTTON_CANDY_PLANT.func_176223_P());
        ItemDye.func_180617_a((World)world, (BlockPos)pos.func_177984_a(), (int)100);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == ModBlocks.COTTON_CANDY_SAPLING || plantable == ModBlocks.COTTON_CANDY_PLANT || plantable == ModBlocks.CHOCOLATE_SAPLING) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }
}

