/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.block.gummy;

import com.ochotonida.candymod.CandyMod;
import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModConfig;
import com.ochotonida.candymod.block.BlockColoring;
import com.ochotonida.candymod.interfaces.IBlockColored;
import com.ochotonida.candymod.proxy.ClientProxy;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockColaGummy
extends Block
implements IBlockColored {
    public BlockColaGummy() {
        super(Material.field_151571_B, MapColor.field_193573_Y);
        this.setRegistryName("cola_gummy_block");
        this.func_149663_c("cola_gummy_block");
        this.func_149647_a(CandyMod.TAB_BLOCKS);
        this.setDefaultSlipperiness(0.6f);
        this.func_149711_c(0.4f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185859_l);
        ClientProxy.addColoredBlock(this);
    }

    @Nonnull
    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return ModConfig.isGummyTransluscent ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!ModConfig.isGummyTransluscent) {
            return super.func_176225_a(blockState, blockAccess, pos, side);
        }
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        return blockState.func_177230_c() != iblockstate.func_177230_c() && blockState.func_177230_c() != ModBlocks.GUMMY_BLOCK;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.func_70093_af()) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
        } else {
            entityIn.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (entityIn.func_70093_af() || Math.abs(entityIn.field_70181_x * 0.8) < 0.3) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x * 0.8;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (Math.abs(entityIn.field_70181_x) < 0.1 && !entityIn.func_70093_af()) {
            entityIn.field_70159_w *= 0.8;
            entityIn.field_70179_y *= 0.8;
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @Override
    @Nonnull
    public IBlockColor getBlockColor() {
        return BlockColoring.COLA_GUMMY;
    }

    @Override
    @Nonnull
    public IItemColor getItemColor() {
        return BlockColoring.ITEM_COLA_GUMMY;
    }
}

