/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.client.renderer;

import com.ochotonida.candymod.entity.EntityEasterChicken;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderEasterChicken
extends RenderLiving<EntityEasterChicken> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation CHICKEN_TEXTURES = new ResourceLocation("candymod", "textures/entity/easter_chicken/easter_chicken.png");

    private RenderEasterChicken(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelChicken(), 0.3f);
    }

    @ParametersAreNonnullByDefault
    protected ResourceLocation getEntityTexture(EntityEasterChicken entity) {
        return CHICKEN_TEXTURES;
    }

    protected float handleRotationFloat(EntityEasterChicken livingBase, float partialTicks) {
        float f = livingBase.oFlap + (livingBase.wingRotation - livingBase.oFlap) * partialTicks;
        float f1 = livingBase.oFlapSpeed + (livingBase.destPos - livingBase.oFlapSpeed) * partialTicks;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    public static class Factory
    implements IRenderFactory<EntityEasterChicken> {
        public Render<? super EntityEasterChicken> createRenderFor(RenderManager manager) {
            return new RenderEasterChicken(manager);
        }
    }
}

