/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.entity;

import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModItems;
import com.ochotonida.candymod.entity.ai.EntityAIEatCandyGrass;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCandySheep
extends EntityAnimal {
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityCandySheep.class, (DataSerializer)DataSerializers.field_187198_h);
    private int sheepTimer;
    private EntityAIEatCandyGrass entityAIEatCandyGrass;

    public EntityCandySheep(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.3f);
        this.field_175506_bl = ModBlocks.CANDY_GRASS;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SHEARED, (Object)Boolean.FALSE);
    }

    public void func_184651_r() {
        this.entityAIEatCandyGrass = new EntityAIEatCandyGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.1, Items.field_151102_aT, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatCandyGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public void func_70619_bc() {
        this.sheepTimer = this.entityAIEatCandyGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    public ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return LootTableList.field_186403_K;
        }
        return LootTableList.field_186403_K;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151055_y && !this.getSheared() && !this.func_70631_g_()) {
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.setSheared(true);
                if (itemstack.func_190916_E() == 1) {
                    player.func_184611_a(hand, new ItemStack((Item)ModItems.COTTON_CANDY));
                } else {
                    itemstack.func_190918_g(1);
                    if (!player.func_191521_c(new ItemStack((Item)ModItems.COTTON_CANDY, 1))) {
                        player.func_71019_a(new ItemStack((Item)ModItems.COTTON_CANDY), false);
                    }
                }
                this.func_184185_a(SoundEvents.field_187552_ah, 1.0f, 1.0f);
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151100_aR && EnumDyeColor.func_176766_a((int)itemstack.func_77960_j()) == EnumDyeColor.WHITE && this.getSheared()) {
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.setSheared(false);
                itemstack.func_190918_g(1);
                this.func_184185_a(SoundEvents.field_187552_ah, 1.0f, 1.0f);
                this.func_70656_aK();
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151102_aT;
    }

    public int func_70641_bl() {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public boolean getSheared() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHEARED);
    }

    private void setSheared(boolean sheared) {
        this.func_184212_Q().func_187227_b(SHEARED, (Object)sheared);
    }

    @ParametersAreNonnullByDefault
    public EntityCandySheep createChild(EntityAgeable entity) {
        return new EntityCandySheep(this.field_70170_p);
    }

    public void func_70615_aA() {
        this.setSheared(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setSheared(false);
        return livingdata;
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }
}

