/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.entity;

import com.google.common.collect.Sets;
import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.ModItems;
import com.ochotonida.candymod.entity.ai.EntityAIEasterChickenPanic;
import com.ochotonida.candymod.enums.EnumChocolate;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityEasterChicken
extends EntityAnimal {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ModItems.WAFER_STICK, ModItems.CHOCOLATE_BAR});
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public boolean explodeWhenDone;
    private float wingRotDelta = 1.0f;
    private int timeUntilNextEgg;
    private int nextEggType;
    private int eggComboAmount;

    public EntityEasterChicken(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.7f);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(4000) + 6000;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.explodeWhenDone = false;
        this.nextEggType = -1;
        this.field_175506_bl = ModBlocks.CANDY_GRASS;
    }

    public void func_174830_Y() {
        if (this.func_70051_ag()) {
            this.func_174808_Z();
        }
    }

    protected void func_174808_Z() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIEasterChickenPanic(this, 1.3));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @ParametersAreNonnullByDefault
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!this.func_70631_g_() && this.nextEggType == -1 && !this.explodeWhenDone) {
            if (itemStack.func_77973_b() == Items.field_151033_d) {
                this.firePanic();
                player.func_184609_a(hand);
                itemStack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
            if (itemStack.func_77973_b() == ModItems.CHOCOLATE_BAR) {
                if (!this.field_70170_p.field_72995_K) {
                    this.timeUntilNextEgg = 30 + this.field_70146_Z.nextInt(30);
                    itemStack.func_190918_g(1);
                    this.nextEggType = itemStack.func_77960_j();
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70656_aK() {
        super.func_70656_aK();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        }
    }

    private void firePanic() {
        if (!this.field_70170_p.field_72995_K) {
            this.timeUntilNextEgg = 20 + this.field_70146_Z.nextInt(50);
            this.func_70097_a(DamageSource.field_76377_j, 0.0f);
            this.explodeWhenDone = true;
            this.func_70031_b(true);
            this.eggComboAmount = 25 + this.field_70146_Z.nextInt(20);
            this.func_184185_a(SoundEvents.field_187904_gd, 1.0f, 1.0f);
        }
    }

    private void explode() {
        EntityItem ent;
        int i;
        this.func_70656_aK();
        this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
        for (i = 0; i <= this.field_70146_Z.nextInt(5) + 3; ++i) {
            ent = this.func_70099_a(new ItemStack(Items.field_151008_G, 1, 0), 0.0f);
            if (ent == null) continue;
            ent.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.4f);
            ent.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f);
            ent.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f);
        }
        for (i = 0; i <= this.field_70146_Z.nextInt(3) + 3; ++i) {
            ent = this.func_70099_a(new ItemStack((Item)ModItems.CHOCOLATE_EGG, 1, this.field_70146_Z.nextInt(EnumChocolate.META_LOOKUP.length)), 0.0f);
            if (ent == null) continue;
            ent.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.4f);
            ent.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f);
            ent.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f);
        }
        this.func_70106_y();
    }

    private void dropEgg(int meta) {
        ItemStack stack = new ItemStack((Item)ModItems.CHOCOLATE_EGG, 1, meta);
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t - this.field_70159_w * 5.0, this.field_70163_u, this.field_70161_v - this.field_70179_y * 5.0, stack);
        entityitem.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (this.func_70027_ad() && !this.explodeWhenDone && !this.func_70631_g_() && !this.func_180799_ab()) {
            this.func_70066_B();
            this.firePanic();
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            boolean flag = false;
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            int meta = this.field_70146_Z.nextInt(EnumChocolate.META_LOOKUP.length);
            if (this.nextEggType != -1) {
                meta = this.nextEggType;
                flag = true;
                this.nextEggType = -1;
            }
            this.dropEgg(meta);
            if (this.eggComboAmount <= 0 && this.field_70146_Z.nextInt(100) == 0 && !flag) {
                this.eggComboAmount = this.field_70146_Z.nextInt(30) + 30;
                this.func_70097_a(DamageSource.field_76377_j, 0.0f);
            }
            this.timeUntilNextEgg = this.eggComboAmount-- > 0 ? 1 : this.field_70146_Z.nextInt(4000) + 6000;
            if (this.eggComboAmount == 0 && this.explodeWhenDone) {
                this.explode();
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186394_B;
    }

    @ParametersAreNonnullByDefault
    public EntityEasterChicken createChild(EntityAgeable ageable) {
        return new EntityEasterChicken(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.WAFER_STICK;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }
}

