/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.enums;

import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum EnumAxis implements IStringSerializable
{
    X(0, "x"),
    Y(1, "y"),
    Z(2, "z");

    public static final EnumAxis[] META_LOOKUP;
    private final String name;
    private final int meta;

    private EnumAxis(int meta, String name) {
        this.name = name;
        this.meta = meta;
    }

    public static EnumAxis byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public static EnumAxis fromFacingAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return X;
            }
            case Y: {
                return Y;
            }
            case Z: {
                return Z;
            }
        }
        return X;
    }

    public int getMetadata() {
        return this.meta;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    static {
        META_LOOKUP = new EnumAxis[EnumAxis.values().length];
        EnumAxis[] enumAxisArray = EnumAxis.values();
        int n = enumAxisArray.length;
        for (int i = 0; i < n; ++i) {
            EnumAxis enumaxis;
            EnumAxis.META_LOOKUP[enumaxis.getMetadata()] = enumaxis = enumAxisArray[i];
        }
    }
}

