/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.worldgen;

import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.block.ModBlockProperties;
import com.ochotonida.candymod.block.cottoncandy.BlockCottonCandyLeaves;
import com.ochotonida.candymod.enums.EnumCandyCane;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenCottonCandyTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = ModBlocks.CANDY_CANE.func_176223_P().func_177226_a(ModBlockProperties.CANDY_CANE_TYPE, (Comparable)((Object)EnumCandyCane.WHITE));
    private static final IBlockState LEAF = ModBlocks.COTTON_CANDY_LEAVES.func_176223_P().func_177226_a((IProperty)BlockCottonCandyLeaves.field_176237_a, (Comparable)Boolean.TRUE);

    public WorldGenCottonCandyTree(boolean notify) {
        super(notify);
    }

    private void setLeafBlock(World worldIn, BlockPos pos) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos)) {
            this.func_175903_a(worldIn, blockpos, LEAF);
        }
    }

    private void setAir(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos) == LEAF) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void placeLayer1(World worldIn, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos blockpos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z);
                this.setLeafBlock(worldIn, blockpos);
            }
        }
    }

    private void placeLayer2(World worldIn, BlockPos pos) {
        this.placeLayerSquare(worldIn, pos);
        this.setAir(worldIn, pos.func_177982_a(2, 0, 2));
        this.setAir(worldIn, pos.func_177982_a(2, 0, -2));
        this.setAir(worldIn, pos.func_177982_a(-2, 0, 2));
        this.setAir(worldIn, pos.func_177982_a(-2, 0, -2));
    }

    private void placeLayer3(World worldIn, BlockPos pos) {
        this.placeLayerSquare(worldIn, pos);
        this.setLeafBlock(worldIn, pos.func_177965_g(3));
        this.setLeafBlock(worldIn, pos.func_177985_f(3));
        this.setLeafBlock(worldIn, pos.func_177964_d(3));
        this.setLeafBlock(worldIn, pos.func_177970_e(3));
    }

    private void placeLayer4(World worldIn, BlockPos pos) {
        this.placeLayerSquare(worldIn, pos);
        for (int i = -1; i <= 1; ++i) {
            this.setLeafBlock(worldIn, pos.func_177982_a(i, 0, 3));
            this.setLeafBlock(worldIn, pos.func_177982_a(i, 0, -3));
            this.setLeafBlock(worldIn, pos.func_177982_a(3, 0, i));
            this.setLeafBlock(worldIn, pos.func_177982_a(-3, 0, i));
        }
    }

    private void placeLayerSquare(World worldIn, BlockPos pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos blockpos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z);
                this.setLeafBlock(worldIn, blockpos);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height = rand.nextInt(3) + 8;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int currentY = position.func_177956_o(); currentY <= position.func_177956_o() + 1 + height; ++currentY) {
                int k = 1;
                if (currentY == position.func_177956_o()) {
                    k = 0;
                }
                if (currentY >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (currentY >= 0 && currentY < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, currentY, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)ModBlocks.COTTON_CANDY_SAPLING);
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                int currentY = -6 + height;
                this.placeLayer1(worldIn, position.func_177981_b(currentY++));
                this.placeLayer2(worldIn, position.func_177981_b(currentY++));
                this.placeLayer3(worldIn, position.func_177981_b(currentY++));
                this.placeLayer4(worldIn, position.func_177981_b(currentY++));
                this.placeLayer4(worldIn, position.func_177981_b(currentY++));
                this.placeLayer3(worldIn, position.func_177981_b(currentY++));
                this.placeLayer2(worldIn, position.func_177981_b(currentY++));
                this.placeLayer1(worldIn, position.func_177981_b(currentY));
                for (int j2 = 0; j2 < height; ++j2) {
                    BlockPos upN = position.func_177981_b(j2);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j2), LOG);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

