/*
 * Decompiled with CFR 0.152.
 */
package com.ochotonida.candymod.world.worldgen;

import com.ochotonida.candymod.ModBlocks;
import com.ochotonida.candymod.block.ModBlockProperties;
import com.ochotonida.candymod.enums.EnumAxis;
import com.ochotonida.candymod.enums.EnumGummy;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGummyWorm
extends WorldGenerator {
    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        BlockPos surfacePos = this.findSurfaceBlock(worldIn, position);
        if (worldIn.func_180495_p(surfacePos).func_177230_c() == ModBlocks.GUMMY_WORM_BLOCK) {
            return false;
        }
        IBlockState state = ModBlocks.GUMMY_WORM_BLOCK.func_176223_P().func_177226_a(ModBlockProperties.GUMMY_TYPE, (Comparable)((Object)EnumGummy.random(rand)));
        int r = rand.nextInt(3);
        switch (r) {
            case 0: {
                return this.generateWormFlat(worldIn, surfacePos, rand.nextInt(10) + 7, state, rand);
            }
            case 1: {
                return this.generateWormStraight(worldIn, surfacePos, rand.nextInt(12) + 6, rand.nextInt(4) + 3, state);
            }
            case 2: {
                return this.generateWormArc(worldIn, surfacePos, state, rand);
            }
        }
        return false;
    }

    private BlockPos findSurfaceBlock(World worldIn, BlockPos position) {
        BlockPos pos = new BlockPos(position.func_177958_n(), 255, position.func_177952_p());
        while (worldIn.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        return pos;
    }

    private boolean generateWormStraight(World worldIn, BlockPos position, int down, int up, IBlockState state) {
        for (int i = -down; i < up; ++i) {
            worldIn.func_180501_a(position.func_177981_b(i), state.func_177226_a(ModBlockProperties.AXIS, (Comparable)((Object)EnumAxis.Y)), 18);
        }
        return true;
    }

    private boolean generateWormArc(World worldIn, BlockPos position, IBlockState state, Random rand) {
        int i;
        int height = rand.nextInt(2) + 2;
        int startDepth = rand.nextInt(4) + 4;
        EnumFacing direction = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
        state = state.func_177226_a(ModBlockProperties.AXIS, (Comparable)((Object)EnumAxis.Y));
        BlockPos pos = position.func_177979_c(startDepth);
        for (i = 0; i <= height + startDepth; ++i) {
            pos = pos.func_177984_a();
            worldIn.func_180501_a(pos, state, 18);
        }
        state = state.func_177226_a(ModBlockProperties.AXIS, (Comparable)((Object)EnumAxis.fromFacingAxis(direction.func_176740_k())));
        for (i = 0; i <= 2 + rand.nextInt(2); ++i) {
            pos = pos.func_177972_a(direction);
            worldIn.func_180501_a(pos, state, 18);
        }
        state = state.func_177226_a(ModBlockProperties.AXIS, (Comparable)((Object)EnumAxis.Y));
        while (worldIn.func_175623_d(pos.func_177977_b())) {
            pos = pos.func_177977_b();
            worldIn.func_180501_a(pos, state, 18);
        }
        for (i = 0; i <= 4 + rand.nextInt(4); ++i) {
            pos = pos.func_177977_b();
            worldIn.func_180501_a(pos, state, 18);
        }
        return true;
    }

    private boolean generateWormFlat(World worldIn, BlockPos position, int length, IBlockState state, Random rand) {
        BlockPos pos = position.func_177984_a();
        EnumFacing direction = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
        int lastTurnDir = 0;
        boolean hasTurned = false;
        for (int i = 0; i <= length; ++i) {
            worldIn.func_180501_a(pos, state.func_177226_a(ModBlockProperties.AXIS, (Comparable)((Object)EnumAxis.fromFacingAxis(direction.func_176740_k()))), 18);
            if (hasTurned) {
                hasTurned = false;
            } else if (rand.nextInt(3) == 0) {
                direction = direction.func_176746_e();
                if (lastTurnDir == 1 || lastTurnDir == 0 && rand.nextBoolean()) {
                    direction = direction.func_176746_e().func_176746_e();
                    lastTurnDir = -1;
                } else {
                    lastTurnDir = 1;
                }
                hasTurned = true;
            }
            while (worldIn.func_175623_d(pos.func_177977_b())) {
                pos = pos.func_177977_b();
                worldIn.func_180501_a(pos, state.func_177226_a(ModBlockProperties.AXIS, (Comparable)((Object)EnumAxis.Y)), 18);
                ++i;
            }
            while (!worldIn.func_175623_d(pos.func_177972_a(direction))) {
                if (!worldIn.func_175623_d(pos = pos.func_177984_a())) {
                    return true;
                }
                worldIn.func_180501_a(pos, state.func_177226_a(ModBlockProperties.AXIS, (Comparable)((Object)EnumAxis.Y)), 18);
                ++i;
            }
            pos = pos.func_177972_a(direction);
        }
        return true;
    }
}

