REM Oberon Color Sampler for CorelDRAW7
REM  30-Mar-1998 by Alex Vakulenko, Oberon
REM
REM http://www.atlant1.com.ua/Settlers/~oberon
REM e-mail: oberon@webber.net.ua

DECLARE SUB DrawBlock(LeftOrg&,TopOrg&,Color3&,Color4&)
DECLARE FUNCTION Num$(Number&)
DECLARE SUB UpdateProgress
DECLARE SUB DoOneStep
DECLARE SUB SetControls(CtrlSet%)
DECLARE SUB DetermineAxes
DECLARE FUNCTION GetColorValue&(StepVakue&,Index&)

GLOBAL ColorModels$(2),Axes_CMYK$(6),Axes_RGB$(3),ColorModel%,Axis_CMYK%,Axis_RGB%
GLOBAL Layouts$(8),XLayout%(8),YLayout%(8),XL%,YL%,RectSizeX&,RectSizeY&
GLOBAL MinColor&(2,4),MaxColor&(2,4),ColorSteps&(2,4),Axis$(2,4),Color&(4)
GLOBAL FlipAxes&,Ref%(2,4),Identical%
GLOBAL Step1&,Step2&,Step3&,Step4&
GLOBAL TotalSteps&,TotalPages&,TotalBlocks&,CurrentStep&,CurrentPage&,CurrentBlock&
GLOBAL LeftOrg&,TopOrg&,BlockX&,BlockY&,TileX&,TileY&
GLOBAL Done as boolean

ColorModels$(1)="CMYK"
ColorModels$(2)="RGB"
Axes_CMYK$(1)="Cyan-Magenta"
Axes_CMYK$(2)="Cyan-Yellow"
Axes_CMYK$(3)="Cyan-Black"
Axes_CMYK$(4)="Magenta-Yellow"
Axes_CMYK$(5)="Magenta-Black"
Axes_CMYK$(6)="Yellow-Black"
Axes_RGB$(1)="Red-Green"
Axes_RGB$(2)="Red-Blue"
Axes_RGB$(3)="Green-Blue"
ColorModel%=1
Axis_CMYK%=1
Axis_RGB%=1
Layouts$(1)="1 per page"
XLayout(1)=1
YLayout(1)=1
Layouts$(2)="2 per page"
XLayout(2)=2
YLayout(2)=1
Layouts$(3)="2x2"
XLayout(3)=2
YLayout(3)=2
Layouts$(4)="3x2"
XLayout(4)=3
YLayout(4)=2
Layouts$(5)="3x3"
XLayout(5)=3
YLayout(5)=3
Layouts$(6)="4x2"
XLayout(6)=4
YLayout(6)=2
Layouts$(7)="4x3"
XLayout(7)=4
YLayout(7)=3
Layouts$(8)="4x4"
XLayout(8)=4
YLayout(8)=4

BEGIN DIALOG OBJECT Sampler 245, 192, "Oberon Color Sampler", SUB SamplerHandler
	IMAGE  5, 6, 66, 154, .Image
	TEXT  100, 7, 42, 8, .Text1, "Color &Model:"
	DDLISTBOX  144, 5, 59, 65, .ColorModel
	TEXT  83, 31, 37, 8, .Text2, "Base &Axes:"
	DDLISTBOX  122, 29, 74, 65, .Axes
	CHECKBOX  205, 30, 25, 10, .Flip, "&Flip"
	GROUPBOX  75, 18, 164, 126, .GroupBox2, "Color Axes"
	TEXT  113, 52, 20, 8, .Text7, "Start"
	TEXT  158, 52, 15, 8, .Text8, "End"
	TEXT  197, 52, 20, 8, .Text9, "Steps"
	TEXT  88, 63, 10, 8, .Color1Text, "C:"
	SPINCONTROL  104, 62, 40, 12, .Color1Start
	SPINCONTROL  147, 62, 40, 12, .Color1End
	SPINCONTROL  190, 62, 40, 12, .Color1Steps
	TEXT  88, 79, 10, 8, .Color2Text, "M:"
	SPINCONTROL  104, 78, 40, 12, .Color2Start
	SPINCONTROL  147, 78, 40, 12, .Color2End
	SPINCONTROL  190, 78, 40, 12, .Color2Steps
	TEXT  88, 95, 10, 8, .Color3Text, "Y:"
	SPINCONTROL  104, 94, 40, 12, .Color3Start
	SPINCONTROL  147, 94, 40, 12, .Color3End
	SPINCONTROL  190, 94, 40, 12, .Color3Steps
	TEXT  88, 111, 10, 8, .Color4Text, "K:"
	SPINCONTROL  104, 110, 40, 12, .Color4Start
	SPINCONTROL  147, 110, 40, 12, .Color4End
	SPINCONTROL  190, 110, 40, 12, .Color4Steps
	CHECKBOX  110, 128, 110, 10, .Identical, "&Identical Values for all colors"
	GROUPBOX  5, 162, 235, 5, .GroupBox3
	TEXT  119, 150, 25, 8, .Text4, "&Layout:"
	DDLISTBOX  145, 148, 59, 126, .Layout
	PUSHBUTTON  136, 172, 48, 14, .Generate, "&Generate"
	CANCELBUTTON  192, 172, 48, 14, .Cancel
	TEXT  7, 174, 81, 8, .Text5, " Alex Vakulenko, 1998"
END DIALOG

SUB SamplerHandler(BYVAL ControlID%, BYVAL Event%)
	SELECT CASE Event%
		CASE 0 'Init
		CASE 1
			SELECT CASE ControlID%
				CASE Sampler.Color1Start.GetID()
					MinColor(ColorModel,Ref(ColorModel,1))=Sampler.Color1Start.GetValue()
					if Identical then
						MinColor(ColorModel,Ref(ColorModel,2))=MinColor(ColorModel,Ref(ColorModel,1))
						MinColor(ColorModel,Ref(ColorModel,3))=MinColor(ColorModel,Ref(ColorModel,1))
						MinColor(ColorModel,Ref(ColorModel,4))=MinColor(ColorModel,Ref(ColorModel,1))
						SetControls 1
					end if
				CASE Sampler.Color2Start.GetID()
					MinColor(ColorModel,Ref(ColorModel,2))=Sampler.Color2Start.GetValue()
				CASE Sampler.Color3Start.GetID()
					MinColor(ColorModel,Ref(ColorModel,3))=Sampler.Color3Start.GetValue()
				CASE Sampler.Color4Start.GetID()
					MinColor(ColorModel,Ref(ColorModel,4))=Sampler.Color4Start.GetValue()
				CASE Sampler.Color1End.GetID()
					MaxColor(ColorModel,Ref(ColorModel,1))=Sampler.Color1End.GetValue()
					if Identical then
						MaxColor(ColorModel,Ref(ColorModel,2))=MaxColor(ColorModel,Ref(ColorModel,1))
						MaxColor(ColorModel,Ref(ColorModel,3))=MaxColor(ColorModel,Ref(ColorModel,1))
						MaxColor(ColorModel,Ref(ColorModel,4))=MaxColor(ColorModel,Ref(ColorModel,1))
						SetControls 1
					end if
				CASE Sampler.Color2End.GetID()
					MaxColor(ColorModel,Ref(ColorModel,2))=Sampler.Color2End.GetValue()
				CASE Sampler.Color3End.GetID()
					MaxColor(ColorModel,Ref(ColorModel,3))=Sampler.Color3End.GetValue()
				CASE Sampler.Color4End.GetID()
					MaxColor(ColorModel,Ref(ColorModel,4))=Sampler.Color4End.GetValue()
				CASE Sampler.Color1Steps.GetID()
					ColorSteps(ColorModel,Ref(ColorModel,1))=Sampler.Color1Steps.GetValue()
					if Identical then
						ColorSteps(ColorModel,Ref(ColorModel,2))=ColorSteps(ColorModel,Ref(ColorModel,1))
						ColorSteps(ColorModel,Ref(ColorModel,3))=ColorSteps(ColorModel,Ref(ColorModel,1))
						ColorSteps(ColorModel,Ref(ColorModel,4))=ColorSteps(ColorModel,Ref(ColorModel,1))
						SetControls 1
					end if
				CASE Sampler.Color2Steps.GetID()
					ColorSteps(ColorModel,Ref(ColorModel,2))=Sampler.Color2Steps.GetValue()
				CASE Sampler.Color3Steps.GetID()
					ColorSteps(ColorModel,Ref(ColorModel,3))=Sampler.Color3Steps.GetValue()
				CASE Sampler.Color4Steps.GetID()
					ColorSteps(ColorModel,Ref(ColorModel,4))=Sampler.Color4Steps.GetValue()
			END SELECT	
		CASE 2
			SELECT CASE ControlID%
				CASE Sampler.Generate.GetID()
					Sampler.CloseDialog 1
				CASE Sampler.ColorModel.GetID()
					ColorModel=Sampler.ColorModel.GetSelect()
					SELECT CASE ColorModel
						CASE 1
							Sampler.Axes.SetArray Axes_CMYK$
							Sampler.Axes.SetSelect Axis_CMYK%
						CASE 2
							Sampler.Axes.SetArray Axes_RGB$
							Sampler.Axes.SetSelect Axis_RGB%
					END SELECT
					DetermineAxes
					SetControls 0
				CASE Sampler.Axes.GetID()
					SELECT CASE ColorModel
						CASE 1
							Axis_CMYK%=Sampler.Axes.GetSelect()
						CASE 2
							Axis_RGB%=Sampler.Axes.GetSelect()
					END SELECT
					DetermineAxes
					SetControls 0
				CASE Sampler.Flip.GetID()
					FlipAxes=Sampler.Flip.GetValue()
					DetermineAxes
					SetControls 0
				CASE Sampler.Identical.GetID()
					Identical=Sampler.Identical.GetValue()
					if Identical<>0 then
						MinColor(ColorModel,Ref(ColorModel,2))=MinColor(ColorModel,Ref(ColorModel,1))
						MinColor(ColorModel,Ref(ColorModel,3))=MinColor(ColorModel,Ref(ColorModel,1))
						MinColor(ColorModel,Ref(ColorModel,4))=MinColor(ColorModel,Ref(ColorModel,1))
						MaxColor(ColorModel,Ref(ColorModel,2))=MaxColor(ColorModel,Ref(ColorModel,1))
						MaxColor(ColorModel,Ref(ColorModel,3))=MaxColor(ColorModel,Ref(ColorModel,1))
						MaxColor(ColorModel,Ref(ColorModel,4))=MaxColor(ColorModel,Ref(ColorModel,1))
						ColorSteps(ColorModel,Ref(ColorModel,2))=ColorSteps(ColorModel,Ref(ColorModel,1))
						ColorSteps(ColorModel,Ref(ColorModel,3))=ColorSteps(ColorModel,Ref(ColorModel,1))
						ColorSteps(ColorModel,Ref(ColorModel,4))=ColorSteps(ColorModel,Ref(ColorModel,1))
					end if
					DetermineAxes
					SetControls 0
			END SELECT
	END SELECT	
END SUB

BEGIN DIALOG OBJECT Working 205, 86, "Working...", SUB WorkFunc
	CANCELBUTTON  82, 63, 40, 14, .Cancel
	TEXT  92, 34, 20, 8, .Percent, "100%"
	PROGRESS 5, 46, 195, 8, .Progress
	TEXT  75, 5, 22, 8, .Text1, "Pages:"
	TEXT  101, 5, 50, 8, .Pages, "1 of 1"
	TEXT  73, 19, 26, 8, .Text2, "Blocks:"
	TEXT  101, 19, 50, 8, .Blocks, "1 of 1"
END DIALOG

SUB WorkFunc(BYVAL CtrlID%, BYVAL Event%)
SELECT CASE Event
	CASE 0
		UpdateProgress
		Working.SETTIMER 10
	CASE 5
		if Done then
			Working.CloseDialog 1
		else
			UpdateProgress
			DoOneStep
		endif		
END SELECT
END SUB

Sampler.Image.SetImage GetScriptFolder()+"\ColorSampler.bmp"
Sampler.Image.SetStyle 288
Sampler.ColorModel.SetArray ColorModels$
Sampler.ColorModel.SetSelect 1
Sampler.Axes.SetArray Axes_CMYK$
Sampler.Axes.SetSelect 1
Sampler.Layout.SetArray Layouts$
Sampler.Layout.SetSelect 1
Sampler.Flip.SetThreeState False
Sampler.Identical.SetThreeState False
for i%=1 to 2
	for j%=1 to 4
		MinColor(i,j)=0
		ColorSteps(i,j)=11
		Ref(i,j)=j
	next j
next i
for j%=1 to 4
	MaxColor(1,j)=100
	MaxColor(2,j)=255
next j
Axis(1,1)="C"
Axis(1,2)="M"
Axis(1,3)="Y"
Axis(1,4)="K"
Axis(2,1)="R"
Axis(2,2)="G"
Axis(2,3)="B"
Axis(2,4)=""
Identical=0
FlipAxes=0
DetermineAxes
SetControls 0

if Dialog(Sampler)=2 then stop

LayoutN%=Sampler.Layout.GetSelect()
XL%=XLayout(LayoutN)
YL%=YLayout(LayoutN)

ON ERROR RESUME NEXT
WithObject "CorelDRAW.Automation.7"
IF (ERRNUM > 0) THEN
	ERRNUM = 0
	MESSAGEBOX "Could not find CorelDRAW."+CHR(13)+ \\
 		     "If this error persists, you may need to re-install CorelDRAW.",\\
		     "Error",16
	STOP
ENDIF
ON ERROR GOTO Trap
.GetPageSize PageX&,PageY&
ON ERROR EXIT
if SGN(PageX-PageY)<>SGN(XL<YL) then XX%=XL:XL=YL:YL=XX
MarginX&=PageX*2\100 'Margin is 2% of page size
MarginY&=PageY*2\100
LeftOrg&=-PageX\2+MarginX
TopOrg&=PageY\2-MarginY

RectSizeX&=(PageX-MarginX*2)\((1+ColorSteps(ColorModel,Ref(ColorModel,1)))*XL)
RectSizeY&=(PageY-MarginY*2)\((2+ColorSteps(ColorModel,Ref(ColorModel,2)))*YL)

Step1=0
Step2=0
Step3=0
Step4=0
TileX=0
TileY=0
BlockX=0
BlockY=0
Done=false
TotalSteps&=ColorSteps(ColorModel,Ref(ColorModel,1))*ColorSteps(ColorModel,Ref(ColorModel,2))*ColorSteps(ColorModel,Ref(ColorModel,3))
if ColorModel=1 then TotalSteps=TotalSteps*ColorSteps(ColorModel,Ref(ColorModel,4))
TotalBlocks&=ColorSteps(ColorModel,Ref(ColorModel,3))
if ColorModel=1 then TotalBlocks=TotalBlocks*ColorSteps(ColorModel,Ref(ColorModel,4))
TotalPages&=(TotalBlocks-1)\(XL*YL)+1
CurrentStep&=0
CurrentPage&=1
CurrentBlock&=1
Working.Progress.SetMaxRange TotalSteps
UpdateProgress
Working.Percent.SetStyle 64
DIALOG Working
STOP

Trap:
	.FileNew
	RESUME

SUB DoOneStep
xb&=LeftOrg+RectSizeX*(ColorSteps(ColorModel,Ref(ColorModel,1))+1)*TileX
yb&=TopOrg-RectSizeY*(ColorSteps(ColorModel,Ref(ColorModel,2))+2)*TileY
Color(Ref(ColorModel,1))=GetColorValue(Step1,1)
Color(Ref(ColorModel,2))=GetColorValue(Step2,2)
Color(Ref(ColorModel,3))=GetColorValue(Step3,3)
Color(Ref(ColorModel,4))=GetColorValue(Step4,4)
.CreateRectangle yb-(Step2+1)*RectSizeY,xb+(Step1+1)*RectSizeX,yb-(Step2+2)*RectSizeY,xb+(Step1+2)*RectSizeX,0
.ApplyUniformFillColor ColorModel*3-1,Color(1),Color(2),Color(3),Color(4)
Step1=Step1+1
if Step1=ColorSteps(ColorModel,Ref(ColorModel,1)) then
	Step1=0
	Step2=Step2+1
	if Step2=ColorSteps(ColorModel,Ref(ColorModel,2)) then
		NumPoint&=RectSizeX*7\6000
		FOR x&=0 to ColorSteps(ColorModel,Ref(ColorModel,1))-1	
			.CreateArtisticText Num$(GetColorValue(x,1)),xb+(x+1.5)*RectSizeX,yb-0.9*RectSizeY
			.SetCharacterAttributes 0, 0, "Arial", 7, NumPoint, 0, 0, 0, 0, 0, 1000, 1000, 2
		NEXT x
		.GetSize tsx&,tsy&
		FOR y&=0 to ColorSteps(ColorModel,Ref(ColorModel,2))-1
			s$=Num$(GetColorValue(y,2))
			if y=0 then s$=Axis$(ColorModel,Ref(ColorModel,2))+"="+s$
			.CreateArtisticText s$,xb+0.95*RectSizeX,yb-(y+2)*RectSizeY+(RectSizeY-tsy)\2
			.SetCharacterAttributes 0, 0, "Arial", 7, NumPoint, 0, 0, 0, 0, 0, 1000, 1000, 3
		NEXT y
		.CreateArtisticText Axis$(ColorModel,Ref(ColorModel,1))+"=",xb+1.2*RectSizeX,yb-0.9*RectSizeY
		.SetCharacterAttributes 0, 0, "Arial", 7, NumPoint, 0, 0, 0, 0, 0, 1000, 1000, 3
		s$=Axis$(ColorModel,Ref(ColorModel,3))+"="+Num$(Color(Ref(ColorModel,3)))
		if ColorModel=1 then s$=s$+", "+Axis$(ColorModel,Ref(ColorModel,4))+"="+Num$(Color(Ref(ColorModel,4)))
		.CreateArtisticText s$,xb+RectSizeX+RectSizeX*ColorSteps(ColorModel,Ref(ColorModel,1))\2,yb-1.5*RectSizeY-RectSizeY*ColorSteps(ColorModel,Ref(ColorModel,2))
		.SetCharacterAttributes 0, 0, "Arial", 7, NumPoint, 0, 0, 0, 0, 0, 1000, 1000, 2

		Step2=0
		CurrentBlock=CurrentBlock+1
		TileX=TileX+1
		if TileX=XL then
			TileX=0
			TileY=TileY+1
			if TileY=YL then
				TileY=0
				if not done then
					.InsertPages FALSE,1
					CurrentPage=CurrentPage+1
				end if
			end if
		end if
		Step3=Step3+1
		if Step3=ColorSteps(ColorModel,Ref(ColorModel,3)) then
			if ColorModel=2 then
				done=true
			else
				Step3=0
				Step4=Step4+1
				if Step4=ColorSteps(ColorModel,Ref(ColorModel,4)) then done=true
			end if
		end if
	end if
end if
CurrentStep=CurrentStep+1
END SUB

SUB UpdateProgress
Working.Progress.SetValue CurrentStep
Working.Percent.SetText Num$(CurrentStep*100\TotalSteps)+"%"
Working.Pages.SetText Num$(CurrentPage)+" of "+Num$(TotalPages)
Working.Blocks.SetText Num$(CurrentBlock)+" of "+Num$(TotalBlocks)
END SUB

FUNCTION Num$(Number&)
Num$=LTRIM(STR(Number))
END FUNCTION

SUB SetControls(CtrlSet%)
min&=0
if ColorModel=1 then max&=100 else max&=255

if CtrlSet<>1 then
	Sampler.Color1Start.SetMinRange min
	Sampler.Color1Start.SetMaxRange max
	Sampler.Color1Start.SetValue MinColor(ColorModel,Ref(ColorModel,1))
	Sampler.Color1End.SetMinRange min
	Sampler.Color1End.SetMaxRange max
	Sampler.Color1End.SetValue MaxColor(ColorModel,Ref(ColorModel,1))
	Sampler.Color1Steps.SetMinRange 2
	Sampler.Color1Steps.SetMaxRange 256
	Sampler.Color1Steps.SetValue ColorSteps(ColorModel,Ref(ColorModel,1))
end if
if CtrlSet<>2 then
	Sampler.Color2Start.SetMinRange min
	Sampler.Color2Start.SetMaxRange max
	Sampler.Color2Start.SetValue MinColor(ColorModel,Ref(ColorModel,2))
	Sampler.Color2End.SetMinRange min
	Sampler.Color2End.SetMaxRange max
	Sampler.Color2End.SetValue MaxColor(ColorModel,Ref(ColorModel,2))
	Sampler.Color2Steps.SetMinRange 2
	Sampler.Color2Steps.SetMaxRange 256
	Sampler.Color2Steps.SetValue ColorSteps(ColorModel,Ref(ColorModel,2))
end if
if CtrlSet<>3 then
	Sampler.Color3Start.SetMinRange min
	Sampler.Color3Start.SetMaxRange max
	Sampler.Color3Start.SetValue MinColor(ColorModel,Ref(ColorModel,3))
	Sampler.Color3End.SetMinRange min
	Sampler.Color3End.SetMaxRange max
	Sampler.Color3End.SetValue MaxColor(ColorModel,Ref(ColorModel,3))
	Sampler.Color3Steps.SetMinRange 2
	Sampler.Color3Steps.SetMaxRange 256
	Sampler.Color3Steps.SetValue ColorSteps(ColorModel,Ref(ColorModel,3))
end if
if CtrlSet<>4 then
	Sampler.Color4Start.SetMinRange min
	Sampler.Color4Start.SetMaxRange max
	Sampler.Color4Start.SetValue MinColor(ColorModel,Ref(ColorModel,4))
	Sampler.Color4End.SetMinRange min
	Sampler.Color4End.SetMaxRange max
	Sampler.Color4End.SetValue MaxColor(ColorModel,Ref(ColorModel,4))
	Sampler.Color4Steps.SetMinRange 2
	Sampler.Color4Steps.SetMaxRange 256
	Sampler.Color4Steps.SetValue ColorSteps(ColorModel,Ref(ColorModel,4))
end if

Sampler.Color4Text.SetVisible ColorModel=1
Sampler.Color4Start.SetVisible ColorModel=1
Sampler.Color4End.SetVisible ColorModel=1
Sampler.Color4Steps.SetVisible ColorModel=1

Sampler.Color2Start.Enable Identical=0
Sampler.Color2End.Enable Identical=0
Sampler.Color2Steps.Enable Identical=0
Sampler.Color3Start.Enable Identical=0
Sampler.Color3End.Enable Identical=0
Sampler.Color3Steps.Enable Identical=0
Sampler.Color4Start.Enable Identical=0
Sampler.Color4End.Enable Identical=0
Sampler.Color4Steps.Enable Identical=0
END SUB

SUB DetermineAxes
SELECT CASE ColorModel
	CASE 1
		SELECT CASE Axis_CMYK
			CASE 1
				Ref(1,1)=1:Ref(1,2)=2:Ref(1,3)=3:Ref(1,4)=4
			CASE 2
				Ref(1,1)=1:Ref(1,2)=3:Ref(1,3)=2:Ref(1,4)=4
			CASE 3
				Ref(1,1)=1:Ref(1,2)=4:Ref(1,3)=2:Ref(1,4)=3
			CASE 4
				Ref(1,1)=2:Ref(1,2)=3:Ref(1,3)=1:Ref(1,4)=4
			CASE 5
				Ref(1,1)=2:Ref(1,2)=4:Ref(1,3)=1:Ref(1,4)=3
			CASE 6
				Ref(1,1)=3:Ref(1,2)=4:Ref(1,3)=1:Ref(1,4)=2
		END SELECT
		If FlipAxes then s%=Ref(1,1):Ref(1,1)=Ref(1,2):Ref(1,2)=s
	CASE 2
		SELECT CASE Axis_RGB
			CASE 1
				Ref(2,1)=1:Ref(2,2)=2:Ref(2,3)=3
			CASE 2
				Ref(2,1)=1:Ref(2,2)=3:Ref(2,3)=2
			CASE 3
				Ref(2,1)=2:Ref(2,2)=3:Ref(2,3)=1
		END SELECT
		If FlipAxes then s%=Ref(2,1):Ref(2,1)=Ref(2,2):Ref(2,2)=s
END SELECT
Sampler.Color1Text.SetText Axis$(ColorModel,Ref(ColorModel,1))+":"
Sampler.Color2Text.SetText Axis$(ColorModel,Ref(ColorModel,2))+":"
Sampler.Color3Text.SetText Axis$(ColorModel,Ref(ColorModel,3))+":"
Sampler.Color4Text.SetText Axis$(ColorModel,Ref(ColorModel,4))+":"
END SUB

FUNCTION GetColorValue&(StepValue&,Index&)
	rf&=Ref(ColorModel,Index)
	mn&=MinColor(ColorModel,rf)
	mx&=MaxColor(ColorModel,rf)
	GetColorValue=mn+StepValue*(mx-mn)\(ColorSteps(ColorModel,rf)-1)
END FUNCTION

END withobject


