REM Oberon Script Gallery 2.1. Oberon Enframer
REM Copyright  1997 Alex I. Vakulenko, Oberon

DECLARE SUB CreateFrame
DECLARE SUB EditFrame
DECLARE SUB StoreData
DECLARE SUB RestoreData
DECLARE SUB HideControls
DECLARE SUB EditVisualize
DECLARE SUB EnableCorners
DECLARE SUB DrawFrame(BYVAL x&,BYVAL y&,BYVAL sx&,BYVAL sy&,BYVAL tp%,BYVAL Width&)

GLOBAL CONST NumFrames%=14
GLOBAL CONST FrameFolder$="FRAMES\"

GLOBAL Grp&,Obj&
GLOBAL Style%,x&,y&,sx&,sy&
GLOBAL Width!,FrameType%,Height&
GLOBAL ListItems$(NumFrames)

GLOBAL Units$(4)
Units$(1)="mm"
Units$(2)="in"
Units$(3)="cm"
Units$(4)="pt"

GLOBAL UnitIndex%(4)
UnitIndex%(1)=2
UnitIndex%(2)=1
UnitIndex%(3)=2
UnitIndex%(4)=3

GLOBAL Widths&(8),Spacings&(7),NumLines%

#INCLUDE "Const.csi"
#INCLUDE "About.csi"

BEGIN DIALOG OBJECT MainDialog 247, 118, "Oberon Enframer", SUB MainDlgFunc
	TEXT  5, 4, 40, 8, .Text1, "Frame &Style:"
	IMAGELISTBOX  4, 15, 110, 95, .Style
	TEXT  123, 18, 22, 8, .Text2, "&Width:"
	TEXTBOX  149, 16, 52, 13, .Width
	DDLISTBOX  205, 16, 34, 52, .DDUnits
	GROUPBOX  121, 31, 118, 38, .GroupBox1, "Location"
	OPTIONGROUP .Location%
		OPTIONBUTTON  126, 42, 38, 10, .Outside, "&Outside"
		OPTIONBUTTON  166, 42, 36, 10, .Center, "&Center"
		OPTIONBUTTON  203, 42, 32, 10, .Inside, "&Inside"
	CHECKBOX  135, 55, 92, 10, .UseCorners, "&Use Corner Dimensions"
	TEXT  131, 78, 50, 8, .PreviewMode, "Preview Mode !"
	PUSHBUTTON  203, 76, 36, 14, .Edit, "&Edit..."
	TEXT  122, 73, 35, 8, .Working, "Working..."
	PROGRESS 121, 82, 118, 7, .Progress
	PUSHBUTTON  121, 96, 36, 14, .Apply, "&Apply"
	CANCELBUTTON  162, 96, 36, 14, .Cancel
	PUSHBUTTON  203, 96, 36, 14, .Preview, "&Preview"
	BITMAPBUTTON  239, 109, 8, 9, .About
END DIALOG

BEGIN DIALOG OBJECT CustomDlg 111, 193, "Custom Frame Settings", SUB CustomDlgFunc
	TEXT  11, 8, 53, 8, .Text1, "&Number of lines:"
	SPINCONTROL  67, 6, 28, 12, .NumLines
	TEXT  39, 29, 21, 8, .Text2, "Width"
	TEXT  71, 29, 30, 8, .Text3, "Spacing"
	TEXT  8, 41, 25, 8, .Line1, "Line &1:"
	SPINCONTROL  35, 39, 32, 12, .Width1
	SPINCONTROL  71, 46, 32, 12, .Spacing1
	GROUPBOX  2, 20, 108, 5, .GroupBox1
	TEXT  8, 56, 25, 8, .Line2, "Line &2:"
	SPINCONTROL  35, 54, 32, 12, .Width2
	SPINCONTROL  71, 61, 32, 12, .Spacing2
	TEXT  8, 71, 25, 8, .Line3, "Line &3:"
	SPINCONTROL  35, 69, 32, 12, .Width3
	SPINCONTROL  71, 76, 32, 12, .Spacing3
	TEXT  8, 86, 25, 8, .Line4, "Line &4:"
	SPINCONTROL  35, 84, 32, 12, .Width4
	SPINCONTROL  71, 91, 32, 12, .Spacing4
	TEXT  8, 101, 25, 8, .Line5, "Line &5:"
	SPINCONTROL  35, 99, 32, 12, .Width5
	SPINCONTROL  71, 106, 32, 12, .Spacing5
	TEXT  8, 116, 25, 8, .Line6, "Line &6:"
	SPINCONTROL  35, 114, 32, 12, .Width6
	SPINCONTROL  71, 121, 32, 12, .Spacing6
	TEXT  8, 131, 25, 8, .Line7, "Line &7:"
	SPINCONTROL  35, 129, 32, 12, .Width7
	SPINCONTROL  71, 136, 32, 12, .Spacing7
	TEXT  8, 146, 25, 8, .Line8, "Line &8:"
	SPINCONTROL  35, 144, 32, 12, .Width8
	GROUPBOX  2, 158, 108, 5, .GroupBox2
	OKBUTTON  7, 170, 40, 14, .OK
	CANCELBUTTON  63, 170, 40, 14, .Cancel
END DIALOG

'==================================================
on error goto handler
WITHOBJECT DRAWOBJECT

'======================= Main Dialog Box event handler =======================
SUB MainDlgFunc(BYVAL ControlID%, BYVAL EventCode%)
SELECT CASE EventCode
	CASE 0
		EnableCorners
 	CASE 2
 		SELECT CASE ControlID
 			CASE MainDialog.Style.GETID()
				EditVisualize
				EnableCorners
 			CASE MainDialog.About.GETID()
				AboutBox("Oberon Enframer")
 			CASE MainDialog.Preview.GETID()
				IF Grp<>0 THEN
					.SelectObjectOfCDRStaticID Grp
					.DeleteObject
				ENDIF
				CALL CreateFrame
				MainDialog.PreviewMode.SETVISIBLE TRUE
 			CASE MainDialog.Apply.GETID()
				IF Grp=0 THEN CALL CreateFrame
				Grp=0
				Obj=0
				MainDialog.PreviewMode.SETVISIBLE FALSE
 			CASE MainDialog.Outside.GETID()
				EnableCorners
 			CASE MainDialog.Center.GETID()
				EnableCorners
 			CASE MainDialog.Inside.GETID()
				EnableCorners
 			CASE MainDialog.Edit.GETID()
				EditFrame
		END SELECT
END SELECT
END Sub

'========== Custom Frame Dialog Box event handler =============
SUB CustomDlgFunc(BYVAL ControlID%, BYVAL EventCode%)
SELECT CASE EventCode
 	CASE 1
 		SELECT CASE ControlID
 			CASE CustomDlg.NumLines.GETID()
				NumLines=CustomDlg.NumLines.GETVALUE()
				HideControls
		END SELECT
END SELECT
END SUB

'====================== Main =======================

FOR i%=1 to NumFrames
	nm$=right("0"+LTRIM(STR(i)),2)
	ListItems$(i)=Path$+FrameFolder$+"Frame"+nm$+".bmp"
NEXT i
Style%=1
Width!=1
Grp=0
Obj=0
NumLines=2
for i=1 to 7
	Widths(i)=1
	Spacings(i)=1
next
Widths(8)=1
MainDialog.About.SETARRAY About$
MainDialog.Style.SETARRAY ListItems$
MainDialog.Style.SETSELECT Style%
MainDialog.DDUnits.SETARRAY Units$
MainDialog.DDUnits.SETSELECT 1
MainDialog.Width.SETTEXT LTRIM(Width!)
MainDialog.Edit.SETVISIBLE FALSE
MainDialog.PreviewMode.SETVISIBLE FALSE
MainDialog.Working.SETVISIBLE FALSE
MainDialog.Progress.SETVISIBLE FALSE
MainDialog.UseCorners.SETTHREESTATE FALSE
ret&=DIALOG(MainDialog)
IF ret=2 THEN
	IF Grp<>0 THEN
		.SelectObjectOfCDRStaticID Grp
		.DeleteObject
	ENDIF
	IF Obj<>0 THEN .SelectObjectOfCDRStaticID Obj
ENDIF
STOP

'====================== Create Frame =========================
SUB CreateFrame
ON ERROR GOTO CreateHandler
IF Grp=0 THEN
	.SetReferencePoint Ref3
	.GetPosition x&,y&
	.GetSize sx&,sy&
	Obj=.GetObjectsCDRStaticID()
END IF
x1&=x
y1&=y
sx1&=sx
sy1&=sy
v%=MainDialog.Location.GETVALUE()
Width!=VAL(MainDialog.Width.GETTEXT())
MainDialog.Width.SETTEXT LTRIM(Width!)
Height&=LENGTHCONVERT(UnitIndex(MainDialog.DDUnits.GETSELECT()),7,Width!)
if Height=0 then
	x1=MessageBox("You cannot draw a frame with zero width","Error",16)
	goto ExSub
endif
IF MainDialog.DDUnits.GETSELECT()=1 THEN Height&=Height&\10
h&=Height
if MainDialog.Style.GETSELECT()=11 and MainDialog.Location.GETVALUE()>0 and MainDialog.UseCorners.GETVALUE()<>0 then h=Height*29\20
if v>0 then
	x1=x+h*v\2
	y1=y-h*v\2
	sx1=sx-h*v
	sy1=sy-h*v
	if sx1<1 or sy1<1 then
		rt&=MessageBox("Object is too small to accomodate the frame with the location specified"+CHR(13)+"The frame will be drawn outside the object","Warning",48)
		x1=x
		y1=y
		sx1=sx
		sy1=sy
	endif
endif
MainDialog.Edit.SETVISIBLE FALSE
MainDialog.PreviewMode.SETVISIBLE FALSE
MainDialog.Progress.SETVALUE 0
MainDialog.Progress.SETMAXRANGE 100
MainDialog.Progress.SETINCREMENT 1
MainDialog.Working.SETVISIBLE TRUE
MainDialog.Progress.SETVISIBLE TRUE
MainDialog.Apply.ENABLE FALSE
MainDialog.Cancel.ENABLE FALSE
MainDialog.Preview.ENABLE FALSE
CALL DrawFrame x1,y1,sx1,sy1,MainDialog.Style.GETSELECT(),Height
MainDialog.Working.SETVISIBLE FALSE
MainDialog.Progress.SETVISIBLE FALSE
EditVisualize
MainDialog.PreviewMode.SETVISIBLE Grp<>0
MainDialog.Apply.ENABLE TRUE
MainDialog.Cancel.ENABLE TRUE
MainDialog.Preview.ENABLE TRUE
ExSub:
EXIT SUB

CreateHandler:
	IF ERRNUM = 5010 THEN
		MESSAGE "Nothing selected"+CHR(13)+"You should select an object first"
	ELSE
		MESSAGE "Error "+STR(ERRNUM)+" encountered"
	END IF
	ERRNUM=0
ON ERROR RESUME NEXT
.ResumePainting
RESUME AT ExSub
END SUB

'======================== Draw Frame ========================
SUB DrawFrame(BYVAL x&,BYVAL y&,BYVAL sx&,BYVAL sy&,BYVAL tp%,BYVAL Width&)
ON ERROR GOTO DrawHandler
.SuppressPainting
SELECT CASE tp
	CASE 1
		.CreateRectangle y+Width\2,x-Width\2,y-sy-Width\2,x+sx+Width\2,0
		.ApplyOutline Width,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.ApplyNoFill
		MainDialog.Progress.SETVALUE 100
	CASE 2
		.StartOfRecording
		.SuppressPainting
		.CreateRectangle y+Width\6,x-Width\6,y-sy-Width\6,x+sx+Width\6,0
		MainDialog.Progress.SETVALUE 50
		.CreateRectangle y+Width*5\6,x-Width*5\6,y-sy-Width*5\6,x+sx+Width*5\6,0
		MainDialog.Progress.SETVALUE 100
		.RecorderSelectObjectsByIndex TRUE,1,2,-1,-1,-1
		.ApplyOutline Width\3,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.Group
		.ApplyNoFill
		.EndOfRecording
	CASE 3
		.StartOfRecording
		.SuppressPainting
		.CreateRectangle y+Width\4,x-Width\4,y-sy-Width\4,x+sx+Width\4,0
		MainDialog.Progress.SETVALUE 50
		.ApplyOutline Width\2,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.CreateRectangle y+Width*11\12,x-Width*11\12,y-sy-Width*11\12,x+sx+Width*11\12,0
		MainDialog.Progress.SETVALUE 100
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.RecorderSelectObjectsByIndex TRUE,1,2,-1,-1,-1
		.Group
		.ApplyNoFill
		.EndOfRecording
	CASE 4
		.StartOfRecording
		.SuppressPainting
		.CreateRectangle y+Width\12,x-Width\12,y-sy-Width\12,x+sx+Width\12,0
		MainDialog.Progress.SETVALUE 33
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.CreateRectangle y+Width*3\4,x-Width*3\4,y-sy-Width*3\4,x+sx+Width*3\4,0
		MainDialog.Progress.SETVALUE 66
		.ApplyOutline Width\2,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.RecorderSelectObjectsByIndex TRUE,1,2,-1,-1,-1
		.Group
		.ApplyNoFill
		MainDialog.Progress.SETVALUE 100
		.EndOfRecording
	CASE 5
		.StartOfRecording
		.SuppressPainting
		.CreateRectangle y+Width\12,x-Width\12,y-sy-Width\12,x+sx+Width\12,0
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 25
		.CreateRectangle y+Width\2,x-Width\2,y-sy-Width\2,x+sx+Width\2,0
		.ApplyOutline Width\3,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 50
		.CreateRectangle y+Width*11\12,x-Width*11\12,y-sy-Width*11\12,x+sx+Width*11\12,0
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 75
		.RecorderSelectObjectsByIndex TRUE,1,2,3,-1,-1
		.Group
		.ApplyNoFill
		MainDialog.Progress.SETVALUE 100
		.EndOfRecording
	CASE 6
		.StartOfRecording
		.SuppressPainting
		.CreateRectangle y+Width*3\24,x-Width*3\24,y-sy-Width*3\24,x+sx+Width*3\24,0
		.ApplyOutline Width\4,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 25
		.CreateRectangle y+Width\2,x-Width\2,y-sy-Width\2,x+sx+Width\2,0
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 50
		.CreateRectangle y+Width*21\24,x-Width*21\24,y-sy-Width*21\24,x+sx+Width*21\24,0
		.ApplyOutline Width\4,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 75
		.RecorderSelectObjectsByIndex TRUE,1,2,3,-1,-1
		.Group
		.ApplyNoFill
		MainDialog.Progress.SETVALUE 100
		.EndOfRecording
	CASE 7
		.StartOfRecording
		.SuppressPainting
		.CreateRectangle y+Width\12,x-Width\12,y-sy-Width\12,x+sx+Width\12,0
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 25
		.CreateRectangle y+Width\2,x-Width\2,y-sy-Width\2,x+sx+Width\2,0
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 50
		.CreateRectangle y+Width*11\12,x-Width*11\12,y-sy-Width*11\12,x+sx+Width*11\12,0
		.ApplyOutline Width\6,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		MainDialog.Progress.SETVALUE 75
		.RecorderSelectObjectsByIndex TRUE,1,2,3,-1,-1
		.Group
		.ApplyNoFill
		MainDialog.Progress.SETVALUE 100
		.EndOfRecording
	CASE 8
		.StartOfRecording
		.SuppressPainting
		ds&=3*Width\202
		d&=0
		FOR i%=1 to 8
			w&=(2*i+1)*Width\101
			dl&=d*Width\101+ds
			.CreateRectangle y+dl,x-dl,y-dl-sy,x+sx+dl
			.ApplyOutline w,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
			d=d+2*i+5
			MainDialog.Progress.SETVALUE i*100\9
		NEXT i
		.RecorderSelectObjectsByIndex TRUE,1,2,3,4,5
		.RecorderSelectObjectsByIndex FALSE,6,7,8,-1,-1
		.Group
		.ApplyNoFill
		MainDialog.Progress.SETVALUE 100
		.EndOfRecording
	CASE 9
		.StartOfRecording
		.SuppressPainting
		d&=3
		FOR i%=1 to 8
			w&=(2*i+1)*Width\101
			dl&=(200-d)*Width\202
			.CreateRectangle y+dl,x-dl,y-dl-sy,x+sx+dl
			.ApplyOutline w,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
			d=d+4*i+10
			MainDialog.Progress.SETVALUE i*100\9
		NEXT i
		.RecorderSelectObjectsByIndex TRUE,1,2,3,4,5
		.RecorderSelectObjectsByIndex FALSE,6,7,8,-1,-1
		.Group
		.ApplyNoFill
		MainDialog.Progress.SETVALUE 100
		.EndOfRecording
	CASE 10
		MainDialog.Progress.SETMAXRANGE NumLines*2
		sum&=0
		total&=Widths(1)
		for i=2 to NumLines
			total=total+Spacings(i-1)+Widths(i)
		next
		.StartOfRecording
		.SuppressPainting
		for i=1 to NumLines
			dl&=Widths(i)*Width\total
			d&=sum+dl\2
			.CreateRectangle y+d,x-d,y-sy-d,x+sx+d,0
			.ApplyOutline dl,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
			if i<NumLines then dl=dl+Spacings(i)*Width\total
			sum=sum+dl
			MainDialog.Progress.STEP
		next
		.RecorderSelectObjectByIndex TRUE,1
		for i=2 to NumLines
			.RecorderSelectObjectByIndex FALSE,i
			MainDialog.Progress.STEP
		next
		.Group
		.ApplyNoFill
		MainDialog.Progress.STEP
		.EndOfRecording
	CASE 11
		MainDialog.Progress.SETMAXRANGE 16
		.StartOfRecording
		.SuppressPainting
		.CreateRectangle y+Width*2\5,x-Width*2\5,y-sy-Width*2\5,x+sx+Width*2\5,0
		'====== #1
		.ApplyOutline Width*4\5,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.ApplyNoFill
		MainDialog.Progress.STEP '1
		.CreateRectangle y+Width*19\20,x-Width*19\20,y-sy-Width*19\20,x+sx+Width*19\20,0
		'====== #2
		.ApplyOutline Width\10,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.ApplyNoFill
		MainDialog.Progress.STEP '2
		IF DrawVersion=8 THEN
			.GetOutlineColor t&,cc&,mm&,yy&,kk&,cl5&,cl6&,cl7&
		ELSE
			.GetOutlineColor t&,cc&,mm&,yy&,kk&
		ENDIF
		dx&=x+sx+Width\20
		dy&=y+Width\20
		sq&=Width*12\10
		.FileImport Path$+FrameFolder$+"fr08.cmx"
		.SetSize Width*24\10,Width*24\10
		.SetReferencePoint Ref9
		.SetPosition dx,dy
'		ID&=.GetObjectsCDRStaticID()
		IF DrawVersion=8 THEN
			.StoreColor 5002,0,0,0,0
			.ApplyUniformFillColor
		ELSE
			.ApplyUniformFillColor 2,0,0,0,0
		ENDIF
		.ApplyOutline Width\10,1,0,0,100,0,0,0,0,FALSE,0,0,FALSE
		IF DrawVersion=8 THEN
			.StoreColor t&,cc&,mm&,yy&,kk&,cl5&,cl6&,cl7&
			.SetOutlineColor
		ELSE
			.SetOutlineColor t&,cc&,mm&,yy&,kk&
		ENDIF
		MainDialog.Progress.STEP '3
		.DuplicateObject 0,0
		'------ #3
		.RotateObject 90000000,TRUE,0,0
		.MoveObject -sx-Width\10,0
		MainDialog.Progress.STEP	'4
		.DuplicateObject 0,0
		'------ #4
		.RotateObject 90000000,TRUE,0,0
		.MoveObject 0,-sy-Width\10
		MainDialog.Progress.STEP	'5
		.DuplicateObject 0,0
		'------ #5
		.RotateObject 90000000,TRUE,0,0
		.MoveObject sx+Width\10,0
		.RecorderSelectObjectsByIndex TRUE,3,4,5,6,-1
'		.AppendObjectToSelection ID
		.Group
		MainDialog.Progress.STEP	'6
		'====== #6
		sq=Width*13\10
		hf&=Width\2
		.CreateRectangle y+sq,x-sq,y+hf,x-hf
		MainDialog.Progress.STEP	'7
		'------ #7
		.CreateRectangle y-sy-hf,x-sq,y-sy-sq,x-hf
		MainDialog.Progress.STEP	'8
		'------ #8
		.CreateRectangle y-sy-hf,x+sx+hf,y-sy-sq,x+sx+sq
		MainDialog.Progress.STEP	'9
		'------ #9
		.CreateRectangle y+sq,x+sx+hf,y+hf,x+sx+sq
		MainDialog.Progress.STEP	'10
		'------ #10
		.RecorderSelectObjectsByIndex TRUE,8,9,10,11,-1
		IF DrawVersion=8 THEN
			.StoreColor t&,cc&,mm&,yy&,kk&,cl5&,cl6&,cl7&
			.ApplyUniformFillColor
		ELSE
			.ApplyUniformFillColor t&,cc&,mm&,yy&,kk&
		ENDIF
		.CreateRectangle y+hf,x-hf,y-sy-hf,x+sx+hf
		.ApplyNoFill
		MainDialog.Progress.STEP	'11
		'------ #11
		.RecorderSelectObjectsByIndex FALSE,8,9,10,11,-1
		.ApplyOutline Width*3\10,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.Group
		MainDialog.Progress.STEP	'12
		'======= #12
		.DuplicateObject 0,0
		MainDialog.Progress.STEP	'13
		'------- #13
		.ApplyOutline Width\10,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		IF DrawVersion=8 THEN
			.StoreColor 5002,0,0,0,0
			.SetOutlineColor
		ELSE
			.SetOutlineColor 2,0,0,0,0
		ENDIF
		.ApplyNoFill
		.RecorderSelectObjectByIndex FALSE,13
		.Group
		'======= #14
		MainDialog.Progress.STEP	'14
		.CreateRectangle y+Width\20,x-Width\20,y-sy-Width\20,x+sx+Width\20,0
		.ApplyOutline Width\10,1,0,0,100,0,0,0,0,FALSE,0,0,TRUE
		.ApplyNoFill
		MainDialog.Progress.STEP	'15
		'======= #15
		.RecorderSelectObjectsByIndex TRUE,1,2,7,15,16
		.Group
		MainDialog.Progress.STEP	'16
		.EndOfRecording
	CASE 12
		.FileImport Path$+FrameFolder$+"fr09-1.cmx"
		.SetSize Width,Width
		ID1&=.GetObjectsCDRStaticID()
		.FileImport Path$+FrameFolder$+"fr09-2.cmx"
		.GetSize xx&,yy&
		s#=Width/yy
		w2&=CLNG(xx*s)
		.SetSize w2,Width
		ID2&=.GetObjectsCDRStaticID()
		.FileImport Path$+FrameFolder$+"fr09-3.cmx"
		.GetSize xx&,yy&
		s#=Width/yy
		w3&=CLNG(xx*s)
		.SetSize w3,Width
		ID3&=.GetObjectsCDRStaticID()
		.FileImport Path$+FrameFolder$+"fr09-4.cmx"
		.GetSize xx&,yy&
		s#=Width/xx
		w4&=CLNG(yy*s)
		.SetSize Width,w4
		ID4&=.GetObjectsCDRStaticID()
		.FileImport Path$+FrameFolder$+"fr09-5.cmx"
		.GetSize xx&,yy&
		s#=Width/xx
		w5&=CLNG(yy*s)
		.SetSize Width,w5
		ID5&=.GetObjectsCDRStaticID()

		MainDialog.Progress.SETMAXRANGE 12+(sx-2*w2)*2\w3+(sy-2*w2)*2\w3
		
		.StartOfRecording
		.SuppressPainting
		.SelectObjectOfCDRStaticID ID1
		.DuplicateObject 0,0
		'==== 1
		MainDialog.Progress.STEP '1
		.SetReferencePoint Ref7
		.SetPosition x,y
		.DuplicateObject sx+Width,0
		'==== 2		
		.StretchObject 1,1,1,1,TRUE,FALSE,9
		MainDialog.Progress.STEP '2
		.SelectObjectOfCDRStaticID ID2
		.DuplicateObject 0,0
		'==== 3
		.SetReferencePoint Ref5
		.SetPosition x,y
		MainDialog.Progress.STEP '3
		n&=(sx-2*w2)\w3
		if n<0 then n=0
		.DuplicateObject w2+w3*n,0
		.StretchObject 1,1,1,1,TRUE,FALSE,9
		'==== 4
		MainDialog.Progress.STEP '4
		if n>0 then
			.SelectObjectOfCDRStaticID ID3
			.DuplicateObject 0,0
			'==== 5
			MainDialog.Progress.STEP '4+n
			.SetReferencePoint Ref5
			.SetPosition x+w2,y
			if n>1 then
				for i%=2 to n
					.DuplicateObject w3,0
					MainDialog.Progress.STEP '4+n
				next
			endif
		endif
		.RecorderSelectObjectsByIndex TRUE,3,4,-1,-1,-1
		if n>0 then
			for i=1 to n
				.RecorderSelectObjectByIndex FALSE,i+4
				MainDialog.Progress.STEP '4+n
			next
		endif
		.SetSize sx,Width
		.SetReferencePoint Ref5
		.SetPosition x,y
		.RecorderSelectObjectsByIndex FALSE,1,2,-1,-1,-1
		.Group
		MainDialog.Progress.STEP '5
		ID_Top&=.GetObjectsCDRStaticID()
		.DuplicateObject 0,-sy-Width
		ID_Bottom&=.GetObjectsCDRStaticID()
		.StretchObject 1,1,1,1,FALSE,TRUE,9
		.EndOfRecording
		MainDialog.Progress.STEP '6

		.StartOfRecording
		.SuppressPainting
		n&=(sy-2*w4)\w3
		if n<0 then n=0
		.SelectObjectOfCDRStaticID ID4
		.DuplicateObject 0,0
		'==== 1
		.SetReferencePoint Ref1
		.SetPosition x,y
		MainDialog.Progress.STEP '7
		.DuplicateObject 0,-w4-w5*n
		.StretchObject 1,1,1,1,FALSE,TRUE,9
		'==== 2
		MainDialog.Progress.STEP '8
		if n>0 then
			.SelectObjectOfCDRStaticID ID5
			.DuplicateObject 0,0
			'==== 3
			.SetReferencePoint Ref1
			.SetPosition x,y-w4
			MainDialog.Progress.STEP '8+n
			if n>1 then
				for i%=2 to n
					.DuplicateObject 0,-w5
					MainDialog.Progress.STEP '8+n
				next
			endif
		endif
		.RecorderSelectObjectsByIndex TRUE,1,2,-1,-1,-1
		if n>0 then
			for i=1 to n
				.RecorderSelectObjectByIndex FALSE,2+i
				MainDialog.Progress.STEP '8+n
			next
		endif
 		.SetSize Width,sy
 		.SetReferencePoint Ref1
 		.SetPosition x,y
		.Group
		MainDialog.Progress.STEP '9
		ID_Left&=.GetObjectsCDRStaticID()
		.DuplicateObject sx+Width,0
		ID_Right&=.GetObjectsCDRStaticID()
		MainDialog.Progress.STEP '10
		.StretchObject 1,1,1,1,TRUE,FALSE,9
		.EndOfRecording

		.SelectObjectOfCDRStaticID ID1
		.AppendObjectToSelection ID2
 		.AppendObjectToSelection ID3
		.AppendObjectToSelection ID4
 		.AppendObjectToSelection ID5
		.DeleteObject
		MainDialog.Progress.STEP '11
		.SelectObjectOfCDRStaticID ID_Top
		.AppendObjectToSelection ID_Bottom
		.AppendObjectToSelection ID_Left
		.AppendObjectToSelection ID_Right
		.Group
		MainDialog.Progress.STEP '12
	CASE 13
		.CreateRectangle 1000,-1000,-1000,1000
		IF DrawVersion=8 THEN
			.GetOutlineColor t&,cc&,mm&,yy&,kk&,cl5&,cl6&,cl7&
		ELSE
			.GetOutlineColor t&,cc&,mm&,yy&,kk&
		ENDIF
		.DeleteObject
		.FileImport Path$+FrameFolder$+"fr10.cmx"
		IF DrawVersion=8 THEN
			.StoreColor t&,cc&,mm&,yy&,kk&,cl5&,cl6&,cl7&
			.ApplyUniformFillColor
		ELSE
			.ApplyUniformFillColor t&,cc&,mm&,yy&,kk&
		ENDIF
		mb&=CLNG(Width*3.15530#)
		MainDialog.Progress.SETVALUE 25
		.SetSize mb,mb
		.SetReferencePoint Ref3
		.SetPosition x-Width,y+Width
		ID&=.GetObjectsCDRStaticID()
		.StartOfRecording
		.SuppressPainting
		.DuplicateObject 0,0
		MainDialog.Progress.SETVALUE 50
		.StretchObject 1,1,1,1,TRUE,FALSE,9
		.SetReferencePoint Ref1
		.SetPosition x+sx+Width,y+Width
		.AppendObjectToSelection id
		.DuplicateObject 0,0
		MainDialog.Progress.SETVALUE 75
		.StretchObject 1,1,1,1,FALSE,TRUE,9
		.SetReferencePoint Ref5
		.SetPosition x-Width,y-sy-Width
		.RecorderSelectObjectByIndex FALSE,1
		.AppendObjectToSelection id
		.EndOfRecording
		.Group
		MainDialog.Progress.SETVALUE 100
	CASE 14
		MainDialog.Progress.SETMAXRANGE 25+(11*sx\Width-7)\4+(11*sy\Width-7)\4
		.StartOfRecording
		.SuppressPainting
		mb&=Width*17\22
		ms&=Width*5\22
		.CreateRectangle y+mb,x-mb,y+ms,x-ms,0
		MainDialog.Progress.STEP '1
		.CreateRectangle y+Width*13\22,x-Width*13\22,y+Width*9\22,x-Width*9\22,0
		MainDialog.Progress.STEP '2
		.GetOutlineColor t&,cc&,mm&,yy&,kk&
		.RecorderSelectObjectByIndex FALSE,1
		.Group
		MainDialog.Progress.STEP '3
		'----- #3
		.DuplicateObject sx+Width,0
		MainDialog.Progress.STEP '4
		'----- #4
		.RecorderSelectObjectByIndex FALSE,3
		.DuplicateObject 0,-sy-Width
		MainDialog.Progress.STEP '5
		.RecorderSelectObjectsByIndex FALSE,3,4,-1,-1,-1
		.Group
		'================ #7
		MainDialog.Progress.STEP '6
		.CreateRectangle y+Width*21\22,x-Width*21\22,y-sy-Width*21\22,x+sx+Width*21\22,0
		'----- #8
		MainDialog.Progress.STEP '7
		.BeginDrawCurve x-Width\22,y+Width*10\11
		.DrawCurveLineTo x-Width\22,y-sy-Width*10\11
		.EndDrawCurve
		MainDialog.Progress.STEP '8
		'----- #9
		.DuplicateObject sx+Width\11,0
		MainDialog.Progress.STEP '9
		'----- #10
		.BeginDrawCurve x-Width*10\11,y+Width\22
		.DrawCurveLineTo x+sx+Width*10\11,y+Width\22
		.EndDrawCurve
		MainDialog.Progress.STEP '10
		'----- #11
		.DuplicateObject 0,-sy-Width\11
		MainDialog.Progress.STEP '11
		'----- #12
		.RecorderSelectObjectsByIndex FALSE,11,10,9,8,-1
		.Group
		MainDialog.Progress.STEP '12
		.RecorderSelectObjectByIndex FALSE,7
		.Group
		MainDialog.Progress.STEP '13
		'================ #13
		ID&=.GetObjectsCDRStaticID()
		.EndOfRecording
		
		n&=(11*sx\Width-7)\8
		if n<0 then n=0
		.FileImport Path$+FrameFolder$+"fr11-1.cmx"
		.SetSize Width*15\22,Width*6\11
		ID_Start&=.GetObjectsCDRStaticID()
		MainDialog.Progress.STEP '14
		.FileImport Path$+FrameFolder$+"fr11-2.cmx"
		.SetSize Width*12\11,Width*6\11
		ID_Mid&=.GetObjectsCDRStaticID()
		MainDialog.Progress.STEP '15
		
		.StartOfRecording
		.SuppressPainting
		.SelectObjectOfCDRStaticID ID_Start
		.DuplicateObject 0,0
		'==== 1
		MainDialog.Progress.STEP '16
		.SetReferencePoint Ref5
		.SetPosition x,y+ms
		.DuplicateObject 0,0
		'==== 2
		.RotateObject 180000000,TRUE,0,0
		.SetPosition x+(7+16*n)*Width\22,y+ms
		MainDialog.Progress.STEP '17
		if n>0 then
			.SelectObjectOfCDRStaticID ID_Mid
			.DuplicateObject 0,0
			'==== 3
			MainDialog.Progress.STEP '17+n
			.SetPosition x+Width*7\22,y+ms
			if n>1 then
				for i%=1 to n-1
					.DuplicateObject Width*8\11,0
					MainDialog.Progress.STEP '17+n
				next
			endif
		endif
		.RecorderSelectObjectsByIndex TRUE,1,2,-1,-1,-1
		if n>0 then
			for i=1 to n
				.RecorderSelectObjectByIndex FALSE,i+2
				MainDialog.Progress.STEP '17+n
			next
		endif
		.Group
		MainDialog.Progress.STEP '18
		.EndOfRecording
		.SetSize sx,Width*6\11
		.SetPosition x,y+ms
		ID_Top&=.GetObjectsCDRStaticID()
		.DuplicateObject 0,-sy-Width
		.StretchObject 1,1,1,1,FALSE,TRUE,9
		ID_Bottom&=.GetObjectsCDRStaticID()
		MainDialog.Progress.STEP '19
		
		n&=(11*sy\Width-7)\8
		if n<0 then n=0
		.StartOfRecording
		.SuppressPainting
		.SelectObjectOfCDRStaticID ID_Start
		.DuplicateObject 0,0
		.RotateObject -90000000,TRUE,0,0
		MainDialog.Progress.STEP '20
		'==== 1
		.SetReferencePoint Ref1
		.SetPosition x-ms,y
		.DuplicateObject 0,0
		'==== 2
		.RotateObject 180000000,TRUE,0,0
		.SetPosition x-ms,y-(7+16*n)*Width\22
		MainDialog.Progress.STEP '21
		if n>0 then
			.SelectObjectOfCDRStaticID ID_Mid
			.DuplicateObject 0,0
			.RotateObject -90000000,TRUE,0,0
			'==== 3
			.SetPosition x-ms,y-Width*7\22
			MainDialog.Progress.STEP '21+n
			if n>1 then
				for i%=1 to n-1
					.DuplicateObject 0,-Width*8\11
					MainDialog.Progress.STEP '21+n
				next
			endif
		endif
		.RecorderSelectObjectsByIndex TRUE,1,2,-1,-1,-1
		if n>0 then
			for i=1 to n
				.RecorderSelectObjectByIndex FALSE,i+2
				MainDialog.Progress.STEP '21+n
			next
		endif
		.Group
		.EndOfRecording
		.SetSize Width*6\11,sy
		.SetPosition x-ms,y
		ID_Left&=.GetObjectsCDRStaticID()
		MainDialog.Progress.STEP '22
		.DuplicateObject sx+Width,0
		.StretchObject 1,1,1,1,TRUE,FALSE,9
		ID_Right&=.GetObjectsCDRStaticID()
		MainDialog.Progress.STEP '23

		.SelectObjectOfCDRStaticID ID_Start
		.DeleteObject
		.SelectObjectOfCDRStaticID ID_Mid
		.DeleteObject
 		.SelectObjectOfCDRStaticID ID
		MainDialog.Progress.STEP '24
		.AppendObjectToSelection ID_Top
		.AppendObjectToSelection ID_Bottom
		.AppendObjectToSelection ID_Left
		.AppendObjectToSelection ID_Right
 		.ApplyOutline Width\11,1,0,0,100,0,0,0,0,FALSE,0,0,FALSE
		IF DrawVersion=8 THEN
			.StoreColor t&,cc&,mm&,yy&,kk&,cl5&,cl6&,cl7&
			.SetOutlineColor
		ELSE
			.SetOutlineColor t&,cc&,mm&,yy&,kk&
		ENDIF
 		.Group
		.ApplyNoFill
		MainDialog.Progress.STEP '25
END SELECT
Grp=.GetObjectsCDRStaticID()
.ResumePainting
ReturnHere:
EXIT SUB
DrawHandler:
.ResumePainting
ret&=MessageBox("Error"+STR(ERRNUM)+" encountered while drawing the frame."+CHR(13)+"This error can occur due to an error in CorelSCRIPT."+CHR(13)+"Try to zoom in and run the script again.","Error",16)
	ERRNUM=0
RESUME AT ReturnHere
END SUB

SUB EditVisualize
ss%=MainDialog.Style.GETSELECT()
if ss=10 then 
	MainDialog.Edit.SETVISIBLE TRUE
else
	MainDialog.Edit.SETVISIBLE FALSE
endif
END SUB

SUB EnableCorners
MainDialog.UseCorners.ENABLE MainDialog.Style.GETSELECT()=11 and MainDialog.Location.GETVALUE()>0
END SUB

SUB EditFrame
	RestoreData
	HideControls
	CustomDlg.NumLines.SETMINRANGE 2
	CustomDlg.NumLines.SETMAXRANGE 8
	CustomDlg.Width1.SETMINRANGE 1
	CustomDlg.Width2.SETMINRANGE 1
	CustomDlg.Width3.SETMINRANGE 1
	CustomDlg.Width4.SETMINRANGE 1
	CustomDlg.Width5.SETMINRANGE 1
	CustomDlg.Width6.SETMINRANGE 1
	CustomDlg.Width7.SETMINRANGE 1
	CustomDlg.Width8.SETMINRANGE 1
	CustomDlg.Spacing1.SETMINRANGE 1
	CustomDlg.Spacing2.SETMINRANGE 1
	CustomDlg.Spacing3.SETMINRANGE 1
	CustomDlg.Spacing4.SETMINRANGE 1
	CustomDlg.Spacing5.SETMINRANGE 1
	CustomDlg.Spacing6.SETMINRANGE 1
	CustomDlg.Spacing7.SETMINRANGE 1
	ret%=DIALOG(CustomDlg)
	if ret=1 then StoreData
END SUB

SUB StoreData
Widths(1)=CustomDlg.Width1.GETVALUE()
Widths(2)=CustomDlg.Width2.GETVALUE()
Widths(3)=CustomDlg.Width3.GETVALUE()
Widths(4)=CustomDlg.Width4.GETVALUE()
Widths(5)=CustomDlg.Width5.GETVALUE()
Widths(6)=CustomDlg.Width6.GETVALUE()
Widths(7)=CustomDlg.Width7.GETVALUE()
Widths(8)=CustomDlg.Width8.GETVALUE()
Spacings(1)=CustomDlg.Spacing1.GETVALUE()
Spacings(2)=CustomDlg.Spacing2.GETVALUE()
Spacings(3)=CustomDlg.Spacing3.GETVALUE()
Spacings(4)=CustomDlg.Spacing4.GETVALUE()
Spacings(5)=CustomDlg.Spacing5.GETVALUE()
Spacings(6)=CustomDlg.Spacing6.GETVALUE()
Spacings(7)=CustomDlg.Spacing7.GETVALUE()
END SUB

SUB RestoreData
CustomDlg.Width1.SETVALUE Widths(1)
CustomDlg.Width2.SETVALUE Widths(2)
CustomDlg.Width3.SETVALUE Widths(3)
CustomDlg.Width4.SETVALUE Widths(4)
CustomDlg.Width5.SETVALUE Widths(5)
CustomDlg.Width6.SETVALUE Widths(6)
CustomDlg.Width7.SETVALUE Widths(7)
CustomDlg.Width8.SETVALUE Widths(8)
CustomDlg.Spacing1.SETVALUE Spacings(1)
CustomDlg.Spacing2.SETVALUE Spacings(2)
CustomDlg.Spacing3.SETVALUE Spacings(3)
CustomDlg.Spacing4.SETVALUE Spacings(4)
CustomDlg.Spacing5.SETVALUE Spacings(5)
CustomDlg.Spacing6.SETVALUE Spacings(6)
CustomDlg.Spacing7.SETVALUE Spacings(7)
CustomDlg.NumLines.SETVALUE NumLines
END SUB

SUB HideControls
CustomDlg.Line3.SETVISIBLE NumLines>2
CustomDlg.Line4.SETVISIBLE NumLines>3
CustomDlg.Line5.SETVISIBLE NumLines>4
CustomDlg.Line6.SETVISIBLE NumLines>5
CustomDlg.Line7.SETVISIBLE NumLines>6
CustomDlg.Line8.SETVISIBLE NumLines>7
CustomDlg.Width3.SETVISIBLE NumLines>2
CustomDlg.Width4.SETVISIBLE NumLines>3
CustomDlg.Width5.SETVISIBLE NumLines>4
CustomDlg.Width6.SETVISIBLE NumLines>5
CustomDlg.Width7.SETVISIBLE NumLines>6
CustomDlg.Width8.SETVISIBLE NumLines>7
CustomDlg.Spacing2.SETVISIBLE NumLines>2
CustomDlg.Spacing3.SETVISIBLE NumLines>3
CustomDlg.Spacing4.SETVISIBLE NumLines>4
CustomDlg.Spacing5.SETVISIBLE NumLines>5
CustomDlg.Spacing6.SETVISIBLE NumLines>6
CustomDlg.Spacing7.SETVISIBLE NumLines>7
END SUB

'==================== Main Error Handler ====================
HANDLER :
	IF ERRNUM = 5010 THEN
		MESSAGE "No object selected"
	ELSE
		MESSAGE "Error "+STR(ERRNUM)+" encountered"
	END IF
	ERRNUM=0
STOP

END WITHOBJECT

