/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkupgrade.app;

import com.st.stlinkupgrade.app.STLinkIntegrationJava;
import com.st.stlinkupgrade.core.SystemParam;

public class CmdLineParams {
    private static final int ACTIVATE_BOARDID_PARAM = 1;
    protected boolean m_bConsoleMode = false;
    private boolean m_bUpdate = false;
    private boolean m_bForceProg = false;
    private boolean m_bMbed = false;
    private boolean m_bJtag = false;
    private boolean m_bSwim = false;
    private boolean m_bJtagSwim = false;
    private boolean m_bAudio = false;
    private boolean m_bDeleteVolName = false;
    private boolean m_bNeedsHelp = false;
    private boolean m_bDeleteMbedBoardId = false;
    private boolean m_setDfuDoNoSwitchTargetPowerOff = false;
    private boolean m_clearDfuDoNoSwitchTargetPowerOff = false;
    private int m_maxCurrentVal = -1;
    private int m_firmwareType = 0;
    String m_volName = null;
    String m_boardId = null;
    String m_badNumberFormat = null;

    void Parse(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                try {
                    this.m_maxCurrentVal = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_badNumberFormat = stringArray[i];
                }
                bl = false;
                continue;
            }
            if (bl2) {
                this.m_volName = stringArray[i];
                bl2 = false;
                continue;
            }
            if (bl3) {
                this.m_boardId = stringArray[i];
                bl3 = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-jtag")) {
                this.m_firmwareType = 2;
                this.m_bJtag = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-swim")) {
                this.m_firmwareType = 3;
                this.m_bSwim = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-jtag_swim")) {
                this.m_firmwareType = 4;
                this.m_bJtagSwim = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-msvcp")) {
                this.m_firmwareType = 5;
                this.m_bMbed = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-audio")) {
                this.m_firmwareType = 6;
                this.m_bAudio = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-update")) {
                this.m_bUpdate = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-force_prog")) {
                this.m_bForceProg = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-usb_max_current")) {
                bl = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-volume")) {
                bl2 = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-deleteV")) {
                this.m_bDeleteVolName = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-board")) {
                bl3 = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-deleteB")) {
                this.m_bDeleteMbedBoardId = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-dfuNoPowerOff")) {
                this.m_setDfuDoNoSwitchTargetPowerOff = true;
                this.m_bConsoleMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-dfuPowerOffNormal")) {
                this.m_clearDfuDoNoSwitchTargetPowerOff = true;
                this.m_bConsoleMode = true;
                continue;
            }
            this.m_bNeedsHelp = true;
            this.m_bConsoleMode = true;
        }
    }

    boolean IsConsoleMode() {
        return this.m_bConsoleMode;
    }

    int GetFirmwareType() {
        return this.m_firmwareType;
    }

    boolean IsForceProg() {
        return this.m_bForceProg;
    }

    long CheckAndAffect(STLinkIntegrationJava sTLinkIntegrationJava, SystemParam systemParam) {
        long l = 0L;
        if (this.m_bNeedsHelp) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("Command syntax error");
            }
            return 20L;
        }
        if (this.m_badNumberFormat != null) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("A wrong string was given as number: " + this.m_badNumberFormat);
            }
            return 20L;
        }
        if (this.m_bUpdate && this.m_bForceProg) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("Parameter error: update and force_prog flags simultaneously set");
            }
            return 20L;
        }
        if (this.m_volName != null) {
            if (!this.m_bMbed) {
                if (this.m_volName.toUpperCase().startsWith("NUCLEO") || this.m_volName.toUpperCase().startsWith("EVAL") || this.m_volName.toUpperCase().startsWith("DIS") || this.m_volName.toUpperCase().startsWith("NODE")) {
                    if (sTLinkIntegrationJava != null) {
                        sTLinkIntegrationJava.DisplayError("-volume " + this.m_volName + " reserved for ST boards");
                    }
                    return 20L;
                }
                this.m_bMbed = true;
                this.m_firmwareType = 5;
            }
            if (this.m_bJtag || this.m_bSwim || this.m_bJtagSwim || this.m_bAudio) {
                if (sTLinkIntegrationJava != null) {
                    sTLinkIntegrationJava.DisplayError("-volume NAME_OF_VOLUME: reserved for mass storage firmware type; ignored on other firmwares");
                }
                return 20L;
            }
            if (this.m_volName.length() > 11 && sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("-volume NAME_OF_VOLUME: is limited to 11 characters and has been truncated");
            }
        }
        int n = 0;
        if (this.m_bJtag) {
            ++n;
        }
        if (this.m_bSwim) {
            ++n;
        }
        if (this.m_bJtagSwim) {
            ++n;
        }
        if (this.m_bMbed) {
            ++n;
        }
        if (this.m_bAudio) {
            ++n;
        }
        if (n > 1) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("Parameter error: must choose between jtag, swim, jtag_swim, mass storage or audio");
            }
            return 20L;
        }
        if (this.m_maxCurrentVal != -1 && (this.m_maxCurrentVal < 100 || this.m_maxCurrentVal > 500)) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("-usb_max_current Val: max current expected on USB bus, in decimal, in the range 100 mA - 500 mA");
            }
            this.m_maxCurrentVal = -1;
            return 20L;
        }
        if (this.m_setDfuDoNoSwitchTargetPowerOff && this.m_clearDfuDoNoSwitchTargetPowerOff) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("Incompatible instructions for DFU Power Off mode");
            }
            return 20L;
        }
        if (this.m_volName != null && this.m_bDeleteVolName) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("volume ignored because of uncompatible command");
            }
            return 20L;
        }
        if (this.m_bDeleteMbedBoardId && this.m_boardId != null) {
            if (sTLinkIntegrationJava != null) {
                sTLinkIntegrationJava.DisplayError("board parameter ignored because of uncompatible command");
            }
            return 20L;
        }
        if (systemParam == null) {
            return 20L;
        }
        if (this.m_bDeleteVolName) {
            systemParam.DeleteVolumeName();
        } else if (this.m_volName != null) {
            systemParam.SetVolumeName(this.m_volName);
        }
        if (this.m_bDeleteMbedBoardId) {
            systemParam.DeleteBoardId();
        } else if (this.m_boardId != null) {
            systemParam.SetBoardId(this.m_boardId);
        }
        if (this.m_maxCurrentVal != -1) {
            systemParam.SetMaxCurrent(this.m_maxCurrentVal);
        }
        if (this.m_setDfuDoNoSwitchTargetPowerOff) {
            systemParam.SetDfuDoNoSwitchTargetPowerOff(true);
        }
        if (this.m_clearDfuDoNoSwitchTargetPowerOff) {
            systemParam.SetDfuDoNoSwitchTargetPowerOff(false);
        }
        return l;
    }
}

