/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkupgrade.core;

import com.st.stlinkinterface.STLinkDevice;
import com.st.stlinkinterface.jni.STLinkDevInfo;
import com.st.stlinkinterface.jni.STLinkUSBDriverJni;
import com.st.stlinkupgrade.core.Aes_Encryption;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STLinkDeviceDfu
extends STLinkDevice {
    static final byte DFU_DNLOAD_TYPE = 1;
    static final byte DFU_UPLOAD_TYPE = 2;
    static final byte DFU_GETSTATUS_TYPE = 3;
    static final byte DFU_CLRSTATUS_TYPE = 4;
    static final byte DFU_GETSTATE_TYPE = 5;
    static final byte DFU_ABORT_TYPE = 6;
    static final byte DFU_EXIT_TYPE = 7;
    static final byte DFU_CHIPINFO = 8;
    static final byte DFU_GET_SYSTEM_DATA = 9;
    static final byte DFU_GET_BOOT_INFO = 10;
    static final byte CMD_ERASE = 65;
    static final byte CMD_ADDRESS = 33;
    static final byte DFU_APPIDLE = 0;
    static final byte DFU_APPDETACH = 1;
    static final byte DFU_IDLE = 2;
    static final byte DFU_DNLOAD_SYNC = 3;
    static final byte DFU_DNBUSY = 4;
    static final byte DFU_DNLOAD_IDLE = 5;
    static final byte DFU_MANIFEST_SYNC = 6;
    static final byte DFU_MANIFEST = 7;
    static final byte DFU_MANIFEST_WAIT_RESET = 8;
    static final byte DFU_UPLOAD_IDLE = 9;
    static final byte DFU_ERROR = 10;
    protected byte[] m_CryUniqueID = new byte[16];
    protected byte[] m_UniqueID = new byte[16];
    protected byte[] m_K2Key = new byte[16];
    protected int m_flashSize = 0;
    protected int m_ramSize = 0;
    protected byte m_versionFlag = 0;
    protected byte m_dfuState = 0;
    protected byte m_dfuStatus = 0;
    protected int m_dfuPollTime = 0;
    protected int m_bootVersion = 0;
    protected int m_bootRevision = 0;
    protected int m_bootFlags = 0;

    public STLinkDeviceDfu(STLinkUSBDriverJni sTLinkUSBDriverJni) {
        super(sTLinkUSBDriverJni);
        Aes_Encryption.StrKeyToByteChar("I am key, wawawa", this.m_K2Key);
    }

    protected int GetFlashSizeKb() {
        return this.m_flashSize;
    }

    protected long GetSystemData(byte[] byArray, int n) {
        long l = 0L;
        if (n == 0) {
            return l;
        }
        if (this.m_STLinkV2_DfuVer < 2) {
            return 24L;
        }
        if (n > 64) {
            n = 64;
        }
        this.m_devReq.m_cmd[0] = -13;
        this.m_devReq.m_cmd[1] = 9;
        this.m_devReq.m_cmd[2] = (byte)n;
        for (int i = 3; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        this.m_devReq.m_data = byArray;
        this.m_devReq.m_dataLength = n;
        return this.SendCmd(this.m_devHandle, this.m_timeout);
    }

    protected long GetBootInfo() {
        int n;
        long l = 0L;
        byte[] byArray = new byte[16];
        if (this.m_STLinkV2_DfuVer < 2) {
            return 24L;
        }
        this.m_devReq.m_cmd[0] = -13;
        this.m_devReq.m_cmd[1] = 10;
        for (n = 2; n < 16; ++n) {
            this.m_devReq.m_cmd[n] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        this.m_devReq.m_data = byArray;
        this.m_devReq.m_dataLength = 16;
        l = this.SendCmd(this.m_devHandle, this.m_timeout);
        if (l == 0L) {
            n = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt(0);
            this.m_bootVersion = n >> 28 & 0xF;
            this.m_bootRevision = n >> 24 & 0xF;
            this.m_bootFlags = n & 0xFFFFFF;
        }
        return l;
    }

    public int GetBootFlags() {
        return this.m_bootFlags;
    }

    public boolean IsDfuMode() {
        return this.m_currentMode == 0;
    }

    protected void DfuSleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(STLinkDeviceDfu.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
    }

    protected long OpenAfterRenum(long l, String string) {
        long l2 = 4L;
        this.CloseStlink();
        long l3 = this.m_jni.Reenumerate(this.m_ifId, false);
        if (l3 == 1L || l3 == 4181L) {
            long l4 = this.m_jni.GetNbDevices(this.m_ifId);
            if (l4 == 0L) {
                return 4L;
            }
            STLinkDevInfo sTLinkDevInfo = new STLinkDevInfo();
            int n = 0;
            while ((long)n < l4) {
                this.m_jni.GetDeviceInfo(this.m_ifId, n, sTLinkDevInfo);
                if (sTLinkDevInfo.m_enumUniqueID.equals(string)) {
                    l2 = this.OpenStlink(this.m_ifId, n, true);
                    break;
                }
                ++n;
            }
        } else {
            l2 = 31L;
        }
        return l2;
    }

    protected long GoToUsbLoader() {
        int n;
        byte[] byArray = new byte[2];
        long l = 0L;
        this.m_devReq.m_cmd[0] = -7;
        this.m_devReq.m_cmd[1] = 0;
        for (n = 2; n < 16; ++n) {
            this.m_devReq.m_cmd[n] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        this.m_devReq.m_data = byArray;
        this.m_devReq.m_dataLength = 2;
        long l2 = this.SendCmd(this.m_devHandle, this.m_timeout);
        if (l2 == 0L) {
            n = this.ConvertStatus(byArray);
            if (n == 128) {
                this.m_devReq.m_cmd[1] = 1;
                this.m_devReq.m_dataLength = 0;
                long l3 = this.m_jni.GetNbDevices(this.m_ifId);
                String string = this.m_jniDevInfo.m_enumUniqueID;
                long l4 = this.m_jni.SendCommand(this.m_devHandle, this.m_devReq, this.m_timeout);
                long l5 = 1167L;
                l2 = this.m_jni.IsWindows() && l4 == 65536L + l5 ? 0L : 0L;
                if (l2 == 0L) {
                    this.CloseStlink();
                    this.DfuSleep(1500L);
                    l = 4L;
                    for (int i = 0; l == 4L && i < 50; ++i) {
                        this.DfuSleep(300L);
                        l = this.OpenAfterRenum(l3, string);
                    }
                }
            } else {
                l = n == 33 ? 26L : 25L;
            }
        }
        if (l2 != 0L) {
            l = 25L;
        }
        return l;
    }

    protected long DnldReq(int n, int n2, byte[] byArray) {
        byte[] byArray2;
        if (!this.IsStlinkOpened()) {
            return 4L;
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l += (long)byArray[i] & 0xFFL;
        }
        if (n >= 2) {
            byArray2 = new byte[n2];
            if (n2 < 16) {
                return 20L;
            }
            Aes_Encryption.STlinkPCaes_Encry_Api(byArray, byArray2, this.m_CryUniqueID, n2);
        } else {
            byArray2 = byArray;
        }
        this.m_devReq.m_cmd[0] = -13;
        this.m_devReq.m_cmd[1] = 1;
        this.m_devReq.m_cmd[2] = (byte)(n & 0xFF);
        this.m_devReq.m_cmd[3] = (byte)(n >> 8 & 0xFF);
        this.m_devReq.m_cmd[4] = (byte)(l & 0xFFL);
        this.m_devReq.m_cmd[5] = (byte)(l >> 8 & 0xFFL);
        this.m_devReq.m_cmd[6] = (byte)(n2 & 0xFF);
        this.m_devReq.m_cmd[7] = (byte)(n2 >> 8 & 0xFF);
        for (int i = 8; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_WRITE;
        this.m_devReq.m_data = byArray2;
        this.m_devReq.m_dataLength = n2;
        return this.SendCmd(this.m_devHandle, this.m_timeout);
    }

    protected long GetDevInfo() {
        if (!this.IsStlinkOpened()) {
            return 4L;
        }
        this.m_devReq.m_cmd[0] = -13;
        this.m_devReq.m_cmd[1] = 8;
        for (int i = 2; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        byte[] byArray = new byte[20];
        this.m_devReq.m_data = byArray;
        this.m_devReq.m_dataLength = 20;
        long l = this.SendCmd(this.m_devHandle, this.m_timeout);
        if (this.m_STLinkV2_DfuVer == 0 && l == 3L || l == 0L) {
            l = 0L;
            this.m_flashSize = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00;
            this.m_ramSize = byArray[2] & 0xFF | byArray[3] << 8 & 0xFF00;
            this.m_versionFlag = byArray[4];
            System.arraycopy(byArray, 0, this.m_UniqueID, 0, 4);
            System.arraycopy(byArray, 8, this.m_UniqueID, 4, 12);
            Aes_Encryption.STlinkPCaes_Encry_Api(this.m_UniqueID, this.m_CryUniqueID, this.m_K2Key, 16);
        }
        return l;
    }

    protected long GetStatus() {
        if (!this.IsStlinkOpened()) {
            return 4L;
        }
        this.m_devReq.m_cmd[0] = -13;
        this.m_devReq.m_cmd[1] = 3;
        for (int i = 2; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_cmd[6] = 6;
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        byte[] byArray = new byte[6];
        this.m_devReq.m_data = byArray;
        this.m_devReq.m_dataLength = 6;
        long l = this.SendCmd(this.m_devHandle, this.m_timeout);
        if (l == 0L) {
            this.m_dfuState = byArray[4];
            this.m_dfuStatus = byArray[0];
            this.m_dfuPollTime = byArray[3] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[1] & 0xFF;
        }
        return l;
    }

    protected long GetStatusIdle() {
        long l = this.GetStatus();
        if (l == 0L && this.m_dfuState != 5) {
            l = this.Abort();
            if (l == 0L) {
                l = this.GetStatus();
            }
            if (l == 0L && this.m_dfuState != 2) {
                l = 28L;
            }
        }
        return l;
    }

    protected long GetStatusPollBusy() {
        long l = this.GetStatus();
        if (l == 0L && this.m_dfuStatus == 0 && this.m_dfuState == 4) {
            this.DfuSleep(this.m_dfuPollTime);
        } else {
            l = 28L;
        }
        if (l == 0L) {
            l = this.GetStatus();
        }
        return l;
    }

    protected long Abort() {
        if (!this.IsStlinkOpened()) {
            return 4L;
        }
        this.m_devReq.m_cmd[0] = -13;
        this.m_devReq.m_cmd[1] = 6;
        for (int i = 2; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        this.m_devReq.m_data = null;
        this.m_devReq.m_dataLength = 0;
        return this.SendCmd(this.m_devHandle, this.m_timeout);
    }

    protected long DfuExit() {
        if (!this.IsStlinkOpened()) {
            return 4L;
        }
        int n = 0;
        long l = this.m_jni.GetNbDevices(this.m_ifId);
        String string = this.m_jniDevInfo.m_enumUniqueID;
        this.m_devReq.m_cmd[0] = -13;
        this.m_devReq.m_cmd[1] = 7;
        for (int i = 2; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        this.m_devReq.m_data = null;
        this.m_devReq.m_dataLength = 0;
        long l2 = this.SendCmd(this.m_devHandle, this.m_timeout);
        if (l2 == 0L) {
            this.CloseStlink();
            this.DfuSleep(1500L);
            l2 = 4L;
            while (l2 == 4L && n < 20) {
                this.DfuSleep(300L);
                l2 = this.OpenAfterRenum(l, string);
                ++n;
            }
        }
        return l2;
    }

    protected long SetAddress(long l) {
        byte[] byArray = new byte[5];
        byArray[0] = 33;
        ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).putInt(1, (int)l & 0xFFFFFFFF);
        return this.DnldReq(0, 5, byArray);
    }

    protected long Erase(long l) {
        byte[] byArray = new byte[5];
        byArray[0] = 65;
        ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).putInt(1, (int)l & 0xFFFFFFFF);
        return this.DnldReq(0, 5, byArray);
    }

    protected long ErasePages(long l, long l2) {
        long l3 = this.GetStatus();
        if (l3 == 0L && this.m_dfuState != 0 && this.m_dfuState != 2 && this.m_dfuState != 5) {
            l3 = this.Abort();
        }
        if (l3 == 0L && (l3 = this.GetStatus()) == 0L && this.m_dfuState != 0 && this.m_dfuState != 2 && this.m_dfuState != 5) {
            l3 = 28L;
        }
        long l4 = 0L;
        while (l2-- > 0L && l3 == 0L) {
            l3 = this.Erase(l + l4);
            if (l3 == 0L) {
                l3 = this.GetStatusPollBusy();
            }
            if (l3 == 0L && this.m_dfuState != 5) {
                l3 = 28L;
            }
            l4 += 1024L;
        }
        return l3;
    }

    protected long Download(long l, byte[] byArray, long l2) {
        long l3;
        int n = 1024;
        long l4 = l2 / (long)n;
        long l5 = l % (long)n;
        long l6 = l2 % (long)n;
        long l7 = l;
        if (l5 != 0L) {
            l7 = l - l5;
            ++l4;
        }
        if (l6 > l5) {
            ++l4;
        }
        if ((l3 = this.ErasePages(l7, l4)) != 0L) {
            return l3;
        }
        int n2 = 2;
        int n3 = 0;
        while (l2 > 0L && l3 == 0L) {
            int n4 = n;
            if (l2 < (long)n) {
                n4 = (int)l2 & 0xFFFFFFFF;
            }
            if ((l3 = this.GetStatusIdle()) == 0L) {
                l3 = this.SetAddress(l + (long)n3);
            }
            if (l3 == 0L) {
                l3 = this.GetStatusPollBusy();
            }
            if ((l3 = l3 == 0L && this.m_dfuState == 5 ? this.DnldReq(n2++, n4, Arrays.copyOfRange(byArray, n3, n3 + n4)) : 28L) == 0L) {
                l3 = this.GetStatusPollBusy();
            }
            if (l3 == 0L && (this.m_dfuState != 5 || this.m_dfuStatus != 0)) {
                l3 = 28L;
            }
            n3 += n4;
            l2 -= (long)n4;
        }
        return l3;
    }
}

