/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkupgrade.core;

import com.st.stlinkupgrade.core.STLinkDeviceDfu;

public class SystemParam {
    protected static final int VOLUME_NAME_OFFSET = 2;
    protected static final int BOARD_ID_OFFSET = 15;
    protected static final int SYS_FLAGS_OFFSET = 20;
    protected static final int SYS_FLAG_DFU_DO_NOT_POWER_OFF_TARGET = 1;
    public static final int MBED_VOLUME_NAME_MAX_SIZE = 11;
    protected static final int MBED_BOARD_ID_SIZE = 4;
    protected static final int FLASH_PARAM_SIZE = 22;
    protected byte[] m_ParamData = new byte[22];
    protected int m_maxPowerParam = -1;
    protected byte[] m_volName = new byte[11];
    protected boolean m_bDeleteVolName = false;
    protected boolean m_bMbedBoardIdProgrammed = false;
    protected byte[] m_mbedBoardId;
    protected boolean m_bDeleteMbedBoardId = false;
    protected boolean m_bVolNameRequired;
    protected static final byte SYS_FLAG_KEEP_UNCHANGED = 0;
    protected static final byte SYS_FLAG_SET = 1;
    protected static final byte SYS_FLAG_CLEAR = 2;
    protected byte m_dfuDoNoSwitchTargetPowerOff = 0;

    public SystemParam() {
        this.m_volName[0] = 0;
        this.m_mbedBoardId = new byte[4];
        this.m_bVolNameRequired = false;
    }

    public long GetInitialDataFromDevice(STLinkDeviceDfu sTLinkDeviceDfu) {
        long l = 0L;
        for (int i = 0; i < 22; ++i) {
            this.m_ParamData[i] = -1;
        }
        if (sTLinkDeviceDfu != null && sTLinkDeviceDfu.GetDfuVersion() >= 2) {
            l = sTLinkDeviceDfu.GetSystemData(this.m_ParamData, 22);
        }
        if (l != 0L) {
            return l;
        }
        return l;
    }

    public byte[] GetSysParamsToProgram() {
        if (this.m_maxPowerParam != -1) {
            this.m_ParamData[0] = 80;
            this.m_ParamData[1] = (byte)(this.m_maxPowerParam / 2);
        }
        if (this.m_volName[0] != 0) {
            this.m_ParamData[2] = 86;
            System.arraycopy(this.m_volName, 0, this.m_ParamData, 3, 11);
        } else if (this.m_bVolNameRequired) {
            if (this.m_ParamData[2] != 86) {
                this.m_ParamData[2] = 86;
                this.m_ParamData[3] = 85;
                this.m_ParamData[4] = 78;
                this.m_ParamData[5] = 68;
                this.m_ParamData[6] = 69;
                this.m_ParamData[7] = 70;
                this.m_ParamData[8] = 73;
                this.m_ParamData[9] = 78;
                this.m_ParamData[10] = 69;
                this.m_ParamData[11] = 68;
                this.m_ParamData[12] = 32;
                this.m_ParamData[13] = 32;
            }
        } else if (this.m_ParamData[15] != 66 && this.m_ParamData[2] == 86 && this.m_ParamData[3] == 68 && this.m_ParamData[4] == 73 && this.m_ParamData[5] == 83 && this.m_ParamData[6] == 95 && this.m_ParamData[7] == 70 && this.m_ParamData[8] == 55 && this.m_ParamData[9] == 52 && this.m_ParamData[10] == 54 && this.m_ParamData[11] == 78 && this.m_ParamData[12] == 71) {
            this.SetBoardId("0815");
        }
        if (this.m_bDeleteVolName) {
            this.m_ParamData[2] = -1;
        }
        if (this.m_bDeleteMbedBoardId) {
            this.m_ParamData[15] = 32;
        } else if (this.m_bMbedBoardIdProgrammed) {
            this.m_ParamData[15] = 66;
            System.arraycopy(this.m_mbedBoardId, 0, this.m_ParamData, 16, 4);
        }
        if (this.m_ParamData[20] != 70) {
            this.m_ParamData[21] = 0;
        }
        if (this.m_dfuDoNoSwitchTargetPowerOff == 1) {
            this.m_ParamData[21] = (byte)(this.m_ParamData[21] | 1);
        }
        if (this.m_dfuDoNoSwitchTargetPowerOff == 2) {
            this.m_ParamData[21] = (byte)(this.m_ParamData[21] & 0xFFFFFFFE);
        }
        if (this.m_ParamData[21] == 0) {
            this.m_ParamData[20] = -1;
            this.m_ParamData[21] = -1;
        } else {
            this.m_ParamData[20] = 70;
        }
        return this.m_ParamData;
    }

    public void SetVolumeName(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < 11; ++i) {
            this.m_volName[i] = (byte)((byte)cArray[i] & 0xFF);
        }
    }

    public void DeleteVolumeName() {
        this.m_bDeleteVolName = true;
    }

    public void DeleteBoardId() {
        this.m_bDeleteMbedBoardId = true;
    }

    public void SetBoardId(String string) {
        int n;
        this.m_bMbedBoardIdProgrammed = true;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        if (n2 > 4) {
            n2 = 4;
        }
        for (n = 0; n < n2; ++n) {
            this.m_mbedBoardId[n] = (byte)((byte)cArray[n] & 0xFF);
        }
        for (n = n2; n < 4; ++n) {
            this.m_mbedBoardId[n] = 48;
        }
    }

    public void SetMaxCurrent(int n) {
        this.m_maxPowerParam = n;
    }

    public void SetDfuDoNoSwitchTargetPowerOff(boolean bl) {
        this.m_dfuDoNoSwitchTargetPowerOff = bl ? (byte)1 : (byte)2;
    }

    void SetVolumeNameRequired(boolean bl) {
        this.m_bVolNameRequired = bl;
    }
}

