UPM.define('AddonReviewModel',
    [
        'jquery',
        'brace'
    ],
    function($, Brace) {

    "use strict";

    /**
     * Represents the review/rating state of an add-on.  This is loaded separately from the add-on model
     * (since it comes from Marketplace) by AddonModel.loadReviewModel().
     */
    return Brace.Model.extend({

        namedAttributes: [
            'addon',
            'links',
            'review',
            'stars'
        ],

        updateStars: function(stars) {
            return this._updateReviewAndStars(null, stars, true);
        },

        updateReview: function(review, stars) {
            return this._updateReviewAndStars(review, stars, false);
        },

        getMarketplaceLink: function() {
            return this.get('links')['marketplace-review'];
        },

        _updateReviewAndStars: function(review, stars, ratingOnly) {
            var existingReviewUrl = this.get('links') && this.get('links').self,
                me = this;
            return $.ajax({
                url: existingReviewUrl || this.getAddon().getLinkOrPacResponseLink('plugin-review'),
                type: existingReviewUrl ? 'put' : 'post',
                dataType: 'json',
                contentType: 'application/json',
                data: JSON.stringify({ ratingOnly: ratingOnly, stars: parseInt(stars), review: review })
            }).done(function(resp) {
                me.set(resp);
            }).promise();
        }
    });
});
