UPM.define('OnDemandInstallOrLicenseConfirmDialog',
    [
        'UpmDialog',
        'UpmAnalytics',
        'UpmEnvironment',
        'OnDemandInstallOrLicenseConfirmDialogTemplate'
    ],
    function(UpmDialog,
             UpmAnalytics,
             UpmEnvironment,
             OnDemandInstallOrLicenseConfirmDialogTemplate) {

    // Dialog for confirming installation or free trial of an add-on in OnDemand (we don't require
    // confirmation in all cases - see MarketplaceInstallFlow).  The model for the dialog is the
    // add-on model.  The pricing model must already be available (see AddonModel.loadPricingModel).

    return UpmDialog.extend({
        template: OnDemandInstallOrLicenseConfirmDialogTemplate,

        _getData: function() {
            return {
                plugin: this.model.toJSON(),
                willNeedPaymentDetailsAfterTrial: this.model.isPaidViaAtlassian() &&
                    UpmEnvironment.isPlatformFreeTier() &&
                    !this.model.getFreeTier(),
                priceDescriptionHtml: this.model.pricingModel &&
                    this.model.pricingModel.getPricingDescription(this.model)
            };
        },

        getResult: function () {
            var pluginKey = this.model.getKey();
            return UpmDialog.prototype.getResult.apply(this)
                .done(function () {
                    UpmAnalytics.logAddonEvent('connect-install-warning-accept', pluginKey);
                })
                .fail(function () {
                    UpmAnalytics.logAddonEvent('connect-install-warning-cancel', pluginKey);
                });
        }
    });
});
