REM Extended Object Search Engine
REM  10-Apr-1998 by Alex I. Vakulenko

DECLARE FUNCTION SearchAll() as boolean
DECLARE FUNCTION TestAndApply() as boolean
DECLARE SUB AddMainCondition()
DECLARE SUB AddExtendedCondition()
DECLARE SUB AddMainVerb(Verb$)
DECLARE SUB AddExtendedVerb(Verb$)
DECLARE SUB AppendCondition(BYREF Condition$,Word$,Arg$)
DECLARE SUB AppendVerb(BYREF Condition$,Verb$)
DECLARE FUNCTION GetLastWord$(Condition$)
DECLARE SUB TestMainButtons()
DECLARE SUB TestExtendedButtons()
DECLARE SUB CheckMainCondition

DECLARE FUNCTION CheckSyntax& LIB "eval.dll" (BYVAL Cond$) ALIAS "CheckSyntax"
DECLARE FUNCTION CheckSyntaxEx& LIB "eval.dll" (BYVAL Cond$,BYVAL cmd&) ALIAS "CheckSyntaxEx"
DECLARE FUNCTION Eval& LIB "eval.dll" (BYVAL Cond$,BYVAL om&,BYVAL o1&,BYVAL o2&,BYVAL o3&,\\
			BYVAL o4&,BYVAL fm&,BYVAL f1&,BYVAL f2&,BYVAL f3&,BYVAL f4&) ALIAS "Eval"

CONST MaxLevel&=1000
GLOBAL LocalID&(1000),StartID&(1000),Level&,Skip as boolean

GLOBAL ObjectContent$(2),Obj$(2),Colors$(2),Col$(2),ColorModel&(2),Extended$,Condition$
ObjectContent$(1)="Fill"
ObjectContent$(2)="Outline"
Obj$(1)="F"
Obj$(2)="O"

Colors$(1)="CMYK"
Colors$(2)="RGB"
Col$(1)="CMYK"
Col$(2)="RGB"
ColorModel(1)=2
ColorModel(2)=5

GLOBAL CMYKColors$(4),RGBColors$(3),ClrComp$(2,4)
CMYKColors$(1)="Cyan"
CMYKColors$(2)="Magenta"
CMYKColors$(3)="Yellow"
CMYKColors$(4)="Black"
RGBColors$(1)="Red"
RGBColors$(2)="Green"
RGBColors$(3)="Blue"

ClrComp$(1,1)="C"
ClrComp$(1,2)="M"
ClrComp$(1,3)="Y"
ClrComp$(1,4)="K"
ClrComp$(2,1)="R"
ClrComp$(2,2)="G"
ClrComp$(2,3)="B"

GLOBAL Operators$(4),OpVerbs$(4)
Operators$(1)="Equal to"
Operators$(2)="Not equal to"
Operators$(3)="Greater than"
Operators$(4)="Less than"

OpVerbs$(1)="="
OpVerbs$(2)="<>"
OpVerbs$(3)=">"
OpVerbs$(4)="<"

GLOBAL ErrorMsg$(8)
ErrorMsg$(1)="Expression missing ')'"
ErrorMsg$(2)="Expression syntax error"
ErrorMsg$(3)="Argument expected"
ErrorMsg$(4)="Invalid color model specified"
ErrorMsg$(5)="Invalid color component name"
ErrorMsg$(6)="Value out of range"
ErrorMsg$(7)="Unknown operator"
ErrorMsg$(8)="Expression missing ']'"

BEGIN DIALOG OBJECT EditSearch 280, 129, "Edit Search Criteria", SUB EditConditionSub
	TEXTBOX  10, 11, 235, 44, .MainCondition
	GROUPBOX  6, 2, 244, 58, .GroupBox1, "Condition"
	PUSHBUTTON  253, 8, 20, 14, .Not, "&Not"
	PUSHBUTTON  253, 26, 20, 14, .And, "&And"
	PUSHBUTTON  253, 45, 20, 14, .Or, "&Or"
	GROUPBOX  6, 62, 212, 48, .GroupBox2, "Condition Details"
	TEXT  12, 74, 23, 8, .Text1, "&Object"
	DDLISTBOX  37, 72, 46, 42, .Fill
	TEXT  86, 74, 8, 8, .Text2, "is"
	DDLISTBOX  95, 72, 60, 42, .ColorMode
	TEXT  11, 94, 25, 8, .Text3, "&Details:"
	TEXTBOX  37, 91, 119, 14, .Details
	PUSHBUTTON  166, 72, 46, 14, .Add, "A&dd"
	PUSHBUTTON  166, 91, 46, 14, .Build, "&Build..."
	PUSHBUTTON  228, 66, 46, 14, .Search, "&Search"
	CANCELBUTTON  228, 83, 46, 14, .Cancel
	HELPBUTTON  228, 100, 46, 14, .Help
	STATUS .Status
END DIALOG

BEGIN DIALOG OBJECT BuildDetails 266, 128, SUB DetailsSub
	TEXTBOX  10, 11, 215, 44, .MainCondition
	GROUPBOX  6, 2, 226, 58, .GroupBox1, "Condition"
	PUSHBUTTON  238, 8, 20, 14, .Not, "&Not"
	PUSHBUTTON  238, 26, 20, 14, .And, "&And"
	PUSHBUTTON  238, 45, 20, 14, .Or, "&Or"
	GROUPBOX  6, 62, 199, 50, .GroupBox2, "Condition Details"
	TEXT  12, 77, 30, 8, .Text1, "&Value for"
	DDLISTBOX  44, 75, 47, 51, .ColorChannel
	DDLISTBOX  94, 75, 61, 50, .Operator
	SPINCONTROL  158, 75, 41, 13, .Value
	PUSHBUTTON  158, 92, 41, 14, .Add, "A&dd"
	OKBUTTON  212, 66, 46, 14, .OK
	CANCELBUTTON  212, 82, 46, 14, .Cancel
	HELPBUTTON  212, 99, 46, 14, .Help
	STATUS .Status
END DIALOG

EditSearch.Fill.SetArray ObjectContent
EditSearch.Fill.SetSelect 1
EditSearch.ColorMode.SetArray Colors
EditSearch.ColorMode.SetSelect 1
EditSearch.MainCondition.SetStyle 1024
Condition$=""
EditSearch.Help.SetHelpPath "ExtSearch.hlp"
EditSearch.Help.SetHelpIndex 100

SUB EditConditionSub(BYVAL ControlID%, BYVAL Event%)
	SELECT CASE Event%
 		CASE 0 'Init
			EditSearch.Search.ENABLE FALSE
			Extended$=""
			EditSearch.MainCondition.SetText Condition
			EditSearch.Details.SetText ""
			TestMainButtons
 		CASE 1
			SELECT CASE ControlID%
				CASE EditSearch.MainCondition.GetID()
					Condition$=EditSearch.MainCondition.GetText()
					TestMainButtons
				CASE EditSearch.Details.GetID()
					Extended$=EditSearch.Details.GetText()
			END SELECT
		CASE 2
			SELECT CASE ControlID%
				CASE EditSearch.Search.GetID()
					EditSearch.CloseDialog 1
				CASE EditSearch.Add.GetID()
					AddMainCondition
					TestMainButtons
				CASE EditSearch.And.GetID()
					AddMainVerb "AND "
					TestMainButtons
				CASE EditSearch.Or.GetID()
					AddMainVerb "OR "
					TestMainButtons
				CASE EditSearch.Not.GetID()
					AddMainVerb "NOT "
					TestMainButtons
				CASE EditSearch.Build.GetID()
					ExTmp$=Extended$
					if(DIALOG(BuildDetails)<>2) then
						EditSearch.Details.SetText Extended$
					else
						Extended$=ExTmp$
					endif
			END SELECT
	END SELECT	
END SUB


BuildDetails.Operator.SetArray Operators
BuildDetails.Operator.SetSelect 1
BuildDetails.MainCondition.SetStyle 1024
BuildDetails.Help.SetHelpPath "ExtSearch.hlp"
BuildDetails.Help.SetHelpIndex 101

SUB DetailsSub(BYVAL ControlID%, BYVAL Event%)
	SELECT CASE Event%
 		CASE 0 'Init
			SELECT CASE EditSearch.ColorMode.GetSelect()
				CASE 1
					BuildDetails.ColorChannel.SetArray CMYKColors
					BuildDetails.Value.SetMinRange 0
					BuildDetails.Value.SetMaxRange 100
				CASE 2
					BuildDetails.ColorChannel.SetArray RGBColors
					BuildDetails.Value.SetMinRange 0
					BuildDetails.Value.SetMaxRange 255
			END SELECT
			BuildDetails.SetText "Extended Search Criteria - "+Colors(EditSearch.ColorMode.GetSelect())
			BuildDetails.ColorChannel.SetSelect 1
			BuildDetails.MainCondition.SetText Extended
			TestExtendedButtons
 		CASE 1
			SELECT CASE ControlID%
				CASE BuildDetails.MainCondition.GetID()
					Extended$=BuildDetails.MainCondition.GetText()
					TestExtendedButtons
			END SELECT
		CASE 2
			SELECT CASE ControlID%
				CASE BuildDetails.Add.GetID()
					AddExtendedCondition
					TestExtendedButtons
				CASE BuildDetails.And.GetID()
					AddExtendedVerb "AND "
					TestExtendedButtons
				CASE BuildDetails.Or.GetID()
					AddExtendedVerb "OR "
					TestExtendedButtons
				CASE BuildDetails.Not.GetID()
					AddExtendedVerb "NOT "
					TestExtendedButtons
			END SELECT
	END SELECT	
END SUB

BEGIN DIALOG OBJECT Searching 130, 97, "Searching", SUB SearchSub
	PUSHBUTTON  6, 77, 53, 14, .Next, "Find &Next"
	CANCELBUTTON  70, 77, 53, 14, .Cancel1
	GROUPBOX  5, 3, 118, 68, .GroupBox1, "Current Object Information"
	TEXT  18, 15, 15, 8, .Text1, "Fill:"
	TEXT  33, 15, 20, 8, .Fill, ""
	TEXT  18, 25, 10, 8, .FCT1, ""
	TEXT  18, 35, 10, 8, .FCT2, ""
	TEXT  18, 45, 10, 8, .FCT3, ""
	TEXT  18, 55, 10, 8, .FCT4, ""
	TEXT  33, 25, 15, 8, .FC1, ""
	TEXT  33, 35, 15, 8, .FC2, ""
	TEXT  33, 45, 15, 8, .FC3, ""
	TEXT  33, 55, 15, 8, .FC4, ""
	TEXT  64, 15, 25, 8, .Text7, "Outline:"
	TEXT  93, 15, 20, 8, .Outline, ""
	TEXT  81, 25, 10, 8, .OCT1, ""
	TEXT  81, 35, 10, 8, .OCT2, ""
	TEXT  81, 45, 10, 8, .OCT3, ""
	TEXT  81, 55, 10, 8, .OCT4, ""
	TEXT  93, 25, 15, 8, .OC1, ""
	TEXT  93, 35, 15, 8, .OC2, ""
	TEXT  93, 45, 15, 8, .OC3, ""
	TEXT  93, 55, 15, 8, .OC4, ""
END DIALOG

on error goto handler

WHILE true
	ret%=DIALOG(EditSearch)
	if ret<>1 then stop
	
	ret%=DIALOG(Searching)
	if ret<>6 then stop
wend

SUB SearchSub(BYVAL ControlID%, BYVAL Event%)
WITHOBJECT "CorelDraw.automation.8"
	SELECT CASE Event%
 		CASE 0 'Init
			.UnSelectAll
			.SelectNextObject 0
			LocalID&(1)=.GetObjectsCDRStaticID()
			StartID&(1)=0
			Level=1
			Skip=false
			if not SearchAll() then
				.UnSelectAll
				Searching.CloseDialog messagebox("No objects matching the condition."+\\
						chr(13)+"Do you wish to try another search?","Search",52)
			endif
		CASE 2
			SELECT CASE ControlID%
				CASE Searching.Next.GetID()
					.SelectNextObject 0
					Skip=true
					if not SearchAll() then
						.UnSelectAll
						Searching.CloseDialog messagebox("Search complete."+\\
							chr(13)+"Do you wish to try another search?","Search",68)
					endif
			END SELECT
	END SELECT
END WITHOBJECT
END SUB

HANDLER :
	IF ERRNUM = 1000 THEN
		MESSAGEBOX "No active document or no objects in drawing","Message",16
	ELSE
		MESSAGEBOX "Error "+STR(ERRNUM)+" encountered","Message",16
	END IF
stop

FUNCTION SearchAll() as boolean
WITHOBJECT "CorelDraw.automation.8"
	DIM Booltest as boolean,Found as boolean,ex as boolean
	Booltest = TRUE
	Found=false
		DO WHILE Booltest
			IF not skip and .GetObjectType() = 12 THEN
				Level=Level+1
				StartID&(Level)=.GetObjectsCDRStaticID()
				.SelectNextObject -1
				LocalID&(Level)= .GetObjectsCDRStaticID()
			ELSE
				if not skip then
					Found=TestAndApply()
					if Found then booltest=false else .SelectNextObject 0
				endif
				IF .GetObjectsCDRStaticID() = LocalID(Level) THEN
					if level=1 then
						Booltest = False
					else
						.SelectObjectOfCDRStaticID StartID(Level)
						level=level-1
						.SelectNextObject 0
						skip=true
					endif
				else
					skip=false
				endif
			END IF
		LOOP
	SearchAll=found
END WITHOBJECT
END SUB

FUNCTION TestAndApply() as boolean
DIM Scaled as boolean
WITHOBJECT "CorelDraw.automation.8"
.GetOutline , OutlineType&
'.GetOutline Width&, OutlineType&, EndCaps&, JoinType&, Aspect&, Angle&, DotDash&, RArrow&, LArrow&, BehindFill, Scaled
O_Mode&=0
OC1&=0
OC2&=0
OC3&=0
OC4&=0
F_Mode&=0
FC1&=0
FC2&=0
FC3&=0
FC4&=0
if outlineType&<>0 then	.GetOutlineColor O_Mode&,OC1&,OC2&,OC3&,OC4&,OC5&,OC6&,OC7&
ft&=.GetFillType()
if ft=1 then .GetUniformFillColor F_Mode&,FC1&,FC2&,FC3&,FC4&,FC5&,FC6&,FC7&
Scaled=false
O_Mode=O_Mode mod 1000
F_Mode=F_Mode mod 1000
if F_Mode=17 then
	F_Mode=2
	FC1=(100*FC1)\255
	FC2=(100*FC2)\255
	FC3=(100*FC3)\255
	FC4=(100*FC4)\255
ENDIF
v&=Eval(Condition$,O_Mode&,OC1&,OC2&,OC3&,OC4&,F_Mode&,FC1&,FC2&,FC3&,FC4&)
if(v=-1) then
	if(F_Mode=5 or F_Mode=2) then
		if F_Mode=5 then
			Searching.Fill.SetText "RGB"
			Searching.FCT1.SetText "R:"
			Searching.FCT2.SetText "G:"
			Searching.FCT3.SetText "B:"
			Searching.FCT4.SetText ""
			Searching.FC4.SetText ""
		else
			Searching.Fill.SetText "CMYK"
			Searching.FCT1.SetText "C:"
			Searching.FCT2.SetText "M:"
			Searching.FCT3.SetText "Y:"
			Searching.FCT4.SetText "K:"
			Searching.FC4.SetText STR(FC4)
		endif
		Searching.FC1.SetText STR(FC1)
		Searching.FC2.SetText STR(FC2)
		Searching.FC3.SetText STR(FC3)
	else
		Searching.Fill.SetText "N/A"
		Searching.FCT1.SetText ""
		Searching.FCT2.SetText ""
		Searching.FCT3.SetText ""
		Searching.FCT4.SetText ""
		Searching.FC1.SetText ""
		Searching.FC2.SetText ""
		Searching.FC3.SetText ""
		Searching.FC4.SetText ""
	endif
	if(O_Mode=5 or O_Mode=2) then
		if O_Mode=5 then
			Searching.Outline.SetText "RGB"
			Searching.OCT1.SetText "R:"
			Searching.OCT2.SetText "G:"
			Searching.OCT3.SetText "B:"
			Searching.OCT4.SetText ""
			Searching.OC4.SetText ""
		else
			Searching.Outline.SetText "CMYK"
			Searching.OCT1.SetText "C:"
			Searching.OCT2.SetText "M:"
			Searching.OCT3.SetText "Y:"
			Searching.OCT4.SetText "K:"
			Searching.OC4.SetText STR(OC4)
		endif
		Searching.OC1.SetText STR(OC1)
		Searching.OC2.SetText STR(OC2)
		Searching.OC3.SetText STR(OC3)
	else
		Searching.Outline.SetText "N/A"
		Searching.OCT1.SetText ""
		Searching.OCT2.SetText ""
		Searching.OCT3.SetText ""
		Searching.OCT4.SetText ""
		Searching.OC1.SetText ""
		Searching.OC2.SetText ""
		Searching.OC3.SetText ""
		Searching.OC4.SetText ""
	endif
	Scaled=true
end if
TestAndApply=Scaled
END WITHOBJECT
END FUNCTION


SUB AddMainCondition()
	s$=Obj$(EditSearch.Fill.GetSelect())+Col$(EditSearch.ColorMode.GetSelect())
	AppendCondition Condition,s$,Extended
	EditSearch.MainCondition.SetText Condition$
	Extended$=""
	EditSearch.Details.SetText ""
END SUB

SUB AddExtendedCondition()
	s$=ClrComp(EditSearch.ColorMode.GetSelect(),BuildDetails.ColorChannel.GetSelect())
	s$=s$+OpVerbs$(BuildDetails.Operator.GetSelect())+LTRIM(STR(BuildDetails.Value.GetValue()))
	AppendCondition Extended,s$,""
	BuildDetails.MainCondition.SetText Extended$
END SUB

SUB AddMainVerb(Verb$)
	AppendVerb Condition,Verb
	EditSearch.MainCondition.SetText Condition$
END SUB

SUB AddExtendedVerb(Verb$)
	AppendVerb Extended,Verb
	BuildDetails.MainCondition.SetText Extended$
END SUB

SUB AppendCondition(BYREF Condition$,Word$,Arg$)
	s$=Word$
	if Arg<>"" then s$=s$+"["+Arg$+"]"
	l$=GetLastWord$(Condition)
	if l$<>"" and l$<>"AND" and l$<>"OR" and l$<>"NOT" and l$<>"!" and l$<>"(" and l$<>"&" and l$<>"|" and l$<>"[" then AppendVerb Condition,"AND "
	AppendVerb Condition,s$
END SUB

SUB AppendVerb(BYREF Condition$,Verb$)
	s$=Right(Condition,1)
	if s$<>" " and s$<>"!" and s$<>"" and s$<>"(" and s$<>"[" then Condition=Condition+" "
	Condition=Condition+Verb$
END SUB

FUNCTION GetLastWord$(Condition$)
CONST Divs$=" !&|()[]"
dim stp as boolean
stp=false
endp%=0
s$=""
if Condition$<>"" then
	i%=len(Condition)
	while not stp and i>0
		c$=mid(Condition,i,1)
		if endp=0 and c$<>" " then endp=i
		if endp<>0 and instr(Divs,c$)<>0 then stp=true
		if endp=0 or instr(Divs$,c$)=0 then i=i-1
	wend
	if instr(mid(Divs,2),c$)=0 or endp<>i then i=i+1
	if i<=endp then s$=mid(Condition,i,endp-i+1)
endif
GetLastWord$=UCASE(s$)
END FUNCTION

SUB TestMainButtons()
	DIM st as boolean,conj as boolean
	st=false
	conj=false
	s$=GetLastWord$(Condition)
	if s$="" or s$="(" or s$="[" then st=true
	if s$="AND" or s$="OR" or s$="&" or s$="|" then conj=true
	EditSearch.Not.ENABLE st or conj
	EditSearch.And.ENABLE not conj and not st and s$<>"!" and s$<>"NOT"
	EditSearch.Or.ENABLE not conj and not st and s$<>"!" and s$<>"NOT"
	a&=CheckSyntax(Condition$)
	if (a>0) then 
		EditSearch.Status.SetText "Error: "+ErrorMsg(a&)
		EditSearch.Search.ENABLE FALSE
	else
		EditSearch.Status.SetText ""
		EditSearch.Search.ENABLE TRUE
	endif
END SUB

SUB TestExtendedButtons()
	DIM st as boolean,conj as boolean
	st=false
	conj=false
	s$=GetLastWord$(Extended)
	if s$="" or s$="(" or s$="[" then st=true
	if s$="AND" or s$="OR" or s$="&" or s$="|" then conj=true
	BuildDetails.Not.ENABLE st or conj
	BuildDetails.And.ENABLE not conj and not st and s$<>"!" and s$<>"NOT"
	BuildDetails.Or.ENABLE not conj and not st and s$<>"!" and s$<>"NOT"
	a&=CheckSyntaxEx(Extended$,ColorModel(EditSearch.ColorMode.GetSelect()))
	if (a>0) then 
		BuildDetails.Status.SetText "Error: "+ErrorMsg(a&)
		BuildDetails.OK.ENABLE FALSE
	else
		BuildDetails.Status.SetText ""
		BuildDetails.OK.ENABLE TRUE
	endif
END SUB

