﻿/*
    Readme:
        At first, if you are obsessive about English spelling, grammar or words usage, 
        ignore this instruction please. I am NOT writing a passage for an exam.
        Else if you are interested in this series of plugin or you fell in love with me,
        Contact me by QQ824395314 or TieBa id "杰拉德临死前".
    Description:    
        This is a weapon coming from CSO named Dragon Cannon(震天龍炮),
        which is a break-action weapon with simple design as well as high destruction power.
        With this weapon you can instant kill multiple zombie with one shoot, 
        Also you could kill (or sell) a teammate as soon as he is infected.(QwQ)
    Cvars & Native:  
        None.
    Supports for:
        Zombie Plague 5.0 with Item Shop
        Most of Adrshoot(Accshoot/ConcentractedFire/6/致命打击) Plugin
        Frenzied players who like teammate selling and ranking
    Usage:
        Get it from weapon selection menu. When your teammate has turned into zombie,
        PRESS 6 to activate AdrShoot and SELL him immediately!
        In addition, use it with SkullAxe or DragonSword by "changeshoot"(SkullAxe Bug):
        Slash, Change, AdrShoot, Fire!
        Even you can slash three times and fire twice during Adrshoot(4.5sec).
    Credits:
        Dias Leon(Pendragon?): Mainly based on his plugin
        Arwel: For light and fade effects
        BTE Team(CSOLDJB & NONAME): For creating mutliple fires angle calculating
        Hui: For knockback and Traceattack stocks
        Bxy: For mental(gaying?) supports =w=
        Xiaobaibai: Finished, checked, tested this plugin and collected resources
*/
#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <fakemeta_util>
#include <hamsandwich>
#include <cstrike>
#include <xs>
#include <zp50_items>

#define PLUGIN "[ZP] Item: Cannon"
#define VERSION "1.0"
#define AUTHOR "Xiaobaibai"

#define CSW_CANNON CSW_UMP45
#define weapon_cannon "weapon_ump45"

#define DEFAULT_W_MODEL "models/w_ump45.mdl"
#define WEAPON_SECRET_CODE 8243
#define CANNONFIRE_CLASSNAME "func_cannon_fire"

#define CANNON_KNOCKBACK 700.0 
#define CANNON_KNOCKHIGH 70.0 
#define CANNON_AMMO 20
#define CANNON_RELOADTIME 3.8
#define CANNON_DRAWTIME 0.65

// Fire Start
#define WEAPON_ATTACH_F 30.0
#define WEAPON_ATTACH_R 10.0
#define WEAPON_ATTACH_U -10.0

#define ITEM_NAME "震天龍炮"
#define ITEM_COST 998

const pev_ammo = pev_iuser4

new const WeaponModel[3][] =
{
    "models/zombie_plague/v_cannon.mdl",
    "models/zombie_plague/p_cannon.mdl",
    "models/zombie_plague/w_cannon.mdl"
}

new const WeaponSound[2][] =
{
    "weapons/cannon-1.wav",
    "weapons/cannon_draw.wav"
}

new const WeaponResource[5][] = 
{
    "sprites/flame_puff01.spr",
    "sprites/weapon_cannon.txt",
    "sprites/640hud69.spr",
    "sprites/640hud2.spr",
    "sprites/smokepuff.spr"
}

enum
{
    CANNON_ANIM_IDLE = 0,
    CANNON_ANIM_SHOOT1,
    CANNON_ANIM_DRAW
}
enum
{
    CANNON_OWN_NONE = 0,
    CANNON_OWN_STANDARD,
    CANNON_OWN_MINOR,
}

new g_iItemCannon[2]
new g_iOwnCannon[33], g_old_weapon[33], g_iAmmo[33]
new g_iSmokepuffID

new Float:g_flDrawTime[33], Float:g_flLastShootTime[33]

public plugin_init() 
{
    register_plugin(PLUGIN, VERSION, AUTHOR)
    
    register_event("CurWeapon", "event_CurWeapon", "be", "1=1")

    register_forward(FM_UpdateClientData, "fw_UpdateClientData_Post", 1)
    register_forward(FM_CmdStart, "fw_CmdStart")
    register_forward(FM_SetModel, "fw_SetModel")

    register_think(CANNONFIRE_CLASSNAME, "fw_Think")
    
    RegisterHam(Ham_Touch,"info_target",  "fw_Touch")
    RegisterHam(Ham_Item_AddToPlayer, weapon_cannon, "fw_AddToPlayer_Post", 1)
    
    register_clcmd("weapon_cannon", "HookWeapon")
}

public plugin_precache()
{
    new i
    for(i = 0; i < sizeof(WeaponModel); i++)
        engfunc(EngFunc_PrecacheModel, WeaponModel[i])
    for(i = 0; i < sizeof(WeaponSound); i++)
        engfunc(EngFunc_PrecacheSound, WeaponSound[i])
        
    engfunc(EngFunc_PrecacheModel, WeaponResource[0])
    engfunc(EngFunc_PrecacheGeneric, WeaponResource[1])
    engfunc(EngFunc_PrecacheModel, WeaponResource[2])
    engfunc(EngFunc_PrecacheModel, WeaponResource[3])
    
    g_iSmokepuffID = engfunc(EngFunc_PrecacheModel, WeaponResource[4])
    
    g_iItemCannon[0] = zp_items_register(ITEM_NAME, ITEM_COST)
    
}
public zp_fw_items_select_post(id, itemid)
{
    if(itemid == g_iItemCannon[0])
        DoGiveCannon(id)
}
public zp_fw_items_select_pre(id, itemid, ignorecost)
{
    if (itemid != g_iItemCannon[0])
        return ZP_ITEM_AVAILABLE;
    if (zp_core_is_zombie(id))
        return ZP_ITEM_NOT_AVAILABLE
    
    return ZP_ITEM_AVAILABLE;
}
public zp_fw_core_infect_post(id)
{
    DoRemoveCannon(id)
}

public zp_fw_core_cure_post(id)
{
    DoRemoveCannon(id)
}
public DoGiveCannon(id)
{
    if(!is_user_alive(id))
        return
    drop_weapons(id, 1)
    g_iOwnCannon[id] = CANNON_OWN_STANDARD
    g_flDrawTime[id] = get_gametime()
    g_iAmmo[id] = CANNON_AMMO
    fm_give_item(id, weapon_cannon)
}

public DoRemoveCannon(id)
{
    if(!is_user_connected(id))
        return
        
    g_iOwnCannon[id] = CANNON_OWN_NONE
    g_iAmmo[id] = 0
}

public HookWeapon(id) 
    engclient_cmd(id, weapon_cannon)

public event_CurWeapon(id)
{
    if(!is_user_alive(id))
        return
        
    if(get_user_weapon(id) == CSW_CANNON && g_iOwnCannon[id])
    {
        set_pev(id, pev_viewmodel2, WeaponModel[0])
        set_pev(id, pev_weaponmodel2, WeaponModel[1])
        g_flDrawTime[id] = get_gametime()
        if(g_old_weapon[id] != CSW_CANNON)
        {
            set_weapon_anim(id, CANNON_ANIM_DRAW)
        }
            
        UpdateAmmo(id)
    }
    g_old_weapon[id] = get_user_weapon(id)
}

public CheckShoot(id)
{
    static Float:flCurTime
    flCurTime = get_gametime()
        
    if((flCurTime - g_flDrawTime[id] > CANNON_DRAWTIME)
        && (flCurTime - g_flLastShootTime[id] > CANNON_RELOADTIME))
        DoShoot(id)
}

public DoShoot(id)
{
    if(!g_iAmmo[id])
        return
    emit_sound(id, CHAN_WEAPON, WeaponSound[0], 1.0, ATTN_NORM, 0, PITCH_NORM)
    set_weapon_anim(id, CANNON_ANIM_SHOOT1)
    
    g_flLastShootTime[id] = -1.0
    MakeFireEffect(id)
}
public PostShoot(id)
{
    emit_sound(id, CHAN_WEAPON, WeaponSound[0], 1.0, ATTN_NORM, 0, PITCH_NORM)
    MakeRecoil(id)
    
    g_iAmmo[id]--
    
    set_weapon_anim(id, CANNON_ANIM_SHOOT1)
    emit_sound(id, CHAN_WEAPON, WeaponSound[0], 1.0, ATTN_NORM, 0, PITCH_NORM)
    
    set_player_nextattack(id, CSW_CANNON, CANNON_RELOADTIME)
    g_flLastShootTime[id] = get_gametime()
    
    UpdateAmmo(id)
    MakeMuzzleFlash(id)
    MakeFireEffect(id)
    CheckRadiusDamage(id)
}
MakeFireEffect(id)
{
    static Float:vStart[3],Float:vPlrAngle[3],Float:iAngle[3],Float:vVelocity[3]
    get_position(id,55.0,2.0,-1.0,vStart)
    pev(id,pev_v_angle,vPlrAngle)
    vPlrAngle[1] -= 18.0
    new Float:fSpeed = 390.0
    for(new i = 0;i<10;i++)
    {
        vPlrAngle[1] += random_float(2.0,10.0)
        angle_vector(vPlrAngle,ANGLEVECTOR_FORWARD,vVelocity)
        xs_vec_mul_scalar(vVelocity,fSpeed,vVelocity)
            
        new iEnt = CreatFireEnt(id)
        dllfunc(DLLFunc_Spawn, iEnt)
        iAngle[2] -= random_num(1, 360)
        iAngle[0] = random_float(-180.0,180.0)
        iAngle[1] = random_float(-180.0,180.0)
        set_pev(iEnt, pev_angles, iAngle)
        set_pev(iEnt, pev_origin, vStart)
        set_pev(iEnt,pev_velocity,vVelocity)
    }
}
CreatFireEnt(id)
{
    new iEnt = fm_create_entity("info_target")
    set_pev(iEnt, pev_model, WeaponResource[0])
    set_pev(iEnt, pev_owner, id)
    set_pev(iEnt, pev_classname, CANNONFIRE_CLASSNAME)
            
    fm_entity_set_model(iEnt, WeaponResource[0])
    fm_set_rendering(iEnt, kRenderFxNoDissipation, 0, 0, 0, kRenderGlow, 255)
    set_pev(iEnt, pev_scale, 3.0)
    set_pev(iEnt, pev_movetype, MOVETYPE_FLY)
    set_pev(iEnt, pev_solid, SOLID_TRIGGER)
    entity_set_size(iEnt, Float:{0.0, 0.0, 0.0}, Float:{0.0, 0.0, 0.0})    
    set_pev(iEnt, pev_fuser1, 255.0)
    set_pev(iEnt, pev_framerate, 0.1)
    set_pev(iEnt, pev_frame, 0.0)
    set_pev(iEnt, pev_nextthink, get_gametime()+random_float(0.001, 0.2))
    return iEnt;
}
MakeRecoil(id)
{
    static Float:PunchAngles[3]
    
    PunchAngles[0] = random_float(-5.42, 5.42)
    PunchAngles[1] = random_float(-5.42, 5.42)
    PunchAngles[2] = random_float(-5.42, 5.42)
    set_pev(id, pev_punchangle, PunchAngles)
}
DoTraceAttack(iAttacker, iVictim, Float:flDamage)
{
    // get fDirection
    static Float:fAngles[3], Float:fDirection[3]
    pev(iAttacker, pev_angles, fAngles)
    angle_vector(fAngles, ANGLEVECTOR_FORWARD, fDirection)
    
    // get fStart
    static Float:fStart[3], Float:fViewOfs[3]
    pev(iAttacker, pev_origin, fStart)
    pev(iAttacker, pev_view_ofs, fViewOfs)
    xs_vec_add(fViewOfs, fStart, fStart)
    
    // get aimOrigin
    static iAimOrigin[3], Float:fAimOrigin[3]
    get_user_origin(iAttacker, iAimOrigin, 3)
    IVecFVec(iAimOrigin, fAimOrigin)
    
    // TraceLine from fStart to AimOrigin
    static ptr; ptr = create_tr2() 
    engfunc(EngFunc_TraceLine, fStart, fAimOrigin, DONT_IGNORE_MONSTERS, iAttacker, ptr)
    static iHitgroup; iHitgroup = get_tr2(ptr, TR_iHitgroup)
    static Float:fEndPos[3]; get_tr2(ptr, TR_vecEndPos, fEndPos)

    // set default iHitgroup
    iHitgroup = HIT_CHEST
    new ptr3 = create_tr2() 
    get_tr2(ptr3, TR_vecEndPos, fEndPos)
    // free ptr3
    free_tr2(ptr3)
    
    // set new Hit & Hitgroup & EndPos
    set_tr2(ptr, TR_pHit, iVictim)
    set_tr2(ptr, TR_iHitgroup, iHitgroup)
    
    
    // hitgroup multi flDamage
    static Float:flMultiDamage 
    switch(iHitgroup)
    {
        case HIT_HEAD: flMultiDamage  = 4.0 // Adrshoot supports
        default: flMultiDamage  = 1.0
    }
    
    // ExecuteHam
    ExecuteHamB(Ham_TraceAttack, iVictim, iAttacker, flDamage * flMultiDamage, fDirection, ptr, DMG_BULLET)
    // free ptr
    free_tr2(ptr)
    
}

MakeMuzzleFlash(id)
{
    static Float:Origin[3]
    get_position(id, WEAPON_ATTACH_F, WEAPON_ATTACH_R, WEAPON_ATTACH_U, Origin)
    
    message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
    write_byte(TE_EXPLOSION) 
    engfunc(EngFunc_WriteCoord, Origin[0])
    engfunc(EngFunc_WriteCoord, Origin[1])
    engfunc(EngFunc_WriteCoord, Origin[2])
    write_short(g_iSmokepuffID) 
    write_byte(7)
    write_byte(30)
    write_byte(TE_EXPLFLAG_NODLIGHTS | TE_EXPLFLAG_NOSOUND | TE_EXPLFLAG_NOPARTICLES)
    message_end()
}

UpdateAmmo(id)
{
    if(!is_user_alive(id))
        return
        
    message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("CurWeapon"), _, id)
    write_byte(1)
    write_byte(CSW_CANNON)
    write_byte(-1)
    message_end()
    
    message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("AmmoX"), _, id)
    write_byte(6)
    write_byte(g_iAmmo[id])
    message_end()
}
CheckRadiusDamage(id)
{
    static Float:Origin[3], Float:MyOrigin[3]
    pev(id, pev_origin, MyOrigin)
    new i = -1
    while((i = engfunc(EngFunc_FindEntityInSphere, i, MyOrigin, 400.0))> 0)
    {
        if(!pev_valid(i)) continue
        if(!pev(i,pev_health)) continue
        if(!pev(i,pev_takedamage)) continue
        if(id == i) continue
        
        pev(i, pev_origin, Origin)
        if(is_wall_between_points(MyOrigin, Origin, id))
            continue
        if(!is_in_viewcone(id, Origin, 1))
            continue
        if(fm_entity_range(id, i) >= 400.0)
            continue
        new Float:flDamage=950.0-(950.0 / 400.0)*floatround(fm_entity_range(id,i));
        if(is_user_alive(i) && zp_core_is_zombie(i))
            DoTraceAttack(id, i, flDamage)
        ExecuteHamB(Ham_TakeDamage, i, id, id, flDamage, DMG_CLUB)
        set_pev(i,pev_velocity,{0,0,0})
    }
}
public fw_Touch(iEnt, id)
{
    if(!pev_valid(iEnt))
    return HAM_IGNORED
    new class[32]    
    pev(iEnt, pev_classname, class, 31)
    if (equal(class, CANNONFIRE_CLASSNAME))
    {
        new class2[32]
        pev(id, pev_classname, class2, 31)
        
        if(equal(class2, "player"))
            if(pev(iEnt,pev_owner) == id)
                return HAM_IGNORED
        if(equal(class2, CANNONFIRE_CLASSNAME))
            return HAM_IGNORED
        
        set_pev(iEnt, pev_movetype, MOVETYPE_NONE)
        set_pev(iEnt, pev_solid, SOLID_NOT)
        set_pev(iEnt, pev_velocity,{0,0,0})
        set_pev(iEnt, pev_fuser1, 35.0)
    }
    return HAM_IGNORED
}
public fw_Think(iEnt)
{
    set_pev(iEnt, pev_nextthink, get_gametime()+0.035)
    
    static Float:amt
    
    pev(iEnt, pev_fuser1, amt)
    
    if(amt<=30.0)
    {
        fm_remove_entity(iEnt)
        
        return 
    }
    
    amt-=6.0
    
    set_pev(iEnt, pev_fuser1, amt)
    set_pev(iEnt, pev_renderamt, amt)
    
    static Float:frame
    
    pev(iEnt, pev_frame, frame)
    
    frame+=0.25
    
    if(frame>=2.5)
    {
        static Float:scale
        
        pev(iEnt, pev_scale, scale)
        
        scale += 0.01
        
        set_pev(iEnt, pev_scale, scale)
    }
    set_pev(iEnt, pev_frame, frame)
}
public fw_UpdateClientData_Post(id, sendweapons, cd_handle)
{
    if(!is_user_alive(id) || !is_user_connected(id))
        return FMRES_IGNORED
    if(get_user_weapon(id) != CSW_CANNON || !g_iOwnCannon[id])
        return FMRES_IGNORED
    
    set_cd(cd_handle, CD_flNextAttack, get_gametime() + random_float(0.001, 0.2)) 
    if(g_flLastShootTime[id] < 0)
        PostShoot(id)
    return FMRES_HANDLED
}

public fw_CmdStart(id, uc_handle, seed)
{
    if(!is_user_alive(id) || !is_user_connected(id))
        return FMRES_IGNORED
    if(get_user_weapon(id) != CSW_CANNON || !g_iOwnCannon[id])
        return FMRES_IGNORED
    
    static CurButton
    CurButton = get_uc(uc_handle, UC_Buttons)
    
    if(CurButton & IN_ATTACK)
    {
        CurButton &= ~IN_ATTACK
        set_uc(uc_handle, UC_Buttons, CurButton)
        CheckShoot(id)
    }
    return FMRES_HANDLED
}

public fw_SetModel(entity, model[])
{
    if(!pev_valid(entity))
        return FMRES_IGNORED
    
    static szClassName[33]
    pev(entity, pev_classname, szClassName, charsmax(szClassName))
    
    if(!equal(szClassName, "weaponbox"))
        return FMRES_IGNORED
    
    static id
    id = pev(entity, pev_owner)
    
    if(equal(model, DEFAULT_W_MODEL))
    {
        static weapon
        weapon = fm_find_ent_by_owner(-1, weapon_cannon, entity)
        
        if(!pev_valid(weapon))
            return FMRES_IGNORED
        
        if(g_iOwnCannon[id])
        {
            set_pev(weapon, pev_impulse, WEAPON_SECRET_CODE)
            set_pev(weapon, pev_ammo, g_iAmmo[id])
            
            engfunc(EngFunc_SetModel, entity, WeaponModel[2])
            DoRemoveCannon(id)
            
            return FMRES_SUPERCEDE
        }
    }

    return FMRES_IGNORED
}

public fw_AddToPlayer_Post(ent, id)
{
    if(!pev_valid(ent))
        return HAM_IGNORED
        
    if(pev(ent, pev_impulse) == WEAPON_SECRET_CODE)
    {
        DoRemoveCannon(id)
        
        g_iOwnCannon[id] = CANNON_OWN_STANDARD
        g_iAmmo[id] = pev(ent, pev_ammo)
    }
    
    message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("WeaponList"), _, id)
    switch(g_iOwnCannon[id])
    {
        case CANNON_OWN_NONE: write_string("weapon_ump45")
        case CANNON_OWN_STANDARD: write_string("weapon_cannon")
        case CANNON_OWN_MINOR: write_string("weapon_cannonm")
    }
    write_byte(6)
    write_byte(20)
    write_byte(-1)
    write_byte(-1)
    write_byte(0)
    write_byte(15)
    write_byte(CSW_CANNON)
    write_byte(0)
    message_end()            
    
    return HAM_HANDLED    
}

stock set_weapon_anim(id, anim)
{
    set_pev(id, pev_weaponanim, anim)
    
    message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, {0, 0, 0}, id)
    write_byte(anim)
    write_byte(pev(id, pev_body))
    message_end()
}

stock drop_weapons(id, dropwhat)
{
    static weapons[32], num, i, weaponid
    num = 0
    get_user_weapons(id, weapons, num)
    
    const PRIMARY_WEAPONS_BIT_SUM = (1<<CSW_SCOUT)|(1<<CSW_XM1014)|(1<<CSW_MAC10)|(1<<CSW_MAC10)|(1<<CSW_UMP45)|(1<<CSW_SG550)|(1<<CSW_MAC10)|(1<<CSW_FAMAS)|(1<<CSW_AWP)|(1<<CSW_MP5NAVY)|(1<<CSW_M249)|(1<<CSW_M3)|(1<<CSW_M4A1)|(1<<CSW_TMP)|(1<<CSW_G3SG1)|(1<<CSW_SG552)|(1<<CSW_AK47)|(1<<CSW_P90)
    
    for (i = 0; i < num; i++)
    {
        weaponid = weapons[i]
        
        if (dropwhat == 1 && ((1<<weaponid) & PRIMARY_WEAPONS_BIT_SUM))
        {
            static wname[32]
            get_weaponname(weaponid, wname, sizeof wname - 1)
            engclient_cmd(id, "drop", wname)
        }
    }
}

stock set_player_nextattack(player, weapon_id, Float:NextTime)
{
    const m_flNextPrimaryAttack = 46
    const m_flNextSecondaryAttack = 47
    const m_flTimeWeaponIdle = 48
    const m_flNextAttack = 83
    
    static weapon
    weapon = fm_get_user_weapon_entity(player, weapon_id)
    
    set_pdata_float(player, m_flNextAttack, NextTime, 5)
    if(pev_valid(weapon))
    {
        set_pdata_float(weapon, m_flNextPrimaryAttack , NextTime, 4)
        set_pdata_float(weapon, m_flNextSecondaryAttack, NextTime, 4)
        set_pdata_float(weapon, m_flTimeWeaponIdle, NextTime, 4)
    }
}

stock get_position(id,Float:forw, Float:right, Float:up, Float:vStart[])
{
    new Float:vOrigin[3], Float:vAngle[3], Float:vForward[3], Float:vRight[3], Float:vUp[3]
    
    pev(id, pev_origin, vOrigin)
    pev(id, pev_view_ofs,vUp) //for player
    xs_vec_add(vOrigin,vUp,vOrigin)
    pev(id, pev_v_angle, vAngle) // if normal entity ,use pev_angles
    
    angle_vector(vAngle,ANGLEVECTOR_FORWARD,vForward) //or use EngFunc_AngleVectors
    angle_vector(vAngle,ANGLEVECTOR_RIGHT,vRight)
    angle_vector(vAngle,ANGLEVECTOR_UP,vUp)
    
    vStart[0] = vOrigin[0] + vForward[0] * forw + vRight[0] * right + vUp[0] * up
    vStart[1] = vOrigin[1] + vForward[1] * forw + vRight[1] * right + vUp[1] * up
    vStart[2] = vOrigin[2] + vForward[2] * forw + vRight[2] * right + vUp[2] * up
}

stock is_wall_between_points(Float:start[3], Float:end[3], ignore_ent)
{
    static ptr
    ptr = create_tr2()
    engfunc(EngFunc_TraceLine, start, end, IGNORE_MONSTERS, ignore_ent, ptr)
    static Float:EndPos[3]
    get_tr2(ptr, TR_vecEndPos, EndPos)
    free_tr2(ptr)
    return floatround(get_distance_f(end, EndPos))
}