﻿/* AMX Mod X
*   CS Stats Plugin
*
* by the AMX Mod X Development Team
*  originally developed by OLO
*
* This file is part of AMX Mod X.
*
*
*  This program is free software; you can redistribute it and/or modify it
*  under the terms of the GNU General Public License as published by the
*  Free Software Foundation; either version 2 of the License, or (at
*  your option) any later version.
*
*  This program is distributed in the hope that it will be useful, but
*  WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*  General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software Foundation,
*  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*  In addition, as a special exception, the author gives permission to
*  link the code of this program with the Half-Life Game Engine ("HL
*  Engine") and Modified Game Libraries ("MODs") developed by Valve,
*  L.L.C ("Valve"). You must obey the GNU General Public License in all
*  respects for all of the code used other than the HL Engine and MODs
*  from Valve. If you modify this file, you may extend this exception
*  to your version of the file, but you are not obligated to do so. If
*  you do not wish to do so, delete this exception statement from your
*  version.
*
*  Modifications by: zhangsheng
*
*  Chinese version by: zhangsheng
*/

#include <amxmodx>
#include <amxmisc>
#include <csstats> 
#include <cstrike>

// You can also manualy enable these options by setting them to 1
// For example:
// public ShowAttackers = 1
// However amx_statscfg command is recommended

public ShowAttackers      // shows attackers
public ShowVictims        // shows victims
public ShowKiller         // shows killer
public EndPlayer          // displays player stats at the end of map
public EndTop15           // displays top15 at the end of map
public KillerHpAp         // displays killer hp&ap to victim console and screen
public SpecRankInfo       // displays rank info when spectating

public ShowSpecStatus	  // show specstatus
public ShowRatio	  // show ratio
public ShowMoney	  // show money
public ShowIp		  // show ip
public EndRoundTop5	  // end round top5

public SayHP              // displays information about user killer
public SayStatsAll        // displays players stats and rank
public SayTop15           // displays first 15. players
public SayRank            // displays user position in rank
public SayStatsMe         // displays user stats

public EndTeamScore       // displays at the end of round team score
public EndMostKills       // displays at the end of who made most kills
public EndMostDamage      // displays at the end of who made most damage

new g_Killers[33][4]
new g_Buffer[2048]
new g_userPosition[33]
new g_userszszState[33]
new g_userPlayers[33][32]
new g_bodyParts[8][] = {"全身","头部","胸部","腹部","左臂","右臂","左腿","右腿"}
new bool:g_specMode[33]
new g_teamScore[2]

new g_disabledMsg[] = "服务器禁止了这个参数"

public plugin_init() {
	register_plugin("CS Stats","0.16","AMXX Dev Team")
	register_event("CS_DeathMsg","eCSDeathMsg","a")
	register_event("ResetHUD","eResetHud","b")
	register_event("SendAudio","eRoundEnd","a","2=%!MRAD_terwin","2=%!MRAD_ctwin","2=%!MRAD_rounddraw") 
	register_event("30","eInterMission","a")
	register_clcmd("say /hp","cmdKiller",0,"- 显示杀你的人的状态")
	register_clcmd("say /statsme","cmdStatsMe",0,"- 显示你的统计")
	register_clcmd("say /stats","cmdStats",0,"- 显示其他人的数据统计")
	register_clcmd("say /top15","cmdTop15",0,"- 显示排名榜前15名")
	register_clcmd("say /rank","cmdRank",0,"- 显示你在这个服务器上的排名情况")
	register_menucmd(register_menuid("在线玩家统计数据"),1023,"actionStatsMenu")
	register_event("TextMsg","setSpecMode","bd","2&ec_Mod") 
	register_event("StatusValue","showRank","bd","1=2")
	register_event( "TeamScore", "eTeamScore", "a" )
}

public plugin_cfg(){
	new g_addStast[] = "amx_statscfg add ^"%s^" %s"
	server_cmd(g_addStast,"Show Attackers","ShowAttackers") 
	server_cmd(g_addStast,"Show Victims","ShowVictims") 
	server_cmd(g_addStast,"Show killer","ShowKiller")
	server_cmd(g_addStast,"Stats at the end of map","EndPlayer")  
	server_cmd(g_addStast,"Top15 at the end of map","EndTop15")  
	server_cmd(g_addStast,"Show killer hp&ap","KillerHpAp")
	server_cmd(g_addStast,"Say /hp","SayHP")  
	server_cmd(g_addStast,"Say /stats","SayStatsAll") 
	server_cmd(g_addStast,"Say /top15","SayTop15")
	server_cmd(g_addStast,"Say /rank","SayRank") 
	server_cmd(g_addStast,"Say /statsme","SayStatsMe")
	server_cmd(g_addStast,"Spec. Rank Info","SpecRankInfo")
	server_cmd(g_addStast,"Team Score","EndTeamScore")
	server_cmd(g_addStast,"Most Kills","EndMostKills")
	server_cmd(g_addStast,"Most Damage","EndMostDamage")  
	server_cmd(g_addStast,"Spec. status","ShowSpecStatus")
	server_cmd(g_addStast,"Spec. hit body ratio","ShowRatio")
	server_cmd(g_addStast,"display player's money","ShowMoney")
	server_cmd(g_addStast,"display top5 on endround","EndRoundTop5")
	server_cmd(g_addStast,"displayer player's ip","ShowIp")
}

public client_color(id,msg[]){
	new playerslist[32],playerscount//,i
	get_players(playerslist,playerscount,"c")
	if(id==0){
		message_begin(MSG_ALL, get_user_msgid("SayText"), {0,0,0},id) 
		write_byte(id)
		write_string(msg)
		message_end()
		
	}
	else{
		message_begin(MSG_ONE, get_user_msgid("SayText"), {0,0,0}, id) 
		write_byte(id)
		write_string(msg)
		message_end()
	}
} 

public eTeamScore(){ 
	new team[2]
	read_data( 1, team, 1 )
	g_teamScore[ (team[0]=='C') ? 1 : 0 ] = read_data(2)
}

public setSpecMode(id) { 
	new arg[12] 
	read_data( 2 , arg , 11 ) 
	g_specMode[ id ] = ( arg[10] == '2' )
} 

Float:getratio( temp[8],x,all ) {
	if( all == 0 ) return ( 0.0 )
	return ( 100.0 * float( temp[x] ) / float( all ) )
}

/*ShowSpecStatus*/
getspecstatus(id) {
	new pos,stats[8],bodyhits[8],bodysum
	if ( ShowSpecStatus ){
		new name[32]
		get_user_name(id,name,31)
		new health = get_user_health(id)
		new armor = get_user_armor(id)
		new data[8]
		new rank = get_user_stats(id,data,data)
		pos += format(g_Buffer[pos],2047-pos,"名字: %s^n生命值: %d^n装甲值: %d^n排名: %d^n",name,health,armor,rank )
	}
	if ( ShowMoney ){
		new money = cs_get_user_money(id)
		pos += format(g_Buffer[pos],2047-pos,"金钱: $ %d^n",money )
	} 
	if ( ShowRatio ){
		get_user_stats(id,stats,bodyhits)
		for( new i=1; i<8; ++i )
			bodysum += bodyhits[i]
		new Float:bodyratio[8]
		for( new i=1; i<8; ++i )
			bodyratio[i] = getratio( bodyhits, i, bodysum )
		if ( stats[1] == 0 )
			bodyratio[0] = 0.0
		else
			bodyratio[0] = ( float (stats[0]) / float (stats[1]) )
		pos += format(g_Buffer[pos],2047-pos,"命中率 列表:^n")
		for ( new i=1; i<8; ++i )
			pos += format(g_Buffer[pos],2047-pos,"->%s : %.2f%%%%^n",g_bodyParts[i],bodyratio[i])
		pos += format(g_Buffer[pos],2047-pos,"杀死/死亡 : %.2f^n",bodyratio[0])
	}
	if ( ShowIp ){
		new ipaddress[16]
		get_user_ip(id,ipaddress,16,1)
		pos += format(g_Buffer[pos],2047-pos,"IP地址 :%s^n",ipaddress)
	}
} 

/*EndRoundTop5*/
gettop5(){
	new pos = 0,name[32],stats[8],bodyhits[8]
	pos += format(g_Buffer[pos],2047-pos,"排行榜前5名:^n————————————————")
	new imax = get_statsnum()
	if (imax > 5) imax = 5
	for(new a = 0; a < imax; ++a){
		get_stats(a, stats, bodyhits, name, 31)
		pos += format(g_Buffer[pos],2047-pos,"^n%d. %s",a+1,name )
	}
} 

public showRank(id)
	if ( SpecRankInfo && g_specMode[id] ){
	new a = read_data(2)
	if ( is_user_connected( a ) ){
		new name[32], data[8]
		get_user_name( a ,name,31)
		new pos = get_user_stats( a ,data,data)
		set_hudmessage(255,255,255,0.02,0.85,2, 0.05, 0.1, 0.01, 3.0, 1)
		show_hudmessage(id,"%s的名次是 %d人中排第 %d",name,get_statsnum(),pos)
		getspecstatus(a)
		if ( ShowRatio ){
			set_hudmessage( 150, 50, 255, 0.03, 0.31, 0, 6.0, 10.0, 0.1, 0.2, 9)
			//set_hudmessage(random_num(0,255),random_num(0,255),random_num(0,255), 0.03, 0.31, 0, 6.0, 10.0, 0.1, 0.2, 2)
			}else{
			set_hudmessage( 150, 50, 255, 0.03, 0.50, 0, 6.0, 10.0, 0.1, 0.2, 9)
			//set_hudmessage(random_num(0,255),random_num(0,255),random_num(0,255), 0.03, 0.50, 0, 6.0, 10.0, 0.1, 0.2, 2)
		}
		show_hudmessage(id,g_Buffer)
	}
} 

/* build list of attackers */
getAttackers(id) {
	new name[32],wpn[32], stats[8],body[8],found=0
	new pos = copy(g_Buffer,2047,"Attackers:^n")
	new amax = get_maxplayers()
	for(new a = 1; a <= amax; ++a){
		if(get_user_astats(id,a,stats,body,wpn,31)){
			found = 1
			if (stats[0])
				format(wpn,31," -- %s",wpn)
			else
				wpn[0] = 0
			get_user_name(a,name,31)
			pos += format(g_Buffer[pos],2047-pos,"%s --  击中%d 次/ %d 点伤害,武器 %s^n",name,stats[5],stats[6],wpn)
		}
	}
	return found
}

/* build list of victims */
getVictims(id) {
	new name[32],wpn[32], stats[8],body[8],found=0
	new pos = copy(g_Buffer,2047,"被你打中的:^n")
	new amax = get_maxplayers()
	for(new a = 1; a <= amax; ++a){
		if(get_user_vstats(id,a,stats,body,wpn,31)){
			found = 1
			if (stats[1])
				format(wpn,31," -- %s",wpn)
			else
				wpn[0] = 0
			get_user_name(a,name,31)
			pos += format(g_Buffer[pos],2047-pos,"%s -- 你使用武器 %s 击中他%d 次/ 造成%d点伤害,^n",name,wpn,stats[5],stats[6])
		}
	}
	return found
}

/* build list of hita for AV List */
getHits(id,killer) {
	new stats[8], body[8], pos = 0
	g_Buffer[0] = 0
	get_user_astats(id,killer,stats,body)
	for(new a = 1; a < 8; ++a)
		if(body[a])
		pos += format(g_Buffer[pos],2047-pos,"%s: %d^n",g_bodyParts[a],body[a])
}

/* get top 15 */
getTop15() {
	new pos, stats[8], body[8], name[32],szstate[4]
	pos = format(g_Buffer,2047,"<meta charset=UTF-8><style>body{color:#FFFFFF;background-color:black;margin-top:5}.one{background-color:#565759}.two{background-color:#3D3D3D}td{font-size:14px}</style><center><b><font size=4>反恐精英CS1.6金牌杀手榜</b><table width=500>")
	pos += format(g_Buffer[pos],2047-pos,"%s","<tr bgcolor=#9A9DA2><td>#<td>昵称<td>杀敌<td>死亡<td>击中<td>开枪<td>爆头</tr>")
	
	new imax = get_statsnum()
	if (imax > 15) imax = 15
	for(new a = 0; a < imax; ++a){
		if (equal(szstate,"one")) copy(szstate,3,"two")
		else copy(szstate,3,"one")
		get_stats(a,stats,body,name,31)
		while( contain ( name, "<" ) != -1 )
			replace( name, 32, "<", "&lt;" )
		//  while( contain ( name, ">" ) != -1 )
		//  replace( name, 32, ">", "&gt;" )
		pos += format(g_Buffer[pos],2047-pos,
		"<tr class=%s><td>%d<td>%s<td>%d<td>%d<td>%d<td>%d<td>%d",szstate,a+1,name,stats[0],stats[1],stats[5],stats[4],stats[2])
	}
	copy(g_Buffer[pos],2047-pos,"</table><hr size=1 color=blue></font>【月光疾風】制作")
} 

/* build list of hits for say hp */
getMyHits(id,killed) {
	new name[32], stats[8], body[8]
	get_user_name(killed,name,31)
	new pos = format(g_Buffer,2047,"^x01你击中^x03%s^x01的部位是:",name)
	get_user_vstats(id,killed,stats,body)
	for(new a = 1; a < 8; ++a){
		if(body[a])
			pos += format(g_Buffer[pos],2047-pos,"^x01【^x04%s^x01】:^x04%d^x01枪",g_bodyParts[a],body[a])
	}
}

/* save hits and damage */
public eCSDeathMsg() {
	new killer = read_data(1)
	new victim = read_data(2)
	if ( killer == victim ) return
	new vorigin[3], korigin[3]
	get_user_origin(victim,vorigin)
	get_user_origin(killer,korigin)
	g_Killers[victim][0] = killer
	g_Killers[victim][1] = get_user_health(killer)
	g_Killers[victim][2] = get_user_armor(killer)      
	g_Killers[victim][3] = get_distance(vorigin,korigin)
	if ( ShowKiller ){
		new name[32], stats[8], body[8], wpn[33], mstats[8], mbody[8]
		get_user_name(killer,name,31)
		get_user_astats(victim,killer,stats,body,wpn,31)
		if ( !get_user_vstats(victim,killer,mstats,mbody) )
			mstats[5] = mstats[6] = 0
		set_hudmessage(220,80,0,0.05,0.15,0, 6.0, 12.0, 1.0, 2.0, 1)
		getHits(victim,killer)
		show_hudmessage(victim,"%s 用 %s 将你击毙^n距离你 %.2f 米.^n他对你造成 %d 的伤害,打中你 %d 次^n他还有 %d生命值 和 %d护甲.^n你对他造成了 %d 的伤害, 击中他 %d次.^n他击中了你下列部位:^n%s",
		name,wpn,float(g_Killers[victim][3]) * 0.0254,  stats[6],stats[5],   g_Killers[victim][1],g_Killers[victim][2],
		mstats[6],mstats[5],g_Buffer )
	}
	if ( ShowVictims && getVictims(victim) ){
		set_hudmessage(0,80,220,0.55,0.60,0, 6.0, 12.0, 1.0, 2.0, 4)
		show_hudmessage(victim,g_Buffer)
	}
	if ( ShowAttackers  && getAttackers(victim)){
		set_hudmessage(220,80,0,0.55,0.35,0, 6.0, 12.0, 1.0, 2.0, 3)
		show_hudmessage(victim,g_Buffer)
	}
	if (  KillerHpAp ){
		new name[32], kmsg[128]
		get_user_name(killer,name,31)
		format(kmsg,127,"%s 还有 %d生命值 和 %d护甲",name,g_Killers[victim][1],g_Killers[victim][2])
		client_print(victim,print_console,kmsg)
		set_hudmessage(255,255,255,0.02,0.85,2, 1.5, 3.0, 0.02, 5.0, 1)
		show_hudmessage(victim,kmsg)
	}
}

public eResetHud( id )
	g_Killers[ id ][0] = 0

public eRoundEnd()
	set_task( 0.3 , "eRoundEndTask" )

public eRoundEndTask() { 
	if ( EndRoundTop5 ){
		gettop5()
		set_hudmessage(0,150,0,-1.0, 0.07, 2, 0.01, 12.0, 0.01, 0.01, 5)
		show_hudmessage( 0 ,g_Buffer)
	}
	if (  ShowVictims || ShowAttackers ) {
		new players[32], pnum
		get_players( players , pnum, "a"  ) 
		for(new i = 0; i < pnum; ++i ) {
			if ( ShowVictims &&getVictims( players[ i ] )){
				set_hudmessage(0,80,220,0.55,0.60,0, 6.0, 12.0, 1.0, 2.0, 4)
				show_hudmessage( players[ i ] ,g_Buffer)
			}
			if ( ShowAttackers && getAttackers( players[ i ] ) ){
				set_hudmessage(220,80,0,0.55,0.35,0, 6.0, 12.0, 1.0, 2.0, 3)
				show_hudmessage( players[ i ] ,g_Buffer)
			}
		}
	}
	if ( EndMostKills || EndTeamScore || EndMostDamage  ){
		new players[32], pnum, stats[8],bodyhits[8], len = 0
		get_players( players , pnum ) 
		g_Buffer[0] = 0
		if ( EndMostKills ){
			new kills = 0, who = 0, hs = 0
			for(new i = 0; i < pnum; ++i){
				get_user_rstats( players[i],stats, bodyhits )
				if ( stats[0] > kills ){
					who = players[i]
					kills = stats[0]
					hs = stats[2]
				}  
			}
			if ( is_user_connected(who) ) {
				new name[32]
				get_user_name( who, name, 31 )
				len += format(g_Buffer[len] , 512 - len ,
				"最佳杀手: %s^n杀敌 %d 个 / 爆头%d 个^n", name , kills , hs )
			}
		}
		if ( EndMostDamage ) {
			new damage = 0, who = 0, hits = 0
			for(new i = 0; i < pnum; ++i){
				get_user_rstats( players[i],stats, bodyhits )
				if ( stats[6] > damage ){
					who = players[i]
					hits = stats[5]
					damage = stats[6]
				}  
			}
			if ( is_user_connected(who) ) {
				new name[32]
				get_user_name( who, name, 31 )
				len += format(g_Buffer[len] , 512 - len ,
				"————————————————^n最具杀伤力: %s^n击中敌人%d 次／造成 %d 伤害^n", name , hits , damage)
			}
		} 
		if ( ShowMoney ){
			new who = 0, temp = 0, money = 0
			new name[32]
			//temp = cs_get_user_money(0)
			//client_print(0,print_chat,"a's money: %d",temp)
			for(new i = 0; i < pnum; ++i){
				money = cs_get_user_money(players[i])
				if ( money > temp ){
					who = players[i]
					temp = cs_get_user_money(players[i])
				}
			}
			if ( is_user_connected(who) ) {
				//client_print(0,print_chat,"richmen is : %d",who)
				get_user_name( who,name,31 )
				//client_print(0,print_chat,"money 's name :%s",name)
				len += format(g_Buffer[len] , 1024 - len , "————————————————^n金钱最多的玩家: %s  $: %d^n",name, cs_get_user_money(who) )
			}
		}
		if ( EndTeamScore )
			format(g_Buffer[len] , 512 - len , "————————————————^n匪徒%d次胜利-- 警察%d次胜利^n", g_teamScore[0] , g_teamScore[1] )
		set_hudmessage(0,128,255,-1.0,0.70,2, 0.01, 5.0, 0.01, 0.01, 3 )
		show_hudmessage( 0 , g_Buffer )
	}
}

public cmdKiller(id) {
	if ( !SayHP ){
		client_print(id,print_chat, g_disabledMsg )
		return PLUGIN_HANDLED
	}
	if (g_Killers[id][0]) {
		new name[32], stats[8], body[8], wpn[33], mstats[8], mbody[8],msg[128]
		get_user_name(g_Killers[id][0],name,31)
		get_user_astats(id,g_Killers[id][0],stats,body,wpn,31)
		format(msg,127, "^x03%s^x01使用【^x04%s^x01】在【^x04%.2f^x01】米外将你结束了",  name,wpn,float(g_Killers[id][3]) * 0.0254)
		client_color(id, msg)
		format(msg,127, "^x01他击中你【^x04%d^x01】枪,对你造成【^x04%d^x01】点伤害,并且他还有【^x04%d^x01】生命和【^x04%d^x01】护甲",stats[5],stats[6], g_Killers[id][1],g_Killers[id][2] )
		client_color(id, msg)
		if ( get_user_vstats(id,g_Killers[id][0],mstats,mbody) )  { 
			getMyHits(id,g_Killers[id][0])
			format(msg,127,"%s",g_Buffer)
			client_color(id, msg)
			format(msg,127, "^x01你击中他【^x04%d^x01】枪,对他造成【^x04%d^x01】伤害",mstats[5], mstats[6])
			client_color(id, msg)
		}
		else client_print(id,print_chat,"【你苯的象猪,居然一枪未中】")
	}
	else {
		client_print(id,print_chat,"【你还没有杀人无法统计】")
	}
	return PLUGIN_CONTINUE
}

public cmdStatsMe(id){
	if ( !SayStatsMe ){
		client_print(id,print_chat, g_disabledMsg )
		return PLUGIN_HANDLED
	}
	displayStats(id,id)
	return PLUGIN_CONTINUE
}

public displayStats(id,dest) {
	new pos, name[32], stats[8], body[8]
	get_user_wstats(id,0,stats,body)
	#if !defined NO_STEAM
	new szszState[4]
	pos += copy(g_Buffer[pos],2047-pos,"<meta charset=UTF-8><style>body{font-family:Arial,sans-serif;font-size:12px;color:#FFFFFF;background-color:#000000;margin-left:8px;margin-top:3px}.header{background-color:#9A9DA2;}.one{background-color:#565759;}.two{background-color:#3D3D3D;}")
	pos += format(g_Buffer[pos],2047-pos,"</style></head><body><table><tr class=^"one^"><td>杀敌:</td><td>%d</td></tr><tr class=^"two^"><td>被杀:</td><td>%d</td></tr><tr class=^"one^"><td>伤害:</td><td>%d</td></tr><tr class=^"two^"><td>击中:</td><td>%d</td></tr><tr class=^"one^"><td>开枪:</td><td>%d</td></tr></table><br><br>",
	stats[0],stats[1],stats[6],stats[5],stats[4])
	pos += copy(g_Buffer[pos],2047-pos,"<table><tr class=^"header^"><td>武器</td><td>开枪</td><td>击中</td><td>伤害</td><td>杀敌</td><td>死亡</td></tr>")
	for(new a = 1; a < 31; ++a) {
		if (get_user_wstats(id,a,stats,body)) {
			if (equal(szszState,"one")) copy(szszState,3,"two")
			else copy(szszState,3,"one")
			get_weaponname(a,name,31)
			pos += format(g_Buffer[pos],2047-pos,"<tr class=^"%s^"><td>%s</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td></tr>",
			szszState,name[7],stats[4],stats[5],stats[6],stats[0],stats[1])
		}
	}
	copy(g_Buffer[pos],2047-pos,"</table></body></html>")
	#else
	pos = format(g_Buffer,2047,"%6s: %d^n%6s: %d^n%6s: %d^n%6s: %d^n%6s: %d^n^n",
	"杀敌",stats[0],"被杀",stats[1],"伤害",stats[6],"击中",stats[5],"开枪",stats[4])
	pos += format(g_Buffer[pos],2047-pos, "%-12.11s  %6s  %6s  %6s  %6s  %6s^n",
	"weapon","shots","hits","damage","kills","deaths")
	for(new a = 1; a < 31; ++a) {
		if (get_user_wstats(id,a,stats,body)){
			get_weaponname(a,name,31)
			pos += format(g_Buffer[pos],2047-pos,"%-12.11s  %6d  %6d  %6d  %6d  %6d^n",
			name[7],stats[4],stats[5],stats[6],stats[0],stats[1])
		}
	}
	#endif
	get_user_name(id,name,31)
	show_motd(dest,g_Buffer,name)
	return PLUGIN_CONTINUE
}

public cmdRank(id){
	if ( !SayRank ){
		client_print(id,print_chat, g_disabledMsg )
		return PLUGIN_HANDLED
	}
	displayRank(id,id)
	return PLUGIN_CONTINUE
}

displayRank(id,dest) {
	new pos, name[32], stats[8], body[8]
	new rank_pos = get_user_stats(id,stats,body) 
	#if !defined NO_STEAM
	pos += copy(g_Buffer[pos],2047-pos,"<meta charset=UTF-8><style>body{font-family:Arial,sans-serif;font-size:12px;color:#FFFFFF;background-color:#000000;margin-left:8px;margin-top:3px}.header{background-color:#9A9DA2;}.one{background-color:#565759;}.two{background-color:#3D3D3D;}")
	pos += format(g_Buffer[pos],2047-pos,"</style></head><body><table><tr><td colspan=2>%s排名是%d总共有%d人,一分努力,一分收获.【月光疾風制作】</td></tr>",(id==dest)?"你的":"他的",rank_pos, get_statsnum())
	pos += format(g_Buffer[pos],2047-pos,"<tr class=^"one^"><td>杀敌:</td><td>%d</td></tr><tr class=^"two^"><td>死亡:</td><td>%d</td></tr><tr class=^"one^"><td>伤害:</td><td>%d</td></tr><tr class=^"two^"><td>击中:</td><td>%d</td></tr><tr class=^"one^"><td>开枪:</td><td>%d</td></tr><tr><td>&nbsp;</td><td>&nbsp;</td></tr>",
	stats[0],stats[1],stats[6],stats[5],stats[4])
	pos += format(g_Buffer[pos],2047-pos,"<tr class=^"header^"><td colspan=2>击中</td></tr><tr class=^"one^"><td>%s:</td><td>%d</td></tr><tr class=^"two^"><td>%s:</td><td>%d</td></tr><tr class=^"one^"><td>%s:</td><td>%d</td></tr><tr class=^"two^"><td>%s:</td><td>%d</td></tr><tr class=^"one^"><td>%s:</td><td>%d</td></tr><tr class=^"two^"><td>%s:</td><td>%d</td></tr><tr class=^"one^"><td>%s:</td><td>%d</td></tr>",
	g_bodyParts[1],body[1],g_bodyParts[2],body[2],g_bodyParts[3],body[3], g_bodyParts[4],body[4],
	g_bodyParts[5],body[5],g_bodyParts[6],body[6],g_bodyParts[7],body[7])
	copy(g_Buffer[pos],2047-pos,"</table></body></html>") 
	#endif
	get_user_name(id,name,31)
	show_motd(dest,g_Buffer,name)
}

public cmdTop15(id) {
	if ( !SayTop15 ){
		client_print(id,print_chat, g_disabledMsg )
		return PLUGIN_HANDLED
	}
	getTop15()
	show_motd(id,g_Buffer,"Top 15")
	return PLUGIN_CONTINUE
}

public endGameStats(){
	if ( EndPlayer ){
		new players[32], inum
		get_players(players,inum)
		for(new i = 0; i < inum; ++i)
			displayStats(players[i],players[i])
	} 
	else if ( EndTop15 ) {
		new players[32], inum
		get_players(players,inum)
		getTop15()
		for(new i = 0; i < inum; ++i)
			show_motd(players[i],g_Buffer,"Top 15")
	}
}

public eInterMission()
	set_task(1.0,"endGameStats")

public cmdStats(id){
	if ( !SayStatsAll ){
		client_print(id,print_chat, g_disabledMsg )
		return PLUGIN_HANDLED
	}
	showStatsMenu(id,g_userPosition[id]=0)
	return PLUGIN_CONTINUE
}

public actionStatsMenu(id,key){
	switch(key){
		case 7: {
			g_userszszState[id] = 1 - g_userszszState[id]
			showStatsMenu(id,g_userPosition[id])
		}
		case 8: showStatsMenu(id,++g_userPosition[id])
			case 9: showStatsMenu(id,--g_userPosition[id])
			default:{
			new option = g_userPosition[id] * 7 + key
			new index = g_userPlayers[id][option]
			if (is_user_connected(index)){
				if (g_userszszState[id])
					displayRank(index,id)
				else
					displayStats(index,id)
			}
			showStatsMenu(id,g_userPosition[id])
		}
	}
	return PLUGIN_HANDLED
}

showStatsMenu(id,pos){
	if (pos < 0) return PLUGIN_HANDLED
	new menu_body[512], inum, k = 0, start = pos * 7
	get_players(g_userPlayers[id],inum)
	if (start >= inum) start = pos = g_userPosition[id] = 0
	new len = format(menu_body,511,"\y在线玩家统计数据\R%d/%d^n\w^n",pos + 1,((inum/7)+((inum%7)?1:0)))
	new name[32], end = start + 7, keys = (1<<9)|(1<<7)
	if (end > inum) end = inum
	for(new a = start; a < end; ++a){
		get_user_name(g_userPlayers[id][a],name,31)
		keys |= (1<<k)
		len += format(menu_body[len],511-len,"%d. %s^n\w",++k,name)
	}
	len += format(menu_body[len],511-len,"^n8. %s^n\w",g_userszszState[id] ? "Show rank" : "Show stats" )
	if (end != inum){
		format(menu_body[len],511-len,"^n9. 更多...^n0. %s" , pos ? "返回" : "退出" )
		keys |= (1<<8)
	}
	else format(menu_body[len],511-len,"^n0. %s" , pos ? "返回" : "退出" )
	show_menu(id,keys,menu_body)
	return PLUGIN_HANDLED
}